/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.ConnectionConfiguration;
import org.apache.hadoop.hbase.client.RetryingCallerInterceptor;
import org.apache.hadoop.hbase.client.RetryingCallerInterceptorFactory;
import org.apache.hadoop.hbase.client.RpcRetryingCaller;
import org.apache.hadoop.hbase.client.RpcRetryingCallerImpl;
import org.apache.hadoop.hbase.client.ServerStatisticTracker;
import org.apache.hadoop.hbase.util.ReflectionUtils;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class RpcRetryingCallerFactory {
    public static final String CUSTOM_CALLER_CONF_KEY = "hbase.rpc.callerfactory.class";
    protected final Configuration conf;
    private final ConnectionConfiguration connectionConf;
    private final RetryingCallerInterceptor interceptor;
    private final int startLogErrorsCnt;

    public RpcRetryingCallerFactory(Configuration conf) {
        this(conf, RetryingCallerInterceptorFactory.NO_OP_INTERCEPTOR);
    }

    public RpcRetryingCallerFactory(Configuration conf, RetryingCallerInterceptor interceptor) {
        this.conf = conf;
        this.connectionConf = new ConnectionConfiguration(conf);
        this.startLogErrorsCnt = conf.getInt("hbase.client.start.log.errors.counter", 5);
        this.interceptor = interceptor;
    }

    public <T> RpcRetryingCaller<T> newCaller(int rpcTimeout) {
        return new RpcRetryingCallerImpl(this.connectionConf.getPauseMillis(), this.connectionConf.getPauseMillisForServerOverloaded(), this.connectionConf.getRetriesNumber(), this.interceptor, this.startLogErrorsCnt, rpcTimeout);
    }

    public <T> RpcRetryingCaller<T> newCaller() {
        return new RpcRetryingCallerImpl(this.connectionConf.getPauseMillis(), this.connectionConf.getPauseMillisForServerOverloaded(), this.connectionConf.getRetriesNumber(), this.interceptor, this.startLogErrorsCnt, this.connectionConf.getRpcTimeout());
    }

    public static RpcRetryingCallerFactory instantiate(Configuration configuration) {
        return RpcRetryingCallerFactory.instantiate(configuration, RetryingCallerInterceptorFactory.NO_OP_INTERCEPTOR, null);
    }

    public static RpcRetryingCallerFactory instantiate(Configuration configuration, ServerStatisticTracker stats) {
        return RpcRetryingCallerFactory.instantiate(configuration, RetryingCallerInterceptorFactory.NO_OP_INTERCEPTOR, stats);
    }

    public static RpcRetryingCallerFactory instantiate(Configuration configuration, RetryingCallerInterceptor interceptor, ServerStatisticTracker stats) {
        String clazzName = RpcRetryingCallerFactory.class.getName();
        String rpcCallerFactoryClazz = configuration.get(CUSTOM_CALLER_CONF_KEY, clazzName);
        RpcRetryingCallerFactory factory = rpcCallerFactoryClazz.equals(clazzName) ? new RpcRetryingCallerFactory(configuration, interceptor) : (RpcRetryingCallerFactory)ReflectionUtils.instantiateWithCustomCtor(rpcCallerFactoryClazz, new Class[]{Configuration.class}, new Object[]{configuration});
        return factory;
    }
}

