/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.com.nimbusds.jose.jwk.gen;

import java.security.KeyStore;
import java.util.Set;
import org.apache.hadoop.hbase.shaded.com.nimbusds.jose.Algorithm;
import org.apache.hadoop.hbase.shaded.com.nimbusds.jose.JOSEException;
import org.apache.hadoop.hbase.shaded.com.nimbusds.jose.jwk.JWK;
import org.apache.hadoop.hbase.shaded.com.nimbusds.jose.jwk.KeyOperation;
import org.apache.hadoop.hbase.shaded.com.nimbusds.jose.jwk.KeyUse;

public abstract class JWKGenerator<T extends JWK> {
    protected KeyUse use;
    protected Set<KeyOperation> ops;
    protected Algorithm alg;
    protected String kid;
    protected boolean x5tKid;
    protected KeyStore keyStore;

    public JWKGenerator<T> keyUse(KeyUse use) {
        this.use = use;
        return this;
    }

    public JWKGenerator<T> keyOperations(Set<KeyOperation> ops) {
        this.ops = ops;
        return this;
    }

    public JWKGenerator<T> algorithm(Algorithm alg) {
        this.alg = alg;
        return this;
    }

    public JWKGenerator<T> keyID(String kid) {
        this.kid = kid;
        return this;
    }

    public JWKGenerator<T> keyIDFromThumbprint(boolean x5tKid) {
        this.x5tKid = x5tKid;
        return this;
    }

    public JWKGenerator<T> keyStore(KeyStore keyStore) {
        this.keyStore = keyStore;
        return this;
    }

    public abstract T generate() throws JOSEException;
}

