/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.compress;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.io.compress.CodecPool;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.io.compress.DoNotPool;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class Compression {
    private static final Logger LOG = LoggerFactory.getLogger(Compression.class);
    public static final String LZO_CODEC_CLASS_KEY = "hbase.io.compress.lzo.codec";
    public static final String LZO_CODEC_CLASS_DEFAULT = "com.hadoop.compression.lzo.LzoCodec";
    public static final String GZ_CODEC_CLASS_KEY = "hbase.io.compress.gz.codec";
    public static final String GZ_CODEC_CLASS_DEFAULT = "org.apache.hadoop.hbase.io.compress.ReusableStreamGzipCodec";
    public static final String SNAPPY_CODEC_CLASS_KEY = "hbase.io.compress.snappy.codec";
    public static final String SNAPPY_CODEC_CLASS_DEFAULT = "org.apache.hadoop.io.compress.SnappyCodec";
    public static final String LZ4_CODEC_CLASS_KEY = "hbase.io.compress.lz4.codec";
    public static final String LZ4_CODEC_CLASS_DEFAULT = "org.apache.hadoop.io.compress.Lz4Codec";
    public static final String ZSTD_CODEC_CLASS_KEY = "hbase.io.compress.zstd.codec";
    public static final String ZSTD_CODEC_CLASS_DEFAULT = "org.apache.hadoop.io.compress.ZStandardCodec";
    public static final String BZIP2_CODEC_CLASS_KEY = "hbase.io.compress.bzip2.codec";
    public static final String BZIP2_CODEC_CLASS_DEFAULT = "org.apache.hadoop.io.compress.BZip2Codec";
    @Deprecated
    public static final String LZMA_CODEC_CLASS_KEY = "hbase.io.compress.lzma.codec";
    @Deprecated
    public static final String LZMA_CODEC_CLASS_DEFAULT = "org.apache.hadoop.hbase.io.compress.xz.LzmaCodec";
    public static final String BROTLI_CODEC_CLASS_KEY = "hbase.io.compress.brotli.codec";
    public static final String BROTLI_CODEC_CLASS_DEFAULT = "org.apache.hadoop.hbase.io.compress.brotli.BrotliCodec";

    private Compression() {
    }

    private static ClassLoader getClassLoaderForCodec() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = Compression.class.getClassLoader();
        }
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        if (cl == null) {
            throw new RuntimeException("A ClassLoader to load the Codec could not be determined");
        }
        return cl;
    }

    public static Algorithm getCompressionAlgorithmByName(String compressName) {
        Algorithm[] algos;
        for (Algorithm a : algos = (Algorithm[])Algorithm.class.getEnumConstants()) {
            if (!a.getName().equals(compressName)) continue;
            return a;
        }
        throw new IllegalArgumentException("Unsupported compression algorithm name: " + compressName);
    }

    public static String[] getSupportedAlgorithms() {
        Algorithm[] algos = (Algorithm[])Algorithm.class.getEnumConstants();
        String[] ret = new String[algos.length];
        int i = 0;
        for (Algorithm a : algos) {
            ret[i++] = a.getName();
        }
        return ret;
    }

    private static CompressionCodec buildCodec(Configuration conf, Algorithm algo) {
        try {
            String codecClassName = conf.get(algo.confKey, algo.confDefault);
            if (codecClassName == null) {
                throw new RuntimeException("No codec configured for " + algo.confKey);
            }
            Class<?> codecClass = Compression.getClassLoaderForCodec().loadClass(codecClassName);
            CompressionCodec codec = (CompressionCodec)ReflectionUtils.newInstance(codecClass, new Configuration(conf));
            LOG.info("Loaded codec {} for compression algorithm {}", (Object)codec.getClass().getCanonicalName(), (Object)algo.name());
            return codec;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) throws Exception {
        Configuration conf = HBaseConfiguration.create();
        HashMap<String, CompressionCodec> implMap = new HashMap<String, CompressionCodec>();
        for (Algorithm algo : (Algorithm[])Algorithm.class.getEnumConstants()) {
            try {
                implMap.put(algo.name(), algo.getCodec(conf));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        for (Algorithm algo : (Algorithm[])Algorithm.class.getEnumConstants()) {
            System.out.println(algo.name() + ":");
            System.out.println("    name: " + algo.getName());
            System.out.println("    confKey: " + algo.confKey);
            System.out.println("    confDefault: " + algo.confDefault);
            CompressionCodec codec = (CompressionCodec)implMap.get(algo.name());
            System.out.println("    implClass: " + (codec != null ? codec.getClass().getCanonicalName() : "<none>"));
        }
    }

    @InterfaceAudience.Public
    @SuppressWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="We are not serializing so doesn't apply (not sure why transient though)")
    public static enum Algorithm {
        LZO("lzo", "hbase.io.compress.lzo.codec", "com.hadoop.compression.lzo.LzoCodec"){
            private volatile transient CompressionCodec lzoCodec;
            private final transient Object lock = new Object();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            CompressionCodec getCodec(Configuration conf) {
                if (this.lzoCodec == null) {
                    Object object = this.lock;
                    synchronized (object) {
                        if (this.lzoCodec == null) {
                            this.lzoCodec = Compression.buildCodec(conf, this);
                        }
                    }
                }
                return this.lzoCodec;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public CompressionCodec reload(Configuration conf) {
                Object object = this.lock;
                synchronized (object) {
                    this.lzoCodec = Compression.buildCodec(conf, this);
                    LOG.warn("Reloaded configuration for {}", (Object)this.name());
                    return this.lzoCodec;
                }
            }
        }
        ,
        GZ("gz", "hbase.io.compress.gz.codec", "org.apache.hadoop.hbase.io.compress.ReusableStreamGzipCodec"){
            private volatile transient CompressionCodec gzCodec;
            private final transient Object lock = new Object();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            CompressionCodec getCodec(Configuration conf) {
                if (this.gzCodec == null) {
                    Object object = this.lock;
                    synchronized (object) {
                        if (this.gzCodec == null) {
                            this.gzCodec = Compression.buildCodec(conf, this);
                        }
                    }
                }
                return this.gzCodec;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public CompressionCodec reload(Configuration conf) {
                Object object = this.lock;
                synchronized (object) {
                    this.gzCodec = Compression.buildCodec(conf, this);
                    LOG.warn("Reloaded configuration for {}", (Object)this.name());
                    return this.gzCodec;
                }
            }
        }
        ,
        NONE("none", "", ""){

            @Override
            CompressionCodec getCodec(Configuration conf) {
                return null;
            }

            @Override
            public CompressionCodec reload(Configuration conf) {
                return null;
            }

            @Override
            public synchronized InputStream createDecompressionStream(InputStream downStream, Decompressor decompressor, int downStreamBufferSize) throws IOException {
                if (downStreamBufferSize > 0) {
                    return new BufferedInputStream(downStream, downStreamBufferSize);
                }
                return downStream;
            }

            @Override
            public synchronized OutputStream createCompressionStream(OutputStream downStream, Compressor compressor, int downStreamBufferSize) throws IOException {
                if (downStreamBufferSize > 0) {
                    return new BufferedOutputStream(downStream, downStreamBufferSize);
                }
                return downStream;
            }
        }
        ,
        SNAPPY("snappy", "hbase.io.compress.snappy.codec", "org.apache.hadoop.io.compress.SnappyCodec"){
            private volatile transient CompressionCodec snappyCodec;
            private final transient Object lock = new Object();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            CompressionCodec getCodec(Configuration conf) {
                if (this.snappyCodec == null) {
                    Object object = this.lock;
                    synchronized (object) {
                        if (this.snappyCodec == null) {
                            this.snappyCodec = Compression.buildCodec(conf, this);
                        }
                    }
                }
                return this.snappyCodec;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public CompressionCodec reload(Configuration conf) {
                Object object = this.lock;
                synchronized (object) {
                    this.snappyCodec = Compression.buildCodec(conf, this);
                    LOG.warn("Reloaded configuration for {}", (Object)this.name());
                    return this.snappyCodec;
                }
            }
        }
        ,
        LZ4("lz4", "hbase.io.compress.lz4.codec", "org.apache.hadoop.io.compress.Lz4Codec"){
            private volatile transient CompressionCodec lz4Codec;
            private final transient Object lock = new Object();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            CompressionCodec getCodec(Configuration conf) {
                if (this.lz4Codec == null) {
                    Object object = this.lock;
                    synchronized (object) {
                        if (this.lz4Codec == null) {
                            this.lz4Codec = Compression.buildCodec(conf, this);
                        }
                    }
                }
                return this.lz4Codec;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public CompressionCodec reload(Configuration conf) {
                Object object = this.lock;
                synchronized (object) {
                    this.lz4Codec = Compression.buildCodec(conf, this);
                    LOG.warn("Reloaded configuration for {}", (Object)this.name());
                    return this.lz4Codec;
                }
            }
        }
        ,
        BZIP2("bzip2", "hbase.io.compress.bzip2.codec", "org.apache.hadoop.io.compress.BZip2Codec"){
            private volatile transient CompressionCodec bzipCodec;
            private final transient Object lock = new Object();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            CompressionCodec getCodec(Configuration conf) {
                if (this.bzipCodec == null) {
                    Object object = this.lock;
                    synchronized (object) {
                        if (this.bzipCodec == null) {
                            this.bzipCodec = Compression.buildCodec(conf, this);
                        }
                    }
                }
                return this.bzipCodec;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public CompressionCodec reload(Configuration conf) {
                Object object = this.lock;
                synchronized (object) {
                    this.bzipCodec = Compression.buildCodec(conf, this);
                    LOG.warn("Reloaded configuration for {}", (Object)this.name());
                    return this.bzipCodec;
                }
            }
        }
        ,
        ZSTD("zstd", "hbase.io.compress.zstd.codec", "org.apache.hadoop.io.compress.ZStandardCodec"){
            private volatile transient CompressionCodec zStandardCodec;
            private final transient Object lock = new Object();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            CompressionCodec getCodec(Configuration conf) {
                if (this.zStandardCodec == null) {
                    Object object = this.lock;
                    synchronized (object) {
                        if (this.zStandardCodec == null) {
                            this.zStandardCodec = Compression.buildCodec(conf, this);
                        }
                    }
                }
                return this.zStandardCodec;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public CompressionCodec reload(Configuration conf) {
                Object object = this.lock;
                synchronized (object) {
                    this.zStandardCodec = Compression.buildCodec(conf, this);
                    LOG.warn("Reloaded configuration for {}", (Object)this.name());
                    return this.zStandardCodec;
                }
            }
        }
        ,
        LZMA("lzma", "hbase.io.compress.lzma.codec", "org.apache.hadoop.hbase.io.compress.xz.LzmaCodec"){
            private volatile transient CompressionCodec lzmaCodec;
            private final transient Object lock = new Object();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            CompressionCodec getCodec(Configuration conf) {
                if (this.lzmaCodec == null) {
                    Object object = this.lock;
                    synchronized (object) {
                        if (this.lzmaCodec == null) {
                            this.lzmaCodec = Compression.buildCodec(conf, this);
                        }
                    }
                }
                return this.lzmaCodec;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public CompressionCodec reload(Configuration conf) {
                Object object = this.lock;
                synchronized (object) {
                    this.lzmaCodec = Compression.buildCodec(conf, this);
                    LOG.warn("Reloaded configuration for {}", (Object)this.name());
                    return this.lzmaCodec;
                }
            }
        }
        ,
        BROTLI("brotli", "hbase.io.compress.brotli.codec", "org.apache.hadoop.hbase.io.compress.brotli.BrotliCodec"){
            private volatile transient CompressionCodec brotliCodec;
            private final transient Object lock = new Object();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            CompressionCodec getCodec(Configuration conf) {
                if (this.brotliCodec == null) {
                    Object object = this.lock;
                    synchronized (object) {
                        if (this.brotliCodec == null) {
                            this.brotliCodec = Compression.buildCodec(conf, this);
                        }
                    }
                }
                return this.brotliCodec;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public CompressionCodec reload(Configuration conf) {
                Object object = this.lock;
                synchronized (object) {
                    this.brotliCodec = Compression.buildCodec(conf, this);
                    LOG.warn("Reloaded configuration for {}", (Object)this.name());
                    return this.brotliCodec;
                }
            }
        };

        private final Configuration conf = HBaseConfiguration.create();
        private final String compressName;
        private final String confKey;
        private final String confDefault;
        private static final int DATA_IBUF_SIZE = 1024;
        private static final int DATA_OBUF_SIZE = 4096;

        private Algorithm(String name, String confKey, String confDefault) {
            this.conf.setBoolean("io.native.lib.available", true);
            this.compressName = name;
            this.confKey = confKey;
            this.confDefault = confDefault;
        }

        abstract CompressionCodec getCodec(Configuration var1);

        public abstract CompressionCodec reload(Configuration var1);

        public InputStream createDecompressionStream(InputStream downStream, Decompressor decompressor, int downStreamBufferSize) throws IOException {
            CompressionCodec codec = this.getCodec(this.conf);
            if (downStreamBufferSize > 0) {
                ((Configurable)((Object)codec)).getConf().setInt("io.file.buffer.size", downStreamBufferSize);
            }
            CompressionInputStream cis = codec.createInputStream(downStream, decompressor);
            BufferedInputStream bis2 = new BufferedInputStream(cis, 1024);
            return bis2;
        }

        public OutputStream createCompressionStream(OutputStream downStream, Compressor compressor, int downStreamBufferSize) throws IOException {
            OutputStream bos1 = null;
            bos1 = downStreamBufferSize > 0 ? new BufferedOutputStream(downStream, downStreamBufferSize) : downStream;
            CompressionOutputStream cos = this.createPlainCompressionStream(bos1, compressor);
            BufferedOutputStream bos2 = new BufferedOutputStream(new FinishOnFlushCompressionStream(cos), 4096);
            return bos2;
        }

        public CompressionOutputStream createPlainCompressionStream(OutputStream downStream, Compressor compressor) throws IOException {
            CompressionCodec codec = this.getCodec(this.conf);
            ((Configurable)((Object)codec)).getConf().setInt("io.file.buffer.size", 32768);
            return codec.createOutputStream(downStream, compressor);
        }

        public Compressor getCompressor() {
            CompressionCodec codec = this.getCodec(this.conf);
            if (codec != null) {
                Compressor compressor = CodecPool.getCompressor(codec);
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Retrieved compressor " + compressor + " from pool.");
                }
                if (compressor != null) {
                    if (compressor.finished()) {
                        LOG.warn("Compressor obtained from CodecPool is already finished()");
                    }
                    compressor.reset();
                }
                return compressor;
            }
            return null;
        }

        public void returnCompressor(Compressor compressor) {
            if (compressor != null) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Returning compressor " + compressor + " to pool.");
                }
                CodecPool.returnCompressor(compressor);
            }
        }

        public Decompressor getDecompressor() {
            CompressionCodec codec = this.getCodec(this.conf);
            if (codec != null) {
                Decompressor decompressor = CodecPool.getDecompressor(codec);
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Retrieved decompressor " + decompressor + " from pool.");
                }
                if (decompressor != null) {
                    if (decompressor.finished()) {
                        LOG.warn("Decompressor {} obtained from CodecPool is already finished", (Object)decompressor);
                    }
                    decompressor.reset();
                }
                return decompressor;
            }
            return null;
        }

        public void returnDecompressor(Decompressor decompressor) {
            if (decompressor != null) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Returning decompressor " + decompressor + " to pool.");
                }
                CodecPool.returnDecompressor(decompressor);
                if (decompressor.getClass().isAnnotationPresent(DoNotPool.class)) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Ending decompressor " + decompressor);
                    }
                    decompressor.end();
                }
            }
        }

        public String getName() {
            return this.compressName;
        }
    }

    static class FinishOnFlushCompressionStream
    extends FilterOutputStream {
        public FinishOnFlushCompressionStream(CompressionOutputStream cout) {
            super(cout);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
        }

        @Override
        public void flush() throws IOException {
            CompressionOutputStream cout = (CompressionOutputStream)this.out;
            cout.finish();
            cout.flush();
            cout.resetState();
        }
    }
}

