/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.apache.zookeeper.server;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.hbase.shaded.org.apache.jute.BinaryOutputArchive;
import org.apache.hadoop.hbase.shaded.org.apache.jute.Record;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.WatchedEvent;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.Watcher;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.data.Id;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.proto.ReplyHeader;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.proto.RequestHeader;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.server.ServerStats;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.server.Stats;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.server.ZooKeeperSaslServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ServerCnxn
implements Stats,
Watcher {
    public static final Object me = new Object();
    private static final Logger LOG = LoggerFactory.getLogger(ServerCnxn.class);
    protected ArrayList<Id> authInfo = new ArrayList();
    private static final byte[] fourBytes = new byte[4];
    boolean isOldClient = true;
    protected ZooKeeperSaslServer zooKeeperSaslServer = null;
    protected final Date established = new Date();
    protected final AtomicLong packetsReceived = new AtomicLong();
    protected final AtomicLong packetsSent = new AtomicLong();
    protected long minLatency;
    protected long maxLatency;
    protected String lastOp;
    protected long lastCxid;
    protected long lastZxid;
    protected long lastResponseTime;
    protected long lastLatency;
    protected long count;
    protected long totalLatency;

    abstract int getSessionTimeout();

    abstract void close();

    public void sendResponse(ReplyHeader h, Record r, String tag) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BinaryOutputArchive bos = BinaryOutputArchive.getArchive(baos);
        try {
            baos.write(fourBytes);
            bos.writeRecord(h, "header");
            if (r != null) {
                bos.writeRecord(r, tag);
            }
            baos.close();
        }
        catch (IOException e) {
            LOG.error("Error serializing response");
        }
        byte[] b = baos.toByteArray();
        this.serverStats().updateClientResponseSize(b.length - 4);
        ByteBuffer bb = ByteBuffer.wrap(b);
        bb.putInt(b.length - 4).rewind();
        this.sendBuffer(bb);
    }

    abstract void sendCloseSession();

    @Override
    public abstract void process(WatchedEvent var1);

    public abstract long getSessionId();

    abstract void setSessionId(long var1);

    public List<Id> getAuthInfo() {
        return Collections.unmodifiableList(this.authInfo);
    }

    public void addAuthInfo(Id id) {
        if (!this.authInfo.contains(id)) {
            this.authInfo.add(id);
        }
    }

    public boolean removeAuthInfo(Id id) {
        return this.authInfo.remove(id);
    }

    abstract void sendBuffer(ByteBuffer var1);

    abstract void enableRecv();

    abstract void disableRecv();

    abstract void setSessionTimeout(int var1);

    protected void packetReceived() {
        this.incrPacketsReceived();
        ServerStats serverStats = this.serverStats();
        if (serverStats != null) {
            this.serverStats().incrementPacketsReceived();
        }
    }

    protected void packetSent() {
        this.incrPacketsSent();
        ServerStats serverStats = this.serverStats();
        if (serverStats != null) {
            serverStats.incrementPacketsSent();
        }
    }

    protected abstract ServerStats serverStats();

    @Override
    public synchronized void resetStats() {
        this.packetsReceived.set(0L);
        this.packetsSent.set(0L);
        this.minLatency = Long.MAX_VALUE;
        this.maxLatency = 0L;
        this.lastOp = "NA";
        this.lastCxid = -1L;
        this.lastZxid = -1L;
        this.lastResponseTime = 0L;
        this.lastLatency = 0L;
        this.count = 0L;
        this.totalLatency = 0L;
    }

    protected long incrPacketsReceived() {
        return this.packetsReceived.incrementAndGet();
    }

    protected void incrOutstandingRequests(RequestHeader h) {
    }

    protected long incrPacketsSent() {
        return this.packetsSent.incrementAndGet();
    }

    protected synchronized void updateStatsForResponse(long cxid, long zxid, String op, long start, long end) {
        long elapsed;
        if (cxid >= 0L) {
            this.lastCxid = cxid;
        }
        this.lastZxid = zxid;
        this.lastOp = op;
        this.lastResponseTime = end;
        this.lastLatency = elapsed = end - start;
        if (elapsed < this.minLatency) {
            this.minLatency = elapsed;
        }
        if (elapsed > this.maxLatency) {
            this.maxLatency = elapsed;
        }
        ++this.count;
        this.totalLatency += elapsed;
    }

    @Override
    public Date getEstablished() {
        return (Date)this.established.clone();
    }

    @Override
    public abstract long getOutstandingRequests();

    @Override
    public long getPacketsReceived() {
        return this.packetsReceived.longValue();
    }

    @Override
    public long getPacketsSent() {
        return this.packetsSent.longValue();
    }

    @Override
    public synchronized long getMinLatency() {
        return this.minLatency == Long.MAX_VALUE ? 0L : this.minLatency;
    }

    @Override
    public synchronized long getAvgLatency() {
        return this.count == 0L ? 0L : this.totalLatency / this.count;
    }

    @Override
    public synchronized long getMaxLatency() {
        return this.maxLatency;
    }

    @Override
    public synchronized String getLastOperation() {
        return this.lastOp;
    }

    @Override
    public synchronized long getLastCxid() {
        return this.lastCxid;
    }

    @Override
    public synchronized long getLastZxid() {
        return this.lastZxid;
    }

    @Override
    public synchronized long getLastResponseTime() {
        return this.lastResponseTime;
    }

    @Override
    public synchronized long getLastLatency() {
        return this.lastLatency;
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter pwriter = new PrintWriter(sw);
        this.dumpConnectionInfo(pwriter, false);
        pwriter.flush();
        pwriter.close();
        return sw.toString();
    }

    public abstract InetSocketAddress getRemoteSocketAddress();

    public abstract int getInterestOps();

    public abstract boolean isSecure();

    public abstract Certificate[] getClientCertificateChain();

    public abstract void setClientCertificateChain(Certificate[] var1);

    public synchronized void dumpConnectionInfo(PrintWriter pwriter, boolean brief) {
        long sessionId;
        pwriter.print(" ");
        pwriter.print(this.getRemoteSocketAddress());
        pwriter.print("[");
        int interestOps = this.getInterestOps();
        pwriter.print(interestOps == 0 ? "0" : Integer.toHexString(interestOps));
        pwriter.print("](queued=");
        pwriter.print(this.getOutstandingRequests());
        pwriter.print(",recved=");
        pwriter.print(this.getPacketsReceived());
        pwriter.print(",sent=");
        pwriter.print(this.getPacketsSent());
        if (!brief && (sessionId = this.getSessionId()) != 0L) {
            pwriter.print(",sid=0x");
            pwriter.print(Long.toHexString(sessionId));
            pwriter.print(",lop=");
            pwriter.print(this.getLastOperation());
            pwriter.print(",est=");
            pwriter.print(this.getEstablished().getTime());
            pwriter.print(",to=");
            pwriter.print(this.getSessionTimeout());
            long lastCxid = this.getLastCxid();
            if (lastCxid >= 0L) {
                pwriter.print(",lcxid=0x");
                pwriter.print(Long.toHexString(lastCxid));
            }
            pwriter.print(",lzxid=0x");
            pwriter.print(Long.toHexString(this.getLastZxid()));
            pwriter.print(",lresp=");
            pwriter.print(this.getLastResponseTime());
            pwriter.print(",llat=");
            pwriter.print(this.getLastLatency());
            pwriter.print(",minlat=");
            pwriter.print(this.getMinLatency());
            pwriter.print(",avglat=");
            pwriter.print(this.getAvgLatency());
            pwriter.print(",maxlat=");
            pwriter.print(this.getMaxLatency());
        }
        pwriter.print(")");
    }

    public synchronized Map<String, Object> getConnectionInfo(boolean brief) {
        LinkedHashMap<String, Object> info = new LinkedHashMap<String, Object>();
        info.put("remote_socket_address", this.getRemoteSocketAddress());
        info.put("interest_ops", this.getInterestOps());
        info.put("outstanding_requests", this.getOutstandingRequests());
        info.put("packets_received", this.getPacketsReceived());
        info.put("packets_sent", this.getPacketsSent());
        if (!brief) {
            info.put("session_id", this.getSessionId());
            info.put("last_operation", this.getLastOperation());
            info.put("established", this.getEstablished());
            info.put("session_timeout", this.getSessionTimeout());
            info.put("last_cxid", this.getLastCxid());
            info.put("last_zxid", this.getLastZxid());
            info.put("last_response_time", this.getLastResponseTime());
            info.put("last_latency", this.getLastLatency());
            info.put("min_latency", this.getMinLatency());
            info.put("avg_latency", this.getAvgLatency());
            info.put("max_latency", this.getMaxLatency());
        }
        return info;
    }

    public void cleanupWriterSocket(PrintWriter pwriter) {
        try {
            if (pwriter != null) {
                pwriter.flush();
                pwriter.close();
            }
        }
        catch (Exception e) {
            LOG.info("Error closing PrintWriter ", (Throwable)e);
        }
        finally {
            try {
                this.close();
            }
            catch (Exception e) {
                LOG.error("Error closing a command socket ", (Throwable)e);
            }
        }
    }

    protected static class EndOfStreamException
    extends IOException {
        private static final long serialVersionUID = -8255690282104294178L;

        public EndOfStreamException(String msg) {
            super(msg);
        }

        @Override
        public String toString() {
            return "EndOfStreamException: " + this.getMessage();
        }
    }

    protected static class CloseRequestException
    extends IOException {
        private static final long serialVersionUID = -7854505709816442681L;

        public CloseRequestException(String msg) {
            super(msg);
        }
    }
}

