/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.List;
import org.apache.hadoop.hbase.Version;
import org.apache.hadoop.hbase.shaded.org.apache.commons.lang3.StringUtils;
import org.apache.hbase.thirdparty.com.google.common.base.Splitter;
import org.apache.hbase.thirdparty.com.google.common.collect.Iterables;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
public class VersionInfo {
    private static final Logger LOG = LoggerFactory.getLogger((String)VersionInfo.class.getName());
    private static final int VERY_LARGE_NUMBER = 100000;

    public static String getVersion() {
        return Version.version;
    }

    public static String getRevision() {
        return "37444de6531b1bdabf2e445c83d0268ab1a6f919";
    }

    public static String getDate() {
        return "Thu Feb 29 16:25:10 PST 2024";
    }

    public static String getUser() {
        return "apurtell";
    }

    public static String getUrl() {
        return "git://buildbox.localdomain/home/apurtell/RM/hbase";
    }

    static String[] versionReport() {
        return new String[]{"HBase " + VersionInfo.getVersion(), "Source code repository " + VersionInfo.getUrl() + " revision=" + VersionInfo.getRevision(), "Compiled by " + VersionInfo.getUser() + " on " + VersionInfo.getDate(), "From source with checksum " + VersionInfo.getSrcChecksum()};
    }

    public static String getSrcChecksum() {
        return "6610447458ea7ade7bba51c568868aebd22fd3c750bc0b3a5eafd006b0cd1029eae305a85f389356517b557096d62b79d99b427b07c6b1794b4964407d6e75a3";
    }

    public static void writeTo(PrintWriter out) {
        for (String line : VersionInfo.versionReport()) {
            out.println(line);
        }
    }

    public static void writeTo(PrintStream out) {
        for (String line : VersionInfo.versionReport()) {
            out.println(line);
        }
    }

    public static void logVersion() {
        for (String line : VersionInfo.versionReport()) {
            LOG.info(line);
        }
    }

    public static int compareVersion(String v1, String v2) {
        if (v1.equals(v2)) {
            return 0;
        }
        String[] v1Comps = VersionInfo.getVersionComponents(v1);
        String[] v2Comps = VersionInfo.getVersionComponents(v2);
        int length = Math.max(v1Comps.length, v2Comps.length);
        for (int i = 0; i < length; ++i) {
            Integer vb;
            Integer va = i < v1Comps.length ? Integer.parseInt(v1Comps[i]) : 0;
            int compare = va.compareTo(vb = Integer.valueOf(i < v2Comps.length ? Integer.parseInt(v2Comps[i]) : 0));
            if (compare == 0) continue;
            return compare;
        }
        return 0;
    }

    private static String[] getVersionComponents(String version) {
        assert (version != null);
        List<String> list = Splitter.onPattern("[\\.-]").splitToList(version);
        String[] strComps = list.toArray(new String[list.size()]);
        assert (strComps.length > 0);
        String[] comps = new String[strComps.length];
        for (int i = 0; i < strComps.length; ++i) {
            comps[i] = StringUtils.isNumeric(strComps[i]) ? strComps[i] : (StringUtils.isEmpty(strComps[i]) ? String.valueOf(100000) : ("SNAPSHOT".equals(strComps[i]) ? "-1" : ("beta".equals(strComps[i]) ? "-2" : ("alpha".equals(strComps[i]) ? "-3" : "-4"))));
        }
        return comps;
    }

    public static int getMajorVersion(String version) {
        return Integer.parseInt(Iterables.get(Splitter.on('.').split(version), 0));
    }

    public static void main(String[] args) {
        VersionInfo.writeTo(System.out);
    }
}

