/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.AuthUtil;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.client.AsyncConnectionImpl;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionOverAsyncConnection;
import org.apache.hadoop.hbase.client.ConnectionRegistry;
import org.apache.hadoop.hbase.client.ConnectionRegistryFactory;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.trace.TraceUtil;
import org.apache.hadoop.hbase.util.FutureUtils;
import org.apache.hadoop.hbase.util.ReflectionUtils;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class ConnectionFactory {
    public static final String HBASE_CLIENT_ASYNC_CONNECTION_IMPL = "hbase.client.async.connection.impl";

    protected ConnectionFactory() {
    }

    public static Connection createConnection() throws IOException {
        Configuration conf = HBaseConfiguration.create();
        return ConnectionFactory.createConnection(conf, null, AuthUtil.loginClient(conf));
    }

    public static Connection createConnection(Configuration conf) throws IOException {
        return ConnectionFactory.createConnection(conf, null, AuthUtil.loginClient(conf));
    }

    public static Connection createConnection(Configuration conf, ExecutorService pool) throws IOException {
        return ConnectionFactory.createConnection(conf, pool, AuthUtil.loginClient(conf));
    }

    public static Connection createConnection(Configuration conf, User user) throws IOException {
        return ConnectionFactory.createConnection(conf, null, user);
    }

    public static Connection createConnection(Configuration conf, ExecutorService pool, User user) throws IOException {
        Class<Connection> clazz = conf.getClass("hbase.client.connection.impl", ConnectionOverAsyncConnection.class, Connection.class);
        if (clazz != ConnectionOverAsyncConnection.class) {
            try {
                Constructor<Connection> constructor = clazz.getDeclaredConstructor(Configuration.class, ExecutorService.class, User.class);
                constructor.setAccessible(true);
                return user.runAs(() -> (Connection)constructor.newInstance(conf, pool, user));
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        return FutureUtils.get(ConnectionFactory.createAsyncConnection(conf, user)).toConnection();
    }

    public static CompletableFuture<AsyncConnection> createAsyncConnection() {
        return ConnectionFactory.createAsyncConnection(HBaseConfiguration.create());
    }

    public static CompletableFuture<AsyncConnection> createAsyncConnection(Configuration conf) {
        User user;
        try {
            user = AuthUtil.loginClient(conf);
        }
        catch (IOException e) {
            CompletableFuture<AsyncConnection> future = new CompletableFuture<AsyncConnection>();
            future.completeExceptionally(e);
            return future;
        }
        return ConnectionFactory.createAsyncConnection(conf, user);
    }

    public static CompletableFuture<AsyncConnection> createAsyncConnection(Configuration conf, User user) {
        return TraceUtil.tracedFuture(() -> {
            CompletableFuture future = new CompletableFuture();
            ConnectionRegistry registry = ConnectionRegistryFactory.getRegistry(conf);
            FutureUtils.addListener(registry.getClusterId(), (clusterId, error) -> {
                if (error != null) {
                    registry.close();
                    future.completeExceptionally((Throwable)error);
                    return;
                }
                if (clusterId == null) {
                    registry.close();
                    future.completeExceptionally(new IOException("clusterid came back null"));
                    return;
                }
                Class<AsyncConnection> clazz = conf.getClass(HBASE_CLIENT_ASYNC_CONNECTION_IMPL, AsyncConnectionImpl.class, AsyncConnection.class);
                try {
                    future.complete(user.runAs(() -> (AsyncConnection)ReflectionUtils.newInstance(clazz, conf, registry, clusterId, null, user)));
                }
                catch (Exception e) {
                    registry.close();
                    future.completeExceptionally(e);
                }
            });
            return future;
        }, "ConnectionFactory.createAsyncConnection");
    }
}

