/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.encoding;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.ByteBufferExtendedCell;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.ExtendedCell;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.io.TagCompressionContext;
import org.apache.hadoop.hbase.io.encoding.AbstractDataBlockEncoder;
import org.apache.hadoop.hbase.io.encoding.EncoderBufferTooSmallException;
import org.apache.hadoop.hbase.io.encoding.EncodingState;
import org.apache.hadoop.hbase.io.encoding.HFileBlockDecodingContext;
import org.apache.hadoop.hbase.io.encoding.HFileBlockDefaultDecodingContext;
import org.apache.hadoop.hbase.io.encoding.HFileBlockDefaultEncodingContext;
import org.apache.hadoop.hbase.io.encoding.HFileBlockEncodingContext;
import org.apache.hadoop.hbase.io.util.LRUDictionary;
import org.apache.hadoop.hbase.io.util.StreamUtils;
import org.apache.hadoop.hbase.nio.ByteBuff;
import org.apache.hadoop.hbase.util.ByteBufferUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ClassSize;
import org.apache.hadoop.hbase.util.ObjectIntPair;
import org.apache.hadoop.io.WritableUtils;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
abstract class BufferedDataBlockEncoder
extends AbstractDataBlockEncoder {
    private static int INITIAL_KEY_BUFFER_SIZE = 512;

    BufferedDataBlockEncoder() {
    }

    @Override
    public ByteBuffer decodeKeyValues(DataInputStream source, HFileBlockDecodingContext blkDecodingCtx) throws IOException {
        if (blkDecodingCtx.getClass() != HFileBlockDefaultDecodingContext.class) {
            throw new IOException(this.getClass().getName() + " only accepts " + HFileBlockDefaultDecodingContext.class.getName() + " as the decoding context.");
        }
        HFileBlockDefaultDecodingContext decodingCtx = (HFileBlockDefaultDecodingContext)blkDecodingCtx;
        if (decodingCtx.getHFileContext().isIncludesTags() && decodingCtx.getHFileContext().isCompressTags()) {
            if (decodingCtx.getTagCompressionContext() != null) {
                decodingCtx.getTagCompressionContext().clear();
            } else {
                try {
                    TagCompressionContext tagCompressionContext = new TagCompressionContext(LRUDictionary.class, 127);
                    decodingCtx.setTagCompressionContext(tagCompressionContext);
                }
                catch (Exception e) {
                    throw new IOException("Failed to initialize TagCompressionContext", e);
                }
            }
        }
        return this.internalDecodeKeyValues(source, 0, 0, decodingCtx);
    }

    public static int compareCommonRowPrefix(Cell left, Cell right, int rowCommonPrefix) {
        return Bytes.compareTo(left.getRowArray(), left.getRowOffset() + rowCommonPrefix, left.getRowLength() - rowCommonPrefix, right.getRowArray(), right.getRowOffset() + rowCommonPrefix, right.getRowLength() - rowCommonPrefix);
    }

    public static int compareCommonFamilyPrefix(Cell left, Cell right, int familyCommonPrefix) {
        return Bytes.compareTo(left.getFamilyArray(), left.getFamilyOffset() + familyCommonPrefix, left.getFamilyLength() - familyCommonPrefix, right.getFamilyArray(), right.getFamilyOffset() + familyCommonPrefix, right.getFamilyLength() - familyCommonPrefix);
    }

    public static int compareCommonQualifierPrefix(Cell left, Cell right, int qualCommonPrefix) {
        return Bytes.compareTo(left.getQualifierArray(), left.getQualifierOffset() + qualCommonPrefix, left.getQualifierLength() - qualCommonPrefix, right.getQualifierArray(), right.getQualifierOffset() + qualCommonPrefix, right.getQualifierLength() - qualCommonPrefix);
    }

    protected final int afterEncodingKeyValue(Cell cell, DataOutputStream out, HFileBlockDefaultEncodingContext encodingCtx) throws IOException {
        int size = 0;
        if (encodingCtx.getHFileContext().isIncludesTags()) {
            int tagsLength = cell.getTagsLength();
            ByteBufferUtils.putCompressedInt(out, tagsLength);
            if (tagsLength > 0) {
                TagCompressionContext tagCompressionContext = encodingCtx.getTagCompressionContext();
                if (tagCompressionContext != null) {
                    PrivateCellUtil.compressTags(out, cell, tagCompressionContext);
                } else {
                    PrivateCellUtil.writeTags(out, cell, tagsLength);
                }
            }
            size += tagsLength + 2;
        }
        if (encodingCtx.getHFileContext().isIncludesMvcc()) {
            long memstoreTS = cell.getSequenceId();
            WritableUtils.writeVLong(out, memstoreTS);
            size += WritableUtils.getVIntSize(memstoreTS);
        }
        return size;
    }

    protected final void afterDecodingKeyValue(DataInputStream source, ByteBuffer dest, HFileBlockDefaultDecodingContext decodingCtx) throws IOException {
        if (decodingCtx.getHFileContext().isIncludesTags()) {
            int tagsLength = ByteBufferUtils.readCompressedInt(source);
            dest.put((byte)(tagsLength >> 8 & 0xFF));
            dest.put((byte)(tagsLength & 0xFF));
            if (tagsLength > 0) {
                TagCompressionContext tagCompressionContext = decodingCtx.getTagCompressionContext();
                if (tagCompressionContext != null) {
                    tagCompressionContext.uncompressTags(source, dest, tagsLength);
                } else {
                    ByteBufferUtils.copyFromStreamToBuffer(dest, source, tagsLength);
                }
            }
        }
        if (decodingCtx.getHFileContext().isIncludesMvcc()) {
            long memstoreTS = -1L;
            try {
                memstoreTS = WritableUtils.readVLong(source);
                ByteBufferUtils.writeVLong(dest, memstoreTS);
            }
            catch (IOException ex) {
                throw new RuntimeException("Unable to copy memstore timestamp " + memstoreTS + " after decoding a key/value");
            }
        }
    }

    protected abstract ByteBuffer internalDecodeKeyValues(DataInputStream var1, int var2, int var3, HFileBlockDefaultDecodingContext var4) throws IOException;

    protected static void ensureSpace(ByteBuffer out, int length) throws EncoderBufferTooSmallException {
        if (out.position() + length > out.limit()) {
            throw new EncoderBufferTooSmallException("Buffer position=" + out.position() + ", buffer limit=" + out.limit() + ", length to be written=" + length);
        }
    }

    @Override
    public void startBlockEncoding(HFileBlockEncodingContext blkEncodingCtx, DataOutputStream out) throws IOException {
        if (blkEncodingCtx.getClass() != HFileBlockDefaultEncodingContext.class) {
            throw new IOException(this.getClass().getName() + " only accepts " + HFileBlockDefaultEncodingContext.class.getName() + " as the encoding context.");
        }
        HFileBlockDefaultEncodingContext encodingCtx = (HFileBlockDefaultEncodingContext)blkEncodingCtx;
        encodingCtx.prepareEncoding(out);
        if (encodingCtx.getHFileContext().isIncludesTags() && encodingCtx.getHFileContext().isCompressTags()) {
            if (encodingCtx.getTagCompressionContext() != null) {
                encodingCtx.getTagCompressionContext().clear();
            } else {
                try {
                    TagCompressionContext tagCompressionContext = new TagCompressionContext(LRUDictionary.class, 127);
                    encodingCtx.setTagCompressionContext(tagCompressionContext);
                }
                catch (Exception e) {
                    throw new IOException("Failed to initialize TagCompressionContext", e);
                }
            }
        }
        StreamUtils.writeInt(out, 0);
        blkEncodingCtx.setEncodingState(new EncodingState());
    }

    @Override
    public void encode(Cell cell, HFileBlockEncodingContext encodingCtx, DataOutputStream out) throws IOException {
        EncodingState state = encodingCtx.getEncodingState();
        int posBeforeEncode = out.size();
        int encodedKvSize = this.internalEncode(cell, (HFileBlockDefaultEncodingContext)encodingCtx, out);
        state.postCellEncode(encodedKvSize, out.size() - posBeforeEncode);
    }

    public abstract int internalEncode(Cell var1, HFileBlockDefaultEncodingContext var2, DataOutputStream var3) throws IOException;

    @Override
    public void endBlockEncoding(HFileBlockEncodingContext encodingCtx, DataOutputStream out, byte[] uncompressedBytesWithHeader) throws IOException {
        EncodingState state = encodingCtx.getEncodingState();
        Bytes.putInt(uncompressedBytesWithHeader, 35, state.getUnencodedDataSizeWritten());
        this.postEncoding(encodingCtx);
    }

    protected static abstract class BufferedEncodedSeeker<STATE extends SeekerState>
    extends AbstractDataBlockEncoder.AbstractEncodedSeeker {
        protected ByteBuff currentBuffer;
        protected TagCompressionContext tagCompressionContext = null;
        protected KeyValue.KeyOnlyKeyValue keyOnlyKV = new KeyValue.KeyOnlyKeyValue();
        protected final ObjectIntPair<ByteBuffer> tmpPair = new ObjectIntPair();
        protected STATE current;
        protected STATE previous;

        public BufferedEncodedSeeker(HFileBlockDecodingContext decodingCtx) {
            super(decodingCtx);
            if (decodingCtx.getHFileContext().isCompressTags()) {
                try {
                    this.tagCompressionContext = new TagCompressionContext(LRUDictionary.class, 127);
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to initialize TagCompressionContext", e);
                }
            }
            this.current = this.createSeekerState();
            this.previous = this.createSeekerState();
        }

        @Override
        public int compareKey(CellComparator comparator, Cell key) {
            this.keyOnlyKV.setKey(((SeekerState)this.current).keyBuffer, 0, ((SeekerState)this.current).keyLength);
            return PrivateCellUtil.compareKeyIgnoresMvcc(comparator, key, this.keyOnlyKV);
        }

        @Override
        public void setCurrentBuffer(ByteBuff buffer) {
            if (this.tagCompressionContext != null) {
                this.tagCompressionContext.clear();
            }
            ((SeekerState)this.current).currentBuffer = this.currentBuffer = buffer;
            if (this.tagCompressionContext != null) {
                ((SeekerState)this.current).tagCompressionContext = this.tagCompressionContext;
            }
            this.decodeFirst();
            ((SeekerState)this.current).setKey(((SeekerState)this.current).keyBuffer, ((SeekerState)this.current).memstoreTS);
            ((SeekerState)this.previous).invalidate();
        }

        @Override
        public Cell getKey() {
            byte[] key = new byte[((SeekerState)this.current).keyLength];
            System.arraycopy(((SeekerState)this.current).keyBuffer, 0, key, 0, ((SeekerState)this.current).keyLength);
            return new KeyValue.KeyOnlyKeyValue(key);
        }

        @Override
        public ByteBuffer getValueShallowCopy() {
            this.currentBuffer.asSubByteBuffer(((SeekerState)this.current).valueOffset, ((SeekerState)this.current).valueLength, this.tmpPair);
            ByteBuffer dup = this.tmpPair.getFirst().duplicate();
            dup.position(this.tmpPair.getSecond());
            dup.limit(this.tmpPair.getSecond() + ((SeekerState)this.current).valueLength);
            return dup.slice();
        }

        @Override
        public Cell getCell() {
            return ((SeekerState)this.current).toCell();
        }

        @Override
        public void rewind() {
            this.currentBuffer.rewind();
            if (this.tagCompressionContext != null) {
                this.tagCompressionContext.clear();
            }
            this.decodeFirst();
            ((SeekerState)this.current).setKey(((SeekerState)this.current).keyBuffer, ((SeekerState)this.current).memstoreTS);
            ((SeekerState)this.previous).invalidate();
        }

        @Override
        public boolean next() {
            if (!this.currentBuffer.hasRemaining()) {
                return false;
            }
            this.decodeNext();
            ((SeekerState)this.current).setKey(((SeekerState)this.current).keyBuffer, ((SeekerState)this.current).memstoreTS);
            ((SeekerState)this.previous).invalidate();
            return true;
        }

        protected void decodeTags() {
            ((SeekerState)this.current).tagsLength = ByteBuff.readCompressedInt(this.currentBuffer);
            if (this.tagCompressionContext != null) {
                if (((SeekerState)this.current).uncompressTags) {
                    ((SeekerState)this.current).ensureSpaceForTags();
                    try {
                        ((SeekerState)this.current).tagsCompressedLength = this.tagCompressionContext.uncompressTags(this.currentBuffer, ((SeekerState)this.current).tagsBuffer, 0, ((SeekerState)this.current).tagsLength);
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Exception while uncompressing tags", e);
                    }
                } else {
                    this.currentBuffer.skip(((SeekerState)this.current).tagsCompressedLength);
                    ((SeekerState)this.current).uncompressTags = true;
                }
                ((SeekerState)this.current).tagsOffset = -1;
            } else {
                ((SeekerState)this.current).tagsOffset = this.currentBuffer.position();
                this.currentBuffer.skip(((SeekerState)this.current).tagsLength);
            }
        }

        @Override
        public int seekToKeyInBlock(Cell seekCell, boolean seekBefore) {
            int rowCommonPrefix = 0;
            int familyCommonPrefix = 0;
            int qualCommonPrefix = 0;
            ((SeekerState)this.previous).invalidate();
            while (true) {
                int comp;
                this.keyOnlyKV.setKey(((SeekerState)this.current).keyBuffer, 0, ((SeekerState)this.current).keyLength);
                if (((SeekerState)this.current).lastCommonPrefix != 0) {
                    rowCommonPrefix = Math.min(rowCommonPrefix, ((SeekerState)this.current).lastCommonPrefix - 2);
                }
                if (((SeekerState)this.current).lastCommonPrefix <= 2) {
                    rowCommonPrefix = 0;
                }
                if ((comp = BufferedDataBlockEncoder.compareCommonRowPrefix(seekCell, this.keyOnlyKV, rowCommonPrefix += BufferedEncodedSeeker.findCommonPrefixInRowPart(seekCell, this.keyOnlyKV, rowCommonPrefix))) == 0 && (comp = this.compareTypeBytes(seekCell, this.keyOnlyKV)) == 0) {
                    familyCommonPrefix = Math.max(0, Math.min(familyCommonPrefix, ((SeekerState)this.current).lastCommonPrefix - (3 + this.keyOnlyKV.getRowLength())));
                    if ((comp = BufferedDataBlockEncoder.compareCommonFamilyPrefix(seekCell, this.keyOnlyKV, familyCommonPrefix += BufferedEncodedSeeker.findCommonPrefixInFamilyPart(seekCell, this.keyOnlyKV, familyCommonPrefix))) == 0) {
                        qualCommonPrefix = Math.max(0, Math.min(qualCommonPrefix, ((SeekerState)this.current).lastCommonPrefix - (3 + this.keyOnlyKV.getRowLength() + this.keyOnlyKV.getFamilyLength())));
                        if ((comp = BufferedDataBlockEncoder.compareCommonQualifierPrefix(seekCell, this.keyOnlyKV, qualCommonPrefix += BufferedEncodedSeeker.findCommonPrefixInQualifierPart(seekCell, this.keyOnlyKV, qualCommonPrefix))) == 0 && (comp = CellComparator.getInstance().compareTimestamps(seekCell, this.keyOnlyKV)) == 0) {
                            comp = (0xFF & this.keyOnlyKV.getTypeByte()) - (0xFF & seekCell.getTypeByte());
                        }
                    }
                }
                if (comp == 0) {
                    if (seekBefore) {
                        if (!((SeekerState)this.previous).isValid()) {
                            throw new IllegalStateException("Cannot seekBefore if positioned at the first key in the block: key=" + Bytes.toStringBinary(seekCell.getRowArray()));
                        }
                        this.moveToPrevious();
                        return 1;
                    }
                    return 0;
                }
                if (comp < 0) {
                    if (!((SeekerState)this.previous).isValid()) {
                        return -2;
                    }
                    this.moveToPrevious();
                    return 1;
                }
                if (!this.currentBuffer.hasRemaining()) break;
                ((SeekerState)this.previous).copyFromNext((SeekerState)this.current);
                this.decodeNext();
                ((SeekerState)this.current).setKey(((SeekerState)this.current).keyBuffer, ((SeekerState)this.current).memstoreTS);
            }
            return 1;
        }

        private int compareTypeBytes(Cell key, Cell right) {
            if (key.getFamilyLength() + key.getQualifierLength() == 0 && key.getTypeByte() == KeyValue.Type.Minimum.getCode()) {
                return 1;
            }
            if (right.getFamilyLength() + right.getQualifierLength() == 0 && right.getTypeByte() == KeyValue.Type.Minimum.getCode()) {
                return -1;
            }
            return 0;
        }

        private static int findCommonPrefixInRowPart(Cell left, Cell right, int rowCommonPrefix) {
            return Bytes.findCommonPrefix(left.getRowArray(), right.getRowArray(), left.getRowLength() - rowCommonPrefix, right.getRowLength() - rowCommonPrefix, left.getRowOffset() + rowCommonPrefix, right.getRowOffset() + rowCommonPrefix);
        }

        private static int findCommonPrefixInFamilyPart(Cell left, Cell right, int familyCommonPrefix) {
            return Bytes.findCommonPrefix(left.getFamilyArray(), right.getFamilyArray(), left.getFamilyLength() - familyCommonPrefix, right.getFamilyLength() - familyCommonPrefix, left.getFamilyOffset() + familyCommonPrefix, right.getFamilyOffset() + familyCommonPrefix);
        }

        private static int findCommonPrefixInQualifierPart(Cell left, Cell right, int qualifierCommonPrefix) {
            return Bytes.findCommonPrefix(left.getQualifierArray(), right.getQualifierArray(), left.getQualifierLength() - qualifierCommonPrefix, right.getQualifierLength() - qualifierCommonPrefix, left.getQualifierOffset() + qualifierCommonPrefix, right.getQualifierOffset() + qualifierCommonPrefix);
        }

        private void moveToPrevious() {
            if (!((SeekerState)this.previous).isValid()) {
                throw new IllegalStateException("Can move back only once and not in first key in the block.");
            }
            STATE tmp = this.previous;
            this.previous = this.current;
            this.current = tmp;
            this.currentBuffer.position(((SeekerState)this.current).nextKvOffset);
            ((SeekerState)this.current).tagsBuffer = ((SeekerState)this.previous).tagsBuffer;
            ((SeekerState)this.current).tagsCompressedLength = ((SeekerState)this.previous).tagsCompressedLength;
            ((SeekerState)this.current).uncompressTags = false;
            ((SeekerState)this.current).setKey(((SeekerState)this.current).keyBuffer, ((SeekerState)this.current).memstoreTS);
            ((SeekerState)this.previous).invalidate();
        }

        protected STATE createSeekerState() {
            return (STATE)new SeekerState(this.tmpPair, this.includesTags());
        }

        protected abstract void decodeFirst();

        protected abstract void decodeNext();
    }

    protected static class OffheapDecodedExtendedCell
    extends ByteBufferExtendedCell {
        private static final long FIXED_OVERHEAD = ClassSize.align(ClassSize.OBJECT + 3 * ClassSize.REFERENCE + 16 + 28 + 2 + 2 + 3 * ClassSize.BYTE_BUFFER);
        private ByteBuffer keyBuffer;
        private short rowLength;
        private int familyOffset;
        private byte familyLength;
        private int qualifierOffset;
        private int qualifierLength;
        private long timestamp;
        private byte typeByte;
        private ByteBuffer valueBuffer;
        private int valueOffset;
        private int valueLength;
        private ByteBuffer tagsBuffer;
        private int tagsOffset;
        private int tagsLength;
        private long seqId;

        protected OffheapDecodedExtendedCell(ByteBuffer keyBuffer, short rowLength, int familyOffset, byte familyLength, int qualOffset, int qualLength, long timeStamp, byte typeByte, ByteBuffer valueBuffer, int valueOffset, int valueLen, long seqId, ByteBuffer tagsBuffer, int tagsOffset, int tagsLength) {
            assert (keyBuffer.hasArray());
            assert (keyBuffer.arrayOffset() == 0);
            this.keyBuffer = keyBuffer;
            this.rowLength = rowLength;
            this.familyOffset = familyOffset;
            this.familyLength = familyLength;
            this.qualifierOffset = qualOffset;
            this.qualifierLength = qualLength;
            this.timestamp = timeStamp;
            this.typeByte = typeByte;
            this.valueBuffer = valueBuffer;
            this.valueOffset = valueOffset;
            this.valueLength = valueLen;
            this.tagsBuffer = tagsBuffer;
            this.tagsOffset = tagsOffset;
            this.tagsLength = tagsLength;
            this.setSequenceId(seqId);
        }

        @Override
        public byte[] getRowArray() {
            return this.keyBuffer.array();
        }

        @Override
        public int getRowOffset() {
            return this.getRowPosition();
        }

        @Override
        public short getRowLength() {
            return this.rowLength;
        }

        @Override
        public byte[] getFamilyArray() {
            return this.keyBuffer.array();
        }

        @Override
        public int getFamilyOffset() {
            return this.getFamilyPosition();
        }

        @Override
        public byte getFamilyLength() {
            return this.familyLength;
        }

        @Override
        public byte[] getQualifierArray() {
            return this.keyBuffer.array();
        }

        @Override
        public int getQualifierOffset() {
            return this.getQualifierPosition();
        }

        @Override
        public int getQualifierLength() {
            return this.qualifierLength;
        }

        @Override
        public long getTimestamp() {
            return this.timestamp;
        }

        @Override
        public byte getTypeByte() {
            return this.typeByte;
        }

        @Override
        public long getSequenceId() {
            return this.seqId;
        }

        @Override
        public byte[] getValueArray() {
            return CellUtil.cloneValue(this);
        }

        @Override
        public int getValueOffset() {
            return 0;
        }

        @Override
        public int getValueLength() {
            return this.valueLength;
        }

        @Override
        public byte[] getTagsArray() {
            return PrivateCellUtil.cloneTags(this);
        }

        @Override
        public int getTagsOffset() {
            return 0;
        }

        @Override
        public int getTagsLength() {
            return this.tagsLength;
        }

        @Override
        public ByteBuffer getRowByteBuffer() {
            return this.keyBuffer;
        }

        @Override
        public int getRowPosition() {
            return 2;
        }

        @Override
        public ByteBuffer getFamilyByteBuffer() {
            return this.keyBuffer;
        }

        @Override
        public int getFamilyPosition() {
            return this.familyOffset;
        }

        @Override
        public ByteBuffer getQualifierByteBuffer() {
            return this.keyBuffer;
        }

        @Override
        public int getQualifierPosition() {
            return this.qualifierOffset;
        }

        @Override
        public ByteBuffer getValueByteBuffer() {
            return this.valueBuffer;
        }

        @Override
        public int getValuePosition() {
            return this.valueOffset;
        }

        @Override
        public ByteBuffer getTagsByteBuffer() {
            return this.tagsBuffer;
        }

        @Override
        public int getTagsPosition() {
            return this.tagsOffset;
        }

        @Override
        public long heapSize() {
            return FIXED_OVERHEAD;
        }

        @Override
        public void setSequenceId(long seqId) {
            this.seqId = seqId;
        }

        @Override
        public int write(OutputStream out, boolean withTags) throws IOException {
            int lenToWrite = this.getSerializedSize(withTags);
            ByteBufferUtils.putInt(out, this.keyBuffer.capacity());
            ByteBufferUtils.putInt(out, this.valueLength);
            out.write(this.keyBuffer.array());
            ByteBufferUtils.copyBufferToStream(out, this.valueBuffer, this.valueOffset, this.valueLength);
            if (withTags && this.tagsLength > 0) {
                out.write((byte)(0xFF & this.tagsLength >> 8));
                out.write((byte)(0xFF & this.tagsLength));
                ByteBufferUtils.copyBufferToStream(out, this.tagsBuffer, this.tagsOffset, this.tagsLength);
            }
            return lenToWrite;
        }

        @Override
        public int getSerializedSize(boolean withTags) {
            return KeyValueUtil.length(this.rowLength, this.familyLength, this.qualifierLength, this.valueLength, this.tagsLength, withTags);
        }

        @Override
        public void setTimestamp(long ts) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setTimestamp(byte[] ts) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void write(ByteBuffer buf, int offset) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ExtendedCell deepClone() {
            throw new UnsupportedOperationException();
        }
    }

    protected static class OnheapDecodedCell
    implements ExtendedCell {
        private static final long FIXED_OVERHEAD = ClassSize.align(ClassSize.OBJECT + 3 * ClassSize.REFERENCE + 16 + 28 + 2 + 2 + 3 * ClassSize.ARRAY);
        private byte[] keyOnlyBuffer;
        private short rowLength;
        private int familyOffset;
        private byte familyLength;
        private int qualifierOffset;
        private int qualifierLength;
        private long timestamp;
        private byte typeByte;
        private byte[] valueBuffer;
        private int valueOffset;
        private int valueLength;
        private byte[] tagsBuffer;
        private int tagsOffset;
        private int tagsLength;
        private long seqId;

        protected OnheapDecodedCell(byte[] keyBuffer, short rowLength, int familyOffset, byte familyLength, int qualOffset, int qualLength, long timeStamp, byte typeByte, byte[] valueBuffer, int valueOffset, int valueLen, long seqId, byte[] tagsBuffer, int tagsOffset, int tagsLength) {
            this.keyOnlyBuffer = keyBuffer;
            this.rowLength = rowLength;
            this.familyOffset = familyOffset;
            this.familyLength = familyLength;
            this.qualifierOffset = qualOffset;
            this.qualifierLength = qualLength;
            this.timestamp = timeStamp;
            this.typeByte = typeByte;
            this.valueBuffer = valueBuffer;
            this.valueOffset = valueOffset;
            this.valueLength = valueLen;
            this.tagsBuffer = tagsBuffer;
            this.tagsOffset = tagsOffset;
            this.tagsLength = tagsLength;
            this.setSequenceId(seqId);
        }

        @Override
        public byte[] getRowArray() {
            return this.keyOnlyBuffer;
        }

        @Override
        public byte[] getFamilyArray() {
            return this.keyOnlyBuffer;
        }

        @Override
        public byte[] getQualifierArray() {
            return this.keyOnlyBuffer;
        }

        @Override
        public int getRowOffset() {
            return 2;
        }

        @Override
        public short getRowLength() {
            return this.rowLength;
        }

        @Override
        public int getFamilyOffset() {
            return this.familyOffset;
        }

        @Override
        public byte getFamilyLength() {
            return this.familyLength;
        }

        @Override
        public int getQualifierOffset() {
            return this.qualifierOffset;
        }

        @Override
        public int getQualifierLength() {
            return this.qualifierLength;
        }

        @Override
        public long getTimestamp() {
            return this.timestamp;
        }

        @Override
        public byte getTypeByte() {
            return this.typeByte;
        }

        @Override
        public long getSequenceId() {
            return this.seqId;
        }

        @Override
        public byte[] getValueArray() {
            return this.valueBuffer;
        }

        @Override
        public int getValueOffset() {
            return this.valueOffset;
        }

        @Override
        public int getValueLength() {
            return this.valueLength;
        }

        @Override
        public byte[] getTagsArray() {
            return this.tagsBuffer;
        }

        @Override
        public int getTagsOffset() {
            return this.tagsOffset;
        }

        @Override
        public int getTagsLength() {
            return this.tagsLength;
        }

        public String toString() {
            return KeyValue.keyToString(this.keyOnlyBuffer, 0, KeyValueUtil.keyLength(this)) + "/vlen=" + this.getValueLength() + "/seqid=" + this.seqId;
        }

        @Override
        public void setSequenceId(long seqId) {
            this.seqId = seqId;
        }

        @Override
        public long heapSize() {
            return FIXED_OVERHEAD + (long)this.rowLength + (long)this.familyLength + (long)this.qualifierLength + (long)this.valueLength + (long)this.tagsLength;
        }

        @Override
        public int write(OutputStream out, boolean withTags) throws IOException {
            int lenToWrite = this.getSerializedSize(withTags);
            ByteBufferUtils.putInt(out, this.keyOnlyBuffer.length);
            ByteBufferUtils.putInt(out, this.valueLength);
            out.write(this.keyOnlyBuffer);
            out.write(this.valueBuffer, this.valueOffset, this.valueLength);
            if (withTags && this.tagsLength > 0) {
                out.write((byte)(0xFF & this.tagsLength >> 8));
                out.write((byte)(0xFF & this.tagsLength));
                out.write(this.tagsBuffer, this.tagsOffset, this.tagsLength);
            }
            return lenToWrite;
        }

        @Override
        public int getSerializedSize(boolean withTags) {
            return KeyValueUtil.length(this.rowLength, this.familyLength, this.qualifierLength, this.valueLength, this.tagsLength, withTags);
        }

        @Override
        public void write(ByteBuffer buf, int offset) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setTimestamp(long ts) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setTimestamp(byte[] ts) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public ExtendedCell deepClone() {
            throw new UnsupportedOperationException();
        }
    }

    protected static class SeekerState {
        protected ByteBuff currentBuffer;
        protected TagCompressionContext tagCompressionContext;
        protected int valueOffset = -1;
        protected int keyLength;
        protected int valueLength;
        protected int lastCommonPrefix;
        protected int tagsLength = 0;
        protected int tagsOffset = -1;
        protected int tagsCompressedLength = 0;
        protected boolean uncompressTags = true;
        protected byte[] keyBuffer = HConstants.EMPTY_BYTE_ARRAY;
        protected byte[] tagsBuffer = HConstants.EMPTY_BYTE_ARRAY;
        protected long memstoreTS;
        protected int nextKvOffset;
        protected KeyValue.KeyOnlyKeyValue currentKey = new KeyValue.KeyOnlyKeyValue();
        private final ObjectIntPair<ByteBuffer> tmpPair;
        private final boolean includeTags;

        public SeekerState(ObjectIntPair<ByteBuffer> tmpPair, boolean includeTags) {
            this.tmpPair = tmpPair;
            this.includeTags = includeTags;
        }

        protected boolean isValid() {
            return this.valueOffset != -1;
        }

        protected void invalidate() {
            this.valueOffset = -1;
            this.tagsCompressedLength = 0;
            this.currentKey.clear();
            this.uncompressTags = true;
            this.currentBuffer = null;
        }

        protected void ensureSpaceForKey() {
            if (this.keyLength > this.keyBuffer.length) {
                int newKeyBufferLength = Integer.highestOneBit(Math.max(INITIAL_KEY_BUFFER_SIZE, this.keyLength) - 1) << 1;
                byte[] newKeyBuffer = new byte[newKeyBufferLength];
                System.arraycopy(this.keyBuffer, 0, newKeyBuffer, 0, this.keyBuffer.length);
                this.keyBuffer = newKeyBuffer;
            }
        }

        protected void ensureSpaceForTags() {
            if (this.tagsLength > this.tagsBuffer.length) {
                int newTagsBufferLength = Integer.highestOneBit(Math.max(INITIAL_KEY_BUFFER_SIZE, this.tagsLength) - 1) << 1;
                byte[] newTagsBuffer = new byte[newTagsBufferLength];
                System.arraycopy(this.tagsBuffer, 0, newTagsBuffer, 0, this.tagsBuffer.length);
                this.tagsBuffer = newTagsBuffer;
            }
        }

        protected void setKey(byte[] keyBuffer, long memTS) {
            this.currentKey.setKey(keyBuffer, 0, this.keyLength);
            this.memstoreTS = memTS;
        }

        protected void copyFromNext(SeekerState nextState) {
            if (this.keyBuffer.length != nextState.keyBuffer.length) {
                this.keyBuffer = (byte[])nextState.keyBuffer.clone();
            } else if (!this.isValid()) {
                System.arraycopy(nextState.keyBuffer, 0, this.keyBuffer, 0, nextState.keyLength);
            } else {
                System.arraycopy(nextState.keyBuffer, nextState.lastCommonPrefix, this.keyBuffer, nextState.lastCommonPrefix, nextState.keyLength - nextState.lastCommonPrefix);
            }
            this.currentKey.set(nextState.currentKey);
            this.valueOffset = nextState.valueOffset;
            this.keyLength = nextState.keyLength;
            this.valueLength = nextState.valueLength;
            this.lastCommonPrefix = nextState.lastCommonPrefix;
            this.nextKvOffset = nextState.nextKvOffset;
            this.memstoreTS = nextState.memstoreTS;
            this.currentBuffer = nextState.currentBuffer;
            this.tagsOffset = nextState.tagsOffset;
            this.tagsLength = nextState.tagsLength;
            if (nextState.tagCompressionContext != null) {
                this.tagCompressionContext = nextState.tagCompressionContext;
            }
        }

        public Cell toCell() {
            int valAndTagsLength = this.valueLength;
            int tagsLenSerializationSize = 0;
            if (this.includeTags && this.tagCompressionContext == null) {
                tagsLenSerializationSize = this.tagsOffset - (this.valueOffset + this.valueLength);
                valAndTagsLength += tagsLenSerializationSize + this.tagsLength;
            }
            this.currentBuffer.asSubByteBuffer(this.valueOffset, valAndTagsLength, this.tmpPair);
            ByteBuffer valAndTagsBuffer = this.tmpPair.getFirst();
            int vOffset = this.tmpPair.getSecond();
            if (valAndTagsBuffer.hasArray()) {
                return this.toOnheapCell(valAndTagsBuffer, vOffset, tagsLenSerializationSize);
            }
            return this.toOffheapCell(valAndTagsBuffer, vOffset, tagsLenSerializationSize);
        }

        private Cell toOnheapCell(ByteBuffer valAndTagsBuffer, int vOffset, int tagsLenSerializationSize) {
            byte[] tagsArray = HConstants.EMPTY_BYTE_ARRAY;
            int tOffset = 0;
            if (this.includeTags) {
                if (this.tagCompressionContext == null) {
                    tOffset = valAndTagsBuffer.arrayOffset() + vOffset + this.valueLength + tagsLenSerializationSize;
                    tagsArray = Bytes.copy(valAndTagsBuffer.array(), tOffset, this.tagsLength);
                    tOffset = 0;
                } else {
                    tagsArray = Bytes.copy(this.tagsBuffer, 0, this.tagsLength);
                    tOffset = 0;
                }
            }
            return new OnheapDecodedCell(Bytes.copy(this.keyBuffer, 0, this.keyLength), this.currentKey.getRowLength(), this.currentKey.getFamilyOffset(), this.currentKey.getFamilyLength(), this.currentKey.getQualifierOffset(), this.currentKey.getQualifierLength(), this.currentKey.getTimestamp(), this.currentKey.getTypeByte(), Bytes.copy(valAndTagsBuffer.array(), valAndTagsBuffer.arrayOffset() + vOffset, this.valueLength), 0, this.valueLength, this.memstoreTS, tagsArray, tOffset, this.tagsLength);
        }

        private Cell toOffheapCell(ByteBuffer valAndTagsBuffer, int vOffset, int tagsLenSerializationSize) {
            byte[] output;
            ByteBuffer tagsBuf = HConstants.EMPTY_BYTE_BUFFER;
            int tOffset = 0;
            if (this.includeTags) {
                if (this.tagCompressionContext == null) {
                    tOffset = vOffset + this.valueLength + tagsLenSerializationSize;
                    output = new byte[this.tagsLength];
                    ByteBufferUtils.copyFromBufferToArray(output, valAndTagsBuffer, tOffset, 0, this.tagsLength);
                    tagsBuf = ByteBuffer.wrap(output);
                    tOffset = 0;
                } else {
                    tagsBuf = ByteBuffer.wrap(Bytes.copy(this.tagsBuffer, 0, this.tagsLength));
                    tOffset = 0;
                }
            }
            if (this.valueLength > 0) {
                output = new byte[this.valueLength];
                ByteBufferUtils.copyFromBufferToArray(output, valAndTagsBuffer, vOffset, 0, this.valueLength);
                valAndTagsBuffer = ByteBuffer.wrap(output);
                vOffset = 0;
            }
            return new OffheapDecodedExtendedCell(ByteBuffer.wrap(Bytes.copy(this.keyBuffer, 0, this.keyLength)), this.currentKey.getRowLength(), this.currentKey.getFamilyOffset(), this.currentKey.getFamilyLength(), this.currentKey.getQualifierOffset(), this.currentKey.getQualifierLength(), this.currentKey.getTimestamp(), this.currentKey.getTypeByte(), valAndTagsBuffer, vOffset, this.valueLength, this.memstoreTS, tagsBuf, tOffset, this.tagsLength);
        }
    }
}

