/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.apache.kerby.kerberos.kerb.crypto.dh;

import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.KeyAgreement;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.kerberos.kerb.crypto.EncTypeHandler;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.kerberos.kerb.crypto.EncryptionHandler;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.kerberos.kerb.crypto.dh.OctetString2Key;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.kerberos.kerb.type.base.EncryptionKey;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.kerberos.kerb.type.base.EncryptionType;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.kerberos.kerb.type.base.KeyUsage;

public class DiffieHellmanClient {
    private KeyAgreement clientKeyAgree;
    private EncryptionKey clientKey;
    private DHParameterSpec dhParameterSpec;

    public DHParameterSpec getDhParam() {
        return this.dhParameterSpec;
    }

    public DHPublicKey init(DHParameterSpec dhParamSpec) throws Exception {
        this.dhParameterSpec = dhParamSpec;
        KeyPairGenerator clientKpairGen = KeyPairGenerator.getInstance("DH");
        clientKpairGen.initialize(dhParamSpec);
        KeyPair clientKpair = clientKpairGen.generateKeyPair();
        this.clientKeyAgree = KeyAgreement.getInstance("DH");
        this.clientKeyAgree.init(clientKpair.getPrivate());
        return (DHPublicKey)clientKpair.getPublic();
    }

    public void doPhase(byte[] serverPubKeyEnc) throws Exception {
        KeyFactory clientKeyFac = KeyFactory.getInstance("DH");
        X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(serverPubKeyEnc);
        PublicKey serverPubKey = clientKeyFac.generatePublic(x509KeySpec);
        this.clientKeyAgree.doPhase(serverPubKey, true);
    }

    public EncryptionKey generateKey(byte[] clientDhNonce, byte[] serverDhNonce, EncryptionType type) {
        byte[] dhSharedSecret;
        byte[] x = dhSharedSecret = this.clientKeyAgree.generateSecret();
        if (clientDhNonce != null && clientDhNonce.length > 0 && serverDhNonce != null && serverDhNonce.length > 0) {
            x = this.concatenateBytes(dhSharedSecret, clientDhNonce);
            x = this.concatenateBytes(x, serverDhNonce);
        }
        byte[] secret = OctetString2Key.kTruncate(dhSharedSecret.length, x);
        this.clientKey = new EncryptionKey(type, secret);
        return this.clientKey;
    }

    public byte[] decrypt(byte[] cipherText, KeyUsage usage) throws Exception {
        EncTypeHandler encType = EncryptionHandler.getEncHandler(this.clientKey.getKeyType());
        return encType.decrypt(cipherText, this.clientKey.getKeyData(), usage.getValue());
    }

    private byte[] concatenateBytes(byte[] array1, byte[] array2) {
        byte[] concatenatedBytes = new byte[array1.length + array2.length];
        System.arraycopy(array1, 0, concatenatedBytes, 0, array1.length);
        for (int j = array1.length; j < concatenatedBytes.length; ++j) {
            concatenatedBytes[j] = array2[j - array1.length];
        }
        return concatenatedBytes;
    }
}

