/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.apache.kerby.xdr.type;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.xdr.EnumType;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.xdr.XdrDataType;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.xdr.type.XdrSimple;

public abstract class XdrEnumerated<T extends EnumType>
extends XdrSimple<T> {
    public XdrEnumerated() {
        this(null);
    }

    public XdrEnumerated(T value) {
        super(XdrDataType.ENUM, value);
    }

    @Override
    protected void toBytes() {
        byte[] bytes = ByteBuffer.allocate(4).putInt(((EnumType)this.getValue()).getValue()).array();
        this.setBytes(bytes);
    }

    @Override
    protected void toValue() {
        EnumType[] allValues;
        if (this.getBytes().length != 4) {
            byte[] intBytes = ByteBuffer.allocate(4).put(this.getBytes(), 0, 4).array();
            this.setBytes(intBytes);
        }
        BigInteger biVal = new BigInteger(this.getBytes());
        int iVal = biVal.intValue();
        for (EnumType val : allValues = this.getAllEnumValues()) {
            if (val.getValue() != iVal) continue;
            this.setValue(val);
        }
    }

    protected abstract EnumType[] getAllEnumValues();
}

