/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.xerial.snappy.pure;

import java.nio.ByteOrder;
import java.util.Arrays;
import org.apache.hadoop.hbase.shaded.org.xerial.snappy.pure.UnsafeUtil;

public final class SnappyRawCompressor {
    private static final int BLOCK_LOG = 16;
    private static final int BLOCK_SIZE = 65536;
    private static final int INPUT_MARGIN_BYTES = 15;
    private static final int MAX_HASH_TABLE_BITS = 14;
    public static final int MAX_HASH_TABLE_SIZE = 16384;
    private static final ByteOrder byteOrder = ByteOrder.nativeOrder();
    private static final int HIGH_BIT_MASK = 128;

    private SnappyRawCompressor() {
    }

    private static int littleEndian(int n) {
        return byteOrder == ByteOrder.LITTLE_ENDIAN ? n : Integer.reverseBytes(n);
    }

    private static long littleEndian(long l) {
        return byteOrder == ByteOrder.LITTLE_ENDIAN ? l : Long.reverseBytes(l);
    }

    private static short littleEndian(short s) {
        return byteOrder == ByteOrder.LITTLE_ENDIAN ? s : Short.reverseBytes(s);
    }

    public static int maxCompressedLength(int n) {
        return 32 + n + n / 6;
    }

    public static int compress(Object object, long l, long l2, Object object2, long l3, long l4, short[] sArray) {
        int n = SnappyRawCompressor.maxCompressedLength((int)(l2 - l));
        if (l4 - l3 < (long)n) {
            throw new IllegalArgumentException("Output buffer must be at least " + n + " bytes");
        }
        long l5 = SnappyRawCompressor.writeUncompressedLength(object2, l3, (int)(l2 - l));
        for (long i = l; i < l2; i += 65536L) {
            int n2;
            long l6 = Math.min(l2, i + 65536L);
            long l7 = i;
            assert (l6 - i <= 65536L);
            int n3 = SnappyRawCompressor.getHashTableSize((int)(l6 - i));
            Arrays.fill(sArray, 0, n3, (short)0);
            int n4 = 32 - SnappyRawCompressor.log2Floor(n3);
            assert ((n3 & n3 - 1) == 0) : "table must be power of two";
            assert (-1 >>> n4 == n3 - 1);
            long l8 = l7;
            long l9 = l6 - 15L;
            while (l7 <= l9) {
                int n5;
                int n6;
                assert (l8 <= l7);
                n2 = 32;
                long l10 = 0L;
                ++l7;
                while (l7 + (long)(n2 >>> 5) <= l9) {
                    n6 = SnappyRawCompressor.littleEndian(UnsafeUtil.UNSAFE.getInt(object, l7));
                    n5 = SnappyRawCompressor.hashBytes(n6, n4);
                    l10 = i + (long)(sArray[n5] & 0xFFFF);
                    assert (l10 >= 0L);
                    assert (l10 < l7);
                    sArray[n5] = (short)(l7 - i);
                    if (n6 == SnappyRawCompressor.littleEndian(UnsafeUtil.UNSAFE.getInt(object, l10))) break;
                    l7 += (long)(n2++ >>> 5);
                }
                if (l7 + (long)(n2 >>> 5) > l9) break;
                assert (l8 + 16L <= l6);
                n6 = (int)(l7 - l8);
                l5 = SnappyRawCompressor.emitLiteralLength(object2, l5, n6);
                l5 = SnappyRawCompressor.fastCopy(object, l8, object2, l5, n6);
                do {
                    assert (l6 >= l7 + 4L);
                    int n7 = SnappyRawCompressor.count(object, l7 + 4L, l10 + 4L, l6);
                    l5 = SnappyRawCompressor.emitCopy(object2, l5, l7, l10, n7 += 4);
                    if ((l7 += (long)n7) >= l9) break;
                    long l11 = SnappyRawCompressor.littleEndian(UnsafeUtil.UNSAFE.getLong(object, l7 - 1L));
                    int n8 = (int)l11;
                    n5 = (int)(l11 >>> 8);
                    int n9 = SnappyRawCompressor.hashBytes(n8, n4);
                    sArray[n9] = (short)(l7 - i - 1L);
                    int n10 = SnappyRawCompressor.hashBytes(n5, n4);
                    l10 = i + (long)(sArray[n10] & 0xFFFF);
                    sArray[n10] = (short)(l7 - i);
                } while (n5 == SnappyRawCompressor.littleEndian(UnsafeUtil.UNSAFE.getInt(object, l10)));
                l8 = l7;
            }
            if (l8 >= l6) continue;
            n2 = (int)(l6 - l8);
            l5 = SnappyRawCompressor.emitLiteralLength(object2, l5, n2);
            UnsafeUtil.UNSAFE.copyMemory(object, l8, object2, l5, n2);
            l5 += (long)n2;
        }
        return (int)(l5 - l3);
    }

    private static int count(Object object, long l, long l2, long l3) {
        long l4 = l;
        while (l4 < l3 - 7L) {
            long l5 = SnappyRawCompressor.littleEndian(UnsafeUtil.UNSAFE.getLong(object, l2)) ^ SnappyRawCompressor.littleEndian(UnsafeUtil.UNSAFE.getLong(object, l4));
            if (l5 != 0L) {
                return (int)((l4 += (long)(Long.numberOfTrailingZeros(l5) >> 3)) - l);
            }
            l4 += 8L;
            l2 += 8L;
        }
        if (l4 < l3 - 3L && SnappyRawCompressor.littleEndian(UnsafeUtil.UNSAFE.getInt(object, l2)) == SnappyRawCompressor.littleEndian(UnsafeUtil.UNSAFE.getInt(object, l4))) {
            l4 += 4L;
            l2 += 4L;
        }
        if (l4 < l3 - 1L && SnappyRawCompressor.littleEndian(UnsafeUtil.UNSAFE.getShort(object, l2)) == SnappyRawCompressor.littleEndian(UnsafeUtil.UNSAFE.getShort(object, l4))) {
            l4 += 2L;
            l2 += 2L;
        }
        if (l4 < l3 && UnsafeUtil.UNSAFE.getByte(object, l2) == UnsafeUtil.UNSAFE.getByte(object, l4)) {
            ++l4;
        }
        return (int)(l4 - l);
    }

    private static long emitLiteralLength(Object object, long l, int n) {
        int n2 = n - 1;
        if (n2 < 60) {
            UnsafeUtil.UNSAFE.putByte(object, l++, (byte)(n2 << 2));
        } else {
            int n3;
            if (n2 < 256) {
                UnsafeUtil.UNSAFE.putByte(object, l++, (byte)-16);
                n3 = 1;
            } else if (n2 < 65536) {
                UnsafeUtil.UNSAFE.putByte(object, l++, (byte)-12);
                n3 = 2;
            } else if (n2 < 0x1000000) {
                UnsafeUtil.UNSAFE.putByte(object, l++, (byte)-8);
                n3 = 3;
            } else {
                UnsafeUtil.UNSAFE.putByte(object, l++, (byte)-4);
                n3 = 4;
            }
            UnsafeUtil.UNSAFE.putInt(object, l, SnappyRawCompressor.littleEndian(n2));
            l += (long)n3;
        }
        return l;
    }

    private static long fastCopy(Object object, long l, Object object2, long l2, int n) {
        long l3 = l2 + (long)n;
        do {
            UnsafeUtil.UNSAFE.putLong(object2, l2, UnsafeUtil.UNSAFE.getLong(object, l));
            l += 8L;
        } while ((l2 += 8L) < l3);
        return l3;
    }

    private static long emitCopy(Object object, long l, long l2, long l3, int n) {
        long l4 = l2 - l3;
        while (n >= 68) {
            UnsafeUtil.UNSAFE.putByte(object, l++, (byte)-2);
            UnsafeUtil.UNSAFE.putShort(object, l, SnappyRawCompressor.littleEndian((short)l4));
            l += 2L;
            n -= 64;
        }
        if (n > 64) {
            UnsafeUtil.UNSAFE.putByte(object, l++, (byte)-18);
            UnsafeUtil.UNSAFE.putShort(object, l, SnappyRawCompressor.littleEndian((short)l4));
            l += 2L;
            n -= 60;
        }
        if (n < 12 && l4 < 2048L) {
            int n2 = n - 4;
            UnsafeUtil.UNSAFE.putByte(object, l++, (byte)((long)(1 + (n2 << 2)) + (l4 >>> 8 << 5)));
            UnsafeUtil.UNSAFE.putByte(object, l++, (byte)l4);
        } else {
            UnsafeUtil.UNSAFE.putByte(object, l++, (byte)(2 + (n - 1 << 2)));
            UnsafeUtil.UNSAFE.putShort(object, l, SnappyRawCompressor.littleEndian((short)l4));
            l += 2L;
        }
        return l;
    }

    private static int getHashTableSize(int n) {
        int n2 = Integer.highestOneBit(n - 1) << 1;
        return Math.max(Math.min(n2, 16384), 256);
    }

    private static int hashBytes(int n, int n2) {
        return n * 506832829 >>> n2;
    }

    private static int log2Floor(int n) {
        return n == 0 ? -1 : 0x1F ^ Integer.numberOfLeadingZeros(n);
    }

    private static long writeUncompressedLength(Object object, long l, int n) {
        if (n < 128 && n >= 0) {
            UnsafeUtil.UNSAFE.putByte(object, l++, (byte)n);
        } else if (n < 16384 && n > 0) {
            UnsafeUtil.UNSAFE.putByte(object, l++, (byte)(n | 0x80));
            UnsafeUtil.UNSAFE.putByte(object, l++, (byte)(n >>> 7));
        } else if (n < 0x200000 && n > 0) {
            UnsafeUtil.UNSAFE.putByte(object, l++, (byte)(n | 0x80));
            UnsafeUtil.UNSAFE.putByte(object, l++, (byte)(n >>> 7 | 0x80));
            UnsafeUtil.UNSAFE.putByte(object, l++, (byte)(n >>> 14));
        } else if (n < 0x10000000 && n > 0) {
            UnsafeUtil.UNSAFE.putByte(object, l++, (byte)(n | 0x80));
            UnsafeUtil.UNSAFE.putByte(object, l++, (byte)(n >>> 7 | 0x80));
            UnsafeUtil.UNSAFE.putByte(object, l++, (byte)(n >>> 14 | 0x80));
            UnsafeUtil.UNSAFE.putByte(object, l++, (byte)(n >>> 21));
        } else {
            UnsafeUtil.UNSAFE.putByte(object, l++, (byte)(n | 0x80));
            UnsafeUtil.UNSAFE.putByte(object, l++, (byte)(n >>> 7 | 0x80));
            UnsafeUtil.UNSAFE.putByte(object, l++, (byte)(n >>> 14 | 0x80));
            UnsafeUtil.UNSAFE.putByte(object, l++, (byte)(n >>> 21 | 0x80));
            UnsafeUtil.UNSAFE.putByte(object, l++, (byte)(n >>> 28));
        }
        return l;
    }
}

