/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import org.apache.hadoop.hbase.ArrayBackedTag;
import org.apache.hadoop.hbase.ByteBufferCell;
import org.apache.hadoop.hbase.ByteBufferTag;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellBuilderFactory;
import org.apache.hadoop.hbase.CellBuilderType;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellScannable;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.ExtendedCell;
import org.apache.hadoop.hbase.ExtendedCellBuilderFactory;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.SettableSequenceId;
import org.apache.hadoop.hbase.SettableTimestamp;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.TagUtil;
import org.apache.hadoop.hbase.io.HeapSize;
import org.apache.hadoop.hbase.io.TagCompressionContext;
import org.apache.hadoop.hbase.io.util.Dictionary;
import org.apache.hadoop.hbase.io.util.StreamUtils;
import org.apache.hadoop.hbase.util.ByteBufferUtils;
import org.apache.hadoop.hbase.util.ByteRange;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ClassSize;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public final class CellUtil {
    private CellUtil() {
    }

    public static ByteRange fillRowRange(Cell cell, ByteRange range) {
        return range.set(cell.getRowArray(), cell.getRowOffset(), cell.getRowLength());
    }

    public static ByteRange fillFamilyRange(Cell cell, ByteRange range) {
        return range.set(cell.getFamilyArray(), cell.getFamilyOffset(), cell.getFamilyLength());
    }

    public static ByteRange fillQualifierRange(Cell cell, ByteRange range) {
        return range.set(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength());
    }

    public static ByteRange fillValueRange(Cell cell, ByteRange range) {
        return range.set(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength());
    }

    public static ByteRange fillTagRange(Cell cell, ByteRange range) {
        return range.set(cell.getTagsArray(), cell.getTagsOffset(), cell.getTagsLength());
    }

    public static byte[] cloneRow(Cell cell) {
        byte[] output = new byte[cell.getRowLength()];
        CellUtil.copyRowTo(cell, output, 0);
        return output;
    }

    public static byte[] cloneFamily(Cell cell) {
        byte[] output = new byte[cell.getFamilyLength()];
        CellUtil.copyFamilyTo(cell, output, 0);
        return output;
    }

    public static byte[] cloneQualifier(Cell cell) {
        byte[] output = new byte[cell.getQualifierLength()];
        CellUtil.copyQualifierTo(cell, output, 0);
        return output;
    }

    public static byte[] cloneValue(Cell cell) {
        byte[] output = new byte[cell.getValueLength()];
        CellUtil.copyValueTo(cell, output, 0);
        return output;
    }

    public static byte[] cloneTags(Cell cell) {
        byte[] output = new byte[cell.getTagsLength()];
        CellUtil.copyTagTo(cell, output, 0);
        return output;
    }

    public static byte[] getTagArray(Cell cell) {
        byte[] output = new byte[cell.getTagsLength()];
        CellUtil.copyTagTo(cell, output, 0);
        return output;
    }

    public static int copyRowTo(Cell cell, byte[] destination, int destinationOffset) {
        short rowLen = cell.getRowLength();
        if (cell instanceof ByteBufferCell) {
            ByteBufferUtils.copyFromBufferToArray(destination, ((ByteBufferCell)cell).getRowByteBuffer(), ((ByteBufferCell)cell).getRowPosition(), destinationOffset, rowLen);
        } else {
            System.arraycopy(cell.getRowArray(), cell.getRowOffset(), destination, destinationOffset, rowLen);
        }
        return destinationOffset + rowLen;
    }

    public static int copyRowTo(Cell cell, ByteBuffer destination, int destinationOffset) {
        short rowLen = cell.getRowLength();
        if (cell instanceof ByteBufferCell) {
            ByteBufferUtils.copyFromBufferToBuffer(((ByteBufferCell)cell).getRowByteBuffer(), destination, ((ByteBufferCell)cell).getRowPosition(), destinationOffset, rowLen);
        } else {
            ByteBufferUtils.copyFromArrayToBuffer(destination, destinationOffset, cell.getRowArray(), cell.getRowOffset(), rowLen);
        }
        return destinationOffset + rowLen;
    }

    public static byte[] copyRow(Cell cell) {
        if (cell instanceof ByteBufferCell) {
            return ByteBufferUtils.copyOfRange(((ByteBufferCell)cell).getRowByteBuffer(), ((ByteBufferCell)cell).getRowPosition(), ((ByteBufferCell)cell).getRowPosition() + cell.getRowLength());
        }
        return Arrays.copyOfRange(cell.getRowArray(), cell.getRowOffset(), cell.getRowOffset() + cell.getRowLength());
    }

    public static int copyFamilyTo(Cell cell, byte[] destination, int destinationOffset) {
        byte fLen = cell.getFamilyLength();
        if (cell instanceof ByteBufferCell) {
            ByteBufferUtils.copyFromBufferToArray(destination, ((ByteBufferCell)cell).getFamilyByteBuffer(), ((ByteBufferCell)cell).getFamilyPosition(), destinationOffset, fLen);
        } else {
            System.arraycopy(cell.getFamilyArray(), cell.getFamilyOffset(), destination, destinationOffset, fLen);
        }
        return destinationOffset + fLen;
    }

    public static int copyFamilyTo(Cell cell, ByteBuffer destination, int destinationOffset) {
        byte fLen = cell.getFamilyLength();
        if (cell instanceof ByteBufferCell) {
            ByteBufferUtils.copyFromBufferToBuffer(((ByteBufferCell)cell).getFamilyByteBuffer(), destination, ((ByteBufferCell)cell).getFamilyPosition(), destinationOffset, fLen);
        } else {
            ByteBufferUtils.copyFromArrayToBuffer(destination, destinationOffset, cell.getFamilyArray(), cell.getFamilyOffset(), fLen);
        }
        return destinationOffset + fLen;
    }

    public static int copyQualifierTo(Cell cell, byte[] destination, int destinationOffset) {
        int qlen = cell.getQualifierLength();
        if (cell instanceof ByteBufferCell) {
            ByteBufferUtils.copyFromBufferToArray(destination, ((ByteBufferCell)cell).getQualifierByteBuffer(), ((ByteBufferCell)cell).getQualifierPosition(), destinationOffset, qlen);
        } else {
            System.arraycopy(cell.getQualifierArray(), cell.getQualifierOffset(), destination, destinationOffset, qlen);
        }
        return destinationOffset + qlen;
    }

    public static int copyQualifierTo(Cell cell, ByteBuffer destination, int destinationOffset) {
        int qlen = cell.getQualifierLength();
        if (cell instanceof ByteBufferCell) {
            ByteBufferUtils.copyFromBufferToBuffer(((ByteBufferCell)cell).getQualifierByteBuffer(), destination, ((ByteBufferCell)cell).getQualifierPosition(), destinationOffset, qlen);
        } else {
            ByteBufferUtils.copyFromArrayToBuffer(destination, destinationOffset, cell.getQualifierArray(), cell.getQualifierOffset(), qlen);
        }
        return destinationOffset + qlen;
    }

    public static int copyValueTo(Cell cell, byte[] destination, int destinationOffset) {
        int vlen = cell.getValueLength();
        if (cell instanceof ByteBufferCell) {
            ByteBufferUtils.copyFromBufferToArray(destination, ((ByteBufferCell)cell).getValueByteBuffer(), ((ByteBufferCell)cell).getValuePosition(), destinationOffset, vlen);
        } else {
            System.arraycopy(cell.getValueArray(), cell.getValueOffset(), destination, destinationOffset, vlen);
        }
        return destinationOffset + vlen;
    }

    public static int copyValueTo(Cell cell, ByteBuffer destination, int destinationOffset) {
        int vlen = cell.getValueLength();
        if (cell instanceof ByteBufferCell) {
            ByteBufferUtils.copyFromBufferToBuffer(((ByteBufferCell)cell).getValueByteBuffer(), destination, ((ByteBufferCell)cell).getValuePosition(), destinationOffset, vlen);
        } else {
            ByteBufferUtils.copyFromArrayToBuffer(destination, destinationOffset, cell.getValueArray(), cell.getValueOffset(), vlen);
        }
        return destinationOffset + vlen;
    }

    public static int copyTagTo(Cell cell, byte[] destination, int destinationOffset) {
        int tlen = cell.getTagsLength();
        if (cell instanceof ByteBufferCell) {
            ByteBufferUtils.copyFromBufferToArray(destination, ((ByteBufferCell)cell).getTagsByteBuffer(), ((ByteBufferCell)cell).getTagsPosition(), destinationOffset, tlen);
        } else {
            System.arraycopy(cell.getTagsArray(), cell.getTagsOffset(), destination, destinationOffset, tlen);
        }
        return destinationOffset + tlen;
    }

    public static int copyTagTo(Cell cell, ByteBuffer destination, int destinationOffset) {
        int tlen = cell.getTagsLength();
        if (cell instanceof ByteBufferCell) {
            ByteBufferUtils.copyFromBufferToBuffer(((ByteBufferCell)cell).getTagsByteBuffer(), destination, ((ByteBufferCell)cell).getTagsPosition(), destinationOffset, tlen);
        } else {
            ByteBufferUtils.copyFromArrayToBuffer(destination, destinationOffset, cell.getTagsArray(), cell.getTagsOffset(), tlen);
        }
        return destinationOffset + tlen;
    }

    @InterfaceAudience.Private
    public static byte getRowByte(Cell cell, int index) {
        if (cell instanceof ByteBufferCell) {
            return ((ByteBufferCell)cell).getRowByteBuffer().get(((ByteBufferCell)cell).getRowPosition() + index);
        }
        return cell.getRowArray()[cell.getRowOffset() + index];
    }

    @InterfaceAudience.Private
    public static byte getQualifierByte(Cell cell, int index) {
        if (cell instanceof ByteBufferCell) {
            return ((ByteBufferCell)cell).getQualifierByteBuffer().get(((ByteBufferCell)cell).getQualifierPosition() + index);
        }
        return cell.getQualifierArray()[cell.getQualifierOffset() + index];
    }

    public static ByteBuffer getValueBufferShallowCopy(Cell cell) {
        ByteBuffer buffer = ByteBuffer.wrap(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength());
        return buffer;
    }

    @Deprecated
    public static ByteBuffer getQualifierBufferShallowCopy(Cell cell) {
        ByteBuffer buffer = ByteBuffer.wrap(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength());
        return buffer;
    }

    @Deprecated
    public static Cell createCell(byte[] row, byte[] family, byte[] qualifier, long timestamp, byte type, byte[] value) {
        return CellBuilderFactory.create(CellBuilderType.DEEP_COPY).setRow(row).setFamily(family).setQualifier(qualifier).setTimestamp(timestamp).setType(type).setValue(value).build();
    }

    @Deprecated
    public static Cell createCell(byte[] rowArray, int rowOffset, int rowLength, byte[] familyArray, int familyOffset, int familyLength, byte[] qualifierArray, int qualifierOffset, int qualifierLength) {
        return CellBuilderFactory.create(CellBuilderType.DEEP_COPY).setRow(rowArray, rowOffset, rowLength).setFamily(familyArray, familyOffset, familyLength).setQualifier(qualifierArray, qualifierOffset, qualifierLength).setTimestamp(Long.MAX_VALUE).setType(KeyValue.Type.Maximum.getCode()).setValue(HConstants.EMPTY_BYTE_ARRAY, 0, HConstants.EMPTY_BYTE_ARRAY.length).build();
    }

    @InterfaceAudience.Private
    @Deprecated
    public static Cell createCell(byte[] row, byte[] family, byte[] qualifier, long timestamp, byte type, byte[] value, long memstoreTS) {
        return CellUtil.createCell(row, family, qualifier, timestamp, type, value, null, memstoreTS);
    }

    @InterfaceAudience.Private
    @Deprecated
    public static Cell createCell(byte[] row, byte[] family, byte[] qualifier, long timestamp, byte type, byte[] value, byte[] tags, long memstoreTS) {
        return ExtendedCellBuilderFactory.create(CellBuilderType.DEEP_COPY).setRow(row).setFamily(family).setQualifier(qualifier).setTimestamp(timestamp).setType(type).setValue(value).setTags(tags).setSequenceId(memstoreTS).build();
    }

    @InterfaceAudience.Private
    @Deprecated
    public static Cell createCell(byte[] row, byte[] family, byte[] qualifier, long timestamp, KeyValue.Type type, byte[] value, byte[] tags) {
        return CellUtil.createCell(row, family, qualifier, timestamp, type.getCode(), value, tags, 0L);
    }

    @Deprecated
    public static Cell createCell(byte[] row) {
        return CellUtil.createCell(row, HConstants.EMPTY_BYTE_ARRAY);
    }

    @Deprecated
    public static Cell createCell(byte[] row, byte[] value) {
        return CellUtil.createCell(row, HConstants.EMPTY_BYTE_ARRAY, HConstants.EMPTY_BYTE_ARRAY, Long.MAX_VALUE, KeyValue.Type.Maximum.getCode(), value);
    }

    @Deprecated
    public static Cell createCell(byte[] row, byte[] family, byte[] qualifier) {
        return CellUtil.createCell(row, family, qualifier, Long.MAX_VALUE, KeyValue.Type.Maximum.getCode(), HConstants.EMPTY_BYTE_ARRAY);
    }

    public static Cell createCell(Cell cell, List<Tag> tags) {
        return CellUtil.createCell(cell, TagUtil.fromList(tags));
    }

    public static Cell createCell(Cell cell, byte[] tags) {
        if (cell instanceof ByteBufferCell) {
            return new TagRewriteByteBufferCell((ByteBufferCell)cell, tags);
        }
        return new TagRewriteCell(cell, tags);
    }

    public static Cell createCell(Cell cell, byte[] value, byte[] tags) {
        if (cell instanceof ByteBufferCell) {
            return new ValueAndTagRewriteByteBufferCell((ByteBufferCell)cell, value, tags);
        }
        return new ValueAndTagRewriteCell(cell, value, tags);
    }

    public static CellScanner createCellScanner(final List<? extends CellScannable> cellScannerables) {
        return new CellScanner(){
            private final Iterator<? extends CellScannable> iterator;
            private CellScanner cellScanner;
            {
                this.iterator = cellScannerables.iterator();
                this.cellScanner = null;
            }

            @Override
            public Cell current() {
                return this.cellScanner != null ? this.cellScanner.current() : null;
            }

            @Override
            public boolean advance() throws IOException {
                while (true) {
                    if (this.cellScanner == null) {
                        if (!this.iterator.hasNext()) {
                            return false;
                        }
                        this.cellScanner = this.iterator.next().cellScanner();
                    }
                    if (this.cellScanner.advance()) {
                        return true;
                    }
                    this.cellScanner = null;
                }
            }
        };
    }

    public static CellScanner createCellScanner(Iterable<Cell> cellIterable) {
        if (cellIterable == null) {
            return null;
        }
        return CellUtil.createCellScanner(cellIterable.iterator());
    }

    public static CellScanner createCellScanner(final Iterator<Cell> cells) {
        if (cells == null) {
            return null;
        }
        return new CellScanner(){
            private final Iterator<Cell> iterator;
            private Cell current;
            {
                this.iterator = cells;
                this.current = null;
            }

            @Override
            public Cell current() {
                return this.current;
            }

            @Override
            public boolean advance() {
                boolean hasNext = this.iterator.hasNext();
                this.current = hasNext ? this.iterator.next() : null;
                return hasNext;
            }
        };
    }

    public static CellScanner createCellScanner(final Cell[] cellArray) {
        return new CellScanner(){
            private final Cell[] cells;
            private int index;
            {
                this.cells = cellArray;
                this.index = -1;
            }

            @Override
            public Cell current() {
                if (this.cells == null) {
                    return null;
                }
                return this.index < 0 ? null : this.cells[this.index];
            }

            @Override
            public boolean advance() {
                if (this.cells == null) {
                    return false;
                }
                return ++this.index < this.cells.length;
            }
        };
    }

    public static CellScanner createCellScanner(final NavigableMap<byte[], List<Cell>> map) {
        return new CellScanner(){
            private final Iterator<Map.Entry<byte[], List<Cell>>> entries;
            private Iterator<Cell> currentIterator;
            private Cell currentCell;
            {
                this.entries = map.entrySet().iterator();
                this.currentIterator = null;
            }

            @Override
            public Cell current() {
                return this.currentCell;
            }

            @Override
            public boolean advance() {
                while (true) {
                    if (this.currentIterator == null) {
                        if (!this.entries.hasNext()) {
                            return false;
                        }
                        this.currentIterator = this.entries.next().getValue().iterator();
                    }
                    if (this.currentIterator.hasNext()) {
                        this.currentCell = this.currentIterator.next();
                        return true;
                    }
                    this.currentCell = null;
                    this.currentIterator = null;
                }
            }
        };
    }

    @Deprecated
    public static boolean matchingRow(Cell left, Cell right) {
        return CellUtil.matchingRows(left, right);
    }

    public static boolean matchingRow(Cell left, byte[] buf) {
        if (buf == null) {
            return left.getRowLength() == 0;
        }
        return CellUtil.matchingRow(left, buf, 0, buf.length);
    }

    public static boolean matchingRow(Cell left, byte[] buf, int offset, int length) {
        if (left instanceof ByteBufferCell) {
            return ByteBufferUtils.equals(((ByteBufferCell)left).getRowByteBuffer(), ((ByteBufferCell)left).getRowPosition(), (int)left.getRowLength(), buf, offset, length);
        }
        return Bytes.equals(left.getRowArray(), left.getRowOffset(), left.getRowLength(), buf, offset, length);
    }

    public static boolean matchingFamily(Cell left, Cell right) {
        byte lfamlength = left.getFamilyLength();
        byte rfamlength = right.getFamilyLength();
        if (left instanceof ByteBufferCell && right instanceof ByteBufferCell) {
            return ByteBufferUtils.equals(((ByteBufferCell)left).getFamilyByteBuffer(), ((ByteBufferCell)left).getFamilyPosition(), (int)lfamlength, ((ByteBufferCell)right).getFamilyByteBuffer(), ((ByteBufferCell)right).getFamilyPosition(), (int)rfamlength);
        }
        if (left instanceof ByteBufferCell) {
            return ByteBufferUtils.equals(((ByteBufferCell)left).getFamilyByteBuffer(), ((ByteBufferCell)left).getFamilyPosition(), (int)lfamlength, right.getFamilyArray(), right.getFamilyOffset(), (int)rfamlength);
        }
        if (right instanceof ByteBufferCell) {
            return ByteBufferUtils.equals(((ByteBufferCell)right).getFamilyByteBuffer(), ((ByteBufferCell)right).getFamilyPosition(), (int)rfamlength, left.getFamilyArray(), left.getFamilyOffset(), (int)lfamlength);
        }
        return Bytes.equals(left.getFamilyArray(), left.getFamilyOffset(), lfamlength, right.getFamilyArray(), right.getFamilyOffset(), rfamlength);
    }

    public static boolean matchingFamily(Cell left, byte[] buf) {
        if (buf == null) {
            return left.getFamilyLength() == 0;
        }
        return CellUtil.matchingFamily(left, buf, 0, buf.length);
    }

    public static boolean matchingFamily(Cell left, byte[] buf, int offset, int length) {
        if (left instanceof ByteBufferCell) {
            return ByteBufferUtils.equals(((ByteBufferCell)left).getFamilyByteBuffer(), ((ByteBufferCell)left).getFamilyPosition(), (int)left.getFamilyLength(), buf, offset, length);
        }
        return Bytes.equals(left.getFamilyArray(), left.getFamilyOffset(), left.getFamilyLength(), buf, offset, length);
    }

    public static boolean matchingQualifier(Cell left, Cell right) {
        int lqlength = left.getQualifierLength();
        int rqlength = right.getQualifierLength();
        if (left instanceof ByteBufferCell && right instanceof ByteBufferCell) {
            return ByteBufferUtils.equals(((ByteBufferCell)left).getQualifierByteBuffer(), ((ByteBufferCell)left).getQualifierPosition(), lqlength, ((ByteBufferCell)right).getQualifierByteBuffer(), ((ByteBufferCell)right).getQualifierPosition(), rqlength);
        }
        if (left instanceof ByteBufferCell) {
            return ByteBufferUtils.equals(((ByteBufferCell)left).getQualifierByteBuffer(), ((ByteBufferCell)left).getQualifierPosition(), lqlength, right.getQualifierArray(), right.getQualifierOffset(), rqlength);
        }
        if (right instanceof ByteBufferCell) {
            return ByteBufferUtils.equals(((ByteBufferCell)right).getQualifierByteBuffer(), ((ByteBufferCell)right).getQualifierPosition(), rqlength, left.getQualifierArray(), left.getQualifierOffset(), lqlength);
        }
        return Bytes.equals(left.getQualifierArray(), left.getQualifierOffset(), lqlength, right.getQualifierArray(), right.getQualifierOffset(), rqlength);
    }

    public static boolean matchingQualifier(Cell left, byte[] buf) {
        if (buf == null) {
            return left.getQualifierLength() == 0;
        }
        return CellUtil.matchingQualifier(left, buf, 0, buf.length);
    }

    public static boolean matchingQualifier(Cell left, byte[] buf, int offset, int length) {
        if (buf == null) {
            return left.getQualifierLength() == 0;
        }
        if (left instanceof ByteBufferCell) {
            return ByteBufferUtils.equals(((ByteBufferCell)left).getQualifierByteBuffer(), ((ByteBufferCell)left).getQualifierPosition(), left.getQualifierLength(), buf, offset, length);
        }
        return Bytes.equals(left.getQualifierArray(), left.getQualifierOffset(), left.getQualifierLength(), buf, offset, length);
    }

    public static boolean matchingColumn(Cell left, byte[] fam, byte[] qual) {
        if (!CellUtil.matchingFamily(left, fam)) {
            return false;
        }
        return CellUtil.matchingQualifier(left, qual);
    }

    public static boolean matchingColumn(Cell left, byte[] fam, int foffset, int flength, byte[] qual, int qoffset, int qlength) {
        if (!CellUtil.matchingFamily(left, fam, foffset, flength)) {
            return false;
        }
        return CellUtil.matchingQualifier(left, qual, qoffset, qlength);
    }

    public static boolean matchingColumn(Cell left, Cell right) {
        if (!CellUtil.matchingFamily(left, right)) {
            return false;
        }
        return CellUtil.matchingQualifier(left, right);
    }

    public static boolean matchingValue(Cell left, Cell right) {
        return CellUtil.matchingValue(left, right, left.getValueLength(), right.getValueLength());
    }

    public static boolean matchingValue(Cell left, Cell right, int lvlength, int rvlength) {
        if (left instanceof ByteBufferCell && right instanceof ByteBufferCell) {
            return ByteBufferUtils.equals(((ByteBufferCell)left).getValueByteBuffer(), ((ByteBufferCell)left).getValuePosition(), lvlength, ((ByteBufferCell)right).getValueByteBuffer(), ((ByteBufferCell)right).getValuePosition(), rvlength);
        }
        if (left instanceof ByteBufferCell) {
            return ByteBufferUtils.equals(((ByteBufferCell)left).getValueByteBuffer(), ((ByteBufferCell)left).getValuePosition(), lvlength, right.getValueArray(), right.getValueOffset(), rvlength);
        }
        if (right instanceof ByteBufferCell) {
            return ByteBufferUtils.equals(((ByteBufferCell)right).getValueByteBuffer(), ((ByteBufferCell)right).getValuePosition(), rvlength, left.getValueArray(), left.getValueOffset(), lvlength);
        }
        return Bytes.equals(left.getValueArray(), left.getValueOffset(), lvlength, right.getValueArray(), right.getValueOffset(), rvlength);
    }

    public static boolean matchingValue(Cell left, byte[] buf) {
        if (left instanceof ByteBufferCell) {
            return ByteBufferUtils.compareTo(((ByteBufferCell)left).getValueByteBuffer(), ((ByteBufferCell)left).getValuePosition(), left.getValueLength(), buf, 0, buf.length) == 0;
        }
        return Bytes.equals(left.getValueArray(), left.getValueOffset(), left.getValueLength(), buf, 0, buf.length);
    }

    public static boolean isDelete(Cell cell) {
        return CellUtil.isDelete(cell.getTypeByte());
    }

    public static boolean isDelete(byte type) {
        return KeyValue.Type.Delete.getCode() <= type && type <= KeyValue.Type.DeleteFamily.getCode();
    }

    public static boolean isDeleteType(Cell cell) {
        return cell.getTypeByte() == KeyValue.Type.Delete.getCode();
    }

    public static boolean isDeleteFamily(Cell cell) {
        return cell.getTypeByte() == KeyValue.Type.DeleteFamily.getCode();
    }

    public static boolean isDeleteFamilyVersion(Cell cell) {
        return cell.getTypeByte() == KeyValue.Type.DeleteFamilyVersion.getCode();
    }

    public static boolean isDeleteColumns(Cell cell) {
        return cell.getTypeByte() == KeyValue.Type.DeleteColumn.getCode();
    }

    public static boolean isDeleteColumnVersion(Cell cell) {
        return cell.getTypeByte() == KeyValue.Type.Delete.getCode();
    }

    public static boolean isDeleteColumnOrFamily(Cell cell) {
        byte t = cell.getTypeByte();
        return t == KeyValue.Type.DeleteColumn.getCode() || t == KeyValue.Type.DeleteFamily.getCode();
    }

    public static int estimatedSerializedSizeOf(Cell cell) {
        if (cell instanceof ExtendedCell) {
            return ((ExtendedCell)cell).getSerializedSize(true) + 4;
        }
        return CellUtil.getSumOfCellElementLengths(cell) + 2 + 1 + 4;
    }

    private static int getSumOfCellElementLengths(Cell cell) {
        return CellUtil.getSumOfCellKeyElementLengths(cell) + cell.getValueLength() + cell.getTagsLength();
    }

    private static int getSumOfCellKeyElementLengths(Cell cell) {
        return cell.getRowLength() + cell.getFamilyLength() + cell.getQualifierLength() + 9;
    }

    public static int estimatedSerializedSizeOfKey(Cell cell) {
        if (cell instanceof KeyValue) {
            return ((KeyValue)cell).getKeyLength();
        }
        return cell.getRowLength() + cell.getFamilyLength() + cell.getQualifierLength() + 12;
    }

    public static long estimatedHeapSizeOf(Cell cell) {
        if (cell instanceof HeapSize) {
            return ((HeapSize)((Object)cell)).heapSize();
        }
        return CellUtil.estimatedSerializedSizeOf(cell);
    }

    @Deprecated
    public static Iterator<Tag> tagsIterator(final byte[] tags, final int offset, final int length) {
        return new Iterator<Tag>(){
            private int pos;
            private int endOffset;
            {
                this.pos = offset;
                this.endOffset = offset + length - 1;
            }

            @Override
            public boolean hasNext() {
                return this.pos < this.endOffset;
            }

            @Override
            public Tag next() {
                if (this.hasNext()) {
                    int curTagLen = Bytes.readAsInt(tags, this.pos, 2);
                    ArrayBackedTag tag = new ArrayBackedTag(tags, this.pos, curTagLen + 2);
                    this.pos += 2 + curTagLen;
                    return tag;
                }
                return null;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private static Iterator<Tag> tagsIterator(final ByteBuffer tags, final int offset, final int length) {
        return new Iterator<Tag>(){
            private int pos;
            private int endOffset;
            {
                this.pos = offset;
                this.endOffset = offset + length - 1;
            }

            @Override
            public boolean hasNext() {
                return this.pos < this.endOffset;
            }

            @Override
            public Tag next() {
                if (this.hasNext()) {
                    int curTagLen = ByteBufferUtils.readAsInt(tags, this.pos, 2);
                    ByteBufferTag tag = new ByteBufferTag(tags, this.pos, curTagLen + 2);
                    this.pos += 2 + curTagLen;
                    return tag;
                }
                return null;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static Iterator<Tag> tagsIterator(Cell cell) {
        int tagsLength = cell.getTagsLength();
        if (tagsLength == 0) {
            return TagUtil.EMPTY_TAGS_ITR;
        }
        if (cell instanceof ByteBufferCell) {
            return CellUtil.tagsIterator(((ByteBufferCell)cell).getTagsByteBuffer(), ((ByteBufferCell)cell).getTagsPosition(), tagsLength);
        }
        return CellUtil.tagsIterator(cell.getTagsArray(), cell.getTagsOffset(), tagsLength);
    }

    public static List<Tag> getTags(Cell cell) {
        ArrayList<Tag> tags = new ArrayList<Tag>();
        Iterator<Tag> tagsItr = CellUtil.tagsIterator(cell);
        while (tagsItr.hasNext()) {
            tags.add(tagsItr.next());
        }
        return tags;
    }

    public static Tag getTag(Cell cell, byte type) {
        int offset;
        int tagLen;
        boolean bufferBacked = cell instanceof ByteBufferCell;
        int length = cell.getTagsLength();
        for (int pos = offset = bufferBacked ? ((ByteBufferCell)cell).getTagsPosition() : cell.getTagsOffset(); pos < offset + length; pos += 2 + tagLen) {
            if (bufferBacked) {
                ByteBuffer tagsBuffer = ((ByteBufferCell)cell).getTagsByteBuffer();
                tagLen = ByteBufferUtils.readAsInt(tagsBuffer, pos, 2);
                if (ByteBufferUtils.toByte(tagsBuffer, pos + 2) != type) continue;
                return new ByteBufferTag(tagsBuffer, pos, tagLen + 2);
            }
            tagLen = Bytes.readAsInt(cell.getTagsArray(), pos, 2);
            if (cell.getTagsArray()[pos + 2] != type) continue;
            return new ArrayBackedTag(cell.getTagsArray(), pos, tagLen + 2);
        }
        return null;
    }

    public static boolean overlappingKeys(byte[] start1, byte[] end1, byte[] start2, byte[] end2) {
        return !(end2.length != 0 && start1.length != 0 && Bytes.compareTo(start1, end2) >= 0 || end1.length != 0 && start2.length != 0 && Bytes.compareTo(start2, end1) >= 0);
    }

    @InterfaceAudience.Private
    public static void setSequenceId(Cell cell, long seqId) throws IOException {
        if (!(cell instanceof SettableSequenceId)) {
            throw new IOException(new UnsupportedOperationException("Cell is not of type " + SettableSequenceId.class.getName()));
        }
        ((SettableSequenceId)((Object)cell)).setSequenceId(seqId);
    }

    public static void setTimestamp(Cell cell, long ts) throws IOException {
        if (!(cell instanceof SettableTimestamp)) {
            throw new IOException(new UnsupportedOperationException("Cell is not of type " + SettableTimestamp.class.getName()));
        }
        ((SettableTimestamp)((Object)cell)).setTimestamp(ts);
    }

    public static void setTimestamp(Cell cell, byte[] ts, int tsOffset) throws IOException {
        if (!(cell instanceof SettableTimestamp)) {
            throw new IOException(new UnsupportedOperationException("Cell is not of type " + SettableTimestamp.class.getName()));
        }
        ((SettableTimestamp)((Object)cell)).setTimestamp(ts, tsOffset);
    }

    public static boolean updateLatestStamp(Cell cell, long ts) throws IOException {
        if (cell.getTimestamp() == Long.MAX_VALUE) {
            CellUtil.setTimestamp(cell, ts);
            return true;
        }
        return false;
    }

    public static boolean updateLatestStamp(Cell cell, byte[] ts, int tsOffset) throws IOException {
        if (cell.getTimestamp() == Long.MAX_VALUE) {
            CellUtil.setTimestamp(cell, ts, tsOffset);
            return true;
        }
        return false;
    }

    public static void writeFlatKey(Cell cell, DataOutputStream out) throws IOException {
        short rowLen = cell.getRowLength();
        byte fLen = cell.getFamilyLength();
        int qLen = cell.getQualifierLength();
        if (cell instanceof ByteBufferCell) {
            out.writeShort(rowLen);
            ByteBufferUtils.copyBufferToStream(out, ((ByteBufferCell)cell).getRowByteBuffer(), ((ByteBufferCell)cell).getRowPosition(), rowLen);
            out.writeByte(fLen);
            ByteBufferUtils.copyBufferToStream(out, ((ByteBufferCell)cell).getFamilyByteBuffer(), ((ByteBufferCell)cell).getFamilyPosition(), fLen);
            ByteBufferUtils.copyBufferToStream(out, ((ByteBufferCell)cell).getQualifierByteBuffer(), ((ByteBufferCell)cell).getQualifierPosition(), qLen);
        } else {
            out.writeShort(rowLen);
            out.write(cell.getRowArray(), cell.getRowOffset(), rowLen);
            out.writeByte(fLen);
            out.write(cell.getFamilyArray(), cell.getFamilyOffset(), fLen);
            out.write(cell.getQualifierArray(), cell.getQualifierOffset(), qLen);
        }
        out.writeLong(cell.getTimestamp());
        out.writeByte(cell.getTypeByte());
    }

    public static int writeFlatKey(Cell cell, OutputStream out) throws IOException {
        short rowLen = cell.getRowLength();
        byte fLen = cell.getFamilyLength();
        int qLen = cell.getQualifierLength();
        if (cell instanceof ByteBufferCell) {
            StreamUtils.writeShort(out, rowLen);
            ByteBufferUtils.copyBufferToStream(out, ((ByteBufferCell)cell).getRowByteBuffer(), ((ByteBufferCell)cell).getRowPosition(), rowLen);
            out.write(fLen);
            ByteBufferUtils.copyBufferToStream(out, ((ByteBufferCell)cell).getFamilyByteBuffer(), ((ByteBufferCell)cell).getFamilyPosition(), fLen);
            ByteBufferUtils.copyBufferToStream(out, ((ByteBufferCell)cell).getQualifierByteBuffer(), ((ByteBufferCell)cell).getQualifierPosition(), qLen);
        } else {
            StreamUtils.writeShort(out, rowLen);
            out.write(cell.getRowArray(), cell.getRowOffset(), rowLen);
            out.write(fLen);
            out.write(cell.getFamilyArray(), cell.getFamilyOffset(), fLen);
            out.write(cell.getQualifierArray(), cell.getQualifierOffset(), qLen);
        }
        StreamUtils.writeLong(out, cell.getTimestamp());
        out.write(cell.getTypeByte());
        return 2 + rowLen + 1 + fLen + qLen + 8 + 1;
    }

    public static void writeRow(OutputStream out, Cell cell, short rlength) throws IOException {
        if (cell instanceof ByteBufferCell) {
            ByteBufferUtils.copyBufferToStream(out, ((ByteBufferCell)cell).getRowByteBuffer(), ((ByteBufferCell)cell).getRowPosition(), rlength);
        } else {
            out.write(cell.getRowArray(), cell.getRowOffset(), rlength);
        }
    }

    public static void writeRowSkippingBytes(DataOutputStream out, Cell cell, short rlength, int commonPrefix) throws IOException {
        if (cell instanceof ByteBufferCell) {
            ByteBufferUtils.copyBufferToStream(out, ((ByteBufferCell)cell).getRowByteBuffer(), ((ByteBufferCell)cell).getRowPosition() + commonPrefix, rlength - commonPrefix);
        } else {
            out.write(cell.getRowArray(), cell.getRowOffset() + commonPrefix, rlength - commonPrefix);
        }
    }

    public static void writeFamily(OutputStream out, Cell cell, byte flength) throws IOException {
        if (cell instanceof ByteBufferCell) {
            ByteBufferUtils.copyBufferToStream(out, ((ByteBufferCell)cell).getFamilyByteBuffer(), ((ByteBufferCell)cell).getFamilyPosition(), flength);
        } else {
            out.write(cell.getFamilyArray(), cell.getFamilyOffset(), flength);
        }
    }

    public static void writeQualifier(OutputStream out, Cell cell, int qlength) throws IOException {
        if (cell instanceof ByteBufferCell) {
            ByteBufferUtils.copyBufferToStream(out, ((ByteBufferCell)cell).getQualifierByteBuffer(), ((ByteBufferCell)cell).getQualifierPosition(), qlength);
        } else {
            out.write(cell.getQualifierArray(), cell.getQualifierOffset(), qlength);
        }
    }

    public static void writeQualifierSkippingBytes(DataOutputStream out, Cell cell, int qlength, int commonPrefix) throws IOException {
        if (cell instanceof ByteBufferCell) {
            ByteBufferUtils.copyBufferToStream(out, ((ByteBufferCell)cell).getQualifierByteBuffer(), ((ByteBufferCell)cell).getQualifierPosition() + commonPrefix, qlength - commonPrefix);
        } else {
            out.write(cell.getQualifierArray(), cell.getQualifierOffset() + commonPrefix, qlength - commonPrefix);
        }
    }

    public static void writeValue(OutputStream out, Cell cell, int vlength) throws IOException {
        if (cell instanceof ByteBufferCell) {
            ByteBufferUtils.copyBufferToStream(out, ((ByteBufferCell)cell).getValueByteBuffer(), ((ByteBufferCell)cell).getValuePosition(), vlength);
        } else {
            out.write(cell.getValueArray(), cell.getValueOffset(), vlength);
        }
    }

    public static void writeTags(OutputStream out, Cell cell, int tagsLength) throws IOException {
        if (cell instanceof ByteBufferCell) {
            ByteBufferUtils.copyBufferToStream(out, ((ByteBufferCell)cell).getTagsByteBuffer(), ((ByteBufferCell)cell).getTagsPosition(), tagsLength);
        } else {
            out.write(cell.getTagsArray(), cell.getTagsOffset(), tagsLength);
        }
    }

    public static String getCellKeyAsString(Cell cell) {
        StringBuilder sb = new StringBuilder(Bytes.toStringBinary(cell.getRowArray(), cell.getRowOffset(), cell.getRowLength()));
        sb.append('/');
        sb.append(cell.getFamilyLength() == 0 ? "" : Bytes.toStringBinary(cell.getFamilyArray(), cell.getFamilyOffset(), cell.getFamilyLength()));
        if (cell.getFamilyLength() > 0) {
            sb.append(':');
        }
        sb.append(cell.getQualifierLength() == 0 ? "" : Bytes.toStringBinary(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength()));
        sb.append('/');
        sb.append(KeyValue.humanReadableTimestamp(cell.getTimestamp()));
        sb.append('/');
        sb.append((Object)KeyValue.Type.codeToType(cell.getTypeByte()));
        if (!(cell instanceof KeyValue.KeyOnlyKeyValue)) {
            sb.append("/vlen=");
            sb.append(cell.getValueLength());
        }
        sb.append("/seqid=");
        sb.append(cell.getSequenceId());
        return sb.toString();
    }

    public static byte[] getCellKeySerializedAsKeyValueKey(Cell cell) {
        if (cell == null) {
            return null;
        }
        byte[] b = new byte[KeyValueUtil.keyLength(cell)];
        KeyValueUtil.appendKeyTo(cell, b, 0);
        return b;
    }

    public static void writeRowKeyExcludingCommon(Cell cell, short rLen, int commonPrefix, DataOutputStream out) throws IOException {
        if (commonPrefix == 0) {
            out.writeShort(rLen);
        } else if (commonPrefix == 1) {
            out.writeByte((byte)rLen);
            --commonPrefix;
        } else {
            commonPrefix -= 2;
        }
        if (rLen > commonPrefix) {
            CellUtil.writeRowSkippingBytes(out, cell, rLen, commonPrefix);
        }
    }

    public static int findCommonPrefixInFlatKey(Cell c1, Cell c2, boolean bypassFamilyCheck, boolean withTsType) {
        short rLen1 = c1.getRowLength();
        short rLen2 = c2.getRowLength();
        int commonPrefix = 2;
        if (rLen1 != rLen2) {
            return ByteBufferUtils.findCommonPrefix(Bytes.toBytes(rLen1), 0, 2, Bytes.toBytes(rLen2), 0, 2);
        }
        int rkCommonPrefix = 0;
        rkCommonPrefix = c1 instanceof ByteBufferCell && c2 instanceof ByteBufferCell ? ByteBufferUtils.findCommonPrefix(((ByteBufferCell)c1).getRowByteBuffer(), ((ByteBufferCell)c1).getRowPosition(), (int)rLen1, ((ByteBufferCell)c2).getRowByteBuffer(), ((ByteBufferCell)c2).getRowPosition(), (int)rLen2) : ByteBufferUtils.findCommonPrefix(c1.getRowArray(), c1.getRowOffset(), (int)rLen1, c2.getRowArray(), c2.getRowOffset(), (int)rLen2);
        commonPrefix += rkCommonPrefix;
        if (rkCommonPrefix != rLen1) {
            return commonPrefix;
        }
        byte fLen1 = c1.getFamilyLength();
        if (bypassFamilyCheck) {
            commonPrefix += 1 + fLen1;
        } else {
            byte fLen2 = c2.getFamilyLength();
            if (fLen1 != fLen2) {
                return commonPrefix;
            }
            ++commonPrefix;
            int fCommonPrefix = c1 instanceof ByteBufferCell && c2 instanceof ByteBufferCell ? ByteBufferUtils.findCommonPrefix(((ByteBufferCell)c1).getFamilyByteBuffer(), ((ByteBufferCell)c1).getFamilyPosition(), (int)fLen1, ((ByteBufferCell)c2).getFamilyByteBuffer(), ((ByteBufferCell)c2).getFamilyPosition(), (int)fLen2) : ByteBufferUtils.findCommonPrefix(c1.getFamilyArray(), c1.getFamilyOffset(), (int)fLen1, c2.getFamilyArray(), c2.getFamilyOffset(), (int)fLen2);
            commonPrefix += fCommonPrefix;
            if (fCommonPrefix != fLen1) {
                return commonPrefix;
            }
        }
        int qLen1 = c1.getQualifierLength();
        int qLen2 = c2.getQualifierLength();
        int qCommon = c1 instanceof ByteBufferCell && c2 instanceof ByteBufferCell ? ByteBufferUtils.findCommonPrefix(((ByteBufferCell)c1).getQualifierByteBuffer(), ((ByteBufferCell)c1).getQualifierPosition(), qLen1, ((ByteBufferCell)c2).getQualifierByteBuffer(), ((ByteBufferCell)c2).getQualifierPosition(), qLen2) : ByteBufferUtils.findCommonPrefix(c1.getQualifierArray(), c1.getQualifierOffset(), qLen1, c2.getQualifierArray(), c2.getQualifierOffset(), qLen2);
        commonPrefix += qCommon;
        if (!withTsType || Math.max(qLen1, qLen2) != qCommon) {
            return commonPrefix;
        }
        int tsCommonPrefix = ByteBufferUtils.findCommonPrefix(Bytes.toBytes(c1.getTimestamp()), 0, 8, Bytes.toBytes(c2.getTimestamp()), 0, 8);
        commonPrefix += tsCommonPrefix;
        if (tsCommonPrefix != 8) {
            return commonPrefix;
        }
        if (c1.getTypeByte() == c2.getTypeByte()) {
            ++commonPrefix;
        }
        return commonPrefix;
    }

    public static String toString(Cell cell, boolean verbose) {
        if (cell == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        String keyStr = CellUtil.getCellKeyAsString(cell);
        String tag = null;
        String value = null;
        if (verbose) {
            if (cell.getTagsLength() > 0) {
                tag = Bytes.toStringBinary(cell.getTagsArray(), cell.getTagsOffset(), cell.getTagsLength());
            }
            if (!(cell instanceof KeyValue.KeyOnlyKeyValue)) {
                value = Bytes.toStringBinary(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength());
            }
        }
        builder.append(keyStr);
        if (tag != null && !tag.isEmpty()) {
            builder.append("/").append(tag);
        }
        if (value != null) {
            builder.append("/").append(value);
        }
        return builder.toString();
    }

    public static boolean equalsIgnoreMvccVersion(Cell a, Cell b) {
        boolean res = CellUtil.matchingRow(a, b);
        if (!res) {
            return res;
        }
        res = CellUtil.matchingColumn(a, b);
        if (!res) {
            return res;
        }
        if (!CellUtil.matchingTimestamp(a, b)) {
            return false;
        }
        int c = (0xFF & b.getTypeByte()) - (0xFF & a.getTypeByte());
        return c == 0;
    }

    public static boolean equals(Cell a, Cell b) {
        return CellUtil.matchingRow(a, b) && CellUtil.matchingFamily(a, b) && CellUtil.matchingQualifier(a, b) && CellUtil.matchingTimestamp(a, b) && CellUtil.matchingType(a, b);
    }

    public static boolean matchingTimestamp(Cell a, Cell b) {
        return CellComparator.compareTimestamps(a.getTimestamp(), b.getTimestamp()) == 0;
    }

    public static boolean matchingType(Cell a, Cell b) {
        return a.getTypeByte() == b.getTypeByte();
    }

    public static boolean matchingRows(Cell left, Cell right) {
        short rrowlength;
        short lrowlength = left.getRowLength();
        if (lrowlength != (rrowlength = right.getRowLength())) {
            return false;
        }
        if (left instanceof ByteBufferCell && right instanceof ByteBufferCell) {
            return ByteBufferUtils.equals(((ByteBufferCell)left).getRowByteBuffer(), ((ByteBufferCell)left).getRowPosition(), (int)lrowlength, ((ByteBufferCell)right).getRowByteBuffer(), ((ByteBufferCell)right).getRowPosition(), (int)rrowlength);
        }
        if (left instanceof ByteBufferCell) {
            return ByteBufferUtils.equals(((ByteBufferCell)left).getRowByteBuffer(), ((ByteBufferCell)left).getRowPosition(), (int)lrowlength, right.getRowArray(), right.getRowOffset(), (int)rrowlength);
        }
        if (right instanceof ByteBufferCell) {
            return ByteBufferUtils.equals(((ByteBufferCell)right).getRowByteBuffer(), ((ByteBufferCell)right).getRowPosition(), (int)rrowlength, left.getRowArray(), left.getRowOffset(), (int)lrowlength);
        }
        return Bytes.equals(left.getRowArray(), left.getRowOffset(), lrowlength, right.getRowArray(), right.getRowOffset(), rrowlength);
    }

    public static boolean matchingRowColumn(Cell left, Cell right) {
        if (left.getRowLength() + left.getFamilyLength() + left.getQualifierLength() != right.getRowLength() + right.getFamilyLength() + right.getQualifierLength()) {
            return false;
        }
        if (!CellUtil.matchingRows(left, right)) {
            return false;
        }
        return CellUtil.matchingColumn(left, right);
    }

    public static int getRowAsInt(Cell cell) {
        if (cell instanceof ByteBufferCell) {
            return ByteBufferUtils.toInt(((ByteBufferCell)cell).getRowByteBuffer(), ((ByteBufferCell)cell).getRowPosition());
        }
        return Bytes.toInt(cell.getRowArray(), cell.getRowOffset());
    }

    public static long getValueAsLong(Cell cell) {
        if (cell instanceof ByteBufferCell) {
            return ByteBufferUtils.toLong(((ByteBufferCell)cell).getValueByteBuffer(), ((ByteBufferCell)cell).getValuePosition());
        }
        return Bytes.toLong(cell.getValueArray(), cell.getValueOffset());
    }

    public static int getValueAsInt(Cell cell) {
        if (cell instanceof ByteBufferCell) {
            return ByteBufferUtils.toInt(((ByteBufferCell)cell).getValueByteBuffer(), ((ByteBufferCell)cell).getValuePosition());
        }
        return Bytes.toInt(cell.getValueArray(), cell.getValueOffset());
    }

    public static double getValueAsDouble(Cell cell) {
        if (cell instanceof ByteBufferCell) {
            return ByteBufferUtils.toDouble(((ByteBufferCell)cell).getValueByteBuffer(), ((ByteBufferCell)cell).getValuePosition());
        }
        return Bytes.toDouble(cell.getValueArray(), cell.getValueOffset());
    }

    public static BigDecimal getValueAsBigDecimal(Cell cell) {
        if (cell instanceof ByteBufferCell) {
            return ByteBufferUtils.toBigDecimal(((ByteBufferCell)cell).getValueByteBuffer(), ((ByteBufferCell)cell).getValuePosition(), cell.getValueLength());
        }
        return Bytes.toBigDecimal(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength());
    }

    public static Cell createFirstOnRow(Cell cell) {
        if (cell instanceof ByteBufferCell) {
            return new FirstOnRowByteBufferCell(((ByteBufferCell)cell).getRowByteBuffer(), ((ByteBufferCell)cell).getRowPosition(), cell.getRowLength());
        }
        return new FirstOnRowCell(cell.getRowArray(), cell.getRowOffset(), cell.getRowLength());
    }

    public static Cell createFirstOnRow(byte[] row, int roffset, short rlength) {
        return new FirstOnRowCell(row, roffset, rlength);
    }

    public static Cell createFirstOnRow(byte[] row, byte[] family, byte[] col) {
        return CellUtil.createFirstOnRow(row, 0, (short)row.length, family, 0, (byte)family.length, col, 0, col.length);
    }

    public static Cell createFirstOnRow(byte[] row, int roffset, short rlength, byte[] family, int foffset, byte flength, byte[] col, int coffset, int clength) {
        return new FirstOnRowColCell(row, roffset, rlength, family, foffset, flength, col, coffset, clength);
    }

    public static Cell createFirstOnRow(byte[] row) {
        return CellUtil.createFirstOnRow(row, 0, (short)row.length);
    }

    public static Cell createFirstOnRowFamily(Cell cell, byte[] fArray, int foff, int flen) {
        if (cell instanceof ByteBufferCell) {
            return new FirstOnRowColByteBufferCell(((ByteBufferCell)cell).getRowByteBuffer(), ((ByteBufferCell)cell).getRowPosition(), cell.getRowLength(), ByteBuffer.wrap(fArray), foff, (byte)flen, HConstants.EMPTY_BYTE_BUFFER, 0, 0);
        }
        return new FirstOnRowColCell(cell.getRowArray(), cell.getRowOffset(), cell.getRowLength(), fArray, foff, (byte)flen, HConstants.EMPTY_BYTE_ARRAY, 0, 0);
    }

    public static Cell createFirstOnRowCol(Cell cell) {
        if (cell instanceof ByteBufferCell) {
            return new FirstOnRowColByteBufferCell(((ByteBufferCell)cell).getRowByteBuffer(), ((ByteBufferCell)cell).getRowPosition(), cell.getRowLength(), HConstants.EMPTY_BYTE_BUFFER, 0, 0, ((ByteBufferCell)cell).getQualifierByteBuffer(), ((ByteBufferCell)cell).getQualifierPosition(), cell.getQualifierLength());
        }
        return new FirstOnRowColCell(cell.getRowArray(), cell.getRowOffset(), cell.getRowLength(), HConstants.EMPTY_BYTE_ARRAY, 0, 0, cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength());
    }

    public static Cell createFirstOnNextRow(Cell cell) {
        byte[] nextRow = new byte[cell.getRowLength() + 1];
        CellUtil.copyRowTo(cell, nextRow, 0);
        nextRow[nextRow.length - 1] = 0;
        return new FirstOnRowCell(nextRow, 0, (short)nextRow.length);
    }

    public static Cell createFirstOnRowCol(Cell cell, byte[] qArray, int qoffest, int qlength) {
        if (cell instanceof ByteBufferCell) {
            return new FirstOnRowColByteBufferCell(((ByteBufferCell)cell).getRowByteBuffer(), ((ByteBufferCell)cell).getRowPosition(), cell.getRowLength(), ((ByteBufferCell)cell).getFamilyByteBuffer(), ((ByteBufferCell)cell).getFamilyPosition(), cell.getFamilyLength(), ByteBuffer.wrap(qArray), qoffest, qlength);
        }
        return new FirstOnRowColCell(cell.getRowArray(), cell.getRowOffset(), cell.getRowLength(), cell.getFamilyArray(), cell.getFamilyOffset(), cell.getFamilyLength(), qArray, qoffest, qlength);
    }

    public static Cell createFirstOnRowColTS(Cell cell, long ts) {
        if (cell instanceof ByteBufferCell) {
            return new FirstOnRowColTSByteBufferCell(((ByteBufferCell)cell).getRowByteBuffer(), ((ByteBufferCell)cell).getRowPosition(), cell.getRowLength(), ((ByteBufferCell)cell).getFamilyByteBuffer(), ((ByteBufferCell)cell).getFamilyPosition(), cell.getFamilyLength(), ((ByteBufferCell)cell).getQualifierByteBuffer(), ((ByteBufferCell)cell).getQualifierPosition(), cell.getQualifierLength(), ts);
        }
        return new FirstOnRowColTSCell(cell.getRowArray(), cell.getRowOffset(), cell.getRowLength(), cell.getFamilyArray(), cell.getFamilyOffset(), cell.getFamilyLength(), cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength(), ts);
    }

    public static Cell createLastOnRow(Cell cell) {
        if (cell instanceof ByteBufferCell) {
            return new LastOnRowByteBufferCell(((ByteBufferCell)cell).getRowByteBuffer(), ((ByteBufferCell)cell).getRowPosition(), cell.getRowLength());
        }
        return new LastOnRowCell(cell.getRowArray(), cell.getRowOffset(), cell.getRowLength());
    }

    public static Cell createLastOnRow(byte[] row) {
        return new LastOnRowCell(row, 0, (short)row.length);
    }

    public static Cell createLastOnRowCol(Cell cell) {
        if (cell instanceof ByteBufferCell) {
            return new LastOnRowColByteBufferCell(((ByteBufferCell)cell).getRowByteBuffer(), ((ByteBufferCell)cell).getRowPosition(), cell.getRowLength(), ((ByteBufferCell)cell).getFamilyByteBuffer(), ((ByteBufferCell)cell).getFamilyPosition(), cell.getFamilyLength(), ((ByteBufferCell)cell).getQualifierByteBuffer(), ((ByteBufferCell)cell).getQualifierPosition(), cell.getQualifierLength());
        }
        return new LastOnRowColCell(cell.getRowArray(), cell.getRowOffset(), cell.getRowLength(), cell.getFamilyArray(), cell.getFamilyOffset(), cell.getFamilyLength(), cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength());
    }

    public static Cell createFirstDeleteFamilyCellOnRow(byte[] row, byte[] fam) {
        return new FirstOnRowDeleteFamilyCell(row, fam);
    }

    @InterfaceAudience.Private
    public static void compressTags(OutputStream out, Cell cell, TagCompressionContext tagCompressionContext) throws IOException {
        if (cell instanceof ByteBufferCell) {
            tagCompressionContext.compressTags(out, ((ByteBufferCell)cell).getTagsByteBuffer(), ((ByteBufferCell)cell).getTagsPosition(), cell.getTagsLength());
        } else {
            tagCompressionContext.compressTags(out, cell.getTagsArray(), cell.getTagsOffset(), cell.getTagsLength());
        }
    }

    @InterfaceAudience.Private
    public static void compressRow(OutputStream out, Cell cell, Dictionary dict) throws IOException {
        if (cell instanceof ByteBufferCell) {
            Dictionary.write(out, ((ByteBufferCell)cell).getRowByteBuffer(), ((ByteBufferCell)cell).getRowPosition(), (int)cell.getRowLength(), dict);
        } else {
            Dictionary.write(out, cell.getRowArray(), cell.getRowOffset(), (int)cell.getRowLength(), dict);
        }
    }

    @InterfaceAudience.Private
    public static void compressFamily(OutputStream out, Cell cell, Dictionary dict) throws IOException {
        if (cell instanceof ByteBufferCell) {
            Dictionary.write(out, ((ByteBufferCell)cell).getFamilyByteBuffer(), ((ByteBufferCell)cell).getFamilyPosition(), (int)cell.getFamilyLength(), dict);
        } else {
            Dictionary.write(out, cell.getFamilyArray(), cell.getFamilyOffset(), (int)cell.getFamilyLength(), dict);
        }
    }

    @InterfaceAudience.Private
    public static void compressQualifier(OutputStream out, Cell cell, Dictionary dict) throws IOException {
        if (cell instanceof ByteBufferCell) {
            Dictionary.write(out, ((ByteBufferCell)cell).getQualifierByteBuffer(), ((ByteBufferCell)cell).getQualifierPosition(), cell.getQualifierLength(), dict);
        } else {
            Dictionary.write(out, cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength(), dict);
        }
    }

    @InterfaceAudience.Private
    public static Cell createNextOnRowCol(Cell cell) {
        long ts = cell.getTimestamp();
        byte type = cell.getTypeByte();
        if (type != KeyValue.Type.Minimum.getCode()) {
            type = KeyValue.Type.values()[KeyValue.Type.codeToType(type).ordinal() - 1].getCode();
        } else if (ts != Long.MIN_VALUE) {
            --ts;
            type = KeyValue.Type.Maximum.getCode();
        } else {
            return cell;
        }
        return CellUtil.createNextOnRowCol(cell, ts, type);
    }

    private static Cell createNextOnRowCol(Cell cell, final long ts, final byte type) {
        if (cell instanceof ByteBufferCell) {
            return new LastOnRowColByteBufferCell(((ByteBufferCell)cell).getRowByteBuffer(), ((ByteBufferCell)cell).getRowPosition(), cell.getRowLength(), ((ByteBufferCell)cell).getFamilyByteBuffer(), ((ByteBufferCell)cell).getFamilyPosition(), cell.getFamilyLength(), ((ByteBufferCell)cell).getQualifierByteBuffer(), ((ByteBufferCell)cell).getQualifierPosition(), cell.getQualifierLength()){

                @Override
                public long getTimestamp() {
                    return ts;
                }

                @Override
                public byte getTypeByte() {
                    return type;
                }
            };
        }
        return new LastOnRowColCell(cell.getRowArray(), cell.getRowOffset(), cell.getRowLength(), cell.getFamilyArray(), cell.getFamilyOffset(), cell.getFamilyLength(), cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength()){

            @Override
            public long getTimestamp() {
                return ts;
            }

            @Override
            public byte getTypeByte() {
                return type;
            }
        };
    }

    @InterfaceAudience.Private
    private static class FirstOnRowDeleteFamilyCell
    extends EmptyCell {
        private final byte[] row;
        private final byte[] fam;

        public FirstOnRowDeleteFamilyCell(byte[] row, byte[] fam) {
            this.row = row;
            this.fam = fam;
        }

        @Override
        public byte[] getRowArray() {
            return this.row;
        }

        @Override
        public short getRowLength() {
            return (short)this.row.length;
        }

        @Override
        public byte[] getFamilyArray() {
            return this.fam;
        }

        @Override
        public byte getFamilyLength() {
            return (byte)this.fam.length;
        }

        @Override
        public long getTimestamp() {
            return Long.MAX_VALUE;
        }

        @Override
        public byte getTypeByte() {
            return KeyValue.Type.DeleteFamily.getCode();
        }
    }

    @InterfaceAudience.Private
    private static class LastOnRowColByteBufferCell
    extends LastOnRowByteBufferCell {
        private final ByteBuffer fBuffer;
        private final int foffset;
        private final byte flength;
        private final ByteBuffer qBuffer;
        private final int qoffset;
        private final int qlength;

        public LastOnRowColByteBufferCell(ByteBuffer rBuffer, int roffset, short rlength, ByteBuffer fBuffer, int foffset, byte flength, ByteBuffer qBuffer, int qoffset, int qlength) {
            super(rBuffer, roffset, rlength);
            this.fBuffer = fBuffer;
            this.foffset = foffset;
            this.flength = flength;
            this.qBuffer = qBuffer;
            this.qoffset = qoffset;
            this.qlength = qlength;
        }

        @Override
        public ByteBuffer getFamilyByteBuffer() {
            return this.fBuffer;
        }

        @Override
        public int getFamilyPosition() {
            return this.foffset;
        }

        @Override
        public byte getFamilyLength() {
            return this.flength;
        }

        @Override
        public ByteBuffer getQualifierByteBuffer() {
            return this.qBuffer;
        }

        @Override
        public int getQualifierPosition() {
            return this.qoffset;
        }

        @Override
        public int getQualifierLength() {
            return this.qlength;
        }
    }

    @InterfaceAudience.Private
    private static class LastOnRowColCell
    extends LastOnRowCell {
        private final byte[] fArray;
        private final int foffset;
        private final byte flength;
        private final byte[] qArray;
        private final int qoffset;
        private final int qlength;

        public LastOnRowColCell(byte[] rArray, int roffset, short rlength, byte[] fArray, int foffset, byte flength, byte[] qArray, int qoffset, int qlength) {
            super(rArray, roffset, rlength);
            this.fArray = fArray;
            this.foffset = foffset;
            this.flength = flength;
            this.qArray = qArray;
            this.qoffset = qoffset;
            this.qlength = qlength;
        }

        @Override
        public byte[] getFamilyArray() {
            return this.fArray;
        }

        @Override
        public int getFamilyOffset() {
            return this.foffset;
        }

        @Override
        public byte getFamilyLength() {
            return this.flength;
        }

        @Override
        public byte[] getQualifierArray() {
            return this.qArray;
        }

        @Override
        public int getQualifierOffset() {
            return this.qoffset;
        }

        @Override
        public int getQualifierLength() {
            return this.qlength;
        }
    }

    @InterfaceAudience.Private
    private static class LastOnRowCell
    extends EmptyCell {
        private final byte[] rowArray;
        private final int roffset;
        private final short rlength;

        public LastOnRowCell(byte[] row, int roffset, short rlength) {
            this.rowArray = row;
            this.roffset = roffset;
            this.rlength = rlength;
        }

        @Override
        public byte[] getRowArray() {
            return this.rowArray;
        }

        @Override
        public int getRowOffset() {
            return this.roffset;
        }

        @Override
        public short getRowLength() {
            return this.rlength;
        }

        @Override
        public long getTimestamp() {
            return Long.MIN_VALUE;
        }

        @Override
        public byte getTypeByte() {
            return KeyValue.Type.Minimum.getCode();
        }
    }

    @InterfaceAudience.Private
    private static class FirstOnRowColTSByteBufferCell
    extends FirstOnRowColByteBufferCell {
        private long ts;

        public FirstOnRowColTSByteBufferCell(ByteBuffer rBuffer, int roffset, short rlength, ByteBuffer fBuffer, int foffset, byte flength, ByteBuffer qBuffer, int qoffset, int qlength, long ts) {
            super(rBuffer, roffset, rlength, fBuffer, foffset, flength, qBuffer, qoffset, qlength);
            this.ts = ts;
        }

        @Override
        public long getTimestamp() {
            return this.ts;
        }
    }

    @InterfaceAudience.Private
    private static class FirstOnRowColTSCell
    extends FirstOnRowColCell {
        private long ts;

        public FirstOnRowColTSCell(byte[] rArray, int roffset, short rlength, byte[] fArray, int foffset, byte flength, byte[] qArray, int qoffset, int qlength, long ts) {
            super(rArray, roffset, rlength, fArray, foffset, flength, qArray, qoffset, qlength);
            this.ts = ts;
        }

        @Override
        public long getTimestamp() {
            return this.ts;
        }
    }

    @InterfaceAudience.Private
    private static class FirstOnRowColCell
    extends FirstOnRowCell {
        private final byte[] fArray;
        private final int foffset;
        private final byte flength;
        private final byte[] qArray;
        private final int qoffset;
        private final int qlength;

        public FirstOnRowColCell(byte[] rArray, int roffset, short rlength, byte[] fArray, int foffset, byte flength, byte[] qArray, int qoffset, int qlength) {
            super(rArray, roffset, rlength);
            this.fArray = fArray;
            this.foffset = foffset;
            this.flength = flength;
            this.qArray = qArray;
            this.qoffset = qoffset;
            this.qlength = qlength;
        }

        @Override
        public byte[] getFamilyArray() {
            return this.fArray;
        }

        @Override
        public int getFamilyOffset() {
            return this.foffset;
        }

        @Override
        public byte getFamilyLength() {
            return this.flength;
        }

        @Override
        public byte[] getQualifierArray() {
            return this.qArray;
        }

        @Override
        public int getQualifierOffset() {
            return this.qoffset;
        }

        @Override
        public int getQualifierLength() {
            return this.qlength;
        }
    }

    @InterfaceAudience.Private
    private static class FirstOnRowColByteBufferCell
    extends FirstOnRowByteBufferCell {
        private final ByteBuffer famBuff;
        private final int famOffset;
        private final byte famLength;
        private final ByteBuffer colBuff;
        private final int colOffset;
        private final int colLength;

        public FirstOnRowColByteBufferCell(ByteBuffer row, int roffset, short rlength, ByteBuffer famBuff, int famOffset, byte famLength, ByteBuffer col, int colOffset, int colLength) {
            super(row, roffset, rlength);
            this.famBuff = famBuff;
            this.famOffset = famOffset;
            this.famLength = famLength;
            this.colBuff = col;
            this.colOffset = colOffset;
            this.colLength = colLength;
        }

        @Override
        public ByteBuffer getFamilyByteBuffer() {
            return this.famBuff;
        }

        @Override
        public int getFamilyPosition() {
            return this.famOffset;
        }

        @Override
        public byte getFamilyLength() {
            return this.famLength;
        }

        @Override
        public ByteBuffer getQualifierByteBuffer() {
            return this.colBuff;
        }

        @Override
        public int getQualifierPosition() {
            return this.colOffset;
        }

        @Override
        public int getQualifierLength() {
            return this.colLength;
        }
    }

    @InterfaceAudience.Private
    private static class LastOnRowByteBufferCell
    extends EmptyByteBufferCell {
        private final ByteBuffer rowBuff;
        private final int roffset;
        private final short rlength;

        public LastOnRowByteBufferCell(ByteBuffer row, int roffset, short rlength) {
            this.rowBuff = row;
            this.roffset = roffset;
            this.rlength = rlength;
        }

        @Override
        public ByteBuffer getRowByteBuffer() {
            return this.rowBuff;
        }

        @Override
        public int getRowPosition() {
            return this.roffset;
        }

        @Override
        public short getRowLength() {
            return this.rlength;
        }

        @Override
        public long getTimestamp() {
            return Long.MIN_VALUE;
        }

        @Override
        public byte getTypeByte() {
            return KeyValue.Type.Minimum.getCode();
        }
    }

    @InterfaceAudience.Private
    private static class FirstOnRowByteBufferCell
    extends EmptyByteBufferCell {
        private final ByteBuffer rowBuff;
        private final int roffset;
        private final short rlength;

        public FirstOnRowByteBufferCell(ByteBuffer row, int roffset, short rlength) {
            this.rowBuff = row;
            this.roffset = roffset;
            this.rlength = rlength;
        }

        @Override
        public ByteBuffer getRowByteBuffer() {
            return this.rowBuff;
        }

        @Override
        public int getRowPosition() {
            return this.roffset;
        }

        @Override
        public short getRowLength() {
            return this.rlength;
        }

        @Override
        public long getTimestamp() {
            return Long.MAX_VALUE;
        }

        @Override
        public byte getTypeByte() {
            return KeyValue.Type.Maximum.getCode();
        }
    }

    @InterfaceAudience.Private
    private static class FirstOnRowCell
    extends EmptyCell {
        private final byte[] rowArray;
        private final int roffset;
        private final short rlength;

        public FirstOnRowCell(byte[] row, int roffset, short rlength) {
            this.rowArray = row;
            this.roffset = roffset;
            this.rlength = rlength;
        }

        @Override
        public byte[] getRowArray() {
            return this.rowArray;
        }

        @Override
        public int getRowOffset() {
            return this.roffset;
        }

        @Override
        public short getRowLength() {
            return this.rlength;
        }

        @Override
        public long getTimestamp() {
            return Long.MAX_VALUE;
        }

        @Override
        public byte getTypeByte() {
            return KeyValue.Type.Maximum.getCode();
        }
    }

    @InterfaceAudience.Private
    private static abstract class EmptyByteBufferCell
    extends ByteBufferCell
    implements SettableSequenceId {
        private EmptyByteBufferCell() {
        }

        @Override
        public void setSequenceId(long seqId) {
        }

        @Override
        public byte[] getRowArray() {
            return CellUtil.cloneRow(this);
        }

        @Override
        public int getRowOffset() {
            return 0;
        }

        @Override
        public short getRowLength() {
            return 0;
        }

        @Override
        public byte[] getFamilyArray() {
            return CellUtil.cloneFamily(this);
        }

        @Override
        public int getFamilyOffset() {
            return 0;
        }

        @Override
        public byte getFamilyLength() {
            return 0;
        }

        @Override
        public byte[] getQualifierArray() {
            return CellUtil.cloneQualifier(this);
        }

        @Override
        public int getQualifierOffset() {
            return 0;
        }

        @Override
        public int getQualifierLength() {
            return 0;
        }

        @Override
        public long getSequenceId() {
            return 0L;
        }

        @Override
        public byte[] getValueArray() {
            return CellUtil.cloneValue(this);
        }

        @Override
        public int getValueOffset() {
            return 0;
        }

        @Override
        public int getValueLength() {
            return 0;
        }

        @Override
        public byte[] getTagsArray() {
            return CellUtil.cloneTags(this);
        }

        @Override
        public int getTagsOffset() {
            return 0;
        }

        @Override
        public int getTagsLength() {
            return 0;
        }

        @Override
        public ByteBuffer getRowByteBuffer() {
            return HConstants.EMPTY_BYTE_BUFFER;
        }

        @Override
        public int getRowPosition() {
            return 0;
        }

        @Override
        public ByteBuffer getFamilyByteBuffer() {
            return HConstants.EMPTY_BYTE_BUFFER;
        }

        @Override
        public int getFamilyPosition() {
            return 0;
        }

        @Override
        public ByteBuffer getQualifierByteBuffer() {
            return HConstants.EMPTY_BYTE_BUFFER;
        }

        @Override
        public int getQualifierPosition() {
            return 0;
        }

        @Override
        public ByteBuffer getTagsByteBuffer() {
            return HConstants.EMPTY_BYTE_BUFFER;
        }

        @Override
        public int getTagsPosition() {
            return 0;
        }

        @Override
        public ByteBuffer getValueByteBuffer() {
            return HConstants.EMPTY_BYTE_BUFFER;
        }

        @Override
        public int getValuePosition() {
            return 0;
        }
    }

    @InterfaceAudience.Private
    private static abstract class EmptyCell
    implements Cell,
    SettableSequenceId {
        private EmptyCell() {
        }

        @Override
        public void setSequenceId(long seqId) {
        }

        @Override
        public byte[] getRowArray() {
            return HConstants.EMPTY_BYTE_ARRAY;
        }

        @Override
        public int getRowOffset() {
            return 0;
        }

        @Override
        public short getRowLength() {
            return 0;
        }

        @Override
        public byte[] getFamilyArray() {
            return HConstants.EMPTY_BYTE_ARRAY;
        }

        @Override
        public int getFamilyOffset() {
            return 0;
        }

        @Override
        public byte getFamilyLength() {
            return 0;
        }

        @Override
        public byte[] getQualifierArray() {
            return HConstants.EMPTY_BYTE_ARRAY;
        }

        @Override
        public int getQualifierOffset() {
            return 0;
        }

        @Override
        public int getQualifierLength() {
            return 0;
        }

        @Override
        public long getSequenceId() {
            return 0L;
        }

        @Override
        public byte[] getValueArray() {
            return HConstants.EMPTY_BYTE_ARRAY;
        }

        @Override
        public int getValueOffset() {
            return 0;
        }

        @Override
        public int getValueLength() {
            return 0;
        }

        @Override
        public byte[] getTagsArray() {
            return HConstants.EMPTY_BYTE_ARRAY;
        }

        @Override
        public int getTagsOffset() {
            return 0;
        }

        @Override
        public int getTagsLength() {
            return 0;
        }
    }

    @InterfaceAudience.Private
    private static class ValueAndTagRewriteByteBufferCell
    extends TagRewriteByteBufferCell {
        protected byte[] value;

        public ValueAndTagRewriteByteBufferCell(ByteBufferCell cell, byte[] value, byte[] tags) {
            super(cell, tags);
            this.value = value;
        }

        @Override
        public byte[] getValueArray() {
            return this.value;
        }

        @Override
        public int getValueOffset() {
            return 0;
        }

        @Override
        public int getValueLength() {
            return this.value == null ? 0 : this.value.length;
        }

        @Override
        public ByteBuffer getValueByteBuffer() {
            return ByteBuffer.wrap(this.value);
        }

        @Override
        public int getValuePosition() {
            return 0;
        }

        @Override
        public long heapSize() {
            long sum = (long)ClassSize.REFERENCE + super.heapSize();
            if (this.value != null) {
                sum += ClassSize.sizeOf(this.value);
            }
            return sum;
        }

        @Override
        public int write(OutputStream out, boolean withTags) throws IOException {
            return ValueAndTagRewriteCell.write(out, withTags, (Cell)this.cell, this.value, this.tags);
        }

        @Override
        public int getSerializedSize(boolean withTags) {
            return super.getSerializedSize(withTags) - this.cell.getValueLength() + this.value.length;
        }

        @Override
        public void write(ByteBuffer buf, int offset) {
            ValueAndTagRewriteCell.write(buf, offset, (Cell)this.cell, this.value, this.tags);
        }

        @Override
        public Cell deepClone() {
            Cell clonedBaseCell = ((ExtendedCell)((Object)this.cell)).deepClone();
            if (clonedBaseCell instanceof ByteBufferCell) {
                return new ValueAndTagRewriteByteBufferCell((ByteBufferCell)clonedBaseCell, this.value, this.tags);
            }
            return new ValueAndTagRewriteCell(clonedBaseCell, this.value, this.tags);
        }
    }

    @InterfaceAudience.Private
    private static class ValueAndTagRewriteCell
    extends TagRewriteCell {
        protected byte[] value;

        public ValueAndTagRewriteCell(Cell cell, byte[] value, byte[] tags) {
            super(cell, tags);
            this.value = value;
        }

        @Override
        public byte[] getValueArray() {
            return this.value;
        }

        @Override
        public int getValueOffset() {
            return 0;
        }

        @Override
        public int getValueLength() {
            return this.value == null ? 0 : this.value.length;
        }

        @Override
        public long heapSize() {
            long sum = (long)ClassSize.REFERENCE + super.heapSize();
            if (this.value != null) {
                sum += ClassSize.sizeOf(this.value);
            }
            return sum;
        }

        @Override
        public int write(OutputStream out, boolean withTags) throws IOException {
            return ValueAndTagRewriteCell.write(out, withTags, this.cell, this.value, this.tags);
        }

        static int write(OutputStream out, boolean withTags, Cell cell, byte[] value, byte[] tags) throws IOException {
            int valLen = value == null ? 0 : value.length;
            ByteBufferUtils.putInt(out, KeyValueUtil.keyLength(cell));
            ByteBufferUtils.putInt(out, valLen);
            int len = 8;
            len += CellUtil.writeFlatKey(cell, out);
            if (valLen > 0) {
                out.write(value);
            }
            len += valLen;
            if (withTags && tags != null) {
                out.write((byte)(0xFF & tags.length >> 8));
                out.write((byte)(0xFF & tags.length));
                out.write(tags);
                len += 2 + tags.length;
            }
            return len;
        }

        @Override
        public int getSerializedSize(boolean withTags) {
            return super.getSerializedSize(withTags) - this.cell.getValueLength() + this.value.length;
        }

        @Override
        public void write(ByteBuffer buf, int offset) {
            ValueAndTagRewriteCell.write(buf, offset, this.cell, this.value, this.tags);
        }

        static void write(ByteBuffer buf, int offset, Cell cell, byte[] value, byte[] tags) {
            int tagsLen;
            offset = ByteBufferUtils.putInt(buf, offset, KeyValueUtil.keyLength(cell));
            offset = ByteBufferUtils.putInt(buf, offset, value.length);
            offset = KeyValueUtil.appendKeyTo(cell, buf, offset);
            ByteBufferUtils.copyFromArrayToBuffer(buf, offset, value, 0, value.length);
            offset += value.length;
            int n = tagsLen = tags == null ? 0 : tags.length;
            if (tagsLen > 0) {
                offset = ByteBufferUtils.putAsShort(buf, offset, tagsLen);
                ByteBufferUtils.copyFromArrayToBuffer(buf, offset, tags, 0, tagsLen);
            }
        }

        @Override
        public Cell deepClone() {
            Cell clonedBaseCell = ((ExtendedCell)this.cell).deepClone();
            return new ValueAndTagRewriteCell(clonedBaseCell, this.value, this.tags);
        }
    }

    @InterfaceAudience.Private
    private static class TagRewriteByteBufferCell
    extends ByteBufferCell
    implements ExtendedCell {
        protected ByteBufferCell cell;
        protected byte[] tags;
        private static final long HEAP_SIZE_OVERHEAD = ClassSize.OBJECT + 2 * ClassSize.REFERENCE;

        public TagRewriteByteBufferCell(ByteBufferCell cell, byte[] tags) {
            assert (cell instanceof ExtendedCell);
            assert (tags != null);
            this.cell = cell;
            this.tags = tags;
            if (this.cell instanceof TagRewriteByteBufferCell) {
                ((TagRewriteByteBufferCell)this.cell).tags = null;
            }
        }

        @Override
        public byte[] getRowArray() {
            return this.cell.getRowArray();
        }

        @Override
        public int getRowOffset() {
            return this.cell.getRowOffset();
        }

        @Override
        public short getRowLength() {
            return this.cell.getRowLength();
        }

        @Override
        public byte[] getFamilyArray() {
            return this.cell.getFamilyArray();
        }

        @Override
        public int getFamilyOffset() {
            return this.cell.getFamilyOffset();
        }

        @Override
        public byte getFamilyLength() {
            return this.cell.getFamilyLength();
        }

        @Override
        public byte[] getQualifierArray() {
            return this.cell.getQualifierArray();
        }

        @Override
        public int getQualifierOffset() {
            return this.cell.getQualifierOffset();
        }

        @Override
        public int getQualifierLength() {
            return this.cell.getQualifierLength();
        }

        @Override
        public long getTimestamp() {
            return this.cell.getTimestamp();
        }

        @Override
        public byte getTypeByte() {
            return this.cell.getTypeByte();
        }

        @Override
        public long getSequenceId() {
            return this.cell.getSequenceId();
        }

        @Override
        public byte[] getValueArray() {
            return this.cell.getValueArray();
        }

        @Override
        public int getValueOffset() {
            return this.cell.getValueOffset();
        }

        @Override
        public int getValueLength() {
            return this.cell.getValueLength();
        }

        @Override
        public byte[] getTagsArray() {
            return this.tags;
        }

        @Override
        public int getTagsOffset() {
            return 0;
        }

        @Override
        public int getTagsLength() {
            if (null == this.tags) {
                return 0;
            }
            return this.tags.length;
        }

        @Override
        public void setSequenceId(long seqId) throws IOException {
            CellUtil.setSequenceId(this.cell, seqId);
        }

        @Override
        public void setTimestamp(long ts) throws IOException {
            CellUtil.setTimestamp(this.cell, ts);
        }

        @Override
        public void setTimestamp(byte[] ts, int tsOffset) throws IOException {
            CellUtil.setTimestamp(this.cell, ts, tsOffset);
        }

        @Override
        public long heapSize() {
            long sum = HEAP_SIZE_OVERHEAD + CellUtil.estimatedHeapSizeOf(this.cell);
            if (this.tags != null) {
                sum += ClassSize.sizeOf(this.tags);
            }
            return sum;
        }

        @Override
        public int write(OutputStream out, boolean withTags) throws IOException {
            int len = ((ExtendedCell)((Object)this.cell)).write(out, false);
            if (withTags && this.tags != null) {
                out.write((byte)(0xFF & this.tags.length >> 8));
                out.write((byte)(0xFF & this.tags.length));
                out.write(this.tags);
                len += 2 + this.tags.length;
            }
            return len;
        }

        @Override
        public int getSerializedSize(boolean withTags) {
            int len = ((ExtendedCell)((Object)this.cell)).getSerializedSize(false);
            if (withTags && this.tags != null) {
                len += 2 + this.tags.length;
            }
            return len;
        }

        @Override
        public void write(ByteBuffer buf, int offset) {
            int tagsLen;
            offset = KeyValueUtil.appendTo(this.cell, buf, offset, false);
            int n = tagsLen = this.tags == null ? 0 : this.tags.length;
            if (tagsLen > 0) {
                offset = ByteBufferUtils.putAsShort(buf, offset, tagsLen);
                ByteBufferUtils.copyFromArrayToBuffer(buf, offset, this.tags, 0, tagsLen);
            }
        }

        @Override
        public Cell deepClone() {
            Cell clonedBaseCell = ((ExtendedCell)((Object)this.cell)).deepClone();
            if (clonedBaseCell instanceof ByteBufferCell) {
                return new TagRewriteByteBufferCell((ByteBufferCell)clonedBaseCell, this.tags);
            }
            return new TagRewriteCell(clonedBaseCell, this.tags);
        }

        @Override
        public ByteBuffer getRowByteBuffer() {
            return this.cell.getRowByteBuffer();
        }

        @Override
        public int getRowPosition() {
            return this.cell.getRowPosition();
        }

        @Override
        public ByteBuffer getFamilyByteBuffer() {
            return this.cell.getFamilyByteBuffer();
        }

        @Override
        public int getFamilyPosition() {
            return this.cell.getFamilyPosition();
        }

        @Override
        public ByteBuffer getQualifierByteBuffer() {
            return this.cell.getQualifierByteBuffer();
        }

        @Override
        public int getQualifierPosition() {
            return this.cell.getQualifierPosition();
        }

        @Override
        public ByteBuffer getValueByteBuffer() {
            return this.cell.getValueByteBuffer();
        }

        @Override
        public int getValuePosition() {
            return this.cell.getValuePosition();
        }

        @Override
        public ByteBuffer getTagsByteBuffer() {
            return this.tags == null ? HConstants.EMPTY_BYTE_BUFFER : ByteBuffer.wrap(this.tags);
        }

        @Override
        public int getTagsPosition() {
            return 0;
        }
    }

    @InterfaceAudience.Private
    private static class TagRewriteCell
    implements ExtendedCell {
        protected Cell cell;
        protected byte[] tags;
        private static final long HEAP_SIZE_OVERHEAD = ClassSize.OBJECT + 2 * ClassSize.REFERENCE;

        public TagRewriteCell(Cell cell, byte[] tags) {
            assert (cell instanceof ExtendedCell);
            assert (tags != null);
            this.cell = cell;
            this.tags = tags;
            if (this.cell instanceof TagRewriteCell) {
                ((TagRewriteCell)this.cell).tags = null;
            }
        }

        @Override
        public byte[] getRowArray() {
            return this.cell.getRowArray();
        }

        @Override
        public int getRowOffset() {
            return this.cell.getRowOffset();
        }

        @Override
        public short getRowLength() {
            return this.cell.getRowLength();
        }

        @Override
        public byte[] getFamilyArray() {
            return this.cell.getFamilyArray();
        }

        @Override
        public int getFamilyOffset() {
            return this.cell.getFamilyOffset();
        }

        @Override
        public byte getFamilyLength() {
            return this.cell.getFamilyLength();
        }

        @Override
        public byte[] getQualifierArray() {
            return this.cell.getQualifierArray();
        }

        @Override
        public int getQualifierOffset() {
            return this.cell.getQualifierOffset();
        }

        @Override
        public int getQualifierLength() {
            return this.cell.getQualifierLength();
        }

        @Override
        public long getTimestamp() {
            return this.cell.getTimestamp();
        }

        @Override
        public byte getTypeByte() {
            return this.cell.getTypeByte();
        }

        @Override
        public long getSequenceId() {
            return this.cell.getSequenceId();
        }

        @Override
        public byte[] getValueArray() {
            return this.cell.getValueArray();
        }

        @Override
        public int getValueOffset() {
            return this.cell.getValueOffset();
        }

        @Override
        public int getValueLength() {
            return this.cell.getValueLength();
        }

        @Override
        public byte[] getTagsArray() {
            return this.tags;
        }

        @Override
        public int getTagsOffset() {
            return 0;
        }

        @Override
        public int getTagsLength() {
            if (null == this.tags) {
                return 0;
            }
            return this.tags.length;
        }

        @Override
        public long heapSize() {
            long sum = HEAP_SIZE_OVERHEAD + CellUtil.estimatedHeapSizeOf(this.cell);
            if (this.tags != null) {
                sum += ClassSize.sizeOf(this.tags);
            }
            return sum;
        }

        @Override
        public void setTimestamp(long ts) throws IOException {
            CellUtil.setTimestamp(this.cell, ts);
        }

        @Override
        public void setTimestamp(byte[] ts, int tsOffset) throws IOException {
            CellUtil.setTimestamp(this.cell, ts, tsOffset);
        }

        @Override
        public void setSequenceId(long seqId) throws IOException {
            CellUtil.setSequenceId(this.cell, seqId);
        }

        @Override
        public int write(OutputStream out, boolean withTags) throws IOException {
            int len = ((ExtendedCell)this.cell).write(out, false);
            if (withTags && this.tags != null) {
                out.write((byte)(0xFF & this.tags.length >> 8));
                out.write((byte)(0xFF & this.tags.length));
                out.write(this.tags);
                len += 2 + this.tags.length;
            }
            return len;
        }

        @Override
        public int getSerializedSize(boolean withTags) {
            int len = ((ExtendedCell)this.cell).getSerializedSize(false);
            if (withTags && this.tags != null) {
                len += 2 + this.tags.length;
            }
            return len;
        }

        @Override
        public void write(ByteBuffer buf, int offset) {
            int tagsLen;
            offset = KeyValueUtil.appendTo(this.cell, buf, offset, false);
            int n = tagsLen = this.tags == null ? 0 : this.tags.length;
            if (tagsLen > 0) {
                offset = ByteBufferUtils.putAsShort(buf, offset, tagsLen);
                ByteBufferUtils.copyFromArrayToBuffer(buf, offset, this.tags, 0, tagsLen);
            }
        }

        @Override
        public Cell deepClone() {
            Cell clonedBaseCell = ((ExtendedCell)this.cell).deepClone();
            return new TagRewriteCell(clonedBaseCell, this.tags);
        }
    }
}

