/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.util.List;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClusterStatusProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Strings;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class RegionLoad {
    protected ClusterStatusProtos.RegionLoad regionLoadPB;

    @InterfaceAudience.Private
    public RegionLoad(ClusterStatusProtos.RegionLoad regionLoadPB) {
        this.regionLoadPB = regionLoadPB;
    }

    public byte[] getName() {
        return this.regionLoadPB.getRegionSpecifier().getValue().toByteArray();
    }

    public String getNameAsString() {
        return Bytes.toStringBinary(this.getName());
    }

    public int getStores() {
        return this.regionLoadPB.getStores();
    }

    public int getStorefiles() {
        return this.regionLoadPB.getStorefiles();
    }

    public int getStorefileSizeMB() {
        return this.regionLoadPB.getStorefileSizeMB();
    }

    public int getMemStoreSizeMB() {
        return this.regionLoadPB.getMemstoreSizeMB();
    }

    @Deprecated
    public int getStorefileIndexSizeMB() {
        return (int)(this.regionLoadPB.getStorefileIndexSizeKB() >> 10);
    }

    public long getStorefileIndexSizeKB() {
        return this.regionLoadPB.getStorefileIndexSizeKB();
    }

    public long getRequestsCount() {
        return this.getReadRequestsCount() + this.getWriteRequestsCount();
    }

    public long getReadRequestsCount() {
        return this.regionLoadPB.getReadRequestsCount();
    }

    public long getFilteredReadRequestsCount() {
        return this.regionLoadPB.getFilteredReadRequestsCount();
    }

    public long getWriteRequestsCount() {
        return this.regionLoadPB.getWriteRequestsCount();
    }

    public int getRootIndexSizeKB() {
        return this.regionLoadPB.getRootIndexSizeKB();
    }

    public int getTotalStaticIndexSizeKB() {
        return this.regionLoadPB.getTotalStaticIndexSizeKB();
    }

    public int getTotalStaticBloomSizeKB() {
        return this.regionLoadPB.getTotalStaticBloomSizeKB();
    }

    public long getTotalCompactingKVs() {
        return this.regionLoadPB.getTotalCompactingKVs();
    }

    public long getCurrentCompactedKVs() {
        return this.regionLoadPB.getCurrentCompactedKVs();
    }

    public long getCompleteSequenceId() {
        return this.regionLoadPB.getCompleteSequenceId();
    }

    public List<ClusterStatusProtos.StoreSequenceId> getStoreCompleteSequenceId() {
        return this.regionLoadPB.getStoreCompleteSequenceIdList();
    }

    public int getStoreUncompressedSizeMB() {
        return this.regionLoadPB.getStoreUncompressedSizeMB();
    }

    public float getDataLocality() {
        if (this.regionLoadPB.hasDataLocality()) {
            return this.regionLoadPB.getDataLocality();
        }
        return 0.0f;
    }

    public long getLastMajorCompactionTs() {
        return this.regionLoadPB.getLastMajorCompactionTs();
    }

    public String toString() {
        StringBuilder sb = Strings.appendKeyValue(new StringBuilder(), "numberOfStores", this.getStores());
        sb = Strings.appendKeyValue(sb, "numberOfStorefiles", this.getStorefiles());
        sb = Strings.appendKeyValue(sb, "storefileUncompressedSizeMB", this.getStoreUncompressedSizeMB());
        sb = Strings.appendKeyValue(sb, "lastMajorCompactionTimestamp", this.getLastMajorCompactionTs());
        sb = Strings.appendKeyValue(sb, "storefileSizeMB", this.getStorefileSizeMB());
        if (this.getStoreUncompressedSizeMB() != 0) {
            sb = Strings.appendKeyValue(sb, "compressionRatio", String.format("%.4f", Float.valueOf((float)this.getStorefileSizeMB() / (float)this.getStoreUncompressedSizeMB())));
        }
        sb = Strings.appendKeyValue(sb, "memstoreSizeMB", this.getMemStoreSizeMB());
        sb = Strings.appendKeyValue(sb, "storefileIndexSizeKB", this.getStorefileIndexSizeKB());
        sb = Strings.appendKeyValue(sb, "readRequestsCount", this.getReadRequestsCount());
        sb = Strings.appendKeyValue(sb, "writeRequestsCount", this.getWriteRequestsCount());
        sb = Strings.appendKeyValue(sb, "rootIndexSizeKB", this.getRootIndexSizeKB());
        sb = Strings.appendKeyValue(sb, "totalStaticIndexSizeKB", this.getTotalStaticIndexSizeKB());
        sb = Strings.appendKeyValue(sb, "totalStaticBloomSizeKB", this.getTotalStaticBloomSizeKB());
        sb = Strings.appendKeyValue(sb, "totalCompactingKVs", this.getTotalCompactingKVs());
        sb = Strings.appendKeyValue(sb, "currentCompactedKVs", this.getCurrentCompactedKVs());
        float compactionProgressPct = Float.NaN;
        if (this.getTotalCompactingKVs() > 0L) {
            compactionProgressPct = (float)this.getCurrentCompactedKVs() / (float)this.getTotalCompactingKVs();
        }
        sb = Strings.appendKeyValue(sb, "compactionProgressPct", Float.valueOf(compactionProgressPct));
        sb = Strings.appendKeyValue(sb, "completeSequenceId", this.getCompleteSequenceId());
        sb = Strings.appendKeyValue(sb, "dataLocality", Float.valueOf(this.getDataLocality()));
        return sb.toString();
    }
}

