/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class RegionInfoBuilder {
    private static final Log LOG = LogFactory.getLog(RegionInfoBuilder.class);
    public static final String ENCODED_REGION_NAME_REGEX = "(?:[a-f0-9]+)";
    private static final int MAX_REPLICA_ID = 65535;
    public static final String NO_HASH = null;
    public static final RegionInfo FIRST_META_REGIONINFO = new MutableRegionInfo(1L, TableName.META_TABLE_NAME, 0);
    private MutableRegionInfo content = null;

    public static RegionInfoBuilder newBuilder(TableName tableName) {
        return new RegionInfoBuilder(tableName);
    }

    public static RegionInfoBuilder newBuilder(RegionInfo regionInfo) {
        return new RegionInfoBuilder(regionInfo);
    }

    private RegionInfoBuilder(TableName tableName) {
        this.content = new MutableRegionInfo(tableName);
    }

    private RegionInfoBuilder(RegionInfo regionInfo) {
        this.content = new MutableRegionInfo(regionInfo);
    }

    public RegionInfoBuilder setStartKey(byte[] startKey) {
        this.content.setStartKey(startKey);
        return this;
    }

    public RegionInfoBuilder setEndKey(byte[] endKey) {
        this.content.setEndKey(endKey);
        return this;
    }

    public RegionInfoBuilder setRegionId(long regionId) {
        this.content.setRegionId(regionId);
        return this;
    }

    public RegionInfoBuilder setReplicaId(int replicaId) {
        this.content.setReplicaId(replicaId);
        return this;
    }

    public RegionInfoBuilder setSplit(boolean isSplit) {
        this.content.setSplit(isSplit);
        return this;
    }

    public RegionInfoBuilder setOffline(boolean isOffline) {
        this.content.setOffline(isOffline);
        return this;
    }

    public RegionInfo build() {
        MutableRegionInfo ri = new MutableRegionInfo(this.content);
        if (ri.getTable().equals(TableName.META_TABLE_NAME) && ri.getReplicaId() == 0) {
            throw new IllegalArgumentException("Cannot create the default meta region; use static define FIRST_META_REGIONINFO");
        }
        return new MutableRegionInfo(this.content);
    }

    @InterfaceAudience.Private
    static class MutableRegionInfo
    implements RegionInfo,
    Comparable<RegionInfo> {
        private boolean offLine = false;
        private boolean split = false;
        private long regionId = -1L;
        private int replicaId = 0;
        private transient byte[] regionName = HConstants.EMPTY_BYTE_ARRAY;
        private byte[] startKey = HConstants.EMPTY_BYTE_ARRAY;
        private byte[] endKey = HConstants.EMPTY_BYTE_ARRAY;
        private int hashCode = -1;
        private String encodedName;
        private byte[] encodedNameAsBytes;
        private TableName tableName;

        private void setHashCode() {
            int result = Arrays.hashCode(this.regionName);
            result = (int)((long)result ^ this.regionId);
            result ^= Arrays.hashCode(this.startKey);
            result ^= Arrays.hashCode(this.endKey);
            result ^= Boolean.valueOf(this.offLine).hashCode();
            result ^= Arrays.hashCode(this.tableName.getName());
            this.hashCode = result ^= this.replicaId;
        }

        private MutableRegionInfo(long regionId, TableName tableName, int replicaId) {
            this.regionId = regionId;
            this.tableName = tableName;
            this.replicaId = replicaId;
            this.regionName = RegionInfo.createRegionName(tableName, null, regionId, replicaId, false);
            this.setHashCode();
        }

        MutableRegionInfo(TableName tableName) {
            this(tableName, null, null);
        }

        MutableRegionInfo(TableName tableName, byte[] startKey, byte[] endKey) throws IllegalArgumentException {
            this(tableName, startKey, endKey, false);
        }

        MutableRegionInfo(TableName tableName, byte[] startKey, byte[] endKey, boolean split) throws IllegalArgumentException {
            this(tableName, startKey, endKey, split, System.currentTimeMillis());
        }

        MutableRegionInfo(TableName tableName, byte[] startKey, byte[] endKey, boolean split, long regionid) throws IllegalArgumentException {
            this(tableName, startKey, endKey, split, regionid, 0);
        }

        MutableRegionInfo(TableName tableName, byte[] startKey, byte[] endKey, boolean split, long regionid, int replicaId) throws IllegalArgumentException {
            if (tableName == null) {
                throw new IllegalArgumentException("TableName cannot be null");
            }
            this.tableName = tableName;
            this.offLine = false;
            this.regionId = regionid;
            this.replicaId = replicaId;
            if (this.replicaId > 65535) {
                throw new IllegalArgumentException("ReplicaId cannot be greater than65535");
            }
            this.regionName = RegionInfo.createRegionName(this.tableName, startKey, this.regionId, replicaId, !this.tableName.equals(TableName.META_TABLE_NAME));
            this.split = split;
            this.endKey = endKey == null ? HConstants.EMPTY_END_ROW : (byte[])endKey.clone();
            this.startKey = startKey == null ? HConstants.EMPTY_START_ROW : (byte[])startKey.clone();
            this.tableName = tableName;
            this.setHashCode();
        }

        MutableRegionInfo(MutableRegionInfo other, boolean isMetaRegion) {
            if (other.getTable() == null) {
                throw new IllegalArgumentException("TableName cannot be null");
            }
            this.tableName = other.getTable();
            this.offLine = other.isOffline();
            this.regionId = other.getRegionId();
            this.replicaId = other.getReplicaId();
            if (this.replicaId > 65535) {
                throw new IllegalArgumentException("ReplicaId cannot be greater than65535");
            }
            this.regionName = isMetaRegion ? RegionInfo.createRegionName(other.getTable(), null, other.getRegionId(), other.getReplicaId(), false) : RegionInfo.createRegionName(other.getTable(), other.getStartKey(), other.getRegionId(), other.getReplicaId(), true);
            this.split = other.isSplit();
            this.endKey = other.getEndKey() == null ? HConstants.EMPTY_END_ROW : (byte[])other.getEndKey().clone();
            this.startKey = other.getStartKey() == null ? HConstants.EMPTY_START_ROW : (byte[])other.getStartKey().clone();
            this.tableName = other.getTable();
            this.setHashCode();
        }

        MutableRegionInfo(RegionInfo regionInfo) {
            this.endKey = regionInfo.getEndKey();
            this.offLine = regionInfo.isOffline();
            this.regionId = regionInfo.getRegionId();
            this.regionName = regionInfo.getRegionName();
            this.split = regionInfo.isSplit();
            this.startKey = regionInfo.getStartKey();
            this.hashCode = regionInfo.hashCode();
            this.encodedName = regionInfo.getEncodedName();
            this.tableName = regionInfo.getTable();
            this.replicaId = regionInfo.getReplicaId();
        }

        @Override
        public String getShortNameToLog() {
            return RegionInfo.prettyPrint(this.getEncodedName());
        }

        @Override
        public long getRegionId() {
            return this.regionId;
        }

        public MutableRegionInfo setRegionId(long regionId) {
            this.regionId = regionId;
            return this;
        }

        @Override
        public byte[] getRegionName() {
            return this.regionName;
        }

        public MutableRegionInfo setRegionName(byte[] regionName) {
            this.regionName = regionName;
            return this;
        }

        @Override
        public String getRegionNameAsString() {
            if (RegionInfo.hasEncodedName(this.regionName)) {
                return Bytes.toStringBinary(this.regionName);
            }
            return Bytes.toStringBinary(this.regionName) + "." + this.getEncodedName();
        }

        @Override
        public synchronized String getEncodedName() {
            if (this.encodedName == null) {
                this.encodedName = RegionInfo.encodeRegionName(this.regionName);
            }
            return this.encodedName;
        }

        @Override
        public synchronized byte[] getEncodedNameAsBytes() {
            if (this.encodedNameAsBytes == null) {
                this.encodedNameAsBytes = Bytes.toBytes(this.getEncodedName());
            }
            return this.encodedNameAsBytes;
        }

        @Override
        public byte[] getStartKey() {
            return this.startKey;
        }

        public MutableRegionInfo setStartKey(byte[] startKey) {
            this.startKey = startKey;
            return this;
        }

        @Override
        public byte[] getEndKey() {
            return this.endKey;
        }

        public MutableRegionInfo setEndKey(byte[] endKey) {
            this.endKey = endKey;
            return this;
        }

        @Override
        public TableName getTable() {
            if (this.tableName == null || this.tableName.getName().length == 0) {
                this.tableName = RegionInfo.getTable(this.getRegionName());
            }
            return this.tableName;
        }

        @Override
        public boolean containsRange(byte[] rangeStartKey, byte[] rangeEndKey) {
            if (Bytes.compareTo(rangeStartKey, rangeEndKey) > 0) {
                throw new IllegalArgumentException("Invalid range: " + Bytes.toStringBinary(rangeStartKey) + " > " + Bytes.toStringBinary(rangeEndKey));
            }
            boolean firstKeyInRange = Bytes.compareTo(rangeStartKey, this.startKey) >= 0;
            boolean lastKeyInRange = Bytes.compareTo(rangeEndKey, this.endKey) < 0 || Bytes.equals(this.endKey, HConstants.EMPTY_BYTE_ARRAY);
            return firstKeyInRange && lastKeyInRange;
        }

        @Override
        public boolean containsRow(byte[] row) {
            return Bytes.compareTo(row, this.startKey) >= 0 && (Bytes.compareTo(row, this.endKey) < 0 || Bytes.equals(this.endKey, HConstants.EMPTY_BYTE_ARRAY));
        }

        @Override
        public boolean isMetaTable() {
            return this.isMetaRegion();
        }

        @Override
        public boolean isMetaRegion() {
            return this.tableName.equals(FIRST_META_REGIONINFO.getTable());
        }

        @Override
        public boolean isSystemTable() {
            return this.tableName.isSystemTable();
        }

        @Override
        public boolean isSplit() {
            return this.split;
        }

        public MutableRegionInfo setSplit(boolean split) {
            this.split = split;
            return this;
        }

        @Override
        public boolean isOffline() {
            return this.offLine;
        }

        public MutableRegionInfo setOffline(boolean offLine) {
            this.offLine = offLine;
            return this;
        }

        @Override
        public boolean isSplitParent() {
            if (!this.isSplit()) {
                return false;
            }
            if (!this.isOffline()) {
                LOG.warn((Object)("Region is split but NOT offline: " + this.getRegionNameAsString()));
            }
            return true;
        }

        @Override
        public int getReplicaId() {
            return this.replicaId;
        }

        public MutableRegionInfo setReplicaId(int replicaId) {
            this.replicaId = replicaId;
            return this;
        }

        public String toString() {
            return "{ENCODED => " + this.getEncodedName() + ", " + "NAME" + " => '" + Bytes.toStringBinary(this.regionName) + "', STARTKEY => '" + Bytes.toStringBinary(this.startKey) + "', ENDKEY => '" + Bytes.toStringBinary(this.endKey) + "'" + (this.isOffline() ? ", OFFLINE => true" : "") + (this.isSplit() ? ", SPLIT => true" : "") + (this.replicaId > 0 ? ", REPLICA_ID => " + this.replicaId : "") + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (!(o instanceof RegionInfo)) {
                return false;
            }
            return this.compareTo((RegionInfo)o) == 0;
        }

        public int hashCode() {
            return this.hashCode;
        }

        @Override
        public int compareTo(RegionInfo other) {
            return RegionInfo.COMPARATOR.compare(this, other);
        }

        @Deprecated
        public KeyValue.KVComparator getComparator() {
            return this.isMetaRegion() ? KeyValue.META_COMPARATOR : KeyValue.COMPARATOR;
        }
    }
}

