/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionImplementation;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.client.Registry;
import org.apache.hadoop.hbase.client.ZooKeeperKeepAliveConnection;
import org.apache.hadoop.hbase.zookeeper.MetaTableLocator;
import org.apache.hadoop.hbase.zookeeper.ZKClusterId;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class ZooKeeperRegistry
implements Registry {
    private static final Log LOG = LogFactory.getLog(ZooKeeperRegistry.class);
    ConnectionImplementation hci;
    private String clusterId = null;

    ZooKeeperRegistry() {
    }

    @Override
    public void init(Connection connection) {
        if (!(connection instanceof ConnectionImplementation)) {
            throw new RuntimeException("This registry depends on ConnectionImplementation");
        }
        this.hci = (ConnectionImplementation)connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RegionLocations getMetaRegionLocation() throws IOException {
        try (ZooKeeperKeepAliveConnection zkw = this.hci.getKeepAliveZooKeeperWatcher();){
            StringBuilder str;
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Looking up meta region location in ZK, connection=" + this));
            }
            List<ServerName> servers = new MetaTableLocator().blockUntilAvailable((ZooKeeperWatcher)zkw, (long)this.hci.rpcTimeout, this.hci.getConfiguration());
            if (LOG.isTraceEnabled()) {
                if (servers == null) {
                    LOG.trace((Object)("Looked up meta region location, connection=" + this + "; servers = null"));
                } else {
                    str = new StringBuilder();
                    for (ServerName s : servers) {
                        str.append(s.toString());
                        str.append(" ");
                    }
                    LOG.trace((Object)("Looked up meta region location, connection=" + this + "; servers = " + str.toString()));
                }
            }
            if (servers == null) {
                str = null;
                return str;
            }
            HRegionLocation[] locs = new HRegionLocation[servers.size()];
            int i = 0;
            for (ServerName server : servers) {
                HRegionInfo h = RegionReplicaUtil.getRegionInfoForReplica(HRegionInfo.FIRST_META_REGIONINFO, i);
                if (server == null) {
                    locs[i++] = null;
                    continue;
                }
                locs[i++] = new HRegionLocation(h, server, 0L);
            }
            RegionLocations regionLocations = new RegionLocations(locs);
            return regionLocations;
        }
    }

    @Override
    public String getClusterId() {
        if (this.clusterId != null) {
            return this.clusterId;
        }
        try (ZooKeeperKeepAliveConnection zkw = null;){
            zkw = this.hci.getKeepAliveZooKeeperWatcher();
            this.clusterId = ZKClusterId.readClusterIdZNode(zkw);
            if (this.clusterId == null) {
                LOG.info((Object)"ClusterId read in ZooKeeper is null");
            }
        }
        return this.clusterId;
    }

    @Override
    public int getCurrentNrHRS() throws IOException {
        try (ZooKeeperKeepAliveConnection zkw = this.hci.getKeepAliveZooKeeperWatcher();){
            int n = ZKUtil.getNumberOfChildren(zkw, zkw.znodePaths.rsZNode);
            return n;
        }
    }
}

