/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.codec.prefixtree.decode;

import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.ByteBufferCell;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.SettableSequenceId;
import org.apache.hadoop.hbase.nio.ByteBuff;
import org.apache.hadoop.hbase.util.ByteBufferUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ObjectIntPair;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class PrefixTreeCell
extends ByteBufferCell
implements SettableSequenceId,
Comparable<Cell> {
    protected CellComparator comparator = CellComparator.COMPARATOR;
    public static final KeyValue.Type[] TYPES = new KeyValue.Type[256];
    public static final KeyValue.Type DEFAULT_TYPE;
    protected ByteBuff block;
    protected boolean includeMvccVersion;
    protected byte[] rowBuffer;
    protected int rowLength;
    protected byte[] familyBuffer;
    protected int familyOffset;
    protected int familyLength;
    protected byte[] qualifierBuffer;
    protected int qualifierOffset;
    protected int qualifierLength;
    protected Long timestamp;
    protected Long mvccVersion;
    protected KeyValue.Type type;
    protected int absoluteValueOffset;
    protected int valueLength;
    protected byte[] tagsBuffer;
    protected int tagsOffset;
    protected int tagsLength;
    protected ObjectIntPair<ByteBuffer> pair = new ObjectIntPair();

    public String toString() {
        return this.getKeyValueString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Cell)) {
            return false;
        }
        return CellUtil.equalsIgnoreMvccVersion(this, (Cell)obj);
    }

    public int hashCode() {
        return this.calculateHashForKey(this);
    }

    private int calculateHashForKey(Cell cell) {
        int rowHash = Bytes.hashCode(cell.getRowArray(), cell.getRowOffset(), cell.getRowLength());
        int familyHash = Bytes.hashCode(cell.getFamilyArray(), cell.getFamilyOffset(), cell.getFamilyLength());
        int qualifierHash = Bytes.hashCode(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength());
        int hash = 31 * rowHash + familyHash;
        hash = 31 * hash + qualifierHash;
        hash = 31 * hash + (int)cell.getTimestamp();
        hash = 31 * hash + cell.getTypeByte();
        return hash;
    }

    @Override
    public int compareTo(Cell other) {
        return this.comparator.compare(this, other);
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public long getSequenceId() {
        if (!this.includeMvccVersion) {
            return 0L;
        }
        return this.mvccVersion;
    }

    @Override
    public int getValueLength() {
        return this.valueLength;
    }

    @Override
    public byte[] getRowArray() {
        return this.rowBuffer;
    }

    @Override
    public int getRowOffset() {
        return 0;
    }

    @Override
    public short getRowLength() {
        return (short)this.rowLength;
    }

    @Override
    public byte[] getFamilyArray() {
        return this.familyBuffer;
    }

    @Override
    public int getFamilyOffset() {
        return this.familyOffset;
    }

    @Override
    public byte getFamilyLength() {
        return (byte)this.familyLength;
    }

    @Override
    public byte[] getQualifierArray() {
        return this.qualifierBuffer;
    }

    @Override
    public int getQualifierOffset() {
        return this.qualifierOffset;
    }

    @Override
    public int getQualifierLength() {
        return this.qualifierLength;
    }

    @Override
    public byte[] getValueArray() {
        if (this.pair.getFirst().hasArray()) {
            return this.pair.getFirst().array();
        }
        byte[] val = new byte[this.valueLength];
        ByteBufferUtils.copyFromBufferToArray(val, this.pair.getFirst(), this.pair.getSecond(), 0, this.valueLength);
        return val;
    }

    @Override
    public int getValueOffset() {
        if (this.pair.getFirst().hasArray()) {
            return this.pair.getSecond() + this.pair.getFirst().arrayOffset();
        }
        return 0;
    }

    @Override
    public byte getTypeByte() {
        return this.type.getCode();
    }

    protected String getKeyValueString() {
        KeyValue kv = KeyValueUtil.copyToNewKeyValue(this);
        return kv.toString();
    }

    @Override
    public int getTagsOffset() {
        return this.tagsOffset;
    }

    @Override
    public int getTagsLength() {
        return this.tagsLength;
    }

    @Override
    public byte[] getTagsArray() {
        return this.tagsBuffer;
    }

    @Override
    public void setSequenceId(long seqId) {
        this.mvccVersion = seqId;
    }

    @Override
    public ByteBuffer getRowByteBuffer() {
        return ByteBuffer.wrap(this.rowBuffer);
    }

    @Override
    public int getRowPosition() {
        return 0;
    }

    @Override
    public ByteBuffer getFamilyByteBuffer() {
        return ByteBuffer.wrap(this.familyBuffer);
    }

    @Override
    public int getFamilyPosition() {
        return this.getFamilyOffset();
    }

    @Override
    public ByteBuffer getQualifierByteBuffer() {
        return ByteBuffer.wrap(this.qualifierBuffer);
    }

    @Override
    public int getQualifierPosition() {
        return this.getQualifierOffset();
    }

    @Override
    public ByteBuffer getValueByteBuffer() {
        return this.pair.getFirst();
    }

    @Override
    public int getValuePosition() {
        return this.pair.getSecond();
    }

    @Override
    public ByteBuffer getTagsByteBuffer() {
        return ByteBuffer.wrap(this.tagsBuffer);
    }

    @Override
    public int getTagsPosition() {
        return this.getTagsOffset();
    }

    static {
        KeyValue.Type[] typeArray = KeyValue.Type.values();
        int n = typeArray.length;
        for (int i = 0; i < n; ++i) {
            KeyValue.Type type;
            PrefixTreeCell.TYPES[type.getCode() & 0xFF] = type = typeArray[i];
        }
        DEFAULT_TYPE = KeyValue.Type.Put;
    }
}

