/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.codec.prefixtree.encode.row;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.codec.prefixtree.PrefixTreeBlockMeta;
import org.apache.hadoop.hbase.codec.prefixtree.encode.PrefixTreeEncoder;
import org.apache.hadoop.hbase.codec.prefixtree.encode.tokenize.TokenizerNode;
import org.apache.hadoop.hbase.util.ByteRangeUtils;
import org.apache.hadoop.hbase.util.CollectionUtils;
import org.apache.hadoop.hbase.util.vint.UFIntTool;
import org.apache.hadoop.hbase.util.vint.UVIntTool;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class RowNodeWriter {
    protected static final Log LOG = LogFactory.getLog(RowNodeWriter.class);
    protected PrefixTreeEncoder prefixTreeEncoder;
    protected PrefixTreeBlockMeta blockMeta;
    protected TokenizerNode tokenizerNode;
    protected int tokenWidth;
    protected int fanOut;
    protected int numCells;
    protected int width;

    public RowNodeWriter(PrefixTreeEncoder keyValueBuilder, TokenizerNode tokenizerNode) {
        this.reconstruct(keyValueBuilder, tokenizerNode);
    }

    public void reconstruct(PrefixTreeEncoder prefixTreeEncoder, TokenizerNode tokenizerNode) {
        this.prefixTreeEncoder = prefixTreeEncoder;
        this.reset(tokenizerNode);
    }

    public void reset(TokenizerNode node) {
        this.blockMeta = this.prefixTreeEncoder.getBlockMeta();
        this.tokenizerNode = node;
        this.tokenWidth = 0;
        this.fanOut = 0;
        this.numCells = 0;
        this.width = 0;
        this.calculateOffsetsAndLengths();
    }

    protected void calculateOffsetsAndLengths() {
        this.tokenWidth = this.tokenizerNode.getTokenLength();
        if (!this.tokenizerNode.isRoot()) {
            --this.tokenWidth;
        }
        this.fanOut = CollectionUtils.nullSafeSize(this.tokenizerNode.getChildren());
        this.numCells = this.tokenizerNode.getNumOccurrences();
    }

    public int calculateWidth() {
        this.calculateWidthOverrideOffsetWidth(this.blockMeta.getNextNodeOffsetWidth());
        return this.width;
    }

    public int calculateWidthOverrideOffsetWidth(int offsetWidth) {
        this.width = 0;
        this.width += UVIntTool.numBytes(this.tokenWidth);
        this.width += this.tokenWidth;
        this.width += UVIntTool.numBytes(this.fanOut);
        this.width += this.fanOut;
        this.width += UVIntTool.numBytes(this.numCells);
        if (this.tokenizerNode.hasOccurrences()) {
            int fixedBytesPerCell = this.blockMeta.getFamilyOffsetWidth() + this.blockMeta.getQualifierOffsetWidth() + this.blockMeta.getTagsOffsetWidth() + this.blockMeta.getTimestampIndexWidth() + this.blockMeta.getMvccVersionIndexWidth() + this.blockMeta.getKeyValueTypeWidth() + this.blockMeta.getValueOffsetWidth() + this.blockMeta.getValueLengthWidth();
            this.width += this.numCells * fixedBytesPerCell;
        }
        if (!this.tokenizerNode.isLeaf()) {
            this.width += this.fanOut * offsetWidth;
        }
        return this.width;
    }

    public void write(OutputStream os) throws IOException {
        this.writeRowToken(os);
        this.writeFan(os);
        this.writeNumCells(os);
        this.writeFamilyNodeOffsets(os);
        this.writeQualifierNodeOffsets(os);
        this.writeTagNodeOffsets(os);
        this.writeTimestampIndexes(os);
        this.writeMvccVersionIndexes(os);
        this.writeCellTypes(os);
        this.writeValueOffsets(os);
        this.writeValueLengths(os);
        this.writeNextRowTrieNodeOffsets(os);
    }

    protected void writeRowToken(OutputStream os) throws IOException {
        UVIntTool.writeBytes(this.tokenWidth, os);
        int tokenStartIndex = this.tokenizerNode.isRoot() ? 0 : 1;
        ByteRangeUtils.write(os, this.tokenizerNode.getToken(), tokenStartIndex);
    }

    public void writeFan(OutputStream os) throws IOException {
        UVIntTool.writeBytes(this.fanOut, os);
        if (this.fanOut <= 0) {
            return;
        }
        ArrayList<TokenizerNode> children = this.tokenizerNode.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            TokenizerNode child = children.get(i);
            os.write(child.getToken().get(0));
        }
    }

    protected void writeNumCells(OutputStream os) throws IOException {
        UVIntTool.writeBytes(this.numCells, os);
    }

    protected void writeFamilyNodeOffsets(OutputStream os) throws IOException {
        if (this.blockMeta.getFamilyOffsetWidth() <= 0) {
            return;
        }
        for (int i = 0; i < this.numCells; ++i) {
            int cellInsertionIndex = 0;
            int sortedIndex = this.prefixTreeEncoder.getFamilySorter().getSortedIndexForInsertionId(cellInsertionIndex);
            int indexedFamilyOffset = this.prefixTreeEncoder.getFamilyWriter().getOutputArrayOffset(sortedIndex);
            UFIntTool.writeBytes(this.blockMeta.getFamilyOffsetWidth(), indexedFamilyOffset, os);
        }
    }

    protected void writeQualifierNodeOffsets(OutputStream os) throws IOException {
        if (this.blockMeta.getQualifierOffsetWidth() <= 0) {
            return;
        }
        for (int i = 0; i < this.numCells; ++i) {
            int cellInsertionIndex = this.tokenizerNode.getFirstInsertionIndex() + i;
            int sortedIndex = this.prefixTreeEncoder.getQualifierSorter().getSortedIndexForInsertionId(cellInsertionIndex);
            int indexedQualifierOffset = this.prefixTreeEncoder.getQualifierWriter().getOutputArrayOffset(sortedIndex);
            UFIntTool.writeBytes(this.blockMeta.getQualifierOffsetWidth(), indexedQualifierOffset, os);
        }
    }

    protected void writeTagNodeOffsets(OutputStream os) throws IOException {
        if (this.blockMeta.getTagsOffsetWidth() <= 0) {
            return;
        }
        for (int i = 0; i < this.numCells; ++i) {
            int cellInsertionIndex = this.tokenizerNode.getFirstInsertionIndex() + i;
            int sortedIndex = this.prefixTreeEncoder.getTagSorter().getSortedIndexForInsertionId(cellInsertionIndex);
            int indexedTagOffset = this.prefixTreeEncoder.getTagWriter().getOutputArrayOffset(sortedIndex);
            UFIntTool.writeBytes(this.blockMeta.getTagsOffsetWidth(), indexedTagOffset, os);
        }
    }

    protected void writeTimestampIndexes(OutputStream os) throws IOException {
        if (this.blockMeta.getTimestampIndexWidth() <= 0) {
            return;
        }
        for (int i = 0; i < this.numCells; ++i) {
            int cellInsertionIndex = this.tokenizerNode.getFirstInsertionIndex() + i;
            long timestamp = this.prefixTreeEncoder.getTimestamps()[cellInsertionIndex];
            int timestampIndex = this.prefixTreeEncoder.getTimestampEncoder().getIndex(timestamp);
            UFIntTool.writeBytes(this.blockMeta.getTimestampIndexWidth(), timestampIndex, os);
        }
    }

    protected void writeMvccVersionIndexes(OutputStream os) throws IOException {
        if (this.blockMeta.getMvccVersionIndexWidth() <= 0) {
            return;
        }
        for (int i = 0; i < this.numCells; ++i) {
            int cellInsertionIndex = this.tokenizerNode.getFirstInsertionIndex() + i;
            long mvccVersion = this.prefixTreeEncoder.getMvccVersions()[cellInsertionIndex];
            int mvccVersionIndex = this.prefixTreeEncoder.getMvccVersionEncoder().getIndex(mvccVersion);
            UFIntTool.writeBytes(this.blockMeta.getMvccVersionIndexWidth(), mvccVersionIndex, os);
        }
    }

    protected void writeCellTypes(OutputStream os) throws IOException {
        if (this.blockMeta.isAllSameType()) {
            return;
        }
        for (int i = 0; i < this.numCells; ++i) {
            int cellInsertionIndex = this.tokenizerNode.getFirstInsertionIndex() + i;
            os.write(this.prefixTreeEncoder.getTypeBytes()[cellInsertionIndex]);
        }
    }

    protected void writeValueOffsets(OutputStream os) throws IOException {
        for (int i = 0; i < this.numCells; ++i) {
            int cellInsertionIndex = this.tokenizerNode.getFirstInsertionIndex() + i;
            long valueStartIndex = this.prefixTreeEncoder.getValueOffset(cellInsertionIndex);
            UFIntTool.writeBytes(this.blockMeta.getValueOffsetWidth(), valueStartIndex, os);
        }
    }

    protected void writeValueLengths(OutputStream os) throws IOException {
        for (int i = 0; i < this.numCells; ++i) {
            int cellInsertionIndex = this.tokenizerNode.getFirstInsertionIndex() + i;
            int valueLength = this.prefixTreeEncoder.getValueLength(cellInsertionIndex);
            UFIntTool.writeBytes(this.blockMeta.getValueLengthWidth(), valueLength, os);
        }
    }

    protected void writeNextRowTrieNodeOffsets(OutputStream os) throws IOException {
        ArrayList<TokenizerNode> children = this.tokenizerNode.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            TokenizerNode child = children.get(i);
            int distanceToChild = this.tokenizerNode.getNegativeIndex() - child.getNegativeIndex();
            UFIntTool.writeBytes(this.blockMeta.getNextNodeOffsetWidth(), distanceToChild, os);
        }
    }
}

