/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.codec.prefixtree.encode.tokenize;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.codec.prefixtree.encode.tokenize.TokenizerNode;
import org.apache.hadoop.hbase.codec.prefixtree.encode.tokenize.TokenizerRowSearchResult;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.Lists;
import org.apache.hadoop.hbase.util.ArrayUtils;
import org.apache.hadoop.hbase.util.ByteRange;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CollectionUtils;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class Tokenizer {
    protected int numArraysAdded = 0;
    protected long lastNodeId = -1L;
    protected ArrayList<TokenizerNode> nodes = Lists.newArrayList();
    protected int numNodes;
    protected TokenizerNode root;
    protected byte[] tokens = new byte[0];
    protected int tokensLength;
    protected int maxElementLength = 0;
    protected int treeDepth = 0;
    protected static final Boolean INCLUDE_FULL_TREE_IN_TO_STRING = false;

    public void reset() {
        this.numArraysAdded = 0;
        this.lastNodeId = -1L;
        this.numNodes = 0;
        this.tokensLength = 0;
        this.root = null;
        this.maxElementLength = 0;
        this.treeDepth = 0;
    }

    public void addAll(ArrayList<ByteRange> sortedByteRanges) {
        for (int i = 0; i < sortedByteRanges.size(); ++i) {
            ByteRange byteRange = sortedByteRanges.get(i);
            this.addSorted(byteRange);
        }
    }

    public void addSorted(ByteRange bytes) {
        ++this.numArraysAdded;
        if (bytes.getLength() > this.maxElementLength) {
            this.maxElementLength = bytes.getLength();
        }
        if (this.root == null) {
            this.root = this.addNode(null, 1, 0, bytes, 0);
        } else {
            this.root.addSorted(bytes);
        }
    }

    public void incrementNumOccurrencesOfLatestValue() {
        CollectionUtils.getLast(this.nodes).incrementNumOccurrences(1);
    }

    protected long nextNodeId() {
        return ++this.lastNodeId;
    }

    protected TokenizerNode addNode(TokenizerNode parent, int nodeDepth, int tokenStartOffset, ByteRange token, int inputTokenOffset) {
        int inputTokenLength = token.getLength() - inputTokenOffset;
        int tokenOffset = this.appendTokenAndRepointByteRange(token, inputTokenOffset);
        TokenizerNode node = null;
        if (this.nodes.size() <= this.numNodes) {
            node = new TokenizerNode(this, parent, nodeDepth, tokenStartOffset, tokenOffset, inputTokenLength);
            this.nodes.add(node);
        } else {
            node = this.nodes.get(this.numNodes);
            node.reset();
            node.reconstruct(this, parent, nodeDepth, tokenStartOffset, tokenOffset, inputTokenLength);
        }
        ++this.numNodes;
        return node;
    }

    protected int appendTokenAndRepointByteRange(ByteRange token, int inputTokenOffset) {
        int newOffset = this.tokensLength;
        int inputTokenLength = token.getLength() - inputTokenOffset;
        int newMinimum = this.tokensLength + inputTokenLength;
        this.tokens = ArrayUtils.growIfNecessary(this.tokens, newMinimum, 2 * newMinimum);
        token.deepCopySubRangeTo(inputTokenOffset, inputTokenLength, this.tokens, this.tokensLength);
        this.tokensLength += inputTokenLength;
        return newOffset;
    }

    protected void submitMaxNodeDepthCandidate(int nodeDepth) {
        if (nodeDepth > this.treeDepth) {
            this.treeDepth = nodeDepth;
        }
    }

    public int getNumAdded() {
        return this.numArraysAdded;
    }

    public ArrayList<TokenizerNode> getNodes(boolean includeNonLeaves, boolean includeLeaves) {
        ArrayList<TokenizerNode> nodes = Lists.newArrayList();
        this.root.appendNodesToExternalList(nodes, includeNonLeaves, includeLeaves);
        return nodes;
    }

    public void appendNodes(List<TokenizerNode> appendTo, boolean includeNonLeaves, boolean includeLeaves) {
        this.root.appendNodesToExternalList(appendTo, includeNonLeaves, includeLeaves);
    }

    public List<byte[]> getArrays() {
        ArrayList<TokenizerNode> nodes = new ArrayList<TokenizerNode>();
        this.root.appendNodesToExternalList(nodes, true, true);
        ArrayList<byte[]> byteArrays = Lists.newArrayListWithCapacity(CollectionUtils.nullSafeSize(nodes));
        for (int i = 0; i < nodes.size(); ++i) {
            TokenizerNode node = (TokenizerNode)nodes.get(i);
            for (int j = 0; j < node.getNumOccurrences(); ++j) {
                byte[] byteArray = node.getNewByteArray();
                byteArrays.add(byteArray);
            }
        }
        return byteArrays;
    }

    public void getNode(TokenizerRowSearchResult resultHolder, byte[] key, int keyOffset, int keyLength) {
        this.root.getNode(resultHolder, key, keyOffset, keyLength);
    }

    public Tokenizer setNodeFirstInsertionIndexes() {
        this.root.setInsertionIndexes(0);
        return this;
    }

    public Tokenizer appendOutputArrayOffsets(List<Integer> offsets) {
        this.root.appendOutputArrayOffsets(offsets);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getStructuralString());
        if (INCLUDE_FULL_TREE_IN_TO_STRING.booleanValue()) {
            for (byte[] bytes : this.getArrays()) {
                if (sb.length() > 0) {
                    sb.append("\n");
                }
                sb.append(Bytes.toString(bytes));
            }
        }
        return sb.toString();
    }

    public String getStructuralString() {
        ArrayList<TokenizerNode> nodes = this.getNodes(true, true);
        StringBuilder sb = new StringBuilder();
        for (TokenizerNode node : nodes) {
            String line = node.getPaddedTokenAndOccurrenceString();
            sb.append(line + "\n");
        }
        return sb.toString();
    }

    public TokenizerNode getRoot() {
        return this.root;
    }

    public int getMaxElementLength() {
        return this.maxElementLength;
    }

    public int getTreeDepth() {
        return this.treeDepth;
    }
}

