/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.constraint;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.constraint.Constraint;
import org.apache.hadoop.hbase.constraint.Constraints;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ConstraintProcessor
implements RegionObserver {
    private static final Log LOG = LogFactory.getLog(ConstraintProcessor.class);
    private final ClassLoader classloader;
    private List<? extends Constraint> constraints = new ArrayList<Constraint>();

    public ConstraintProcessor() {
        this.classloader = this.getClass().getClassLoader();
    }

    @Override
    public void start(CoprocessorEnvironment environment) {
        if (!(environment instanceof RegionCoprocessorEnvironment)) {
            throw new IllegalArgumentException("Constraints only act on regions - started in an environment that was not a region");
        }
        RegionCoprocessorEnvironment env = (RegionCoprocessorEnvironment)environment;
        TableDescriptor desc = env.getRegion().getTableDescriptor();
        try {
            this.constraints = Constraints.getConstraints(desc, this.classloader);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Finished loading " + this.constraints.size() + " user Constraints on table: " + desc.getTableName()));
        }
    }

    @Override
    public void prePut(ObserverContext<RegionCoprocessorEnvironment> e, Put put, WALEdit edit, Durability durability) throws IOException {
        for (Constraint constraint : this.constraints) {
            constraint.check(put);
        }
    }

    @Override
    public boolean postScannerFilterRow(ObserverContext<RegionCoprocessorEnvironment> e, InternalScanner s, Cell curRowCell, boolean hasMore) throws IOException {
        return hasMore;
    }
}

