/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import edu.umd.cs.findbugs.annotations.Nullable;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.security.User;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.LimitedPrivate(value={"Coprocesssor"})
@InterfaceStability.Evolving
public class ObserverContext<E extends CoprocessorEnvironment> {
    private E env;
    private boolean bypass;
    private boolean complete;
    private User caller;

    public ObserverContext(User caller) {
        this.caller = caller;
    }

    public E getEnvironment() {
        return this.env;
    }

    public void prepare(E env) {
        this.env = env;
    }

    public void bypass() {
        this.bypass = true;
    }

    public void complete() {
        this.complete = true;
    }

    public boolean shouldBypass() {
        boolean current = this.bypass;
        this.bypass = false;
        return current;
    }

    public boolean shouldComplete() {
        boolean current = this.complete;
        this.complete = false;
        return current;
    }

    @Nullable
    public User getCaller() {
        return this.caller;
    }

    @Deprecated
    public static <T extends CoprocessorEnvironment> ObserverContext<T> createAndPrepare(T env, ObserverContext<T> context) {
        if (context == null) {
            context = new ObserverContext(RpcServer.getRequestUser());
        }
        context.prepare(env);
        return context;
    }

    public static <T extends CoprocessorEnvironment> ObserverContext<T> createAndPrepare(T env, ObserverContext<T> context, User user) {
        if (context == null) {
            context = new ObserverContext(user);
        }
        context.prepare(env);
        return context;
    }
}

