/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.favored;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.favored.StartcodeAgnosticServerName;
import org.apache.hadoop.hbase.master.RackManager;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.Lists;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.Sets;
import org.apache.hadoop.hbase.shaded.org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class FavoredNodeAssignmentHelper {
    private static final Log LOG = LogFactory.getLog(FavoredNodeAssignmentHelper.class);
    private RackManager rackManager;
    private Map<String, List<ServerName>> rackToRegionServerMap;
    private List<String> uniqueRackList;
    private Map<String, String> regionServerToRackMap;
    private Random random;
    private List<ServerName> servers;
    public static final byte[] FAVOREDNODES_QUALIFIER = Bytes.toBytes("fn");
    public static final short FAVORED_NODES_NUM = 3;
    public static final short MAX_ATTEMPTS_FN_GENERATION = 10;

    public FavoredNodeAssignmentHelper(List<ServerName> servers, Configuration conf) {
        this(servers, new RackManager(conf));
    }

    public FavoredNodeAssignmentHelper(List<ServerName> servers, RackManager rackManager) {
        this.servers = servers;
        this.rackManager = rackManager;
        this.rackToRegionServerMap = new HashMap<String, List<ServerName>>();
        this.regionServerToRackMap = new HashMap<String, String>();
        this.uniqueRackList = new ArrayList<String>();
        this.random = new Random();
    }

    public void initialize() {
        for (ServerName sn : this.servers) {
            String rackName = this.getRackOfServer(sn);
            List<ServerName> serverList = this.rackToRegionServerMap.get(rackName);
            if (serverList == null) {
                serverList = Lists.newArrayList();
                this.uniqueRackList.add(rackName);
                this.rackToRegionServerMap.put(rackName, serverList);
            }
            for (ServerName serverName : serverList) {
                if (ServerName.isSameAddress(sn, serverName)) break;
            }
            serverList.add(sn);
            this.regionServerToRackMap.put(sn.getHostname(), rackName);
        }
    }

    public static void updateMetaWithFavoredNodesInfo(Map<HRegionInfo, List<ServerName>> regionToFavoredNodes, Connection connection) throws IOException {
        ArrayList<Put> puts = new ArrayList<Put>();
        for (Map.Entry<HRegionInfo, List<ServerName>> entry : regionToFavoredNodes.entrySet()) {
            Put put = FavoredNodeAssignmentHelper.makePutFromRegionInfo(entry.getKey(), entry.getValue());
            if (put == null) continue;
            puts.add(put);
        }
        MetaTableAccessor.putsToMetaTable(connection, puts);
        LOG.info((Object)("Added " + puts.size() + " regions in META"));
    }

    public static void updateMetaWithFavoredNodesInfo(Map<HRegionInfo, List<ServerName>> regionToFavoredNodes, Configuration conf) throws IOException {
        ArrayList<Put> puts = new ArrayList<Put>();
        for (Map.Entry<HRegionInfo, List<ServerName>> entry : regionToFavoredNodes.entrySet()) {
            Put put = FavoredNodeAssignmentHelper.makePutFromRegionInfo(entry.getKey(), entry.getValue());
            if (put == null) continue;
            puts.add(put);
        }
        try (Connection connection = ConnectionFactory.createConnection(conf);
             Table metaTable = connection.getTable(TableName.META_TABLE_NAME);){
            metaTable.put(puts);
        }
        LOG.info((Object)("Added " + puts.size() + " regions in META"));
    }

    static Put makePutFromRegionInfo(HRegionInfo regionInfo, List<ServerName> favoredNodeList) throws IOException {
        Put put = null;
        if (favoredNodeList != null) {
            put = MetaTableAccessor.makePutFromRegionInfo(regionInfo);
            byte[] favoredNodes = FavoredNodeAssignmentHelper.getFavoredNodes(favoredNodeList);
            put.addImmutable(HConstants.CATALOG_FAMILY, FAVOREDNODES_QUALIFIER, EnvironmentEdgeManager.currentTime(), favoredNodes);
            LOG.debug((Object)("Create the region " + regionInfo.getRegionNameAsString() + " with favored nodes " + favoredNodeList));
        }
        return put;
    }

    public static ServerName[] getFavoredNodesList(byte[] favoredNodes) throws IOException {
        HBaseProtos.FavoredNodes f = HBaseProtos.FavoredNodes.parseFrom(favoredNodes);
        List<HBaseProtos.ServerName> protoNodes = f.getFavoredNodeList();
        ServerName[] servers = new ServerName[protoNodes.size()];
        int i = 0;
        for (HBaseProtos.ServerName node : protoNodes) {
            servers[i++] = ProtobufUtil.toServerName(node);
        }
        return servers;
    }

    public static byte[] getFavoredNodes(List<ServerName> serverAddrList) {
        HBaseProtos.FavoredNodes.Builder f = HBaseProtos.FavoredNodes.newBuilder();
        for (ServerName s : serverAddrList) {
            HBaseProtos.ServerName.Builder b = HBaseProtos.ServerName.newBuilder();
            b.setHostName(s.getHostname());
            b.setPort(s.getPort());
            b.setStartCode(-1L);
            f.addFavoredNode(b.build());
        }
        return f.build().toByteArray();
    }

    public void placePrimaryRSAsRoundRobin(Map<ServerName, List<HRegionInfo>> assignmentMap, Map<HRegionInfo, ServerName> primaryRSMap, List<HRegionInfo> regions) {
        ArrayList<String> rackList = new ArrayList<String>(this.rackToRegionServerMap.size());
        rackList.addAll(this.rackToRegionServerMap.keySet());
        int rackIndex = this.random.nextInt(rackList.size());
        int maxRackSize = 0;
        for (Map.Entry<String, List<ServerName>> r : this.rackToRegionServerMap.entrySet()) {
            if (r.getValue().size() <= maxRackSize) continue;
            maxRackSize = r.getValue().size();
        }
        int numIterations = 0;
        int serverIndex = this.random.nextInt(maxRackSize);
        for (HRegionInfo regionInfo : regions) {
            List<ServerName> currentServerList;
            while (true) {
                String rackName = (String)rackList.get(rackIndex);
                ++numIterations;
                currentServerList = this.rackToRegionServerMap.get(rackName);
                if (serverIndex < currentServerList.size()) break;
                if (numIterations % rackList.size() == 0 && ++serverIndex >= maxRackSize) {
                    serverIndex = 0;
                }
                if (++rackIndex < rackList.size()) continue;
                rackIndex = 0;
            }
            ServerName currentServer = currentServerList.get(serverIndex);
            primaryRSMap.put(regionInfo, currentServer);
            if (assignmentMap != null) {
                List<HRegionInfo> regionsForServer = assignmentMap.get(currentServer);
                if (regionsForServer == null) {
                    regionsForServer = new ArrayList<HRegionInfo>();
                    assignmentMap.put(currentServer, regionsForServer);
                }
                regionsForServer.add(regionInfo);
            }
            if (numIterations % rackList.size() == 0) {
                ++serverIndex;
            }
            if (++rackIndex < rackList.size()) continue;
            rackIndex = 0;
        }
    }

    public Map<HRegionInfo, ServerName[]> placeSecondaryAndTertiaryRS(Map<HRegionInfo, ServerName> primaryRSMap) {
        HashMap<HRegionInfo, ServerName[]> secondaryAndTertiaryMap = new HashMap<HRegionInfo, ServerName[]>();
        for (Map.Entry<HRegionInfo, ServerName> entry : primaryRSMap.entrySet()) {
            HRegionInfo regionInfo = entry.getKey();
            ServerName primaryRS = entry.getValue();
            try {
                ServerName[] favoredNodes = this.getSecondaryAndTertiary(regionInfo, primaryRS);
                if (favoredNodes == null) continue;
                secondaryAndTertiaryMap.put(regionInfo, favoredNodes);
                LOG.debug((Object)("Place the secondary and tertiary region server for region " + regionInfo.getRegionNameAsString()));
            }
            catch (Exception e) {
                LOG.warn((Object)("Cannot place the favored nodes for region " + regionInfo.getRegionNameAsString() + " because " + e), (Throwable)e);
            }
        }
        return secondaryAndTertiaryMap;
    }

    public ServerName[] getSecondaryAndTertiary(HRegionInfo regionInfo, ServerName primaryRS) throws IOException {
        String primaryRack = this.getRackOfServer(primaryRS);
        ServerName[] favoredNodes = this.getTotalNumberOfRacks() == 1 ? this.singleRackCase(regionInfo, primaryRS, primaryRack) : this.multiRackCase(regionInfo, primaryRS, primaryRack);
        return favoredNodes;
    }

    private Map<ServerName, Set<HRegionInfo>> mapRSToPrimaries(Map<HRegionInfo, ServerName> primaryRSMap) {
        HashMap<ServerName, Set<HRegionInfo>> primaryServerMap = new HashMap<ServerName, Set<HRegionInfo>>();
        for (Map.Entry<HRegionInfo, ServerName> e : primaryRSMap.entrySet()) {
            HashSet<HRegionInfo> currentSet = (HashSet<HRegionInfo>)primaryServerMap.get(e.getValue());
            if (currentSet == null) {
                currentSet = new HashSet<HRegionInfo>();
            }
            currentSet.add(e.getKey());
            primaryServerMap.put(e.getValue(), currentSet);
        }
        return primaryServerMap;
    }

    public Map<HRegionInfo, ServerName[]> placeSecondaryAndTertiaryWithRestrictions(Map<HRegionInfo, ServerName> primaryRSMap) {
        Map<ServerName, Set<HRegionInfo>> serverToPrimaries = this.mapRSToPrimaries(primaryRSMap);
        HashMap<HRegionInfo, ServerName[]> secondaryAndTertiaryMap = new HashMap<HRegionInfo, ServerName[]>();
        for (Map.Entry<HRegionInfo, ServerName> entry : primaryRSMap.entrySet()) {
            HRegionInfo regionInfo = entry.getKey();
            ServerName primaryRS = entry.getValue();
            try {
                String primaryRack = this.getRackOfServer(primaryRS);
                ServerName[] favoredNodes = null;
                favoredNodes = this.getTotalNumberOfRacks() == 1 ? this.singleRackCase(regionInfo, primaryRS, primaryRack) : this.multiRackCaseWithRestrictions(serverToPrimaries, secondaryAndTertiaryMap, primaryRack, primaryRS, regionInfo);
                if (favoredNodes == null) continue;
                secondaryAndTertiaryMap.put(regionInfo, favoredNodes);
                LOG.debug((Object)("Place the secondary and tertiary region server for region " + regionInfo.getRegionNameAsString()));
            }
            catch (Exception e) {
                LOG.warn((Object)("Cannot place the favored nodes for region " + regionInfo.getRegionNameAsString() + " because " + e), (Throwable)e);
            }
        }
        return secondaryAndTertiaryMap;
    }

    private ServerName[] multiRackCaseWithRestrictions(Map<ServerName, Set<HRegionInfo>> serverToPrimaries, Map<HRegionInfo, ServerName[]> secondaryAndTertiaryMap, String primaryRack, ServerName primaryRS, HRegionInfo regionInfo) throws IOException {
        ServerName[] favoredNodes;
        HashSet<String> rackSkipSet = new HashSet<String>();
        rackSkipSet.add(primaryRack);
        String secondaryRack = this.getOneRandomRack(rackSkipSet);
        List<ServerName> serverList = this.getServersFromRack(secondaryRack);
        HashSet<ServerName> serverSet = new HashSet<ServerName>();
        serverSet.addAll(serverList);
        if (serverList.size() >= 2) {
            Set<HRegionInfo> primaries = serverToPrimaries.get(primaryRS);
            HashSet<ServerName> skipServerSet = new HashSet<ServerName>();
            while (true) {
                ServerName[] secondaryAndTertiary = null;
                if (primaries.size() > 1) {
                    for (HRegionInfo primary : primaries) {
                        secondaryAndTertiary = secondaryAndTertiaryMap.get(primary);
                        if (secondaryAndTertiary == null) continue;
                        if (this.getRackOfServer(secondaryAndTertiary[0]).equals(secondaryRack)) {
                            skipServerSet.add(secondaryAndTertiary[0]);
                        }
                        if (!this.getRackOfServer(secondaryAndTertiary[1]).equals(secondaryRack)) continue;
                        skipServerSet.add(secondaryAndTertiary[1]);
                    }
                }
                if (skipServerSet.size() + 2 <= serverSet.size()) break;
                skipServerSet.clear();
                rackSkipSet.add(secondaryRack);
                if (rackSkipSet.size() == this.getTotalNumberOfRacks()) {
                    skipServerSet.remove(secondaryAndTertiary[0]);
                    skipServerSet.remove(secondaryAndTertiary[1]);
                    break;
                }
                secondaryRack = this.getOneRandomRack(rackSkipSet);
                serverList = this.getServersFromRack(secondaryRack);
                serverSet = new HashSet();
                serverSet.addAll(serverList);
            }
            ServerName secondaryRS = this.getOneRandomServer(secondaryRack, skipServerSet);
            skipServerSet.add(secondaryRS);
            ServerName tertiaryRS = this.getOneRandomServer(secondaryRack, skipServerSet);
            if (secondaryRS == null || tertiaryRS == null) {
                LOG.error((Object)("Cannot place the secondary and tertiary region server for region " + regionInfo.getRegionNameAsString()));
            }
            favoredNodes = new ServerName[]{secondaryRS, tertiaryRS};
        } else {
            ServerName secondary;
            favoredNodes = new ServerName[2];
            favoredNodes[0] = secondary = this.getOneRandomServer(secondaryRack);
            if (this.getTotalNumberOfRacks() == 2) {
                HashSet<ServerName> serverSkipSet = new HashSet<ServerName>();
                serverSkipSet.add(primaryRS);
                favoredNodes[1] = this.getOneRandomServer(primaryRack, serverSkipSet);
            } else {
                rackSkipSet.add(secondaryRack);
                String tertiaryRandomRack = this.getOneRandomRack(rackSkipSet);
                favoredNodes[1] = this.getOneRandomServer(tertiaryRandomRack);
            }
        }
        return favoredNodes;
    }

    private ServerName[] singleRackCase(HRegionInfo regionInfo, ServerName primaryRS, String primaryRack) throws IOException {
        List<ServerName> serverList = this.getServersFromRack(primaryRack);
        if (serverList == null || serverList.size() <= 2) {
            return null;
        }
        HashSet<ServerName> serverSkipSet = new HashSet<ServerName>();
        serverSkipSet.add(primaryRS);
        ServerName secondaryRS = this.getOneRandomServer(primaryRack, serverSkipSet);
        serverSkipSet.add(secondaryRS);
        ServerName tertiaryRS = this.getOneRandomServer(primaryRack, serverSkipSet);
        if (secondaryRS == null || tertiaryRS == null) {
            LOG.error((Object)("Cannot place the secondary, tertiary favored node for region " + regionInfo.getRegionNameAsString()));
        }
        ServerName[] favoredNodes = new ServerName[]{secondaryRS, tertiaryRS};
        return favoredNodes;
    }

    private ServerName[] multiRackCase(HRegionInfo regionInfo, ServerName primaryRS, String primaryRack) throws IOException {
        ServerName tertiaryRS;
        ArrayList<ServerName> favoredNodes = Lists.newArrayList(primaryRS);
        ServerName secondaryRS = this.generateMissingFavoredNodeMultiRack(favoredNodes);
        favoredNodes.add(secondaryRS);
        String secondaryRack = this.getRackOfServer(secondaryRS);
        if (primaryRack.equals(secondaryRack)) {
            tertiaryRS = this.generateMissingFavoredNode(favoredNodes);
        } else {
            tertiaryRS = this.getOneRandomServer(secondaryRack, Sets.newHashSet(secondaryRS));
            if (tertiaryRS == null) {
                tertiaryRS = this.getOneRandomServer(primaryRack, Sets.newHashSet(primaryRS));
            }
            if (tertiaryRS == null) {
                tertiaryRS = this.generateMissingFavoredNode(Lists.newArrayList(primaryRS, secondaryRS));
            }
        }
        return new ServerName[]{secondaryRS, tertiaryRS};
    }

    public boolean canPlaceFavoredNodes() {
        return this.servers.size() >= 3;
    }

    private int getTotalNumberOfRacks() {
        return this.uniqueRackList.size();
    }

    private List<ServerName> getServersFromRack(String rack) {
        return this.rackToRegionServerMap.get(rack);
    }

    protected ServerName getOneRandomServer(String rack, Set<ServerName> skipServerSet) {
        if (rack == null || this.getServersFromRack(rack) == null || this.getServersFromRack(rack).isEmpty()) {
            return null;
        }
        HashSet<StartcodeAgnosticServerName> serversToChooseFrom = Sets.newHashSet();
        for (ServerName sn : this.getServersFromRack(rack)) {
            serversToChooseFrom.add(StartcodeAgnosticServerName.valueOf(sn));
        }
        if (skipServerSet != null && skipServerSet.size() > 0) {
            for (ServerName sn : skipServerSet) {
                serversToChooseFrom.remove(StartcodeAgnosticServerName.valueOf(sn));
            }
            if (serversToChooseFrom.isEmpty()) {
                return null;
            }
        }
        ServerName randomServer = null;
        int randomIndex = this.random.nextInt(serversToChooseFrom.size());
        int j = 0;
        for (StartcodeAgnosticServerName sn : serversToChooseFrom) {
            if (j == randomIndex) {
                randomServer = sn;
                break;
            }
            ++j;
        }
        if (randomServer != null) {
            return ServerName.valueOf(randomServer.getHostAndPort(), randomServer.getStartcode());
        }
        return null;
    }

    private ServerName getOneRandomServer(String rack) throws IOException {
        return this.getOneRandomServer(rack, null);
    }

    protected String getOneRandomRack(Set<String> skipRackSet) throws IOException {
        int randomIndex;
        String randomRack;
        if (skipRackSet == null || this.uniqueRackList.size() <= skipRackSet.size()) {
            throw new IOException("Cannot randomly pick another random server");
        }
        while (skipRackSet.contains(randomRack = this.uniqueRackList.get(randomIndex = this.random.nextInt(this.uniqueRackList.size())))) {
        }
        return randomRack;
    }

    public static String getFavoredNodesAsString(List<ServerName> nodes) {
        StringBuffer strBuf = new StringBuffer();
        int i = 0;
        for (ServerName node : nodes) {
            strBuf.append(node.getHostAndPort());
            if (++i == nodes.size()) continue;
            strBuf.append(";");
        }
        return strBuf.toString();
    }

    public ServerName generateMissingFavoredNode(List<ServerName> favoredNodes) throws IOException {
        if (this.uniqueRackList.size() == 1) {
            return this.generateMissingFavoredNodeSingleRack(favoredNodes, null);
        }
        return this.generateMissingFavoredNodeMultiRack(favoredNodes, null);
    }

    public ServerName generateMissingFavoredNode(List<ServerName> favoredNodes, List<ServerName> excludeNodes) throws IOException {
        if (this.uniqueRackList.size() == 1) {
            return this.generateMissingFavoredNodeSingleRack(favoredNodes, excludeNodes);
        }
        return this.generateMissingFavoredNodeMultiRack(favoredNodes, excludeNodes);
    }

    private ServerName generateMissingFavoredNodeSingleRack(List<ServerName> favoredNodes, List<ServerName> excludeNodes) throws IOException {
        ServerName newServer = null;
        HashSet<ServerName> excludeFNSet = Sets.newHashSet(favoredNodes);
        if (excludeNodes != null && excludeNodes.size() > 0) {
            excludeFNSet.addAll(excludeNodes);
        }
        if (favoredNodes.size() < 3) {
            newServer = this.getOneRandomServer(this.uniqueRackList.get(0), excludeFNSet);
        }
        return newServer;
    }

    private ServerName generateMissingFavoredNodeMultiRack(List<ServerName> favoredNodes) throws IOException {
        return this.generateMissingFavoredNodeMultiRack(favoredNodes, null);
    }

    private ServerName generateMissingFavoredNodeMultiRack(List<ServerName> favoredNodes, List<ServerName> excludeNodes) throws IOException {
        HashSet<String> racks = Sets.newHashSet();
        HashMap<String, HashSet<ServerName>> rackToFNMapping = new HashMap<String, HashSet<ServerName>>();
        for (ServerName serverName : favoredNodes) {
            String rack = this.getRackOfServer(serverName);
            racks.add(rack);
            HashSet<ServerName> serversInRack = (HashSet<ServerName>)rackToFNMapping.get(rack);
            if (serversInRack == null) {
                serversInRack = Sets.newHashSet();
                rackToFNMapping.put(rack, serversInRack);
            }
            serversInRack.add(serverName);
        }
        HashSet<String> skipRackSet = Sets.newHashSet();
        if (racks.size() == 1 && favoredNodes.size() > 1) {
            skipRackSet.add((String)racks.iterator().next());
        }
        for (String rack : racks) {
            if (this.getServersFromRack(rack) == null || ((Set)rackToFNMapping.get(rack)).size() != this.getServersFromRack(rack).size()) continue;
            skipRackSet.add(rack);
        }
        HashSet<ServerName> hashSet = Sets.newHashSet(favoredNodes);
        if (excludeNodes != null && excludeNodes.size() > 0) {
            hashSet.addAll(excludeNodes);
        }
        int i = 0;
        HashSet<String> randomRacks = Sets.newHashSet();
        ServerName newServer = null;
        do {
            String randomRack = this.getOneRandomRack(skipRackSet);
            newServer = this.getOneRandomServer(randomRack, hashSet);
            randomRacks.add(randomRack);
        } while (++i < 10 && newServer == null);
        if (newServer == null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)String.format("Unable to generate additional favored nodes for %s after considering racks %s and skip rack %s with a unique rack list of %s and rack to RS map of %s and RS to rack map of %s", StringUtils.join(favoredNodes, ","), randomRacks, skipRackSet, this.uniqueRackList, this.rackToRegionServerMap, this.regionServerToRackMap));
            }
            throw new IOException(" Unable to generate additional favored nodes for " + StringUtils.join(favoredNodes, ","));
        }
        return newServer;
    }

    public List<ServerName> generateFavoredNodes(HRegionInfo hri) throws IOException {
        ArrayList<ServerName> favoredNodesForRegion = new ArrayList<ServerName>(3);
        ServerName primary = this.servers.get(this.random.nextInt(this.servers.size()));
        favoredNodesForRegion.add(ServerName.valueOf(primary.getHostAndPort(), -1L));
        HashMap<HRegionInfo, ServerName> primaryRSMap = new HashMap<HRegionInfo, ServerName>(1);
        primaryRSMap.put(hri, primary);
        Map<HRegionInfo, ServerName[]> secondaryAndTertiaryRSMap = this.placeSecondaryAndTertiaryRS(primaryRSMap);
        ServerName[] secondaryAndTertiaryNodes = secondaryAndTertiaryRSMap.get(hri);
        if (secondaryAndTertiaryNodes != null && secondaryAndTertiaryNodes.length == 2) {
            for (ServerName sn : secondaryAndTertiaryNodes) {
                favoredNodesForRegion.add(ServerName.valueOf(sn.getHostAndPort(), -1L));
            }
            return favoredNodesForRegion;
        }
        throw new HBaseIOException("Unable to generate secondary and tertiary favored nodes.");
    }

    public Map<HRegionInfo, List<ServerName>> generateFavoredNodesRoundRobin(Map<ServerName, List<HRegionInfo>> assignmentMap, List<HRegionInfo> regions) throws IOException {
        if (regions.size() > 0) {
            if (this.canPlaceFavoredNodes()) {
                HashMap<HRegionInfo, ServerName> primaryRSMap = new HashMap<HRegionInfo, ServerName>();
                this.placePrimaryRSAsRoundRobin(assignmentMap, primaryRSMap, regions);
                return this.generateFavoredNodes(primaryRSMap);
            }
            throw new HBaseIOException("Not enough nodes to generate favored nodes");
        }
        return null;
    }

    private Map<HRegionInfo, List<ServerName>> generateFavoredNodes(Map<HRegionInfo, ServerName> primaryRSMap) {
        HashMap<HRegionInfo, List<ServerName>> generatedFavNodes = new HashMap<HRegionInfo, List<ServerName>>();
        Map<HRegionInfo, ServerName[]> secondaryAndTertiaryRSMap = this.placeSecondaryAndTertiaryRS(primaryRSMap);
        for (Map.Entry<HRegionInfo, ServerName> entry : primaryRSMap.entrySet()) {
            ArrayList<ServerName> favoredNodesForRegion = new ArrayList<ServerName>(3);
            HRegionInfo region = entry.getKey();
            ServerName primarySN = entry.getValue();
            favoredNodesForRegion.add(ServerName.valueOf(primarySN.getHostname(), primarySN.getPort(), -1L));
            ServerName[] secondaryAndTertiaryNodes = secondaryAndTertiaryRSMap.get(region);
            if (secondaryAndTertiaryNodes != null) {
                favoredNodesForRegion.add(ServerName.valueOf(secondaryAndTertiaryNodes[0].getHostname(), secondaryAndTertiaryNodes[0].getPort(), -1L));
                favoredNodesForRegion.add(ServerName.valueOf(secondaryAndTertiaryNodes[1].getHostname(), secondaryAndTertiaryNodes[1].getPort(), -1L));
            }
            generatedFavNodes.put(region, favoredNodesForRegion);
        }
        return generatedFavNodes;
    }

    private String getRackOfServer(ServerName sn) {
        if (this.regionServerToRackMap.containsKey(sn.getHostname())) {
            return this.regionServerToRackMap.get(sn.getHostname());
        }
        String rack = this.rackManager.getRack(sn);
        this.regionServerToRackMap.put(sn.getHostname(), rack);
        return rack;
    }
}

