/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.favored;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.favored.FavoredNodeAssignmentHelper;
import org.apache.hadoop.hbase.favored.FavoredNodesPlan;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.RackManager;
import org.apache.hadoop.hbase.master.SnapshotOfRegionAssignmentFromMeta;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.Lists;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.Maps;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.Sets;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.net.NetUtils;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class FavoredNodesManager {
    private static final Log LOG = LogFactory.getLog(FavoredNodesManager.class);
    private FavoredNodesPlan globalFavoredNodesAssignmentPlan;
    private Map<ServerName, List<HRegionInfo>> primaryRSToRegionMap;
    private Map<ServerName, List<HRegionInfo>> secondaryRSToRegionMap;
    private Map<ServerName, List<HRegionInfo>> teritiaryRSToRegionMap;
    private MasterServices masterServices;
    private RackManager rackManager;
    private int datanodeDataTransferPort;

    public FavoredNodesManager(MasterServices masterServices) {
        this.masterServices = masterServices;
        this.globalFavoredNodesAssignmentPlan = new FavoredNodesPlan();
        this.primaryRSToRegionMap = new HashMap<ServerName, List<HRegionInfo>>();
        this.secondaryRSToRegionMap = new HashMap<ServerName, List<HRegionInfo>>();
        this.teritiaryRSToRegionMap = new HashMap<ServerName, List<HRegionInfo>>();
        this.rackManager = new RackManager(masterServices.getConfiguration());
    }

    public void initialize(SnapshotOfRegionAssignmentFromMeta snapshotOfRegionAssignment) throws HBaseIOException {
        this.globalFavoredNodesAssignmentPlan = snapshotOfRegionAssignment.getExistingAssignmentPlan();
        this.primaryRSToRegionMap = snapshotOfRegionAssignment.getPrimaryToRegionInfoMap();
        this.secondaryRSToRegionMap = snapshotOfRegionAssignment.getSecondaryToRegionInfoMap();
        this.teritiaryRSToRegionMap = snapshotOfRegionAssignment.getTertiaryToRegionInfoMap();
        this.datanodeDataTransferPort = this.getDataNodePort();
    }

    public int getDataNodePort() {
        HdfsConfiguration.init();
        HdfsConfiguration dnConf = new HdfsConfiguration(this.masterServices.getConfiguration());
        int dnPort = NetUtils.createSocketAddr(dnConf.get("dfs.datanode.address", "0.0.0.0:50010")).getPort();
        LOG.debug((Object)("Loaded default datanode port for FN: " + this.datanodeDataTransferPort));
        return dnPort;
    }

    public synchronized List<ServerName> getFavoredNodes(HRegionInfo regionInfo) {
        return this.globalFavoredNodesAssignmentPlan.getFavoredNodes(regionInfo);
    }

    public static boolean isFavoredNodeApplicable(HRegionInfo regionInfo) {
        return !regionInfo.isSystemTable();
    }

    public static Set<HRegionInfo> filterNonFNApplicableRegions(Collection<HRegionInfo> regions) {
        HashSet<HRegionInfo> fnRegions = Sets.newHashSet();
        for (HRegionInfo regionInfo : regions) {
            if (FavoredNodesManager.isFavoredNodeApplicable(regionInfo)) continue;
            fnRegions.add(regionInfo);
        }
        return fnRegions;
    }

    public synchronized List<ServerName> getFavoredNodesWithDNPort(HRegionInfo regionInfo) {
        if (this.getFavoredNodes(regionInfo) == null) {
            return null;
        }
        ArrayList<ServerName> fnWithDNPort = Lists.newArrayList();
        for (ServerName sn : this.getFavoredNodes(regionInfo)) {
            fnWithDNPort.add(ServerName.valueOf(sn.getHostname(), this.datanodeDataTransferPort, -1L));
        }
        return fnWithDNPort;
    }

    public synchronized void updateFavoredNodes(Map<HRegionInfo, List<ServerName>> regionFNMap) throws IOException {
        HRegionInfo regionInfo;
        HashMap<HRegionInfo, List<ServerName>> regionToFavoredNodes = new HashMap<HRegionInfo, List<ServerName>>();
        for (Map.Entry<HRegionInfo, List<ServerName>> entry : regionFNMap.entrySet()) {
            regionInfo = entry.getKey();
            List<ServerName> servers = entry.getValue();
            if (servers.size() != Sets.newHashSet(servers).size()) {
                throw new IOException("Duplicates found: " + servers);
            }
            if (!FavoredNodesManager.isFavoredNodeApplicable(regionInfo)) {
                throw new IOException("Can't update FN for a un-applicable region: " + regionInfo.getRegionNameAsString() + " with " + servers);
            }
            if (servers.size() != 3) {
                throw new IOException("At least 3 favored nodes should be present for region : " + regionInfo.getEncodedName() + " current FN servers:" + servers);
            }
            ArrayList<ServerName> serversWithNoStartCodes = Lists.newArrayList();
            for (ServerName sn : servers) {
                if (sn.getStartcode() == -1L) {
                    serversWithNoStartCodes.add(sn);
                    continue;
                }
                serversWithNoStartCodes.add(ServerName.valueOf(sn.getHostname(), sn.getPort(), -1L));
            }
            regionToFavoredNodes.put(regionInfo, serversWithNoStartCodes);
        }
        FavoredNodeAssignmentHelper.updateMetaWithFavoredNodesInfo(regionToFavoredNodes, this.masterServices.getConnection());
        this.deleteFavoredNodesForRegions(regionToFavoredNodes.keySet());
        for (Map.Entry<HRegionInfo, List<ServerName>> entry : regionToFavoredNodes.entrySet()) {
            regionInfo = entry.getKey();
            List<ServerName> serversWithNoStartCodes = entry.getValue();
            this.globalFavoredNodesAssignmentPlan.updateFavoredNodesMap(regionInfo, serversWithNoStartCodes);
            this.addToReplicaLoad(regionInfo, serversWithNoStartCodes);
        }
    }

    private synchronized void addToReplicaLoad(HRegionInfo hri, List<ServerName> servers) {
        ServerName serverToUse = ServerName.valueOf(servers.get(FavoredNodesPlan.Position.PRIMARY.ordinal()).getHostAndPort(), -1L);
        List<HRegionInfo> regionList = this.primaryRSToRegionMap.get(serverToUse);
        if (regionList == null) {
            regionList = new ArrayList<HRegionInfo>();
        }
        regionList.add(hri);
        this.primaryRSToRegionMap.put(serverToUse, regionList);
        serverToUse = ServerName.valueOf(servers.get(FavoredNodesPlan.Position.SECONDARY.ordinal()).getHostAndPort(), -1L);
        regionList = this.secondaryRSToRegionMap.get(serverToUse);
        if (regionList == null) {
            regionList = new ArrayList<HRegionInfo>();
        }
        regionList.add(hri);
        this.secondaryRSToRegionMap.put(serverToUse, regionList);
        serverToUse = ServerName.valueOf(servers.get(FavoredNodesPlan.Position.TERTIARY.ordinal()).getHostAndPort(), -1L);
        regionList = this.teritiaryRSToRegionMap.get(serverToUse);
        if (regionList == null) {
            regionList = new ArrayList<HRegionInfo>();
        }
        regionList.add(hri);
        this.teritiaryRSToRegionMap.put(serverToUse, regionList);
    }

    public synchronized Map<ServerName, List<Integer>> getReplicaLoad(List<ServerName> servers) {
        HashMap<ServerName, List<Integer>> result = Maps.newHashMap();
        for (ServerName sn : servers) {
            ServerName serverWithNoStartCode = ServerName.valueOf(sn.getHostAndPort(), -1L);
            ArrayList<Integer> countList = Lists.newArrayList();
            if (this.primaryRSToRegionMap.containsKey(serverWithNoStartCode)) {
                countList.add(this.primaryRSToRegionMap.get(serverWithNoStartCode).size());
            } else {
                countList.add(0);
            }
            if (this.secondaryRSToRegionMap.containsKey(serverWithNoStartCode)) {
                countList.add(this.secondaryRSToRegionMap.get(serverWithNoStartCode).size());
            } else {
                countList.add(0);
            }
            if (this.teritiaryRSToRegionMap.containsKey(serverWithNoStartCode)) {
                countList.add(this.teritiaryRSToRegionMap.get(serverWithNoStartCode).size());
            } else {
                countList.add(0);
            }
            result.put(sn, countList);
        }
        return result;
    }

    public synchronized void deleteFavoredNodesForRegions(Collection<HRegionInfo> regionInfoList) {
        for (HRegionInfo hri : regionInfoList) {
            List<ServerName> favNodes = this.getFavoredNodes(hri);
            if (favNodes == null) continue;
            if (this.primaryRSToRegionMap.containsKey(favNodes.get(FavoredNodesPlan.Position.PRIMARY.ordinal()))) {
                this.primaryRSToRegionMap.get(favNodes.get(FavoredNodesPlan.Position.PRIMARY.ordinal())).remove(hri);
            }
            if (this.secondaryRSToRegionMap.containsKey(favNodes.get(FavoredNodesPlan.Position.SECONDARY.ordinal()))) {
                this.secondaryRSToRegionMap.get(favNodes.get(FavoredNodesPlan.Position.SECONDARY.ordinal())).remove(hri);
            }
            if (this.teritiaryRSToRegionMap.containsKey(favNodes.get(FavoredNodesPlan.Position.TERTIARY.ordinal()))) {
                this.teritiaryRSToRegionMap.get(favNodes.get(FavoredNodesPlan.Position.TERTIARY.ordinal())).remove(hri);
            }
            this.globalFavoredNodesAssignmentPlan.removeFavoredNodes(hri);
        }
    }

    public RackManager getRackManager() {
        return this.rackManager;
    }
}

