/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.hbase.ByteBufferCell;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.filter.ParseFilter;
import org.apache.hadoop.hbase.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.UnsafeByteOperations;
import org.apache.hadoop.hbase.shaded.protobuf.generated.FilterProtos;
import org.apache.hadoop.hbase.util.ByteBufferUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class ColumnPrefixFilter
extends FilterBase {
    protected byte[] prefix = null;

    public ColumnPrefixFilter(byte[] prefix) {
        this.prefix = prefix;
    }

    public byte[] getPrefix() {
        return this.prefix;
    }

    @Override
    public boolean filterRowKey(Cell cell) throws IOException {
        return false;
    }

    @Override
    public Filter.ReturnCode filterKeyValue(Cell cell) {
        if (this.prefix == null) {
            return Filter.ReturnCode.INCLUDE;
        }
        return this.filterColumn(cell);
    }

    public Filter.ReturnCode filterColumn(Cell cell) {
        int qualifierLength = cell.getQualifierLength();
        if (qualifierLength < this.prefix.length) {
            int cmp = ColumnPrefixFilter.compareQualifierPart(cell, qualifierLength, this.prefix);
            if (cmp <= 0) {
                return Filter.ReturnCode.SEEK_NEXT_USING_HINT;
            }
            return Filter.ReturnCode.NEXT_ROW;
        }
        int cmp = ColumnPrefixFilter.compareQualifierPart(cell, this.prefix.length, this.prefix);
        if (cmp < 0) {
            return Filter.ReturnCode.SEEK_NEXT_USING_HINT;
        }
        if (cmp > 0) {
            return Filter.ReturnCode.NEXT_ROW;
        }
        return Filter.ReturnCode.INCLUDE;
    }

    private static int compareQualifierPart(Cell cell, int length, byte[] prefix) {
        if (cell instanceof ByteBufferCell) {
            return ByteBufferUtils.compareTo(((ByteBufferCell)cell).getQualifierByteBuffer(), ((ByteBufferCell)cell).getQualifierPosition(), length, prefix, 0, length);
        }
        return Bytes.compareTo(cell.getQualifierArray(), cell.getQualifierOffset(), length, prefix, 0, length);
    }

    public static Filter createFilterFromArguments(ArrayList<byte[]> filterArguments) {
        Preconditions.checkArgument(filterArguments.size() == 1, "Expected 1 but got: %s", filterArguments.size());
        byte[] columnPrefix = ParseFilter.removeQuotesFromByteArray(filterArguments.get(0));
        return new ColumnPrefixFilter(columnPrefix);
    }

    @Override
    public byte[] toByteArray() {
        FilterProtos.ColumnPrefixFilter.Builder builder = FilterProtos.ColumnPrefixFilter.newBuilder();
        if (this.prefix != null) {
            builder.setPrefix(UnsafeByteOperations.unsafeWrap(this.prefix));
        }
        return builder.build().toByteArray();
    }

    public static ColumnPrefixFilter parseFrom(byte[] pbBytes) throws DeserializationException {
        FilterProtos.ColumnPrefixFilter proto;
        try {
            proto = FilterProtos.ColumnPrefixFilter.parseFrom(pbBytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new DeserializationException(e);
        }
        return new ColumnPrefixFilter(proto.getPrefix().toByteArray());
    }

    @Override
    boolean areSerializedFieldsEqual(Filter o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ColumnPrefixFilter)) {
            return false;
        }
        ColumnPrefixFilter other = (ColumnPrefixFilter)o;
        return Bytes.equals(this.getPrefix(), other.getPrefix());
    }

    @Override
    public Cell getNextCellHint(Cell cell) {
        return CellUtil.createFirstOnRowCol(cell, this.prefix, 0, this.prefix.length);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " " + Bytes.toStringBinary(this.prefix);
    }
}

