/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.util.Locale;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ComparatorProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class SubstringComparator
extends ByteArrayComparable {
    private String substr;

    public SubstringComparator(String substr) {
        super(Bytes.toBytes(substr.toLowerCase(Locale.ROOT)));
        this.substr = substr.toLowerCase(Locale.ROOT);
    }

    @Override
    public byte[] getValue() {
        return Bytes.toBytes(this.substr);
    }

    @Override
    public int compareTo(byte[] value, int offset, int length) {
        return Bytes.toString(value, offset, length).toLowerCase(Locale.ROOT).contains(this.substr) ? 0 : 1;
    }

    @Override
    public byte[] toByteArray() {
        ComparatorProtos.SubstringComparator.Builder builder = ComparatorProtos.SubstringComparator.newBuilder();
        builder.setSubstr(this.substr);
        return builder.build().toByteArray();
    }

    public static SubstringComparator parseFrom(byte[] pbBytes) throws DeserializationException {
        ComparatorProtos.SubstringComparator proto;
        try {
            proto = ComparatorProtos.SubstringComparator.parseFrom(pbBytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new DeserializationException(e);
        }
        return new SubstringComparator(proto.getSubstr());
    }

    @Override
    boolean areSerializedFieldsEqual(ByteArrayComparable other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof SubstringComparator)) {
            return false;
        }
        SubstringComparator comparator = (SubstringComparator)other;
        return super.areSerializedFieldsEqual(comparator) && this.substr.equals(comparator.substr);
    }
}

