/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.hbase.ByteBufferKeyOnlyKeyValue;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.HeapSize;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.hfile.BlockCacheKey;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.io.hfile.BlockWithScanInfo;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileBlock;
import org.apache.hadoop.hbase.io.hfile.InlineBlockWriter;
import org.apache.hadoop.hbase.nio.ByteBuff;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ClassSize;
import org.apache.hadoop.hbase.util.ObjectIntPair;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class HFileBlockIndex {
    private static final Log LOG = LogFactory.getLog(HFileBlockIndex.class);
    static final int DEFAULT_MAX_CHUNK_SIZE = 131072;
    public static final String MAX_CHUNK_SIZE_KEY = "hfile.index.block.max.size";
    public static final String MIN_INDEX_NUM_ENTRIES_KEY = "hfile.index.block.min.entries";
    static final int DEFAULT_MIN_INDEX_NUM_ENTRIES = 16;
    static final int SECONDARY_INDEX_ENTRY_OVERHEAD = 12;
    private static final String INLINE_BLOCKS_NOT_ALLOWED = "Inline blocks are not allowed in the single-level-only mode";
    private static final int MID_KEY_METADATA_SIZE = 16;

    public static int getMaxChunkSize(Configuration conf) {
        return conf.getInt(MAX_CHUNK_SIZE_KEY, 131072);
    }

    public static int getMinIndexNumEntries(Configuration conf) {
        return conf.getInt(MIN_INDEX_NUM_ENTRIES_KEY, 16);
    }

    static class BlockIndexChunk {
        private final List<byte[]> blockKeys = new ArrayList<byte[]>();
        private final List<Long> blockOffsets = new ArrayList<Long>();
        private final List<Integer> onDiskDataSizes = new ArrayList<Integer>();
        private final List<Long> numSubEntriesAt = new ArrayList<Long>();
        private int curTotalNonRootEntrySize = 0;
        private int curTotalRootSize = 0;
        private final List<Integer> secondaryIndexOffsetMarks = new ArrayList<Integer>();

        BlockIndexChunk() {
        }

        void add(byte[] firstKey, long blockOffset, int onDiskDataSize, long curTotalNumSubEntries) {
            this.secondaryIndexOffsetMarks.add(this.curTotalNonRootEntrySize);
            this.curTotalNonRootEntrySize += 12 + firstKey.length;
            this.curTotalRootSize += 12 + WritableUtils.getVIntSize(firstKey.length) + firstKey.length;
            this.blockKeys.add(firstKey);
            this.blockOffsets.add(blockOffset);
            this.onDiskDataSizes.add(onDiskDataSize);
            if (curTotalNumSubEntries != -1L) {
                this.numSubEntriesAt.add(curTotalNumSubEntries);
                if (this.numSubEntriesAt.size() != this.blockKeys.size()) {
                    throw new IllegalStateException("Only have key/value count stats for " + this.numSubEntriesAt.size() + " block index entries out of " + this.blockKeys.size());
                }
            }
        }

        public void add(byte[] firstKey, long blockOffset, int onDiskDataSize) {
            this.add(firstKey, blockOffset, onDiskDataSize, -1L);
        }

        public void clear() {
            this.blockKeys.clear();
            this.blockOffsets.clear();
            this.onDiskDataSizes.clear();
            this.secondaryIndexOffsetMarks.clear();
            this.numSubEntriesAt.clear();
            this.curTotalNonRootEntrySize = 0;
            this.curTotalRootSize = 0;
        }

        public int getEntryBySubEntry(long k) {
            int i = Collections.binarySearch(this.numSubEntriesAt, k);
            if (i >= 0) {
                return i + 1;
            }
            return -i - 1;
        }

        public byte[] getMidKeyMetadata() throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(16);
            DataOutputStream baosDos = new DataOutputStream(baos);
            long totalNumSubEntries = this.numSubEntriesAt.get(this.blockKeys.size() - 1);
            if (totalNumSubEntries == 0L) {
                throw new IOException("No leaf-level entries, mid-key unavailable");
            }
            long midKeySubEntry = (totalNumSubEntries - 1L) / 2L;
            int midKeyEntry = this.getEntryBySubEntry(midKeySubEntry);
            baosDos.writeLong(this.blockOffsets.get(midKeyEntry));
            baosDos.writeInt(this.onDiskDataSizes.get(midKeyEntry));
            long numSubEntriesBefore = midKeyEntry > 0 ? this.numSubEntriesAt.get(midKeyEntry - 1) : 0L;
            long subEntryWithinEntry = midKeySubEntry - numSubEntriesBefore;
            if (subEntryWithinEntry < 0L || subEntryWithinEntry > Integer.MAX_VALUE) {
                throw new IOException("Could not identify mid-key index within the leaf-level block containing mid-key: out of range (" + subEntryWithinEntry + ", numSubEntriesBefore=" + numSubEntriesBefore + ", midKeySubEntry=" + midKeySubEntry + ")");
            }
            baosDos.writeInt((int)subEntryWithinEntry);
            if (baosDos.size() != 16) {
                throw new IOException("Could not write mid-key metadata: size=" + baosDos.size() + ", correct size: " + 16);
            }
            baos.close();
            return baos.toByteArray();
        }

        void writeNonRoot(DataOutput out) throws IOException {
            out.writeInt(this.blockKeys.size());
            if (this.secondaryIndexOffsetMarks.size() != this.blockKeys.size()) {
                throw new IOException("Corrupted block index chunk writer: " + this.blockKeys.size() + " entries but " + this.secondaryIndexOffsetMarks.size() + " secondary index items");
            }
            for (int currentSecondaryIndex : this.secondaryIndexOffsetMarks) {
                out.writeInt(currentSecondaryIndex);
            }
            out.writeInt(this.curTotalNonRootEntrySize);
            for (int i = 0; i < this.blockKeys.size(); ++i) {
                out.writeLong(this.blockOffsets.get(i));
                out.writeInt(this.onDiskDataSizes.get(i));
                out.write(this.blockKeys.get(i));
            }
        }

        int getNonRootSize() {
            return 4 + 4 * (this.blockKeys.size() + 1) + this.curTotalNonRootEntrySize;
        }

        void writeRoot(DataOutput out) throws IOException {
            for (int i = 0; i < this.blockKeys.size(); ++i) {
                out.writeLong(this.blockOffsets.get(i));
                out.writeInt(this.onDiskDataSizes.get(i));
                Bytes.writeByteArray(out, this.blockKeys.get(i));
            }
        }

        int getRootSize() {
            return this.curTotalRootSize;
        }

        public int getNumEntries() {
            return this.blockKeys.size();
        }

        public byte[] getBlockKey(int i) {
            return this.blockKeys.get(i);
        }

        public long getBlockOffset(int i) {
            return this.blockOffsets.get(i);
        }

        public int getOnDiskDataSize(int i) {
            return this.onDiskDataSizes.get(i);
        }

        public long getCumulativeNumKV(int i) {
            if (i < 0) {
                return 0L;
            }
            return this.numSubEntriesAt.get(i);
        }
    }

    public static class BlockIndexWriter
    implements InlineBlockWriter {
        private BlockIndexChunk rootChunk = new BlockIndexChunk();
        private BlockIndexChunk curInlineChunk = new BlockIndexChunk();
        private int numLevels = 1;
        private HFileBlock.Writer blockWriter;
        private byte[] firstKey = null;
        private long totalNumEntries;
        private long totalBlockOnDiskSize;
        private long totalBlockUncompressedSize;
        private int maxChunkSize;
        private int minIndexNumEntries;
        private boolean singleLevelOnly;
        private CacheConfig cacheConf;
        private String nameForCaching;

        public BlockIndexWriter() {
            this(null, null, null);
            this.singleLevelOnly = true;
        }

        public BlockIndexWriter(HFileBlock.Writer blockWriter, CacheConfig cacheConf, String nameForCaching) {
            if (cacheConf == null != (nameForCaching == null)) {
                throw new IllegalArgumentException("Block cache and file name for caching must be both specified or both null");
            }
            this.blockWriter = blockWriter;
            this.cacheConf = cacheConf;
            this.nameForCaching = nameForCaching;
            this.maxChunkSize = 131072;
            this.minIndexNumEntries = 16;
        }

        public void setMaxChunkSize(int maxChunkSize) {
            if (maxChunkSize <= 0) {
                throw new IllegalArgumentException("Invalid maximum index block size");
            }
            this.maxChunkSize = maxChunkSize;
        }

        public void setMinIndexNumEntries(int minIndexNumEntries) {
            if (minIndexNumEntries <= 1) {
                throw new IllegalArgumentException("Invalid maximum index level, should be >= 2");
            }
            this.minIndexNumEntries = minIndexNumEntries;
        }

        public long writeIndexBlocks(FSDataOutputStream out) throws IOException {
            byte[] midKeyMetadata;
            if (this.curInlineChunk != null && this.curInlineChunk.getNumEntries() != 0) {
                throw new IOException("Trying to write a multi-level block index, but are " + this.curInlineChunk.getNumEntries() + " entries in the last inline chunk.");
            }
            byte[] byArray = midKeyMetadata = this.numLevels > 1 ? this.rootChunk.getMidKeyMetadata() : null;
            if (this.curInlineChunk != null) {
                while (this.rootChunk.getRootSize() > this.maxChunkSize && this.rootChunk.getNumEntries() > this.minIndexNumEntries && this.numLevels < 16) {
                    this.rootChunk = this.writeIntermediateLevel(out, this.rootChunk);
                    ++this.numLevels;
                }
            }
            long rootLevelIndexPos = out.getPos();
            DataOutputStream blockStream = this.blockWriter.startWriting(BlockType.ROOT_INDEX);
            this.rootChunk.writeRoot(blockStream);
            if (midKeyMetadata != null) {
                blockStream.write(midKeyMetadata);
            }
            this.blockWriter.writeHeaderAndData(out);
            if (this.cacheConf != null) {
                HFileBlock blockForCaching = this.blockWriter.getBlockForCaching(this.cacheConf);
                this.cacheConf.getBlockCache().cacheBlock(new BlockCacheKey(this.nameForCaching, rootLevelIndexPos, true, blockForCaching.getBlockType()), blockForCaching);
            }
            this.totalBlockOnDiskSize += (long)this.blockWriter.getOnDiskSizeWithoutHeader();
            this.totalBlockUncompressedSize += (long)this.blockWriter.getUncompressedSizeWithoutHeader();
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Wrote a " + this.numLevels + "-level index with root level at pos " + rootLevelIndexPos + ", " + this.rootChunk.getNumEntries() + " root-level entries, " + this.totalNumEntries + " total entries, " + StringUtils.humanReadableInt(this.totalBlockOnDiskSize) + " on-disk size, " + StringUtils.humanReadableInt(this.totalBlockUncompressedSize) + " total uncompressed size."));
            }
            return rootLevelIndexPos;
        }

        public void writeSingleLevelIndex(DataOutput out, String description) throws IOException {
            this.expectNumLevels(1);
            if (!this.singleLevelOnly) {
                throw new IOException("Single-level mode is turned off");
            }
            if (this.rootChunk.getNumEntries() > 0) {
                throw new IOException("Root-level entries already added in single-level mode");
            }
            this.rootChunk = this.curInlineChunk;
            this.curInlineChunk = new BlockIndexChunk();
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Wrote a single-level " + description + " index with " + this.rootChunk.getNumEntries() + " entries, " + this.rootChunk.getRootSize() + " bytes"));
            }
            this.rootChunk.writeRoot(out);
        }

        private BlockIndexChunk writeIntermediateLevel(FSDataOutputStream out, BlockIndexChunk currentLevel) throws IOException {
            BlockIndexChunk parent = new BlockIndexChunk();
            BlockIndexChunk curChunk = new BlockIndexChunk();
            for (int i = 0; i < currentLevel.getNumEntries(); ++i) {
                curChunk.add(currentLevel.getBlockKey(i), currentLevel.getBlockOffset(i), currentLevel.getOnDiskDataSize(i));
                if (i < this.minIndexNumEntries || curChunk.getRootSize() < this.maxChunkSize) continue;
                this.writeIntermediateBlock(out, parent, curChunk);
            }
            if (curChunk.getNumEntries() > 0) {
                this.writeIntermediateBlock(out, parent, curChunk);
            }
            return parent;
        }

        private void writeIntermediateBlock(FSDataOutputStream out, BlockIndexChunk parent, BlockIndexChunk curChunk) throws IOException {
            long beginOffset = out.getPos();
            DataOutputStream dos = this.blockWriter.startWriting(BlockType.INTERMEDIATE_INDEX);
            curChunk.writeNonRoot(dos);
            byte[] curFirstKey = curChunk.getBlockKey(0);
            this.blockWriter.writeHeaderAndData(out);
            if (this.getCacheOnWrite()) {
                HFileBlock blockForCaching = this.blockWriter.getBlockForCaching(this.cacheConf);
                this.cacheConf.getBlockCache().cacheBlock(new BlockCacheKey(this.nameForCaching, beginOffset, true, blockForCaching.getBlockType()), blockForCaching);
            }
            this.totalBlockOnDiskSize += (long)this.blockWriter.getOnDiskSizeWithoutHeader();
            this.totalBlockUncompressedSize += (long)this.blockWriter.getUncompressedSizeWithoutHeader();
            parent.add(curFirstKey, beginOffset, this.blockWriter.getOnDiskSizeWithHeader());
            curChunk.clear();
            curFirstKey = null;
        }

        public final int getNumRootEntries() {
            return this.rootChunk.getNumEntries();
        }

        public int getNumLevels() {
            return this.numLevels;
        }

        private void expectNumLevels(int expectedNumLevels) {
            if (this.numLevels != expectedNumLevels) {
                throw new IllegalStateException("Number of block index levels is " + this.numLevels + "but is expected to be " + expectedNumLevels);
            }
        }

        @Override
        public boolean shouldWriteBlock(boolean closing) {
            if (this.singleLevelOnly) {
                throw new UnsupportedOperationException(HFileBlockIndex.INLINE_BLOCKS_NOT_ALLOWED);
            }
            if (this.curInlineChunk == null) {
                throw new IllegalStateException("curInlineChunk is null; has shouldWriteBlock been called with closing=true and then called again?");
            }
            if (this.curInlineChunk.getNumEntries() == 0) {
                return false;
            }
            if (closing) {
                if (this.rootChunk.getNumEntries() == 0) {
                    this.expectNumLevels(1);
                    this.rootChunk = this.curInlineChunk;
                    this.curInlineChunk = null;
                    return false;
                }
                return true;
            }
            return this.curInlineChunk.getNonRootSize() >= this.maxChunkSize;
        }

        @Override
        public void writeInlineBlock(DataOutput out) throws IOException {
            if (this.singleLevelOnly) {
                throw new UnsupportedOperationException(HFileBlockIndex.INLINE_BLOCKS_NOT_ALLOWED);
            }
            this.curInlineChunk.writeNonRoot(out);
            this.firstKey = this.curInlineChunk.getBlockKey(0);
            this.curInlineChunk.clear();
        }

        @Override
        public void blockWritten(long offset, int onDiskSize, int uncompressedSize) {
            this.totalBlockOnDiskSize += (long)onDiskSize;
            this.totalBlockUncompressedSize += (long)uncompressedSize;
            if (this.singleLevelOnly) {
                throw new UnsupportedOperationException(HFileBlockIndex.INLINE_BLOCKS_NOT_ALLOWED);
            }
            if (this.firstKey == null) {
                throw new IllegalStateException("Trying to add second-level index entry with offset=" + offset + " and onDiskSize=" + onDiskSize + "but the first key was not set in writeInlineBlock");
            }
            if (this.rootChunk.getNumEntries() == 0) {
                this.expectNumLevels(1);
                this.numLevels = 2;
            }
            this.rootChunk.add(this.firstKey, offset, onDiskSize, this.totalNumEntries);
            this.firstKey = null;
        }

        @Override
        public BlockType getInlineBlockType() {
            return BlockType.LEAF_INDEX;
        }

        public void addEntry(byte[] firstKey, long blockOffset, int blockDataSize) {
            this.curInlineChunk.add(firstKey, blockOffset, blockDataSize);
            ++this.totalNumEntries;
        }

        public void ensureSingleLevel() throws IOException {
            if (this.numLevels > 1) {
                throw new IOException("Wrote a " + this.numLevels + "-level index with " + this.rootChunk.getNumEntries() + " root-level entries, but this is expected to be a single-level block index.");
            }
        }

        @Override
        public boolean getCacheOnWrite() {
            return this.cacheConf != null && this.cacheConf.shouldCacheIndexesOnWrite();
        }

        public long getTotalUncompressedSize() {
            return this.totalBlockUncompressedSize;
        }
    }

    static abstract class BlockIndexReader
    implements HeapSize {
        protected long[] blockOffsets;
        protected int[] blockDataSizes;
        protected int rootCount = 0;
        protected long midLeafBlockOffset = -1L;
        protected int midLeafBlockOnDiskSize = -1;
        protected int midKeyEntry = -1;
        protected int searchTreeLevel;
        protected HFile.CachingBlockReader cachingBlockReader;

        BlockIndexReader() {
        }

        public abstract boolean isEmpty();

        public void ensureNonEmpty() {
            if (this.isEmpty()) {
                throw new IllegalStateException("Block index is empty or not loaded");
            }
        }

        public HFileBlock seekToDataBlock(Cell key, HFileBlock currentBlock, boolean cacheBlocks, boolean pread, boolean isCompaction, DataBlockEncoding expectedDataBlockEncoding) throws IOException {
            BlockWithScanInfo blockWithScanInfo = this.loadDataBlockWithScanInfo(key, currentBlock, cacheBlocks, pread, isCompaction, expectedDataBlockEncoding);
            if (blockWithScanInfo == null) {
                return null;
            }
            return blockWithScanInfo.getHFileBlock();
        }

        public abstract BlockWithScanInfo loadDataBlockWithScanInfo(Cell var1, HFileBlock var2, boolean var3, boolean var4, boolean var5, DataBlockEncoding var6) throws IOException;

        public abstract Cell midkey() throws IOException;

        public long getRootBlockOffset(int i) {
            return this.blockOffsets[i];
        }

        public int getRootBlockDataSize(int i) {
            return this.blockDataSizes[i];
        }

        public int getRootBlockCount() {
            return this.rootCount;
        }

        public abstract int rootBlockContainingKey(byte[] var1, int var2, int var3, CellComparator var4);

        public int rootBlockContainingKey(byte[] key, int offset, int length) {
            return this.rootBlockContainingKey(key, offset, length, null);
        }

        public abstract int rootBlockContainingKey(Cell var1);

        protected byte[] getNonRootIndexedKey(ByteBuff nonRootIndex, int i) {
            int numEntries = nonRootIndex.getInt(0);
            if (i < 0 || i >= numEntries) {
                return null;
            }
            int entriesOffset = 4 * (numEntries + 2);
            int targetKeyRelOffset = nonRootIndex.getInt(4 * (i + 1));
            int targetKeyOffset = entriesOffset + targetKeyRelOffset + 12;
            int targetKeyLength = nonRootIndex.getInt(4 * (i + 2)) - targetKeyRelOffset - 12;
            return nonRootIndex.toBytes(targetKeyOffset, targetKeyLength);
        }

        static int binarySearchNonRootIndex(Cell key, ByteBuff nonRootIndex, CellComparator comparator) {
            int numEntries = nonRootIndex.getIntAfterPosition(0);
            int low = 0;
            int high = numEntries - 1;
            int mid = 0;
            int entriesOffset = 4 * (numEntries + 2);
            ByteBufferKeyOnlyKeyValue nonRootIndexkeyOnlyKV = new ByteBufferKeyOnlyKeyValue();
            ObjectIntPair<ByteBuffer> pair = new ObjectIntPair<ByteBuffer>();
            while (low <= high) {
                mid = low + high >>> 1;
                int midKeyRelOffset = nonRootIndex.getIntAfterPosition(4 * (mid + 1));
                int midKeyOffset = entriesOffset + midKeyRelOffset + 12;
                int midLength = nonRootIndex.getIntAfterPosition(4 * (mid + 2)) - midKeyRelOffset - 12;
                nonRootIndex.asSubByteBuffer(midKeyOffset, midLength, pair);
                nonRootIndexkeyOnlyKV.setKey(pair.getFirst(), pair.getSecond(), midLength);
                int cmp = comparator.compareKeyIgnoresMvcc(key, nonRootIndexkeyOnlyKV);
                if (cmp > 0) {
                    low = mid + 1;
                    continue;
                }
                if (cmp < 0) {
                    high = mid - 1;
                    continue;
                }
                return mid;
            }
            if (low != high + 1) {
                throw new IllegalStateException("Binary search broken: low=" + low + " instead of " + (high + 1));
            }
            int i = low - 1;
            if (i < -1 || i >= numEntries) {
                throw new IllegalStateException("Binary search broken: result is " + i + " but expected to be between -1 and (numEntries - 1) = " + (numEntries - 1));
            }
            return i;
        }

        static int locateNonRootIndexEntry(ByteBuff nonRootBlock, Cell key, CellComparator comparator) {
            int entryIndex = BlockIndexReader.binarySearchNonRootIndex(key, nonRootBlock, comparator);
            if (entryIndex != -1) {
                int numEntries = nonRootBlock.getIntAfterPosition(0);
                int entriesOffset = 4 * (numEntries + 2);
                int entryRelOffset = nonRootBlock.getIntAfterPosition(4 * (1 + entryIndex));
                nonRootBlock.position(entriesOffset + entryRelOffset);
            }
            return entryIndex;
        }

        public void readRootIndex(DataInput in, int numEntries) throws IOException {
            this.blockOffsets = new long[numEntries];
            this.initialize(numEntries);
            this.blockDataSizes = new int[numEntries];
            if (numEntries > 0) {
                for (int i = 0; i < numEntries; ++i) {
                    long offset = in.readLong();
                    int dataSize = in.readInt();
                    byte[] key = Bytes.readByteArray(in);
                    this.add(key, offset, dataSize);
                }
            }
        }

        protected abstract void initialize(int var1);

        protected abstract void add(byte[] var1, long var2, int var4);

        public DataInputStream readRootIndex(HFileBlock blk, int numEntries) throws IOException {
            DataInputStream in = blk.getByteStream();
            this.readRootIndex(in, numEntries);
            return in;
        }

        public void readMultiLevelIndexRoot(HFileBlock blk, int numEntries) throws IOException {
            DataInputStream in = this.readRootIndex(blk, numEntries);
            int checkSumBytes = blk.totalChecksumBytes();
            if (in.available() - checkSumBytes < 16) {
                return;
            }
            this.midLeafBlockOffset = in.readLong();
            this.midLeafBlockOnDiskSize = in.readInt();
            this.midKeyEntry = in.readInt();
        }

        @Override
        public long heapSize() {
            long heapSize = ClassSize.align(3 * ClassSize.REFERENCE + 8 + ClassSize.OBJECT);
            heapSize += 16L;
            heapSize = this.calculateHeapSizeForBlockKeys(heapSize);
            if (this.blockOffsets != null) {
                heapSize += (long)ClassSize.align(ClassSize.ARRAY + this.blockOffsets.length * 8);
            }
            if (this.blockDataSizes != null) {
                heapSize += (long)ClassSize.align(ClassSize.ARRAY + this.blockDataSizes.length * 4);
            }
            return ClassSize.align(heapSize);
        }

        protected abstract long calculateHeapSizeForBlockKeys(long var1);
    }

    static class CellBasedKeyBlockIndexReader
    extends BlockIndexReader {
        private Cell[] blockKeys;
        private AtomicReference<Cell> midKey = new AtomicReference();
        private CellComparator comparator;

        public CellBasedKeyBlockIndexReader(CellComparator c, int treeLevel, HFile.CachingBlockReader cachingBlockReader) {
            this(c, treeLevel);
            this.cachingBlockReader = cachingBlockReader;
        }

        public CellBasedKeyBlockIndexReader(CellComparator c, int treeLevel) {
            this.comparator = c;
            this.searchTreeLevel = treeLevel;
        }

        @Override
        protected long calculateHeapSizeForBlockKeys(long heapSize) {
            if (this.blockKeys != null) {
                heapSize += (long)ClassSize.REFERENCE;
                heapSize += (long)ClassSize.align(ClassSize.ARRAY + this.blockKeys.length * ClassSize.REFERENCE);
                for (Cell key : this.blockKeys) {
                    heapSize += ClassSize.align(CellUtil.estimatedHeapSizeOf(key));
                }
            }
            return heapSize += (long)(2 * ClassSize.REFERENCE);
        }

        @Override
        public boolean isEmpty() {
            return this.blockKeys.length == 0;
        }

        public Cell getRootBlockKey(int i) {
            return this.blockKeys[i];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public BlockWithScanInfo loadDataBlockWithScanInfo(Cell key, HFileBlock currentBlock, boolean cacheBlocks, boolean pread, boolean isCompaction, DataBlockEncoding expectedDataBlockEncoding) throws IOException {
            int rootLevelIndex = this.rootBlockContainingKey(key);
            if (rootLevelIndex < 0) return null;
            if (rootLevelIndex >= this.blockOffsets.length) {
                return null;
            }
            Cell nextIndexedKey = null;
            long currentOffset = this.blockOffsets[rootLevelIndex];
            int currentOnDiskSize = this.blockDataSizes[rootLevelIndex];
            nextIndexedKey = rootLevelIndex < this.blockKeys.length - 1 ? this.blockKeys[rootLevelIndex + 1] : KeyValueScanner.NO_NEXT_INDEXED_KEY;
            int lookupLevel = 1;
            int index = -1;
            HFileBlock block = null;
            boolean dataBlock = false;
            KeyValue.KeyOnlyKeyValue tmpNextIndexKV = new KeyValue.KeyOnlyKeyValue();
            while (true) {
                try {
                    if (currentBlock != null && currentBlock.getOffset() == currentOffset) {
                        block = currentBlock;
                    } else {
                        boolean shouldCache;
                        boolean bl = shouldCache = cacheBlocks || lookupLevel < this.searchTreeLevel;
                        BlockType expectedBlockType = lookupLevel < this.searchTreeLevel - 1 ? BlockType.INTERMEDIATE_INDEX : (lookupLevel == this.searchTreeLevel - 1 ? BlockType.LEAF_INDEX : BlockType.DATA);
                        block = this.cachingBlockReader.readBlock(currentOffset, currentOnDiskSize, shouldCache, pread, isCompaction, true, expectedBlockType, expectedDataBlockEncoding);
                    }
                    if (block == null) {
                        throw new IOException("Failed to read block at offset " + currentOffset + ", onDiskSize=" + currentOnDiskSize);
                    }
                    if (block.getBlockType().isData()) {
                        dataBlock = true;
                        if (dataBlock) break;
                        this.cachingBlockReader.returnBlock(block);
                        break;
                    }
                }
                catch (Throwable throwable) {
                    if (dataBlock) throw throwable;
                    this.cachingBlockReader.returnBlock(block);
                    throw throwable;
                }
                {
                    if (++lookupLevel > this.searchTreeLevel) {
                        throw new IOException("Search Tree Level overflow: lookupLevel=" + lookupLevel + ", searchTreeLevel=" + this.searchTreeLevel);
                    }
                    ByteBuff buffer = block.getBufferWithoutHeader();
                    index = CellBasedKeyBlockIndexReader.locateNonRootIndexEntry(buffer, key, this.comparator);
                    if (index == -1) {
                        throw new IOException("The key " + CellUtil.getCellKeyAsString(key) + " is before the first key of the non-root index block " + block);
                    }
                    currentOffset = buffer.getLong();
                    currentOnDiskSize = buffer.getInt();
                    byte[] nonRootIndexedKey = this.getNonRootIndexedKey(buffer, index + 1);
                    if (nonRootIndexedKey != null) {
                        tmpNextIndexKV.setKey(nonRootIndexedKey, 0, nonRootIndexedKey.length);
                        nextIndexedKey = tmpNextIndexKV;
                    }
                    if (dataBlock) continue;
                    this.cachingBlockReader.returnBlock(block);
                    continue;
                }
                break;
            }
            if (lookupLevel == this.searchTreeLevel) {
                return new BlockWithScanInfo(block, nextIndexedKey);
            }
            assert (dataBlock);
            this.cachingBlockReader.returnBlock(block);
            throw new IOException("Reached a data block at level " + lookupLevel + " but the number of levels is " + this.searchTreeLevel);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Cell midkey() throws IOException {
            if (this.rootCount == 0) {
                throw new IOException("HFile empty");
            }
            Cell targetMidKey = this.midKey.get();
            if (targetMidKey != null) {
                return targetMidKey;
            }
            if (this.midLeafBlockOffset >= 0L) {
                if (this.cachingBlockReader == null) {
                    throw new IOException("Have to read the middle leaf block but no block reader available");
                }
                HFileBlock midLeafBlock = this.cachingBlockReader.readBlock(this.midLeafBlockOffset, this.midLeafBlockOnDiskSize, true, true, false, true, BlockType.LEAF_INDEX, null);
                try {
                    ByteBuff b = midLeafBlock.getBufferWithoutHeader();
                    int numDataBlocks = b.getIntAfterPosition(0);
                    int keyRelOffset = b.getIntAfterPosition(4 * (this.midKeyEntry + 1));
                    int keyLen = b.getIntAfterPosition(4 * (this.midKeyEntry + 2)) - keyRelOffset - 12;
                    int keyOffset = 4 * (numDataBlocks + 2) + keyRelOffset + 12;
                    byte[] bytes = b.toBytes(keyOffset, keyLen);
                    targetMidKey = new KeyValue.KeyOnlyKeyValue(bytes, 0, bytes.length);
                }
                finally {
                    this.cachingBlockReader.returnBlock(midLeafBlock);
                }
            } else {
                targetMidKey = this.blockKeys[this.rootCount / 2];
            }
            this.midKey.set(targetMidKey);
            return targetMidKey;
        }

        @Override
        protected void initialize(int numEntries) {
            this.blockKeys = new Cell[numEntries];
        }

        @Override
        protected void add(byte[] key, long offset, int dataSize) {
            this.blockOffsets[this.rootCount] = offset;
            this.blockKeys[this.rootCount] = new KeyValue.KeyOnlyKeyValue(key, 0, key.length);
            this.blockDataSizes[this.rootCount] = dataSize;
            ++this.rootCount;
        }

        @Override
        public int rootBlockContainingKey(byte[] key, int offset, int length, CellComparator comp) {
            throw new UnsupportedOperationException("Cannot find for a key containing plain byte array. Only cell based keys can be searched for");
        }

        @Override
        public int rootBlockContainingKey(Cell key) {
            int pos = Bytes.binarySearch(this.blockKeys, key, this.comparator);
            if (pos >= 0) {
                assert (pos < this.blockKeys.length);
                return pos;
            }
            int i = -pos - 1;
            assert (0 <= i && i <= this.blockKeys.length);
            return i - 1;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("size=" + this.rootCount).append("\n");
            for (int i = 0; i < this.rootCount; ++i) {
                sb.append("key=").append(this.blockKeys[i]).append("\n  offset=").append(this.blockOffsets[i]).append(", dataSize=" + this.blockDataSizes[i]).append("\n");
            }
            return sb.toString();
        }
    }

    static class ByteArrayKeyBlockIndexReader
    extends BlockIndexReader {
        private byte[][] blockKeys;

        public ByteArrayKeyBlockIndexReader(int treeLevel, HFile.CachingBlockReader cachingBlockReader) {
            this(treeLevel);
            this.cachingBlockReader = cachingBlockReader;
        }

        public ByteArrayKeyBlockIndexReader(int treeLevel) {
            this.searchTreeLevel = treeLevel;
        }

        @Override
        protected long calculateHeapSizeForBlockKeys(long heapSize) {
            if (this.blockKeys != null) {
                heapSize += (long)ClassSize.REFERENCE;
                heapSize += (long)ClassSize.align(ClassSize.ARRAY + this.blockKeys.length * ClassSize.REFERENCE);
                for (byte[] key : this.blockKeys) {
                    heapSize += (long)ClassSize.align(ClassSize.ARRAY + key.length);
                }
            }
            return heapSize;
        }

        @Override
        public boolean isEmpty() {
            return this.blockKeys.length == 0;
        }

        public byte[] getRootBlockKey(int i) {
            return this.blockKeys[i];
        }

        @Override
        public BlockWithScanInfo loadDataBlockWithScanInfo(Cell key, HFileBlock currentBlock, boolean cacheBlocks, boolean pread, boolean isCompaction, DataBlockEncoding expectedDataBlockEncoding) throws IOException {
            return null;
        }

        @Override
        public Cell midkey() throws IOException {
            return null;
        }

        @Override
        protected void initialize(int numEntries) {
            this.blockKeys = new byte[numEntries][];
        }

        @Override
        protected void add(byte[] key, long offset, int dataSize) {
            this.blockOffsets[this.rootCount] = offset;
            this.blockKeys[this.rootCount] = key;
            this.blockDataSizes[this.rootCount] = dataSize;
            ++this.rootCount;
        }

        @Override
        public int rootBlockContainingKey(byte[] key, int offset, int length, CellComparator comp) {
            int pos = Bytes.binarySearch(this.blockKeys, key, offset, length);
            if (pos >= 0) {
                assert (pos < this.blockKeys.length);
                return pos;
            }
            int i = -pos - 1;
            assert (0 <= i && i <= this.blockKeys.length);
            return i - 1;
        }

        @Override
        public int rootBlockContainingKey(Cell key) {
            throw new UnsupportedOperationException("Cannot search for a key that is of Cell type. Only plain byte array keys can be searched for");
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("size=" + this.rootCount).append("\n");
            for (int i = 0; i < this.rootCount; ++i) {
                sb.append("key=").append(KeyValue.keyToString(this.blockKeys[i])).append("\n  offset=").append(this.blockOffsets[i]).append(", dataSize=" + this.blockDataSizes[i]).append("\n");
            }
            return sb.toString();
        }
    }
}

