/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.CellScannable;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.ipc.HBaseRpcController;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.RpcCallback;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class HBaseRpcControllerImpl
implements HBaseRpcController {
    private Integer callTimeout;
    private boolean done = false;
    private boolean cancelled = false;
    private final List<RpcCallback<Object>> cancellationCbs = new ArrayList<RpcCallback<Object>>();
    private IOException exception;
    private int priority = -1;
    private CellScanner cellScanner;

    public HBaseRpcControllerImpl() {
        this((CellScanner)null);
    }

    public HBaseRpcControllerImpl(CellScanner cellScanner) {
        this.cellScanner = cellScanner;
    }

    public HBaseRpcControllerImpl(List<CellScannable> cellIterables) {
        this.cellScanner = cellIterables == null ? null : CellUtil.createCellScanner(cellIterables);
    }

    @Override
    public CellScanner cellScanner() {
        return this.cellScanner;
    }

    @Override
    @SuppressWarnings(value={"IS2_INCONSISTENT_SYNC"}, justification="The only possible race method is startCancel")
    public void setCellScanner(CellScanner cellScanner) {
        this.cellScanner = cellScanner;
    }

    @Override
    public void setPriority(int priority) {
        this.priority = Math.max(this.priority, priority);
    }

    @Override
    public void setPriority(TableName tn) {
        this.setPriority(tn != null && tn.isSystemTable() ? 200 : 0);
    }

    @Override
    public int getPriority() {
        return this.priority < 0 ? 0 : this.priority;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressWarnings(value={"IS2_INCONSISTENT_SYNC"}, justification="The only possible race method is startCancel")
    public void reset() {
        this.priority = 0;
        this.cellScanner = null;
        this.exception = null;
        this.callTimeout = null;
        HBaseRpcControllerImpl hBaseRpcControllerImpl = this;
        synchronized (hBaseRpcControllerImpl) {
            this.done = false;
            this.cancelled = false;
            this.cancellationCbs.clear();
        }
    }

    @Override
    public int getCallTimeout() {
        if (this.callTimeout != null) {
            return this.callTimeout;
        }
        return 0;
    }

    @Override
    public void setCallTimeout(int callTimeout) {
        this.callTimeout = callTimeout;
    }

    @Override
    public boolean hasCallTimeout() {
        return this.callTimeout != null;
    }

    @Override
    public synchronized String errorText() {
        if (!this.done || this.exception == null) {
            return null;
        }
        return this.exception.getMessage();
    }

    @Override
    public synchronized boolean failed() {
        return this.done && this.exception != null;
    }

    @Override
    public synchronized boolean isCanceled() {
        return this.cancelled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyOnCancel(RpcCallback<Object> callback) {
        HBaseRpcControllerImpl hBaseRpcControllerImpl = this;
        synchronized (hBaseRpcControllerImpl) {
            if (this.done) {
                return;
            }
            if (!this.cancelled) {
                this.cancellationCbs.add(callback);
                return;
            }
        }
        callback.run(null);
    }

    @Override
    public synchronized void setFailed(String reason) {
        if (this.done) {
            return;
        }
        this.done = true;
        this.exception = new IOException(reason);
    }

    @Override
    public synchronized void setFailed(IOException e) {
        if (this.done) {
            return;
        }
        this.done = true;
        this.exception = e;
    }

    @Override
    public synchronized IOException getFailed() {
        return this.done ? this.exception : null;
    }

    @Override
    public synchronized void setDone(CellScanner cellScanner) {
        if (this.done) {
            return;
        }
        this.done = true;
        this.cellScanner = cellScanner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startCancel() {
        ArrayList<RpcCallback<Object>> cbs;
        HBaseRpcControllerImpl hBaseRpcControllerImpl = this;
        synchronized (hBaseRpcControllerImpl) {
            if (this.done) {
                return;
            }
            this.done = true;
            this.cancelled = true;
            cbs = new ArrayList<RpcCallback<Object>>(this.cancellationCbs);
        }
        for (RpcCallback rpcCallback : cbs) {
            rpcCallback.run(null);
        }
    }

    @Override
    public synchronized void notifyOnCancel(RpcCallback<Object> callback, HBaseRpcController.CancellationCallback action) throws IOException {
        if (this.cancelled) {
            action.run(true);
        } else {
            this.cancellationCbs.add(callback);
            action.run(false);
        }
    }
}

