/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.io.IOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.exceptions.ConnectionClosingException;
import org.apache.hadoop.hbase.ipc.Call;
import org.apache.hadoop.hbase.ipc.CallCancelledException;
import org.apache.hadoop.hbase.ipc.FatalConnectionException;
import org.apache.hadoop.hbase.ipc.RemoteWithExtrasException;
import org.apache.hadoop.hbase.ipc.ServerTooBusyException;
import org.apache.hadoop.hbase.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.CodedOutputStream;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.Message;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RPCProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.TracingProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class IPCUtil {
    IPCUtil() {
    }

    public static int write(OutputStream dos, Message header, Message param, ByteBuffer cellBlock) throws IOException {
        int totalSize = IPCUtil.getTotalSizeWhenWrittenDelimited(header, param);
        if (cellBlock != null) {
            totalSize += cellBlock.remaining();
        }
        return IPCUtil.write(dos, header, param, cellBlock, totalSize);
    }

    private static int write(OutputStream dos, Message header, Message param, ByteBuffer cellBlock, int totalSize) throws IOException {
        dos.write(Bytes.toBytes(totalSize));
        header.writeDelimitedTo(dos);
        if (param != null) {
            param.writeDelimitedTo(dos);
        }
        if (cellBlock != null) {
            dos.write(cellBlock.array(), 0, cellBlock.remaining());
        }
        dos.flush();
        return totalSize;
    }

    public static int getTotalSizeWhenWrittenDelimited(Message ... messages) {
        int totalSize = 0;
        for (Message m : messages) {
            if (m == null) continue;
            totalSize += m.getSerializedSize();
            totalSize += CodedOutputStream.computeRawVarint32Size(m.getSerializedSize());
        }
        Preconditions.checkArgument(totalSize < Integer.MAX_VALUE);
        return totalSize;
    }

    static RPCProtos.RequestHeader buildRequestHeader(Call call, RPCProtos.CellBlockMeta cellBlockMeta) {
        RPCProtos.RequestHeader.Builder builder = RPCProtos.RequestHeader.newBuilder();
        builder.setCallId(call.id);
        if (call.span != null) {
            builder.setTraceInfo(TracingProtos.RPCTInfo.newBuilder().setParentId(call.span.getSpanId()).setTraceId(call.span.getTraceId()));
        }
        builder.setMethodName(call.md.getName());
        builder.setRequestParam(call.param != null);
        if (cellBlockMeta != null) {
            builder.setCellBlockMeta(cellBlockMeta);
        }
        if (call.priority != -1) {
            builder.setPriority(call.priority);
        }
        builder.setTimeout(call.timeout);
        return builder.build();
    }

    static RemoteException createRemoteException(RPCProtos.ExceptionResponse e) {
        String innerExceptionClassName = e.getExceptionClassName();
        boolean doNotRetry = e.getDoNotRetry();
        return e.hasHostname() ? new RemoteWithExtrasException(innerExceptionClassName, e.getStackTrace(), e.getHostname(), e.getPort(), doNotRetry) : new RemoteWithExtrasException(innerExceptionClassName, e.getStackTrace(), doNotRetry);
    }

    static boolean isFatalConnectionException(RPCProtos.ExceptionResponse e) {
        return e.getExceptionClassName().equals(FatalConnectionException.class.getName());
    }

    static IOException toIOE(Throwable t) {
        if (t instanceof IOException) {
            return (IOException)t;
        }
        return new IOException(t);
    }

    static IOException wrapException(InetSocketAddress addr, Exception exception) {
        if (exception instanceof ConnectException) {
            return (ConnectException)new ConnectException("Call to " + addr + " failed on connection exception: " + exception).initCause(exception);
        }
        if (exception instanceof SocketTimeoutException) {
            return (SocketTimeoutException)new SocketTimeoutException("Call to " + addr + " failed because " + exception).initCause(exception);
        }
        if (exception instanceof ConnectionClosingException) {
            return (ConnectionClosingException)new ConnectionClosingException("Call to " + addr + " failed on local exception: " + exception).initCause(exception);
        }
        if (exception instanceof ServerTooBusyException) {
            return (IOException)exception;
        }
        if (exception instanceof DoNotRetryIOException) {
            return (IOException)new DoNotRetryIOException("Call to " + addr + " failed on local exception: " + exception).initCause(exception);
        }
        return (IOException)new IOException("Call to " + addr + " failed on local exception: " + exception).initCause(exception);
    }

    static void setCancelled(Call call) {
        call.setException(new CallCancelledException("Call id=" + call.id + ", waitTime=" + (EnvironmentEdgeManager.currentTime() - call.getStartTime()) + ", rpcTimeout=" + call.timeout));
    }
}

