/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.ipc.NettyRpcServer;
import org.apache.hadoop.hbase.ipc.NettyRpcServerRequestDecoder;
import org.apache.hadoop.hbase.ipc.NettyServerRpcConnection;
import org.apache.hadoop.hbase.shaded.io.netty.buffer.ByteBuf;
import org.apache.hadoop.hbase.shaded.io.netty.channel.ChannelHandlerContext;
import org.apache.hadoop.hbase.shaded.io.netty.channel.ChannelPipeline;
import org.apache.hadoop.hbase.shaded.io.netty.channel.SimpleChannelInboundHandler;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class NettyRpcServerPreambleHandler
extends SimpleChannelInboundHandler<ByteBuf> {
    private final NettyRpcServer rpcServer;

    public NettyRpcServerPreambleHandler(NettyRpcServer rpcServer) {
        this.rpcServer = rpcServer;
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) throws Exception {
        NettyServerRpcConnection conn = new NettyServerRpcConnection(this.rpcServer, ctx.channel());
        ByteBuffer buf = ByteBuffer.allocate(msg.readableBytes());
        msg.readBytes(buf);
        buf.flip();
        if (!conn.processPreamble(buf)) {
            conn.close();
            return;
        }
        ChannelPipeline p = ctx.pipeline();
        ((NettyRpcServerRequestDecoder)p.get("decoder")).setConnection(conn);
        p.remove(this);
        p.remove("preambleDecoder");
    }
}

