/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapred;

import java.io.Closeable;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapred.TableRecordReader;
import org.apache.hadoop.hbase.mapred.TableSplit;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public abstract class TableInputFormatBase
implements InputFormat<ImmutableBytesWritable, Result> {
    private static final Log LOG = LogFactory.getLog(TableInputFormatBase.class);
    private byte[][] inputColumns;
    private Table table;
    private RegionLocator regionLocator;
    private Connection connection;
    private TableRecordReader tableRecordReader;
    private Filter rowFilter;
    private static final String NOT_INITIALIZED = "The input format instance has not been properly initialized. Ensure you call initializeTable either in your constructor or initialize method";
    private static final String INITIALIZATION_ERROR = "Cannot create a record reader because of a previous error. Please look at the previous logs lines from the task's full log for more details.";

    @Override
    public RecordReader<ImmutableBytesWritable, Result> getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
        if (this.table == null) {
            this.initialize(job);
        }
        try {
            if (this.getTable() == null) {
                throw new IOException(INITIALIZATION_ERROR);
            }
        }
        catch (IllegalStateException exception) {
            throw new IOException(INITIALIZATION_ERROR, exception);
        }
        TableSplit tSplit = (TableSplit)split;
        final TableRecordReader trr = this.tableRecordReader == null ? new TableRecordReader() : this.tableRecordReader;
        trr.setStartRow(tSplit.getStartRow());
        trr.setEndRow(tSplit.getEndRow());
        trr.setHTable(this.table);
        trr.setInputColumns(this.inputColumns);
        trr.setRowFilter(this.rowFilter);
        trr.init();
        return new RecordReader<ImmutableBytesWritable, Result>(){

            @Override
            public void close() throws IOException {
                trr.close();
                TableInputFormatBase.this.closeTable();
            }

            @Override
            public ImmutableBytesWritable createKey() {
                return trr.createKey();
            }

            @Override
            public Result createValue() {
                return trr.createValue();
            }

            @Override
            public long getPos() throws IOException {
                return trr.getPos();
            }

            @Override
            public float getProgress() throws IOException {
                return trr.getProgress();
            }

            @Override
            public boolean next(ImmutableBytesWritable key, Result value) throws IOException {
                return trr.next(key, value);
            }
        };
    }

    @Override
    public InputSplit[] getSplits(JobConf job, int numSplits) throws IOException {
        if (this.table == null) {
            this.initialize(job);
        }
        try {
            if (this.getTable() == null) {
                throw new IOException(INITIALIZATION_ERROR);
            }
        }
        catch (IllegalStateException exception) {
            throw new IOException(INITIALIZATION_ERROR, exception);
        }
        byte[][] startKeys = this.regionLocator.getStartKeys();
        if (startKeys == null || startKeys.length == 0) {
            throw new IOException("Expecting at least one region");
        }
        if (this.inputColumns == null || this.inputColumns.length == 0) {
            throw new IOException("Expecting at least one column");
        }
        int realNumSplits = numSplits > startKeys.length ? startKeys.length : numSplits;
        InputSplit[] splits = new InputSplit[realNumSplits];
        int middle = startKeys.length / realNumSplits;
        int startPos = 0;
        for (int i = 0; i < realNumSplits; ++i) {
            int lastPos = startPos + middle;
            lastPos = startKeys.length % realNumSplits > i ? lastPos + 1 : lastPos;
            String regionLocation = this.regionLocator.getRegionLocation(startKeys[startPos]).getHostname();
            splits[i] = new TableSplit(this.table.getName(), startKeys[startPos], i + 1 < realNumSplits ? startKeys[lastPos] : HConstants.EMPTY_START_ROW, regionLocation);
            LOG.info((Object)("split: " + i + "->" + splits[i]));
            startPos = lastPos;
        }
        return splits;
    }

    protected void initializeTable(Connection connection, TableName tableName) throws IOException {
        if (this.table != null || this.connection != null) {
            LOG.warn((Object)"initializeTable called multiple times. Overwriting connection and table reference; TableInputFormatBase will not close these old references when done.");
        }
        this.table = connection.getTable(tableName);
        this.regionLocator = connection.getRegionLocator(tableName);
        this.connection = connection;
    }

    protected void setInputColumns(byte[][] inputColumns) {
        this.inputColumns = inputColumns;
    }

    protected Table getTable() {
        if (this.table == null) {
            throw new IllegalStateException(NOT_INITIALIZED);
        }
        return this.table;
    }

    protected void setTableRecordReader(TableRecordReader tableRecordReader) {
        this.tableRecordReader = tableRecordReader;
    }

    protected void setRowFilter(Filter rowFilter) {
        this.rowFilter = rowFilter;
    }

    protected void initialize(JobConf job) throws IOException {
    }

    protected void closeTable() throws IOException {
        this.close(this.table, this.connection);
        this.table = null;
        this.connection = null;
    }

    private void close(Closeable ... closables) throws IOException {
        for (Closeable c : closables) {
            if (c == null) continue;
            c.close();
        }
    }
}

