/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.fs.HFileSystem;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.io.hfile.HFileWriterImpl;
import org.apache.hadoop.hbase.mapreduce.KeyValueSerialization;
import org.apache.hadoop.hbase.mapreduce.KeyValueSortReducer;
import org.apache.hadoop.hbase.mapreduce.MultiTableHFileOutputFormat;
import org.apache.hadoop.hbase.mapreduce.MutationSerialization;
import org.apache.hadoop.hbase.mapreduce.PutSortReducer;
import org.apache.hadoop.hbase.mapreduce.ResultSerialization;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.mapreduce.TextSortReducer;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFileWriter;
import org.apache.hadoop.hbase.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.hbase.shaded.org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputCommitter;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.partition.TotalOrderPartitioner;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class HFileOutputFormat2
extends FileOutputFormat<ImmutableBytesWritable, Cell> {
    private static final Log LOG = LogFactory.getLog(HFileOutputFormat2.class);
    protected static final byte[] tableSeparator = ";".getBytes(StandardCharsets.UTF_8);
    static final String COMPRESSION_FAMILIES_CONF_KEY = "hbase.hfileoutputformat.families.compression";
    static final String BLOOM_TYPE_FAMILIES_CONF_KEY = "hbase.hfileoutputformat.families.bloomtype";
    static final String BLOCK_SIZE_FAMILIES_CONF_KEY = "hbase.mapreduce.hfileoutputformat.blocksize";
    static final String DATABLOCK_ENCODING_FAMILIES_CONF_KEY = "hbase.mapreduce.hfileoutputformat.families.datablock.encoding";
    public static final String DATABLOCK_ENCODING_OVERRIDE_CONF_KEY = "hbase.mapreduce.hfileoutputformat.datablock.encoding";
    public static final String LOCALITY_SENSITIVE_CONF_KEY = "hbase.bulkload.locality.sensitive.enabled";
    private static final boolean DEFAULT_LOCALITY_SENSITIVE = true;
    static final String OUTPUT_TABLE_NAME_CONF_KEY = "hbase.mapreduce.hfileoutputformat.table.name";
    static final String MULTI_TABLE_HFILEOUTPUTFORMAT_CONF_KEY = "hbase.mapreduce.use.multi.table.hfileoutputformat";
    public static final String STORAGE_POLICY_PROPERTY = "hbase.hstore.storagepolicy";
    public static final String STORAGE_POLICY_PROPERTY_CF_PREFIX = "hbase.hstore.storagepolicy.";
    @VisibleForTesting
    static Function<ColumnFamilyDescriptor, String> compressionDetails = familyDescriptor -> familyDescriptor.getCompressionType().getName();
    @VisibleForTesting
    static Function<ColumnFamilyDescriptor, String> blockSizeDetails = familyDescriptor -> String.valueOf(familyDescriptor.getBlocksize());
    @VisibleForTesting
    static Function<ColumnFamilyDescriptor, String> bloomTypeDetails = familyDescriptor -> {
        String bloomType = familyDescriptor.getBloomFilterType().toString();
        if (bloomType == null) {
            bloomType = ColumnFamilyDescriptorBuilder.DEFAULT_BLOOMFILTER.name();
        }
        return bloomType;
    };
    @VisibleForTesting
    static Function<ColumnFamilyDescriptor, String> dataBlockEncodingDetails = familyDescriptor -> {
        DataBlockEncoding encoding = familyDescriptor.getDataBlockEncoding();
        if (encoding == null) {
            encoding = DataBlockEncoding.NONE;
        }
        return encoding.toString();
    };

    protected static byte[] combineTableNameSuffix(byte[] tableName, byte[] suffix) {
        return Bytes.add(tableName, tableSeparator, suffix);
    }

    @Override
    public RecordWriter<ImmutableBytesWritable, Cell> getRecordWriter(TaskAttemptContext context) throws IOException, InterruptedException {
        return HFileOutputFormat2.createRecordWriter(context);
    }

    protected static byte[] getTableNameSuffixedWithFamily(byte[] tableName, byte[] family) {
        return HFileOutputFormat2.combineTableNameSuffix(tableName, family);
    }

    static <V extends Cell> RecordWriter<ImmutableBytesWritable, V> createRecordWriter(final TaskAttemptContext context) throws IOException {
        Path outputPath = FileOutputFormat.getOutputPath(context);
        final Path outputDir = new FileOutputCommitter(outputPath, context).getWorkPath();
        final Configuration conf = context.getConfiguration();
        final boolean writeMultipleTables = conf.getBoolean(MULTI_TABLE_HFILEOUTPUTFORMAT_CONF_KEY, false);
        final String writeTableNames = conf.get(OUTPUT_TABLE_NAME_CONF_KEY);
        if (writeTableNames == null || writeTableNames.isEmpty()) {
            throw new IllegalArgumentException("Configuration parameter hbase.mapreduce.hfileoutputformat.table.name cannot be empty");
        }
        final FileSystem fs = outputDir.getFileSystem(conf);
        final long maxsize = conf.getLong("hbase.hregion.max.filesize", 0x280000000L);
        String defaultCompressionStr = conf.get("hfile.compression", Compression.Algorithm.NONE.getName());
        final Compression.Algorithm defaultCompression = HFileWriterImpl.compressionByName(defaultCompressionStr);
        final boolean compactionExclude = conf.getBoolean("hbase.mapreduce.hfileoutputformat.compaction.exclude", false);
        final Set allTableNames = Arrays.stream(writeTableNames.split(Bytes.toString(tableSeparator))).collect(Collectors.toSet());
        final Map<byte[], Compression.Algorithm> compressionMap = HFileOutputFormat2.createFamilyCompressionMap(conf);
        final Map<byte[], BloomType> bloomTypeMap = HFileOutputFormat2.createFamilyBloomTypeMap(conf);
        final Map<byte[], Integer> blockSizeMap = HFileOutputFormat2.createFamilyBlockSizeMap(conf);
        String dataBlockEncodingStr = conf.get(DATABLOCK_ENCODING_OVERRIDE_CONF_KEY);
        final Map<byte[], DataBlockEncoding> datablockEncodingMap = HFileOutputFormat2.createFamilyDataBlockEncodingMap(conf);
        final DataBlockEncoding overriddenEncoding = dataBlockEncodingStr != null ? DataBlockEncoding.valueOf(dataBlockEncodingStr) : null;
        return new RecordWriter<ImmutableBytesWritable, V>(){
            private final Map<byte[], WriterLength> writers = new TreeMap<byte[], WriterLength>(Bytes.BYTES_COMPARATOR);
            private byte[] previousRow = HConstants.EMPTY_BYTE_ARRAY;
            private final byte[] now = Bytes.toBytes(EnvironmentEdgeManager.currentTime());
            private boolean rollRequested = false;

            @Override
            public void write(ImmutableBytesWritable row, V cell) throws IOException {
                byte[] tableAndFamily;
                WriterLength wl;
                KeyValue kv = KeyValueUtil.ensureKeyValue(cell);
                if (row == null && kv == null) {
                    this.rollWriters();
                    return;
                }
                byte[] rowKey = CellUtil.cloneRow(kv);
                long length = kv.getLength();
                byte[] family = CellUtil.cloneFamily(kv);
                byte[] tableNameBytes = null;
                if (writeMultipleTables) {
                    tableNameBytes = MultiTableHFileOutputFormat.getTableName(row.get());
                    if (!allTableNames.contains(Bytes.toString(tableNameBytes))) {
                        throw new IllegalArgumentException("TableName '" + Bytes.toString(tableNameBytes) + "' not expected");
                    }
                } else {
                    tableNameBytes = writeTableNames.getBytes(StandardCharsets.UTF_8);
                }
                if ((wl = this.writers.get(tableAndFamily = HFileOutputFormat2.getTableNameSuffixedWithFamily(tableNameBytes, family))) == null) {
                    Path writerPath = null;
                    writerPath = writeMultipleTables ? new Path(outputDir, new Path(Bytes.toString(tableNameBytes), Bytes.toString(family))) : new Path(outputDir, Bytes.toString(family));
                    fs.mkdirs(writerPath);
                    HFileOutputFormat2.configureStoragePolicy(conf, fs, tableAndFamily, writerPath);
                }
                if (wl != null && wl.written + length >= maxsize) {
                    this.rollRequested = true;
                }
                if (this.rollRequested && Bytes.compareTo(this.previousRow, rowKey) != 0) {
                    this.rollWriters();
                }
                if (wl == null || wl.writer == null) {
                    if (conf.getBoolean(HFileOutputFormat2.LOCALITY_SENSITIVE_CONF_KEY, true)) {
                        HRegionLocation loc = null;
                        String tableName = Bytes.toString(tableNameBytes);
                        if (tableName != null) {
                            try (Connection connection = ConnectionFactory.createConnection(conf);
                                 RegionLocator locator = connection.getRegionLocator(TableName.valueOf(tableName));){
                                loc = locator.getRegionLocation(rowKey);
                            }
                            catch (Throwable e) {
                                LOG.warn((Object)("There's something wrong when locating rowkey: " + Bytes.toString(rowKey) + " for tablename: " + tableName), e);
                                loc = null;
                            }
                        }
                        if (null == loc) {
                            if (LOG.isTraceEnabled()) {
                                LOG.trace((Object)("failed to get region location, so use default writer for rowkey: " + Bytes.toString(rowKey)));
                            }
                            wl = this.getNewWriter(tableNameBytes, family, conf, null);
                        } else {
                            InetSocketAddress initialIsa;
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("first rowkey: [" + Bytes.toString(rowKey) + "]"));
                            }
                            if ((initialIsa = new InetSocketAddress(loc.getHostname(), loc.getPort())).isUnresolved()) {
                                if (LOG.isTraceEnabled()) {
                                    LOG.trace((Object)("failed to resolve bind address: " + loc.getHostname() + ":" + loc.getPort() + ", so use default writer"));
                                }
                                wl = this.getNewWriter(tableNameBytes, family, conf, null);
                            } else {
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug((Object)("use favored nodes writer: " + initialIsa.getHostString()));
                                }
                                wl = this.getNewWriter(tableNameBytes, family, conf, new InetSocketAddress[]{initialIsa});
                            }
                        }
                    } else {
                        wl = this.getNewWriter(tableNameBytes, family, conf, null);
                    }
                }
                kv.updateLatestStamp(this.now);
                wl.writer.append(kv);
                wl.written += length;
                this.previousRow = rowKey;
            }

            private void rollWriters() throws IOException {
                for (WriterLength wl : this.writers.values()) {
                    if (wl.writer != null) {
                        LOG.info((Object)("Writer=" + wl.writer.getPath() + (wl.written == 0L ? "" : ", wrote=" + wl.written)));
                        this.close(wl.writer);
                    }
                    wl.writer = null;
                    wl.written = 0L;
                }
                this.rollRequested = false;
            }

            @SuppressWarnings(value={"BX_UNBOXING_IMMEDIATELY_REBOXED"}, justification="Not important")
            private WriterLength getNewWriter(byte[] tableName, byte[] family, Configuration conf2, InetSocketAddress[] favoredNodes) throws IOException {
                byte[] tableAndFamily = HFileOutputFormat2.getTableNameSuffixedWithFamily(tableName, family);
                Path familydir = new Path(outputDir, Bytes.toString(family));
                if (writeMultipleTables) {
                    familydir = new Path(outputDir, new Path(Bytes.toString(tableName), Bytes.toString(family)));
                }
                WriterLength wl = new WriterLength();
                Compression.Algorithm compression = (Compression.Algorithm)((Object)compressionMap.get(tableAndFamily));
                compression = compression == null ? defaultCompression : compression;
                BloomType bloomType = (BloomType)((Object)bloomTypeMap.get(tableAndFamily));
                bloomType = bloomType == null ? BloomType.NONE : bloomType;
                Integer blockSize = (Integer)blockSizeMap.get(tableAndFamily);
                blockSize = blockSize == null ? 65536 : blockSize;
                DataBlockEncoding encoding = overriddenEncoding;
                encoding = encoding == null ? (DataBlockEncoding)((Object)datablockEncodingMap.get(tableAndFamily)) : encoding;
                encoding = encoding == null ? DataBlockEncoding.NONE : encoding;
                Configuration tempConf = new Configuration(conf2);
                tempConf.setFloat("hfile.block.cache.size", 0.0f);
                HFileContextBuilder contextBuilder = new HFileContextBuilder().withCompression(compression).withChecksumType(HStore.getChecksumType(conf2)).withBytesPerCheckSum(HStore.getBytesPerChecksum(conf2)).withBlockSize(blockSize);
                if (HFile.getFormatVersion(conf2) >= 3) {
                    contextBuilder.withIncludesTags(true);
                }
                contextBuilder.withDataBlockEncoding(encoding);
                HFileContext hFileContext = contextBuilder.build();
                wl.writer = null == favoredNodes ? new StoreFileWriter.Builder(conf2, new CacheConfig(tempConf), fs).withOutputDir(familydir).withBloomType(bloomType).withComparator(CellComparator.COMPARATOR).withFileContext(hFileContext).build() : new StoreFileWriter.Builder(conf2, new CacheConfig(tempConf), new HFileSystem(fs)).withOutputDir(familydir).withBloomType(bloomType).withComparator(CellComparator.COMPARATOR).withFileContext(hFileContext).withFavoredNodes(favoredNodes).build();
                this.writers.put(tableAndFamily, wl);
                return wl;
            }

            private void close(StoreFileWriter w) throws IOException {
                if (w != null) {
                    w.appendFileInfo(StoreFile.BULKLOAD_TIME_KEY, Bytes.toBytes(System.currentTimeMillis()));
                    w.appendFileInfo(StoreFile.BULKLOAD_TASK_KEY, Bytes.toBytes(context.getTaskAttemptID().toString()));
                    w.appendFileInfo(StoreFile.MAJOR_COMPACTION_KEY, Bytes.toBytes(true));
                    w.appendFileInfo(StoreFile.EXCLUDE_FROM_MINOR_COMPACTION_KEY, Bytes.toBytes(compactionExclude));
                    w.appendTrackedTimestampsToMetadata();
                    w.close();
                }
            }

            @Override
            public void close(TaskAttemptContext c) throws IOException, InterruptedException {
                for (WriterLength wl : this.writers.values()) {
                    this.close(wl.writer);
                }
            }
        };
    }

    static void configureStoragePolicy(Configuration conf, FileSystem fs, byte[] tableAndFamily, Path cfPath) {
        if (null == conf || null == fs || null == tableAndFamily || null == cfPath) {
            return;
        }
        String policy = conf.get(STORAGE_POLICY_PROPERTY_CF_PREFIX + Bytes.toString(tableAndFamily), conf.get(STORAGE_POLICY_PROPERTY));
        FSUtils.setStoragePolicy(fs, cfPath, policy);
    }

    private static List<ImmutableBytesWritable> getRegionStartKeys(List<RegionLocator> regionLocators, boolean writeMultipleTables) throws IOException {
        ArrayList<ImmutableBytesWritable> ret = new ArrayList<ImmutableBytesWritable>();
        for (RegionLocator regionLocator : regionLocators) {
            byte[][] byteKeys;
            TableName tableName = regionLocator.getName();
            LOG.info((Object)("Looking up current regions for table " + tableName));
            byte[][] byArray = byteKeys = regionLocator.getStartKeys();
            int n = byArray.length;
            for (int i = 0; i < n; ++i) {
                byte[] byteKey;
                byte[] fullKey = byteKey = byArray[i];
                if (writeMultipleTables) {
                    fullKey = HFileOutputFormat2.combineTableNameSuffix(tableName.getName(), byteKey);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("SplitPoint startkey for table [" + tableName + "]: [" + Bytes.toStringBinary(fullKey) + "]"));
                }
                ret.add(new ImmutableBytesWritable(fullKey));
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writePartitions(Configuration conf, Path partitionsPath, List<ImmutableBytesWritable> startKeys, boolean writeMultipleTables) throws IOException {
        LOG.info((Object)("Writing partition information to " + partitionsPath));
        if (startKeys.isEmpty()) {
            throw new IllegalArgumentException("No regions passed");
        }
        TreeSet<ImmutableBytesWritable> sorted = new TreeSet<ImmutableBytesWritable>(startKeys);
        ImmutableBytesWritable first = sorted.first();
        if (writeMultipleTables) {
            first = new ImmutableBytesWritable(MultiTableHFileOutputFormat.getSuffix(sorted.first().get()));
        }
        if (!first.equals(HConstants.EMPTY_BYTE_ARRAY)) {
            throw new IllegalArgumentException("First region of table should have empty start key. Instead has: " + Bytes.toStringBinary(first.get()));
        }
        sorted.remove(sorted.first());
        FileSystem fs = partitionsPath.getFileSystem(conf);
        try (SequenceFile.Writer writer = SequenceFile.createWriter(fs, conf, partitionsPath, ImmutableBytesWritable.class, NullWritable.class);){
            for (ImmutableBytesWritable startKey : sorted) {
                writer.append(startKey, NullWritable.get());
            }
        }
    }

    public static void configureIncrementalLoad(Job job, Table table, RegionLocator regionLocator) throws IOException {
        HFileOutputFormat2.configureIncrementalLoad(job, table.getDescriptor(), regionLocator);
    }

    public static void configureIncrementalLoad(Job job, TableDescriptor tableDescriptor, RegionLocator regionLocator) throws IOException {
        ArrayList<TableInfo> singleTableInfo = new ArrayList<TableInfo>();
        singleTableInfo.add(new TableInfo(tableDescriptor, regionLocator));
        HFileOutputFormat2.configureIncrementalLoad(job, singleTableInfo, HFileOutputFormat2.class);
    }

    static void configureIncrementalLoad(Job job, List<TableInfo> multiTableInfo, Class<? extends OutputFormat<?, ?>> cls) throws IOException {
        Configuration conf = job.getConfiguration();
        job.setOutputKeyClass(ImmutableBytesWritable.class);
        job.setOutputValueClass(KeyValue.class);
        job.setOutputFormatClass(cls);
        if (multiTableInfo.stream().distinct().count() != (long)multiTableInfo.size()) {
            throw new IllegalArgumentException("Duplicate entries found in TableInfo argument");
        }
        boolean writeMultipleTables = false;
        if (MultiTableHFileOutputFormat.class.equals(cls)) {
            writeMultipleTables = true;
            conf.setBoolean(MULTI_TABLE_HFILEOUTPUTFORMAT_CONF_KEY, true);
        }
        if (KeyValue.class.equals(job.getMapOutputValueClass())) {
            job.setReducerClass(KeyValueSortReducer.class);
        } else if (Put.class.equals(job.getMapOutputValueClass())) {
            job.setReducerClass(PutSortReducer.class);
        } else if (Text.class.equals(job.getMapOutputValueClass())) {
            job.setReducerClass(TextSortReducer.class);
        } else {
            LOG.warn((Object)("Unknown map output value type:" + job.getMapOutputValueClass()));
        }
        conf.setStrings("io.serializations", conf.get("io.serializations"), MutationSerialization.class.getName(), ResultSerialization.class.getName(), KeyValueSerialization.class.getName());
        if (conf.getBoolean(LOCALITY_SENSITIVE_CONF_KEY, true)) {
            LOG.info((Object)"bulkload locality sensitive enabled");
        }
        ArrayList<String> allTableNames = new ArrayList<String>(multiTableInfo.size());
        ArrayList<RegionLocator> regionLocators = new ArrayList<RegionLocator>(multiTableInfo.size());
        ArrayList<TableDescriptor> tableDescriptors = new ArrayList<TableDescriptor>(multiTableInfo.size());
        for (TableInfo tableInfo : multiTableInfo) {
            regionLocators.add(tableInfo.getRegionLocator());
            allTableNames.add(tableInfo.getRegionLocator().getName().getNameAsString());
            tableDescriptors.add(tableInfo.getTableDescriptor());
        }
        conf.set(OUTPUT_TABLE_NAME_CONF_KEY, StringUtils.join(allTableNames, Bytes.toString(tableSeparator)));
        List<ImmutableBytesWritable> startKeys = HFileOutputFormat2.getRegionStartKeys(regionLocators, writeMultipleTables);
        LOG.info((Object)("Configuring " + startKeys.size() + " reduce partitions to match current region count for all tables"));
        job.setNumReduceTasks(startKeys.size());
        HFileOutputFormat2.configurePartitioner(job, startKeys, writeMultipleTables);
        conf.set(COMPRESSION_FAMILIES_CONF_KEY, HFileOutputFormat2.serializeColumnFamilyAttribute(compressionDetails, tableDescriptors));
        conf.set(BLOCK_SIZE_FAMILIES_CONF_KEY, HFileOutputFormat2.serializeColumnFamilyAttribute(blockSizeDetails, tableDescriptors));
        conf.set(BLOOM_TYPE_FAMILIES_CONF_KEY, HFileOutputFormat2.serializeColumnFamilyAttribute(bloomTypeDetails, tableDescriptors));
        conf.set(DATABLOCK_ENCODING_FAMILIES_CONF_KEY, HFileOutputFormat2.serializeColumnFamilyAttribute(dataBlockEncodingDetails, tableDescriptors));
        TableMapReduceUtil.addDependencyJars(job);
        TableMapReduceUtil.initCredentials(job);
        LOG.info((Object)("Incremental output configured for tables: " + StringUtils.join(allTableNames, ",")));
    }

    public static void configureIncrementalLoadMap(Job job, TableDescriptor tableDescriptor) throws IOException {
        Configuration conf = job.getConfiguration();
        job.setOutputKeyClass(ImmutableBytesWritable.class);
        job.setOutputValueClass(KeyValue.class);
        job.setOutputFormatClass(HFileOutputFormat2.class);
        ArrayList<TableDescriptor> singleTableDescriptor = new ArrayList<TableDescriptor>(1);
        singleTableDescriptor.add(tableDescriptor);
        conf.set(OUTPUT_TABLE_NAME_CONF_KEY, tableDescriptor.getTableName().getNameAsString());
        conf.set(COMPRESSION_FAMILIES_CONF_KEY, HFileOutputFormat2.serializeColumnFamilyAttribute(compressionDetails, singleTableDescriptor));
        conf.set(BLOCK_SIZE_FAMILIES_CONF_KEY, HFileOutputFormat2.serializeColumnFamilyAttribute(blockSizeDetails, singleTableDescriptor));
        conf.set(BLOOM_TYPE_FAMILIES_CONF_KEY, HFileOutputFormat2.serializeColumnFamilyAttribute(bloomTypeDetails, singleTableDescriptor));
        conf.set(DATABLOCK_ENCODING_FAMILIES_CONF_KEY, HFileOutputFormat2.serializeColumnFamilyAttribute(dataBlockEncodingDetails, singleTableDescriptor));
        TableMapReduceUtil.addDependencyJars(job);
        TableMapReduceUtil.initCredentials(job);
        LOG.info((Object)("Incremental table " + tableDescriptor.getTableName() + " output configured."));
    }

    @VisibleForTesting
    static Map<byte[], Compression.Algorithm> createFamilyCompressionMap(Configuration conf) {
        Map<byte[], String> stringMap = HFileOutputFormat2.createFamilyConfValueMap(conf, COMPRESSION_FAMILIES_CONF_KEY);
        TreeMap<byte[], Compression.Algorithm> compressionMap = new TreeMap<byte[], Compression.Algorithm>(Bytes.BYTES_COMPARATOR);
        for (Map.Entry<byte[], String> e : stringMap.entrySet()) {
            Compression.Algorithm algorithm = HFileWriterImpl.compressionByName(e.getValue());
            compressionMap.put(e.getKey(), algorithm);
        }
        return compressionMap;
    }

    @VisibleForTesting
    static Map<byte[], BloomType> createFamilyBloomTypeMap(Configuration conf) {
        Map<byte[], String> stringMap = HFileOutputFormat2.createFamilyConfValueMap(conf, BLOOM_TYPE_FAMILIES_CONF_KEY);
        TreeMap<byte[], BloomType> bloomTypeMap = new TreeMap<byte[], BloomType>(Bytes.BYTES_COMPARATOR);
        for (Map.Entry<byte[], String> e : stringMap.entrySet()) {
            BloomType bloomType = BloomType.valueOf(e.getValue());
            bloomTypeMap.put(e.getKey(), bloomType);
        }
        return bloomTypeMap;
    }

    @VisibleForTesting
    static Map<byte[], Integer> createFamilyBlockSizeMap(Configuration conf) {
        Map<byte[], String> stringMap = HFileOutputFormat2.createFamilyConfValueMap(conf, BLOCK_SIZE_FAMILIES_CONF_KEY);
        TreeMap<byte[], Integer> blockSizeMap = new TreeMap<byte[], Integer>(Bytes.BYTES_COMPARATOR);
        for (Map.Entry<byte[], String> e : stringMap.entrySet()) {
            Integer blockSize = Integer.parseInt(e.getValue());
            blockSizeMap.put(e.getKey(), blockSize);
        }
        return blockSizeMap;
    }

    @VisibleForTesting
    static Map<byte[], DataBlockEncoding> createFamilyDataBlockEncodingMap(Configuration conf) {
        Map<byte[], String> stringMap = HFileOutputFormat2.createFamilyConfValueMap(conf, DATABLOCK_ENCODING_FAMILIES_CONF_KEY);
        TreeMap<byte[], DataBlockEncoding> encoderMap = new TreeMap<byte[], DataBlockEncoding>(Bytes.BYTES_COMPARATOR);
        for (Map.Entry<byte[], String> e : stringMap.entrySet()) {
            encoderMap.put(e.getKey(), DataBlockEncoding.valueOf(e.getValue()));
        }
        return encoderMap;
    }

    private static Map<byte[], String> createFamilyConfValueMap(Configuration conf, String confName) {
        TreeMap<byte[], String> confValMap = new TreeMap<byte[], String>(Bytes.BYTES_COMPARATOR);
        String confVal = conf.get(confName, "");
        for (String familyConf : confVal.split("&")) {
            String[] familySplit = familyConf.split("=");
            if (familySplit.length != 2) continue;
            try {
                confValMap.put(URLDecoder.decode(familySplit[0], "UTF-8").getBytes(StandardCharsets.UTF_8), URLDecoder.decode(familySplit[1], "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new AssertionError((Object)e);
            }
        }
        return confValMap;
    }

    static void configurePartitioner(Job job, List<ImmutableBytesWritable> splitPoints, boolean writeMultipleTables) throws IOException {
        Configuration conf = job.getConfiguration();
        FileSystem fs = FileSystem.get(conf);
        String hbaseTmpFsDir = conf.get("hbase.fs.tmp.dir", HConstants.DEFAULT_TEMPORARY_HDFS_DIRECTORY);
        Path partitionsPath = new Path(hbaseTmpFsDir, "partitions_" + UUID.randomUUID());
        fs.makeQualified(partitionsPath);
        HFileOutputFormat2.writePartitions(conf, partitionsPath, splitPoints, writeMultipleTables);
        fs.deleteOnExit(partitionsPath);
        job.setPartitionerClass(TotalOrderPartitioner.class);
        TotalOrderPartitioner.setPartitionFile(conf, partitionsPath);
    }

    @SuppressWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"})
    @VisibleForTesting
    static String serializeColumnFamilyAttribute(Function<ColumnFamilyDescriptor, String> fn, List<TableDescriptor> allTables) throws UnsupportedEncodingException {
        StringBuilder attributeValue = new StringBuilder();
        int i = 0;
        for (TableDescriptor tableDescriptor : allTables) {
            if (tableDescriptor == null) {
                return "";
            }
            for (ColumnFamilyDescriptor familyDescriptor : tableDescriptor.getColumnFamilies()) {
                if (i++ > 0) {
                    attributeValue.append('&');
                }
                attributeValue.append(URLEncoder.encode(Bytes.toString(HFileOutputFormat2.combineTableNameSuffix(tableDescriptor.getTableName().getName(), familyDescriptor.getName())), "UTF-8"));
                attributeValue.append('=');
                attributeValue.append(URLEncoder.encode(fn.apply(familyDescriptor), "UTF-8"));
            }
        }
        return attributeValue.toString();
    }

    static class WriterLength {
        long written = 0L;
        StoreFileWriter writer = null;

        WriterLength() {
        }
    }

    static class TableInfo {
        private TableDescriptor tableDesctiptor;
        private RegionLocator regionLocator;

        public TableInfo(TableDescriptor tableDesctiptor, RegionLocator regionLocator) {
            this.tableDesctiptor = tableDesctiptor;
            this.regionLocator = regionLocator;
        }

        @Deprecated
        public HTableDescriptor getHTableDescriptor() {
            return new HTableDescriptor(this.tableDesctiptor);
        }

        public TableDescriptor getTableDescriptor() {
            return this.tableDesctiptor;
        }

        public RegionLocator getRegionLocator() {
            return this.regionLocator;
        }
    }
}

