/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import java.util.TreeSet;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class KeyValueSortReducer
extends Reducer<ImmutableBytesWritable, KeyValue, ImmutableBytesWritable, KeyValue> {
    @Override
    protected void reduce(ImmutableBytesWritable row, Iterable<KeyValue> kvs, Reducer.Context context) throws IOException, InterruptedException {
        TreeSet<Cell> map = new TreeSet<Cell>(CellComparator.COMPARATOR);
        for (KeyValue kv : kvs) {
            try {
                map.add(kv.clone());
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new IOException(cloneNotSupportedException);
            }
        }
        context.setStatus("Read " + map.getClass());
        int index = 0;
        for (KeyValue keyValue : map) {
            context.write(row, keyValue);
            if (++index % 100 != 0) continue;
            context.setStatus("Wrote " + index);
        }
    }
}

