/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.HFileOutputFormat2;
import org.apache.hadoop.hbase.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapreduce.Job;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
@VisibleForTesting
public class MultiTableHFileOutputFormat
extends HFileOutputFormat2 {
    private static final Log LOG = LogFactory.getLog(MultiTableHFileOutputFormat.class);

    public static byte[] createCompositeKey(byte[] tableName, byte[] suffix) {
        return MultiTableHFileOutputFormat.combineTableNameSuffix(tableName, suffix);
    }

    public static byte[] createCompositeKey(byte[] tableName, ImmutableBytesWritable suffix) {
        return MultiTableHFileOutputFormat.combineTableNameSuffix(tableName, suffix.get());
    }

    public static byte[] createCompositeKey(String tableName, ImmutableBytesWritable suffix) {
        return MultiTableHFileOutputFormat.combineTableNameSuffix(tableName.getBytes(Charset.forName("UTF-8")), suffix.get());
    }

    public static void configureIncrementalLoad(Job job, List<HFileOutputFormat2.TableInfo> multiTableDescriptors) throws IOException {
        MultiTableHFileOutputFormat.configureIncrementalLoad(job, multiTableDescriptors, MultiTableHFileOutputFormat.class);
    }

    private static final int validateCompositeKey(byte[] keyBytes) {
        int separatorIdx = Bytes.indexOf(keyBytes, tableSeparator);
        if (separatorIdx == -1) {
            throw new IllegalArgumentException("Invalid format for composite key [" + Bytes.toStringBinary(keyBytes) + "]. Cannot extract tablename and suffix from key");
        }
        return separatorIdx;
    }

    protected static byte[] getTableName(byte[] keyBytes) {
        int separatorIdx = MultiTableHFileOutputFormat.validateCompositeKey(keyBytes);
        return Bytes.copy(keyBytes, 0, separatorIdx);
    }

    protected static byte[] getSuffix(byte[] keyBytes) {
        int separatorIdx = MultiTableHFileOutputFormat.validateCompositeKey(keyBytes);
        return Bytes.copy(keyBytes, separatorIdx + 1, keyBytes.length - separatorIdx - 1);
    }
}

