/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.RegionLoad;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.Sets;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class RegionSizeCalculator {
    private static final Log LOG = LogFactory.getLog(RegionSizeCalculator.class);
    private final Map<byte[], Long> sizeMap = new TreeMap<byte[], Long>(Bytes.BYTES_COMPARATOR);
    static final String ENABLE_REGIONSIZECALCULATOR = "hbase.regionsizecalculator.enable";
    private static final long MEGABYTE = 0x100000L;

    public RegionSizeCalculator(RegionLocator regionLocator, Admin admin) throws IOException {
        this.init(regionLocator, admin);
    }

    private void init(RegionLocator regionLocator, Admin admin) throws IOException {
        if (!this.enabled(admin.getConfiguration())) {
            LOG.info((Object)"Region size calculation disabled.");
            return;
        }
        if (regionLocator.getName().isSystemTable()) {
            LOG.info((Object)"Region size calculation disabled for system tables.");
            return;
        }
        LOG.info((Object)("Calculating region sizes for table \"" + regionLocator.getName() + "\"."));
        Set<ServerName> tableServers = this.getRegionServersOfTable(regionLocator);
        for (ServerName tableServerName : tableServers) {
            Map<byte[], RegionLoad> regionLoads = admin.getRegionLoad(tableServerName, regionLocator.getName());
            for (RegionLoad regionLoad : regionLoads.values()) {
                byte[] regionId = regionLoad.getName();
                long regionSizeBytes = (long)regionLoad.getStorefileSizeMB() * 0x100000L;
                this.sizeMap.put(regionId, regionSizeBytes);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Region " + regionLoad.getNameAsString() + " has size " + regionSizeBytes));
            }
        }
        LOG.debug((Object)"Region sizes calculated");
    }

    private Set<ServerName> getRegionServersOfTable(RegionLocator regionLocator) throws IOException {
        HashSet<ServerName> tableServers = Sets.newHashSet();
        for (HRegionLocation regionLocation : regionLocator.getAllRegionLocations()) {
            tableServers.add(regionLocation.getServerName());
        }
        return tableServers;
    }

    boolean enabled(Configuration configuration) {
        return configuration.getBoolean(ENABLE_REGIONSIZECALCULATOR, true);
    }

    public long getRegionSize(byte[] regionId) {
        Long size = this.sizeMap.get(regionId);
        if (size == null) {
            LOG.debug((Object)("Unknown region:" + Arrays.toString(regionId)));
            return 0L;
        }
        return size;
    }

    public Map<byte[], Long> getRegionSizeMap() {
        return Collections.unmodifiableMap(this.sizeMap);
    }
}

