/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.ScheduledChore;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.assignment.AssignmentManager;
import org.apache.hadoop.hbase.master.assignment.GCMergedRegionsProcedure;
import org.apache.hadoop.hbase.master.assignment.GCRegionProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.PairOfSameType;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.util.Triple;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class CatalogJanitor
extends ScheduledChore {
    private static final Log LOG = LogFactory.getLog((String)CatalogJanitor.class.getName());
    private final AtomicBoolean alreadyRunning = new AtomicBoolean(false);
    private final AtomicBoolean enabled = new AtomicBoolean(true);
    private final MasterServices services;
    private final Connection connection;

    CatalogJanitor(MasterServices services) {
        super("CatalogJanitor-" + services.getServerName().toShortString(), services, services.getConfiguration().getInt("hbase.catalogjanitor.interval", 300000));
        this.services = services;
        this.connection = services.getConnection();
    }

    @Override
    protected boolean initialChore() {
        try {
            if (this.enabled.get()) {
                this.scan();
            }
        }
        catch (IOException e) {
            LOG.warn((Object)"Failed initial scan of catalog table", (Throwable)e);
            return false;
        }
        return true;
    }

    public boolean setEnabled(boolean enabled) {
        boolean alreadyEnabled = this.enabled.getAndSet(enabled);
        if (!enabled && alreadyEnabled) {
            while (this.alreadyRunning.get()) {
                Threads.sleepWithoutInterrupt(100L);
            }
        }
        return alreadyEnabled;
    }

    boolean getEnabled() {
        return this.enabled.get();
    }

    @Override
    protected void chore() {
        try {
            AssignmentManager am = this.services.getAssignmentManager();
            if (this.enabled.get() && !this.services.isInMaintenanceMode() && am != null && am.isFailoverCleanupDone() && !am.hasRegionsInTransition()) {
                this.scan();
            } else {
                LOG.warn((Object)("CatalogJanitor is disabled! Enabled=" + this.enabled.get() + ", maintenanceMode=" + this.services.isInMaintenanceMode() + ", am=" + am + ", failoverCleanupDone=" + (am != null && am.isFailoverCleanupDone()) + ", hasRIT=" + (am != null && am.hasRegionsInTransition())));
            }
        }
        catch (IOException e) {
            LOG.warn((Object)"Failed scan of catalog table", (Throwable)e);
        }
    }

    Triple<Integer, Map<HRegionInfo, Result>, Map<HRegionInfo, Result>> getMergedRegionsAndSplitParents() throws IOException {
        return this.getMergedRegionsAndSplitParents(null);
    }

    Triple<Integer, Map<HRegionInfo, Result>, Map<HRegionInfo, Result>> getMergedRegionsAndSplitParents(final TableName tableName) throws IOException {
        final boolean isTableSpecified = tableName != null;
        final AtomicInteger count = new AtomicInteger(0);
        final TreeMap splitParents = new TreeMap(new SplitParentFirstComparator());
        final TreeMap mergedRegions = new TreeMap();
        MetaTableAccessor.Visitor visitor = new MetaTableAccessor.Visitor(){

            @Override
            public boolean visit(Result r) throws IOException {
                if (r == null || r.isEmpty()) {
                    return true;
                }
                count.incrementAndGet();
                HRegionInfo info = MetaTableAccessor.getHRegionInfo(r);
                if (info == null) {
                    return true;
                }
                if (isTableSpecified && info.getTable().compareTo(tableName) > 0) {
                    return false;
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("" + info + " IS-SPLIT_PARENT=" + info.isSplitParent()));
                }
                if (info.isSplitParent()) {
                    splitParents.put(info, r);
                }
                if (r.getValue(HConstants.CATALOG_FAMILY, HConstants.MERGEA_QUALIFIER) != null) {
                    mergedRegions.put(info, r);
                }
                return true;
            }
        };
        MetaTableAccessor.scanMetaForTableRegions(this.connection, visitor, tableName);
        return new Triple<Integer, Map<HRegionInfo, Result>, Map<HRegionInfo, Result>>(count.get(), mergedRegions, splitParents);
    }

    boolean cleanMergeRegion(HRegionInfo mergedRegion, HRegionInfo regionA, HRegionInfo regionB) throws IOException {
        FileSystem fs = this.services.getMasterFileSystem().getFileSystem();
        Path rootdir = this.services.getMasterFileSystem().getRootDir();
        Path tabledir = FSUtils.getTableDir(rootdir, mergedRegion.getTable());
        TableDescriptor htd = this.getTableDescriptor(mergedRegion.getTable());
        HRegionFileSystem regionFs = null;
        try {
            regionFs = HRegionFileSystem.openRegionFromFileSystem(this.services.getConfiguration(), fs, tabledir, mergedRegion, true);
        }
        catch (IOException e) {
            LOG.warn((Object)("Merged region does not exist: " + mergedRegion.getEncodedName()));
        }
        if (regionFs == null || !regionFs.hasReferences(htd)) {
            LOG.debug((Object)("Deleting region " + regionA.getShortNameToLog() + " and " + regionB.getShortNameToLog() + " from fs because merged region no longer holds references"));
            ProcedureExecutor<MasterProcedureEnv> pe = this.services.getMasterProcedureExecutor();
            pe.submitProcedure(new GCMergedRegionsProcedure(pe.getEnvironment(), mergedRegion, regionA, regionB));
            this.services.getAssignmentManager().getRegionStates().deleteRegion(regionA);
            this.services.getAssignmentManager().getRegionStates().deleteRegion(regionB);
            this.services.getServerManager().removeRegion(regionA);
            this.services.getServerManager().removeRegion(regionB);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int scan() throws IOException {
        int result = 0;
        try {
            if (!this.alreadyRunning.compareAndSet(false, true)) {
                LOG.debug((Object)"CatalogJanitor already running");
                int n = result;
                return n;
            }
            Triple<Integer, Map<HRegionInfo, Result>, Map<HRegionInfo, Result>> scanTriple = this.getMergedRegionsAndSplitParents();
            Map<HRegionInfo, Result> mergedRegions = scanTriple.getSecond();
            for (Map.Entry<HRegionInfo, Result> e : mergedRegions.entrySet()) {
                if (this.services.isInMaintenanceMode()) break;
                PairOfSameType<HRegionInfo> p = MetaTableAccessor.getMergeRegions(e.getValue());
                HRegionInfo regionA = p.getFirst();
                HRegionInfo regionB = p.getSecond();
                if (regionA == null || regionB == null) {
                    LOG.warn((Object)("Unexpected references regionA=" + (regionA == null ? "null" : regionA.getShortNameToLog()) + ",regionB=" + (regionB == null ? "null" : regionB.getShortNameToLog()) + " in merged region " + e.getKey().getShortNameToLog()));
                    continue;
                }
                if (!this.cleanMergeRegion(e.getKey(), regionA, regionB)) continue;
                ++result;
            }
            Map<HRegionInfo, Result> splitParents = scanTriple.getThird();
            HashSet<String> parentNotCleaned = new HashSet<String>();
            for (Map.Entry<HRegionInfo, Result> e : splitParents.entrySet()) {
                if (this.services.isInMaintenanceMode()) break;
                if (!parentNotCleaned.contains(e.getKey().getEncodedName()) && this.cleanParent(e.getKey(), e.getValue())) {
                    ++result;
                    continue;
                }
                PairOfSameType<HRegionInfo> daughters = MetaTableAccessor.getDaughterRegions(e.getValue());
                parentNotCleaned.add(daughters.getFirst().getEncodedName());
                parentNotCleaned.add(daughters.getSecond().getEncodedName());
            }
            int n = result;
            return n;
        }
        finally {
            this.alreadyRunning.set(false);
        }
    }

    boolean cleanParent(HRegionInfo parent, Result rowContent) throws IOException {
        if (rowContent.getValue(HConstants.CATALOG_FAMILY, HConstants.MERGEA_QUALIFIER) != null) {
            return false;
        }
        PairOfSameType<HRegionInfo> daughters = MetaTableAccessor.getDaughterRegions(rowContent);
        Pair<Boolean, Boolean> a = this.checkDaughterInFs(parent, daughters.getFirst());
        Pair<Boolean, Boolean> b = this.checkDaughterInFs(parent, daughters.getSecond());
        if (this.hasNoReferences(a) && this.hasNoReferences(b)) {
            String daughterA = daughters.getFirst() != null ? daughters.getFirst().getShortNameToLog() : "null";
            String daughterB = daughters.getSecond() != null ? daughters.getSecond().getShortNameToLog() : "null";
            LOG.debug((Object)("Deleting region " + parent.getShortNameToLog() + " because daughters -- " + daughterA + ", " + daughterB + " -- no longer hold references"));
            ProcedureExecutor<MasterProcedureEnv> pe = this.services.getMasterProcedureExecutor();
            pe.submitProcedure(new GCRegionProcedure(pe.getEnvironment(), parent));
            this.services.getAssignmentManager().getRegionStates().deleteRegion(parent);
            this.services.getServerManager().removeRegion(parent);
            return true;
        }
        return false;
    }

    private boolean hasNoReferences(Pair<Boolean, Boolean> p) {
        return p.getFirst() == false || p.getSecond() == false;
    }

    Pair<Boolean, Boolean> checkDaughterInFs(HRegionInfo parent, HRegionInfo daughter) throws IOException {
        if (daughter == null) {
            return new Pair<Boolean, Boolean>(Boolean.FALSE, Boolean.FALSE);
        }
        FileSystem fs = this.services.getMasterFileSystem().getFileSystem();
        Path rootdir = this.services.getMasterFileSystem().getRootDir();
        Path tabledir = FSUtils.getTableDir(rootdir, daughter.getTable());
        Path daughterRegionDir = new Path(tabledir, daughter.getEncodedName());
        HRegionFileSystem regionFs = null;
        try {
            if (!FSUtils.isExists(fs, daughterRegionDir)) {
                return new Pair<Boolean, Boolean>(Boolean.FALSE, Boolean.FALSE);
            }
        }
        catch (IOException ioe) {
            LOG.error((Object)"Error trying to determine if daughter region exists, assuming exists and has references", (Throwable)ioe);
            return new Pair<Boolean, Boolean>(Boolean.TRUE, Boolean.TRUE);
        }
        boolean references = false;
        TableDescriptor parentDescriptor = this.getTableDescriptor(parent.getTable());
        try {
            ColumnFamilyDescriptor family;
            regionFs = HRegionFileSystem.openRegionFromFileSystem(this.services.getConfiguration(), fs, tabledir, daughter, true);
            ColumnFamilyDescriptor[] columnFamilyDescriptorArray = parentDescriptor.getColumnFamilies();
            int n = columnFamilyDescriptorArray.length;
            for (int i = 0; i < n && !(references = regionFs.hasReferences((family = columnFamilyDescriptorArray[i]).getNameAsString())); ++i) {
            }
        }
        catch (IOException e) {
            LOG.error((Object)("Error trying to determine referenced files from : " + daughter.getEncodedName() + ", to: " + parent.getEncodedName() + " assuming has references"), (Throwable)e);
            return new Pair<Boolean, Boolean>(Boolean.TRUE, Boolean.TRUE);
        }
        return new Pair<Boolean, Boolean>(Boolean.TRUE, references);
    }

    private TableDescriptor getTableDescriptor(TableName tableName) throws FileNotFoundException, IOException {
        return this.services.getTableDescriptors().get(tableName);
    }

    public boolean cleanMergeQualifier(HRegionInfo region) throws IOException {
        Pair<HRegionInfo, HRegionInfo> mergeRegions = MetaTableAccessor.getRegionsFromMergeQualifier(this.services.getConnection(), region.getRegionName());
        if (mergeRegions == null || mergeRegions.getFirst() == null && mergeRegions.getSecond() == null) {
            return true;
        }
        if (mergeRegions.getFirst() == null || mergeRegions.getSecond() == null) {
            LOG.error((Object)("Merged region " + region.getRegionNameAsString() + " has only one merge qualifier in META."));
            return false;
        }
        return this.cleanMergeRegion(region, mergeRegions.getFirst(), mergeRegions.getSecond());
    }

    static class SplitParentFirstComparator
    implements Comparator<HRegionInfo> {
        Comparator<byte[]> rowEndKeyComparator = new Bytes.RowEndKeyComparator();

        SplitParentFirstComparator() {
        }

        @Override
        public int compare(HRegionInfo left, HRegionInfo right) {
            if (left == null) {
                return -1;
            }
            if (right == null) {
                return 1;
            }
            int result = left.getTable().compareTo(right.getTable());
            if (result != 0) {
                return result;
            }
            result = Bytes.compareTo(left.getStartKey(), right.getStartKey());
            if (result != 0) {
                return result;
            }
            result = this.rowEndKeyComparator.compare(right.getEndKey(), left.getEndKey());
            return result;
        }
    }
}

