/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.ScheduledChore;
import org.apache.hadoop.hbase.TableDescriptors;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.locking.LockManager;
import org.apache.hadoop.hbase.mob.ExpiredMobFileCleaner;
import org.apache.hadoop.hbase.mob.MobUtils;
import org.apache.hadoop.hbase.procedure2.LockType;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ExpiredMobFileCleanerChore
extends ScheduledChore {
    private static final Log LOG = LogFactory.getLog(ExpiredMobFileCleanerChore.class);
    private final HMaster master;
    private ExpiredMobFileCleaner cleaner;

    public ExpiredMobFileCleanerChore(HMaster master) {
        super(master.getServerName() + "-ExpiredMobFileCleanerChore", master, master.getConfiguration().getInt("hbase.master.mob.ttl.cleaner.period", 86400), master.getConfiguration().getInt("hbase.master.mob.ttl.cleaner.period", 86400), TimeUnit.SECONDS);
        this.master = master;
        this.cleaner = new ExpiredMobFileCleaner();
        this.cleaner.setConf(master.getConfiguration());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressWarnings(value={"REC_CATCH_EXCEPTION"}, justification="Intentional")
    protected void chore() {
        try {
            TableDescriptors htds = this.master.getTableDescriptors();
            Map<String, TableDescriptor> map = htds.getAll();
            for (TableDescriptor htd : map.values()) {
                for (ColumnFamilyDescriptor hcd : htd.getColumnFamilies()) {
                    if (!hcd.isMobEnabled() || hcd.getMinVersions() != 0) continue;
                    LockManager.MasterLock lock = this.master.getLockManager().createMasterLock(MobUtils.getTableLockName(htd.getTableName()), LockType.SHARED, this.getClass().getSimpleName() + ": Cleaning expired mob files");
                    try {
                        lock.acquire();
                        this.cleaner.cleanExpiredMobFiles(htd.getTableName().getNameAsString(), hcd);
                    }
                    finally {
                        lock.release();
                    }
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Fail to clean the expired mob files", (Throwable)e);
        }
    }
}

