/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.regex.Pattern;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.CoordinatedStateException;
import org.apache.hadoop.hbase.CoordinatedStateManager;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.PleaseHoldException;
import org.apache.hadoop.hbase.ServerLoad;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.TableDescriptors;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotDisabledException;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.UnknownRegionException;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.MasterSwitchType;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.client.TableState;
import org.apache.hadoop.hbase.coprocessor.BypassCoprocessorException;
import org.apache.hadoop.hbase.coprocessor.CoprocessorHost;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.exceptions.MergeRegionException;
import org.apache.hadoop.hbase.executor.ExecutorType;
import org.apache.hadoop.hbase.favored.FavoredNodesManager;
import org.apache.hadoop.hbase.favored.FavoredNodesPromoter;
import org.apache.hadoop.hbase.http.InfoServer;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcUtils;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.ipc.ServerNotRunningYetException;
import org.apache.hadoop.hbase.master.ActiveMasterManager;
import org.apache.hadoop.hbase.master.CatalogJanitor;
import org.apache.hadoop.hbase.master.ClusterSchema;
import org.apache.hadoop.hbase.master.ClusterSchemaService;
import org.apache.hadoop.hbase.master.ClusterSchemaServiceImpl;
import org.apache.hadoop.hbase.master.ClusterStatusPublisher;
import org.apache.hadoop.hbase.master.ExpiredMobFileCleanerChore;
import org.apache.hadoop.hbase.master.HMasterCommandLine;
import org.apache.hadoop.hbase.master.LoadBalancer;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.master.MasterDumpServlet;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.master.MasterMetaBootstrap;
import org.apache.hadoop.hbase.master.MasterMobCompactionThread;
import org.apache.hadoop.hbase.master.MasterRpcServices;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.MasterStatusServlet;
import org.apache.hadoop.hbase.master.MasterWalManager;
import org.apache.hadoop.hbase.master.MetricsMaster;
import org.apache.hadoop.hbase.master.MetricsMasterWrapperImpl;
import org.apache.hadoop.hbase.master.MobCompactionChore;
import org.apache.hadoop.hbase.master.RegionPlan;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.master.SnapshotOfRegionAssignmentFromMeta;
import org.apache.hadoop.hbase.master.TableStateManager;
import org.apache.hadoop.hbase.master.assignment.AssignmentManager;
import org.apache.hadoop.hbase.master.assignment.MergeTableRegionsProcedure;
import org.apache.hadoop.hbase.master.assignment.RegionStates;
import org.apache.hadoop.hbase.master.balancer.BalancerChore;
import org.apache.hadoop.hbase.master.balancer.BaseLoadBalancer;
import org.apache.hadoop.hbase.master.balancer.ClusterStatusChore;
import org.apache.hadoop.hbase.master.balancer.LoadBalancerFactory;
import org.apache.hadoop.hbase.master.cleaner.HFileCleaner;
import org.apache.hadoop.hbase.master.cleaner.LogCleaner;
import org.apache.hadoop.hbase.master.cleaner.ReplicationMetaCleaner;
import org.apache.hadoop.hbase.master.cleaner.ReplicationZKNodeCleaner;
import org.apache.hadoop.hbase.master.cleaner.ReplicationZKNodeCleanerChore;
import org.apache.hadoop.hbase.master.locking.LockManager;
import org.apache.hadoop.hbase.master.normalizer.NormalizationPlan;
import org.apache.hadoop.hbase.master.normalizer.RegionNormalizer;
import org.apache.hadoop.hbase.master.normalizer.RegionNormalizerChore;
import org.apache.hadoop.hbase.master.normalizer.RegionNormalizerFactory;
import org.apache.hadoop.hbase.master.procedure.AddColumnFamilyProcedure;
import org.apache.hadoop.hbase.master.procedure.CreateTableProcedure;
import org.apache.hadoop.hbase.master.procedure.DeleteColumnFamilyProcedure;
import org.apache.hadoop.hbase.master.procedure.DeleteTableProcedure;
import org.apache.hadoop.hbase.master.procedure.DisableTableProcedure;
import org.apache.hadoop.hbase.master.procedure.EnableTableProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureScheduler;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureUtil;
import org.apache.hadoop.hbase.master.procedure.ModifyColumnFamilyProcedure;
import org.apache.hadoop.hbase.master.procedure.ModifyTableProcedure;
import org.apache.hadoop.hbase.master.procedure.ProcedurePrepareLatch;
import org.apache.hadoop.hbase.master.procedure.RecoverMetaProcedure;
import org.apache.hadoop.hbase.master.procedure.TruncateTableProcedure;
import org.apache.hadoop.hbase.master.replication.ReplicationManager;
import org.apache.hadoop.hbase.master.snapshot.SnapshotManager;
import org.apache.hadoop.hbase.monitoring.MemoryBoundedLogMessageBuffer;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hadoop.hbase.monitoring.TaskMonitor;
import org.apache.hadoop.hbase.procedure.MasterProcedureManagerHost;
import org.apache.hadoop.hbase.procedure.flush.MasterFlushTableProcedureManager;
import org.apache.hadoop.hbase.procedure2.LockedResource;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureEvent;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.store.wal.WALProcedureStore;
import org.apache.hadoop.hbase.quotas.MasterQuotaManager;
import org.apache.hadoop.hbase.quotas.MasterSpaceQuotaObserver;
import org.apache.hadoop.hbase.quotas.QuotaObserverChore;
import org.apache.hadoop.hbase.quotas.QuotaUtil;
import org.apache.hadoop.hbase.quotas.SnapshotQuotaObserverChore;
import org.apache.hadoop.hbase.quotas.SpaceQuotaSnapshotNotifier;
import org.apache.hadoop.hbase.quotas.SpaceQuotaSnapshotNotifierFactory;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.RSRpcServices;
import org.apache.hadoop.hbase.regionserver.RegionCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.RegionSplitPolicy;
import org.apache.hadoop.hbase.regionserver.compactions.ExploringCompactionPolicy;
import org.apache.hadoop.hbase.regionserver.compactions.FIFOCompactionPolicy;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationFactory;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationPeerDescription;
import org.apache.hadoop.hbase.replication.ReplicationQueuesZKImpl;
import org.apache.hadoop.hbase.replication.master.TableCFsUpdater;
import org.apache.hadoop.hbase.replication.regionserver.Replication;
import org.apache.hadoop.hbase.security.AccessDeniedException;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.Lists;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.Maps;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.Descriptors;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.Service;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.KeeperException;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.QuotaProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.SnapshotProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.WALProtos;
import org.apache.hadoop.hbase.util.Addressing;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CompressionTest;
import org.apache.hadoop.hbase.util.EncryptionTest;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.HFileArchiveUtil;
import org.apache.hadoop.hbase.util.HasThread;
import org.apache.hadoop.hbase.util.IdLock;
import org.apache.hadoop.hbase.util.ModifyRegionUtils;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.util.ZKDataMigrator;
import org.apache.hadoop.hbase.zookeeper.DrainingServerTracker;
import org.apache.hadoop.hbase.zookeeper.LoadBalancerTracker;
import org.apache.hadoop.hbase.zookeeper.MasterAddressTracker;
import org.apache.hadoop.hbase.zookeeper.MasterMaintenanceModeTracker;
import org.apache.hadoop.hbase.zookeeper.RegionNormalizerTracker;
import org.apache.hadoop.hbase.zookeeper.RegionServerTracker;
import org.apache.hadoop.hbase.zookeeper.SplitOrMergeTracker;
import org.apache.hadoop.hbase.zookeeper.ZKClusterId;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hadoop.util.VersionInfo;
import org.apache.yetus.audience.InterfaceAudience;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.webapp.WebAppContext;

@InterfaceAudience.LimitedPrivate(value={"Tools"})
public class HMaster
extends HRegionServer
implements MasterServices {
    private static final Log LOG = LogFactory.getLog((String)HMaster.class.getName());
    public static final String MASTER = "master";
    private final ActiveMasterManager activeMasterManager;
    RegionServerTracker regionServerTracker;
    private DrainingServerTracker drainingServerTracker;
    LoadBalancerTracker loadBalancerTracker;
    private SplitOrMergeTracker splitOrMergeTracker;
    private RegionNormalizerTracker regionNormalizerTracker;
    private MasterMaintenanceModeTracker maintenanceModeTracker;
    private ClusterSchemaService clusterSchemaService;
    public static final String HBASE_MASTER_WAIT_ON_SERVICE_IN_SECONDS = "hbase.master.wait.on.service.seconds";
    public static final int DEFAULT_HBASE_MASTER_WAIT_ON_SERVICE_IN_SECONDS = 300;
    final MetricsMaster metricsMaster;
    private MasterFileSystem fileSystemManager;
    private MasterWalManager walManager;
    private volatile ServerManager serverManager;
    private AssignmentManager assignmentManager;
    private ReplicationManager replicationManager;
    MemoryBoundedLogMessageBuffer rsFatals;
    private volatile boolean activeMaster = false;
    private final ProcedureEvent initialized = new ProcedureEvent<String>("master initialized");
    volatile boolean serviceStarted = false;
    private final ProcedureEvent serverCrashProcessingEnabled = new ProcedureEvent<String>("server crash processing");
    private final int maxBlancingTime;
    private final double maxRitPercent;
    private final LockManager lockManager = new LockManager(this);
    private LoadBalancer balancer;
    private RegionNormalizer normalizer;
    private BalancerChore balancerChore;
    private RegionNormalizerChore normalizerChore;
    private ClusterStatusChore clusterStatusChore;
    private ClusterStatusPublisher clusterStatusPublisherChore = null;
    CatalogJanitor catalogJanitorChore;
    private ReplicationMetaCleaner replicationMetaCleaner;
    private ReplicationZKNodeCleanerChore replicationZKNodeCleanerChore;
    private LogCleaner logCleaner;
    private HFileCleaner hfileCleaner;
    private ExpiredMobFileCleanerChore expiredMobFileCleanerChore;
    private MobCompactionChore mobCompactChore;
    private MasterMobCompactionThread mobCompactThread;
    private final IdLock mobCompactionLock = new IdLock();
    private Map<TableName, AtomicInteger> mobCompactionStates = Maps.newConcurrentMap();
    MasterCoprocessorHost cpHost;
    private final boolean preLoadTableDescriptors;
    private long masterActiveTime;
    private long masterFinishedInitializationTime;
    private final boolean masterCheckCompression;
    private final boolean masterCheckEncryption;
    Map<String, Service> coprocessorServiceHandlers = Maps.newHashMap();
    SnapshotManager snapshotManager;
    private MasterProcedureManagerHost mpmHost;
    private volatile MasterQuotaManager quotaManager;
    private SpaceQuotaSnapshotNotifier spaceQuotaSnapshotNotifier;
    private QuotaObserverChore quotaObserverChore;
    private SnapshotQuotaObserverChore snapshotQuotaChore;
    private ProcedureExecutor<MasterProcedureEnv> procedureExecutor;
    private WALProcedureStore procedureStore;
    private TableStateManager tableStateManager;
    private long splitPlanCount;
    private long mergePlanCount;
    private FavoredNodesManager favoredNodesManager;
    private Server masterJettyServer;

    public HMaster(Configuration conf, CoordinatedStateManager csm) throws IOException, KeeperException {
        super(conf, csm);
        this.rsFatals = new MemoryBoundedLogMessageBuffer(conf.getLong("hbase.master.buffer.for.rs.fatals", 0x100000L));
        LOG.info((Object)("hbase.rootdir=" + this.getRootDir() + ", hbase.cluster.distributed=" + this.conf.getBoolean("hbase.cluster.distributed", false)));
        this.conf.setBoolean("hbase.meta.replicas.use", false);
        Replication.decorateMasterConfiguration(this.conf);
        if (this.conf.get("mapreduce.task.attempt.id") == null) {
            this.conf.set("mapreduce.task.attempt.id", "hb_m_" + this.serverName.toString());
        }
        this.masterCheckCompression = conf.getBoolean("hbase.master.check.compression", true);
        this.masterCheckEncryption = conf.getBoolean("hbase.master.check.encryption", true);
        this.metricsMaster = new MetricsMaster(new MetricsMasterWrapperImpl(this));
        this.preLoadTableDescriptors = conf.getBoolean("hbase.master.preload.tabledescriptors", true);
        this.maxBlancingTime = this.getMaxBalancingTime();
        this.maxRitPercent = conf.getDouble("hbase.master.balancer.maxRitPercent", 1.0);
        boolean shouldPublish = conf.getBoolean("hbase.status.published", false);
        Class<ClusterStatusPublisher.Publisher> publisherClass = conf.getClass("hbase.status.publisher.class", ClusterStatusPublisher.DEFAULT_STATUS_PUBLISHER_CLASS, ClusterStatusPublisher.Publisher.class);
        if (shouldPublish) {
            if (publisherClass == null) {
                LOG.warn((Object)("hbase.status.published is true, but " + ClusterStatusPublisher.DEFAULT_STATUS_PUBLISHER_CLASS + " is not set - not publishing status"));
            } else {
                this.clusterStatusPublisherChore = new ClusterStatusPublisher(this, conf, publisherClass);
                this.getChoreService().scheduleChore(this.clusterStatusPublisherChore);
            }
        }
        if (!conf.getBoolean("hbase.testing.nocluster", false)) {
            this.setInitLatch(new CountDownLatch(1));
            this.activeMasterManager = new ActiveMasterManager(this.zooKeeper, this.serverName, this);
            int infoPort = this.putUpJettyServer();
            this.startActiveMasterManager(infoPort);
        } else {
            this.activeMasterManager = null;
        }
    }

    @Override
    public void run() {
        try {
            super.run();
        }
        finally {
            this.clusterSchemaService.stopAsync();
            try {
                this.clusterSchemaService.awaitTerminated(this.getConfiguration().getInt(HBASE_MASTER_WAIT_ON_SERVICE_IN_SECONDS, 300), TimeUnit.SECONDS);
            }
            catch (TimeoutException te) {
                LOG.warn((Object)"Failed shutdown of clusterSchemaService", (Throwable)te);
            }
            this.activeMaster = false;
        }
    }

    private int putUpJettyServer() throws IOException {
        if (!this.conf.getBoolean("hbase.master.infoserver.redirect", true)) {
            return -1;
        }
        int infoPort = this.conf.getInt("hbase.master.info.port.orig", 16010);
        if (infoPort < 0 || this.infoServer == null) {
            return -1;
        }
        if (infoPort == this.infoServer.getPort()) {
            return infoPort;
        }
        String addr = this.conf.get("hbase.master.info.bindAddress", "0.0.0.0");
        if (!Addressing.isLocalAddress(InetAddress.getByName(addr))) {
            String msg = "Failed to start redirecting jetty server. Address " + addr + " does not belong to this host. Correct configuration parameter: hbase.master.info.bindAddress";
            LOG.error((Object)msg);
            throw new IOException(msg);
        }
        this.masterJettyServer = new Server();
        ServerConnector connector = new ServerConnector(this.masterJettyServer);
        connector.setHost(addr);
        connector.setPort(infoPort);
        this.masterJettyServer.addConnector((Connector)connector);
        this.masterJettyServer.setStopAtShutdown(true);
        String redirectHostname = this.shouldUseThisHostnameInstead() ? this.useThisHostnameInstead : null;
        RedirectServlet redirect = new RedirectServlet(this.infoServer, redirectHostname);
        WebAppContext context = new WebAppContext(null, "/", null, null, null, null, 0);
        context.addServlet(new ServletHolder((Servlet)redirect), "/*");
        context.setServer(this.masterJettyServer);
        try {
            this.masterJettyServer.start();
        }
        catch (Exception e) {
            throw new IOException("Failed to start redirecting jetty server", e);
        }
        return connector.getLocalPort();
    }

    @Override
    protected Function<TableDescriptorBuilder, TableDescriptorBuilder> getMetaTableObserver() {
        return builder -> builder.setRegionReplication(this.conf.getInt("hbase.meta.replica.count", 1));
    }

    @Override
    protected void login(UserProvider user, String host) throws IOException {
        try {
            super.login(user, host);
        }
        catch (IOException ie) {
            user.login("hbase.master.keytab.file", "hbase.master.kerberos.principal", host);
        }
    }

    @Override
    protected void waitForMasterActive() {
        boolean tablesOnMaster = LoadBalancer.isTablesOnMaster(this.conf);
        while (!(tablesOnMaster && this.activeMaster || this.isStopped() || this.isAborted())) {
            this.sleeper.sleep();
        }
    }

    @VisibleForTesting
    public MasterRpcServices getMasterRpcServices() {
        return (MasterRpcServices)this.rpcServices;
    }

    public boolean balanceSwitch(boolean b) throws IOException {
        return this.getMasterRpcServices().switchBalancer(b, MasterRpcServices.BalanceSwitchMode.ASYNC);
    }

    @Override
    protected String getProcessName() {
        return MASTER;
    }

    @Override
    protected boolean canCreateBaseZNode() {
        return true;
    }

    @Override
    protected boolean canUpdateTableDescriptor() {
        return true;
    }

    @Override
    protected RSRpcServices createRpcServices() throws IOException {
        return new MasterRpcServices(this);
    }

    @Override
    protected void configureInfoServer() {
        this.infoServer.addServlet("master-status", "/master-status", MasterStatusServlet.class);
        this.infoServer.setAttribute(MASTER, this);
        if (LoadBalancer.isTablesOnMaster(this.conf)) {
            super.configureInfoServer();
        }
    }

    @Override
    protected Class<? extends HttpServlet> getDumpServlet() {
        return MasterDumpServlet.class;
    }

    @Override
    public MetricsMaster getMasterMetrics() {
        return this.metricsMaster;
    }

    void initializeZKBasedSystemTrackers() throws IOException, InterruptedException, KeeperException, CoordinatedStateException {
        this.balancer = LoadBalancerFactory.getLoadBalancer(this.conf);
        this.normalizer = RegionNormalizerFactory.getRegionNormalizer(this.conf);
        this.normalizer.setMasterServices(this);
        this.normalizer.setMasterRpcServices((MasterRpcServices)this.rpcServices);
        this.loadBalancerTracker = new LoadBalancerTracker(this.zooKeeper, this);
        this.loadBalancerTracker.start();
        this.regionNormalizerTracker = new RegionNormalizerTracker(this.zooKeeper, this);
        this.regionNormalizerTracker.start();
        this.splitOrMergeTracker = new SplitOrMergeTracker(this.zooKeeper, this.conf, this);
        this.splitOrMergeTracker.start();
        this.assignmentManager = new AssignmentManager(this);
        this.assignmentManager.start();
        this.replicationManager = new ReplicationManager(this.conf, this.zooKeeper, this);
        this.regionServerTracker = new RegionServerTracker(this.zooKeeper, this, this.serverManager);
        this.regionServerTracker.start();
        this.drainingServerTracker = new DrainingServerTracker(this.zooKeeper, this, this.serverManager);
        this.drainingServerTracker.start();
        this.maintenanceModeTracker = new MasterMaintenanceModeTracker(this.zooKeeper);
        this.maintenanceModeTracker.start();
        boolean wasUp = this.clusterStatusTracker.isClusterUp();
        if (!wasUp) {
            this.clusterStatusTracker.setClusterUp();
        }
        LOG.info((Object)("Server active/primary master=" + this.serverName + ", sessionid=0x" + Long.toHexString(this.zooKeeper.getRecoverableZooKeeper().getSessionId()) + ", setting cluster-up flag (Was=" + wasUp + ")"));
        this.snapshotManager = new SnapshotManager();
        this.mpmHost = new MasterProcedureManagerHost();
        this.mpmHost.register(this.snapshotManager);
        this.mpmHost.register(new MasterFlushTableProcedureManager());
        this.mpmHost.loadProcedures(this.conf);
        this.mpmHost.initialize(this, this.metricsMaster);
    }

    private void finishActiveMasterInitialization(MonitoredTask status) throws IOException, InterruptedException, KeeperException, CoordinatedStateException {
        this.activeMaster = true;
        Thread zombieDetector = new Thread((Runnable)new InitializationMonitor(this), "ActiveMasterInitializationMonitor-" + System.currentTimeMillis());
        zombieDetector.start();
        status.setStatus("Initializing Master file system");
        this.masterActiveTime = System.currentTimeMillis();
        this.initializeMemStoreChunkCreator();
        this.fileSystemManager = new MasterFileSystem(this);
        this.walManager = new MasterWalManager(this);
        this.tableDescriptors.setCacheOn();
        if (this.preLoadTableDescriptors) {
            status.setStatus("Pre-loading table descriptors");
            this.tableDescriptors.getAll();
        }
        status.setStatus("Publishing Cluster ID in ZooKeeper");
        ZKClusterId.setClusterId(this.zooKeeper, this.fileSystemManager.getClusterId());
        this.initLatch.countDown();
        this.serverManager = this.createServerManager(this);
        this.tableStateManager = new TableStateManager(this);
        status.setStatus("Initializing ZK system trackers");
        this.initializeZKBasedSystemTrackers();
        status.setStatus("Update TableCFs node in ZNode");
        TableCFsUpdater tableCFsUpdater = new TableCFsUpdater(this.zooKeeper, this.conf, this.clusterConnection);
        tableCFsUpdater.update();
        if (QuotaUtil.isQuotaEnabled(this.conf)) {
            this.updateConfigurationForSpaceQuotaObserver(this.conf);
        }
        status.setStatus("Initializing master coprocessors");
        this.cpHost = new MasterCoprocessorHost(this, this.conf);
        status.setStatus("Initializing master service threads");
        this.startServiceThreads();
        this.sleeper.skipSleepCycle();
        String statusStr = "Wait for region servers to report in";
        status.setStatus(statusStr);
        LOG.info((Object)status);
        this.waitForRegionServers(status);
        if (this.balancer instanceof FavoredNodesPromoter) {
            this.favoredNodesManager = new FavoredNodesManager(this);
        }
        if (LoadBalancer.isTablesOnMaster(this.conf)) {
            this.waitForServerOnline();
        }
        this.balancer.setMasterServices(this);
        this.balancer.setClusterStatus(this.getClusterStatus());
        this.balancer.initialize();
        if (this.isStopped()) {
            return;
        }
        status.setStatus("Recovering  Meta Region");
        MasterMetaBootstrap metaBootstrap = this.createMetaBootstrap(this, status);
        metaBootstrap.recoverMeta();
        if (this.isStopped()) {
            return;
        }
        if (this.favoredNodesManager != null) {
            SnapshotOfRegionAssignmentFromMeta snapshotOfRegionAssignment = new SnapshotOfRegionAssignmentFromMeta(this.getConnection());
            snapshotOfRegionAssignment.initialize();
            this.favoredNodesManager.initialize(snapshotOfRegionAssignment);
        }
        for (Map.Entry entry : ZKDataMigrator.queryForTableStates(this.getZooKeeper()).entrySet()) {
            LOG.info((Object)("Converting state from zk to new states:" + entry));
            this.tableStateManager.setTableState((TableName)entry.getKey(), (TableState.State)((Object)entry.getValue()));
        }
        ZKUtil.deleteChildrenRecursively(this.getZooKeeper(), this.getZooKeeper().znodePaths.tableZNode);
        status.setStatus("Submitting log splitting work for previously failed region servers");
        metaBootstrap.processDeadServers();
        status.setStatus("Starting assignment manager");
        this.assignmentManager.joinCluster();
        this.balancer.setClusterStatus(this.getClusterStatus());
        status.setStatus("Starting balancer and catalog janitor");
        this.clusterStatusChore = new ClusterStatusChore(this, this.balancer);
        this.getChoreService().scheduleChore(this.clusterStatusChore);
        this.balancerChore = new BalancerChore(this);
        this.getChoreService().scheduleChore(this.balancerChore);
        this.normalizerChore = new RegionNormalizerChore(this);
        this.getChoreService().scheduleChore(this.normalizerChore);
        this.catalogJanitorChore = new CatalogJanitor(this);
        this.getChoreService().scheduleChore(this.catalogJanitorChore);
        status.setStatus("Starting cluster schema service");
        this.initClusterSchemaService();
        if (this.cpHost != null) {
            try {
                this.cpHost.preMasterInitialization();
            }
            catch (IOException e) {
                LOG.error((Object)"Coprocessor preMasterInitialization() hook failed", (Throwable)e);
            }
        }
        status.markComplete("Initialization successful");
        LOG.info((Object)String.format("Master has completed initialization %.3fsec", Float.valueOf((float)(System.currentTimeMillis() - this.masterActiveTime) / 1000.0f)));
        this.masterFinishedInitializationTime = System.currentTimeMillis();
        this.configurationManager.registerObserver(this.balancer);
        this.configurationManager.registerObserver(this.hfileCleaner);
        this.setInitialized(true);
        this.assignmentManager.checkIfShouldMoveSystemRegionAsync();
        status.setStatus("Assign meta replicas");
        metaBootstrap.assignMetaReplicas();
        status.setStatus("Starting quota manager");
        this.initQuotaManager();
        if (QuotaUtil.isQuotaEnabled(this.conf)) {
            this.spaceQuotaSnapshotNotifier = this.createQuotaSnapshotNotifier();
            this.spaceQuotaSnapshotNotifier.initialize(this.getClusterConnection());
            this.quotaObserverChore = new QuotaObserverChore(this, this.getMasterMetrics());
            this.getChoreService().scheduleChore(this.quotaObserverChore);
            this.snapshotQuotaChore = new SnapshotQuotaObserverChore(this, this.getMasterMetrics());
            this.getChoreService().scheduleChore(this.snapshotQuotaChore);
        }
        this.serverManager.clearDeadServersWithSameHostNameAndPortOfOnlineServer();
        status.setStatus("Checking ZNode ACLs");
        this.zooKeeper.checkAndSetZNodeAcls();
        status.setStatus("Initializing MOB Cleaner");
        this.initMobCleaner();
        status.setStatus("Calling postStartMaster coprocessors");
        if (this.cpHost != null) {
            try {
                this.cpHost.postStartMaster();
            }
            catch (IOException ioe) {
                LOG.error((Object)"Coprocessor postStartMaster() hook failed", (Throwable)ioe);
            }
        }
        zombieDetector.interrupt();
    }

    @VisibleForTesting
    public void updateConfigurationForSpaceQuotaObserver(Configuration conf) {
        if (!conf.getBoolean("hbase.quota.remove.on.table.delete", true)) {
            return;
        }
        String[] masterCoprocs = conf.getStrings("hbase.coprocessor.master.classes");
        int length = null == masterCoprocs ? 0 : masterCoprocs.length;
        String[] updatedCoprocs = new String[length + 1];
        if (length > 0) {
            System.arraycopy(masterCoprocs, 0, updatedCoprocs, 0, masterCoprocs.length);
        }
        updatedCoprocs[length] = MasterSpaceQuotaObserver.class.getName();
        conf.setStrings("hbase.coprocessor.master.classes", updatedCoprocs);
    }

    private void initMobCleaner() {
        this.expiredMobFileCleanerChore = new ExpiredMobFileCleanerChore(this);
        this.getChoreService().scheduleChore(this.expiredMobFileCleanerChore);
        int mobCompactionPeriod = this.conf.getInt("hbase.mob.compaction.chore.period", 604800);
        if (mobCompactionPeriod > 0) {
            this.mobCompactChore = new MobCompactionChore(this, mobCompactionPeriod);
            this.getChoreService().scheduleChore(this.mobCompactChore);
        } else {
            LOG.info((Object)("The period is " + mobCompactionPeriod + " seconds, MobCompactionChore is disabled"));
        }
        this.mobCompactThread = new MasterMobCompactionThread(this);
    }

    MasterMetaBootstrap createMetaBootstrap(HMaster master, MonitoredTask status) {
        return new MasterMetaBootstrap(master, status);
    }

    ServerManager createServerManager(MasterServices master) throws IOException {
        this.setupClusterConnection();
        return new ServerManager(master);
    }

    private void waitForRegionServers(MonitoredTask status) throws IOException, InterruptedException {
        this.serverManager.waitForRegionServers(status);
        for (ServerName sn : this.regionServerTracker.getOnlineServers()) {
            if (this.serverManager.isServerOnline(sn) || !this.serverManager.checkAndRecordNewServer(sn, ServerLoad.EMPTY_SERVERLOAD)) continue;
            LOG.info((Object)("Registered server found up in zk but who has not yet reported in: " + sn));
        }
    }

    void initClusterSchemaService() throws IOException, InterruptedException {
        this.clusterSchemaService = new ClusterSchemaServiceImpl(this);
        this.clusterSchemaService.startAsync();
        try {
            this.clusterSchemaService.awaitRunning(this.getConfiguration().getInt(HBASE_MASTER_WAIT_ON_SERVICE_IN_SECONDS, 300), TimeUnit.SECONDS);
        }
        catch (TimeoutException toe) {
            throw new IOException("Timedout starting ClusterSchemaService", toe);
        }
    }

    void initQuotaManager() throws IOException {
        MasterQuotaManager quotaManager = new MasterQuotaManager(this);
        this.assignmentManager.setRegionStateListener(quotaManager);
        quotaManager.start();
        this.quotaManager = quotaManager;
    }

    SpaceQuotaSnapshotNotifier createQuotaSnapshotNotifier() {
        SpaceQuotaSnapshotNotifier notifier = SpaceQuotaSnapshotNotifierFactory.getInstance().create(this.getConfiguration());
        return notifier;
    }

    boolean isCatalogJanitorEnabled() {
        return this.catalogJanitorChore != null ? this.catalogJanitorChore.getEnabled() : false;
    }

    boolean isCleanerChoreEnabled() {
        boolean hfileCleanerFlag = true;
        boolean logCleanerFlag = true;
        if (this.hfileCleaner != null) {
            hfileCleanerFlag = this.hfileCleaner.getEnabled();
        }
        if (this.logCleaner != null) {
            logCleanerFlag = this.logCleaner.getEnabled();
        }
        return hfileCleanerFlag && logCleanerFlag;
    }

    @Override
    public TableDescriptors getTableDescriptors() {
        return this.tableDescriptors;
    }

    @Override
    public ServerManager getServerManager() {
        return this.serverManager;
    }

    @Override
    public MasterFileSystem getMasterFileSystem() {
        return this.fileSystemManager;
    }

    @Override
    public MasterWalManager getMasterWalManager() {
        return this.walManager;
    }

    @Override
    public TableStateManager getTableStateManager() {
        return this.tableStateManager;
    }

    private void startServiceThreads() throws IOException {
        this.service.startExecutorService(ExecutorType.MASTER_OPEN_REGION, this.conf.getInt("hbase.master.executor.openregion.threads", 5));
        this.service.startExecutorService(ExecutorType.MASTER_CLOSE_REGION, this.conf.getInt("hbase.master.executor.closeregion.threads", 5));
        this.service.startExecutorService(ExecutorType.MASTER_SERVER_OPERATIONS, this.conf.getInt("hbase.master.executor.serverops.threads", 5));
        this.service.startExecutorService(ExecutorType.MASTER_META_SERVER_OPERATIONS, this.conf.getInt("hbase.master.executor.meta.serverops.threads", 5));
        this.service.startExecutorService(ExecutorType.M_LOG_REPLAY_OPS, this.conf.getInt("hbase.master.executor.logreplayops.threads", 10));
        this.service.startExecutorService(ExecutorType.MASTER_TABLE_OPERATIONS, 1);
        this.startProcedureExecutor();
        int cleanerInterval = this.conf.getInt("hbase.master.cleaner.interval", 60000);
        this.logCleaner = new LogCleaner(cleanerInterval, (Stoppable)this, this.conf, this.getMasterWalManager().getFileSystem(), this.getMasterWalManager().getOldLogDir());
        this.getChoreService().scheduleChore(this.logCleaner);
        Path archiveDir = HFileArchiveUtil.getArchivePath(this.conf);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(MASTER, this);
        this.hfileCleaner = new HFileCleaner(cleanerInterval, this, this.conf, this.getMasterFileSystem().getFileSystem(), archiveDir, params);
        this.getChoreService().scheduleChore(this.hfileCleaner);
        this.serviceStarted = true;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)"Started service threads");
        }
        if (this.conf.getClass("hbase.region.replica.replication.replicationQueues.class", ReplicationFactory.defaultReplicationQueueClass) == ReplicationQueuesZKImpl.class) {
            try {
                this.replicationZKNodeCleanerChore = new ReplicationZKNodeCleanerChore(this, cleanerInterval, new ReplicationZKNodeCleaner(this.conf, this.getZooKeeper(), this));
                this.getChoreService().scheduleChore(this.replicationZKNodeCleanerChore);
            }
            catch (Exception e) {
                LOG.error((Object)"start replicationZKNodeCleanerChore failed", (Throwable)e);
            }
        }
        this.replicationMetaCleaner = new ReplicationMetaCleaner(this, (Stoppable)this, cleanerInterval);
        this.getChoreService().scheduleChore(this.replicationMetaCleaner);
    }

    @Override
    protected void stopServiceThreads() {
        if (this.masterJettyServer != null) {
            LOG.info((Object)"Stopping master jetty server");
            try {
                this.masterJettyServer.stop();
            }
            catch (Exception e) {
                LOG.error((Object)"Failed to stop master jetty server", (Throwable)e);
            }
        }
        super.stopServiceThreads();
        this.stopChores();
        if (!this.isAborted() && this.serverManager != null && this.serverManager.isClusterShutdown()) {
            this.serverManager.letRegionServersShutdown();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Stopping service threads");
        }
        if (this.logCleaner != null) {
            this.logCleaner.cancel(true);
        }
        if (this.hfileCleaner != null) {
            this.hfileCleaner.cancel(true);
        }
        if (this.replicationZKNodeCleanerChore != null) {
            this.replicationZKNodeCleanerChore.cancel(true);
        }
        if (this.replicationMetaCleaner != null) {
            this.replicationMetaCleaner.cancel(true);
        }
        if (this.quotaManager != null) {
            this.quotaManager.stop();
        }
        if (this.activeMasterManager != null) {
            this.activeMasterManager.stop();
        }
        if (this.serverManager != null) {
            this.serverManager.stop();
        }
        if (this.assignmentManager != null) {
            this.assignmentManager.stop();
        }
        this.stopProcedureExecutor();
        if (this.walManager != null) {
            this.walManager.stop();
        }
        if (this.fileSystemManager != null) {
            this.fileSystemManager.stop();
        }
        if (this.mpmHost != null) {
            this.mpmHost.stop("server shutting down.");
        }
    }

    private void startProcedureExecutor() throws IOException {
        MasterProcedureEnv procEnv = new MasterProcedureEnv(this);
        Path walDir = new Path(FSUtils.getWALRootDir(this.conf), "MasterProcWALs");
        Path walArchiveDir = new Path(walDir, "archive");
        FileSystem walFs = walDir.getFileSystem(this.conf);
        if (!walFs.exists(walDir) && !walFs.mkdirs(walDir)) {
            throw new IOException("Unable to mkdir " + walDir);
        }
        FSUtils.setStoragePolicy(walFs, this.conf, walDir, "hbase.wal.storage.policy", "HOT");
        this.procedureStore = new WALProcedureStore(this.conf, walDir.getFileSystem(this.conf), walDir, walArchiveDir, new MasterProcedureEnv.WALStoreLeaseRecovery(this));
        this.procedureStore.registerListener(new MasterProcedureEnv.MasterProcedureStoreListener(this));
        MasterProcedureScheduler procedureScheduler = procEnv.getProcedureScheduler();
        this.procedureExecutor = new ProcedureExecutor<MasterProcedureEnv>(this.conf, procEnv, this.procedureStore, procedureScheduler);
        this.configurationManager.registerObserver(procEnv);
        int numThreads = this.conf.getInt("hbase.master.procedure.threads", Math.max(Runtime.getRuntime().availableProcessors(), 16));
        boolean abortOnCorruption = this.conf.getBoolean("hbase.procedure.abort.on.corruption", false);
        this.procedureStore.start(numThreads);
        this.procedureExecutor.start(numThreads, abortOnCorruption);
        procEnv.getRemoteDispatcher().start();
    }

    private void stopProcedureExecutor() {
        if (this.procedureExecutor != null) {
            this.configurationManager.deregisterObserver(this.procedureExecutor.getEnvironment());
            this.procedureExecutor.getEnvironment().getRemoteDispatcher().stop();
            this.procedureExecutor.stop();
            this.procedureExecutor = null;
        }
        if (this.procedureStore != null) {
            this.procedureStore.stop(this.isAborted());
            this.procedureStore = null;
        }
    }

    private void stopChores() {
        if (this.expiredMobFileCleanerChore != null) {
            this.expiredMobFileCleanerChore.cancel(true);
        }
        if (this.mobCompactChore != null) {
            this.mobCompactChore.cancel(true);
        }
        if (this.balancerChore != null) {
            this.balancerChore.cancel(true);
        }
        if (this.normalizerChore != null) {
            this.normalizerChore.cancel(true);
        }
        if (this.clusterStatusChore != null) {
            this.clusterStatusChore.cancel(true);
        }
        if (this.catalogJanitorChore != null) {
            this.catalogJanitorChore.cancel(true);
        }
        if (this.clusterStatusPublisherChore != null) {
            this.clusterStatusPublisherChore.cancel(true);
        }
        if (this.mobCompactThread != null) {
            this.mobCompactThread.close();
        }
        if (this.quotaObserverChore != null) {
            this.quotaObserverChore.cancel();
        }
        if (this.snapshotQuotaChore != null) {
            this.snapshotQuotaChore.cancel();
        }
    }

    InetAddress getRemoteInetAddress(int port, long serverStartCode) throws UnknownHostException {
        InetSocketAddress isa;
        InetAddress ia = RpcServer.getRemoteIp();
        if (ia == null && serverStartCode == this.startcode && (isa = this.rpcServices.getSocketAddress()) != null && isa.getPort() == port) {
            ia = isa.getAddress();
        }
        return ia;
    }

    private int getMaxBalancingTime() {
        int maxBalancingTime = this.getConfiguration().getInt("hbase.balancer.max.balancing", -1);
        if (maxBalancingTime == -1) {
            maxBalancingTime = this.getConfiguration().getInt("hbase.balancer.period", 300000);
        }
        return maxBalancingTime;
    }

    private int getMaxRegionsInTransition() {
        int numRegions = this.assignmentManager.getRegionStates().getRegionAssignments().size();
        return Math.max((int)Math.floor((double)numRegions * this.maxRitPercent), 1);
    }

    private void balanceThrottling(long nextBalanceStartTime, int maxRegionsInTransition, long cutoffTime) {
        boolean interrupted = false;
        while (!interrupted && System.currentTimeMillis() < nextBalanceStartTime && this.assignmentManager.getRegionStates().hasRegionsInTransition()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ie) {
                interrupted = true;
            }
        }
        while (!interrupted && maxRegionsInTransition > 0 && this.assignmentManager.getRegionStates().getRegionsInTransition().size() >= maxRegionsInTransition && System.currentTimeMillis() <= cutoffTime) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ie) {
                interrupted = true;
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    public boolean balance() throws IOException {
        return this.balance(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean balance(boolean force) throws IOException {
        if (!this.isInitialized()) {
            LOG.debug((Object)"Master has not been initialized, don't run balancer.");
            return false;
        }
        if (this.isInMaintenanceMode()) {
            LOG.info((Object)"Master is in maintenanceMode mode, don't run balancer.");
            return false;
        }
        int maxRegionsInTransition = this.getMaxRegionsInTransition();
        LoadBalancer loadBalancer = this.balancer;
        synchronized (loadBalancer) {
            if (!this.loadBalancerTracker.isBalancerOn()) {
                return false;
            }
            if (this.assignmentManager.hasRegionsInTransition()) {
                List<RegionStates.RegionStateNode> regionsInTransition = this.assignmentManager.getRegionsInTransition();
                boolean metaInTransition = this.assignmentManager.isMetaRegionInTransition();
                String prefix = force && !metaInTransition ? "R" : "Not r";
                List<RegionStates.RegionStateNode> toPrint = regionsInTransition;
                int max = 5;
                boolean truncated = false;
                if (regionsInTransition.size() > max) {
                    toPrint = regionsInTransition.subList(0, max);
                    truncated = true;
                }
                LOG.info((Object)(prefix + "unning balancer because " + regionsInTransition.size() + " region(s) in transition: " + toPrint + (truncated ? "(truncated list)" : "")));
                if (!force || metaInTransition) {
                    return false;
                }
            }
            if (this.serverManager.areDeadServersInProgress()) {
                LOG.info((Object)("Not running balancer because processing dead regionserver(s): " + this.serverManager.getDeadServers()));
                return false;
            }
            if (this.cpHost != null) {
                try {
                    if (this.cpHost.preBalance()) {
                        LOG.debug((Object)"Coprocessor bypassing balancer request");
                        return false;
                    }
                }
                catch (IOException ioe) {
                    LOG.error((Object)"Error invoking master coprocessor preBalance()", (Throwable)ioe);
                    return false;
                }
            }
            Map<TableName, Map<ServerName, List<HRegionInfo>>> assignmentsByTable = this.assignmentManager.getRegionStates().getAssignmentsByTable();
            ArrayList<RegionPlan> plans = new ArrayList<RegionPlan>();
            this.balancer.setClusterStatus(this.getClusterStatus());
            this.balancer.setClusterLoad(this.assignmentManager.getRegionStates().getAssignmentsByTable());
            for (Map.Entry<TableName, Map<ServerName, List<HRegionInfo>>> e : assignmentsByTable.entrySet()) {
                List<RegionPlan> partialPlans = this.balancer.balanceCluster(e.getKey(), e.getValue());
                if (partialPlans == null) continue;
                plans.addAll(partialPlans);
            }
            long balanceStartTime = System.currentTimeMillis();
            long cutoffTime = balanceStartTime + (long)this.maxBlancingTime;
            int rpCount = 0;
            if (plans != null && !plans.isEmpty()) {
                int balanceInterval = this.maxBlancingTime / plans.size();
                LOG.info((Object)("Balancer plans size is " + plans.size() + ", the balance interval is " + balanceInterval + " ms, and the max number regions in transition is " + maxRegionsInTransition));
                for (RegionPlan plan : plans) {
                    LOG.info((Object)("balance " + plan));
                    this.assignmentManager.moveAsync(plan);
                    this.balanceThrottling(balanceStartTime + (long)(++rpCount * balanceInterval), maxRegionsInTransition, cutoffTime);
                    if (rpCount >= plans.size() || System.currentTimeMillis() <= cutoffTime) continue;
                    LOG.debug((Object)("No more balancing till next balance run; maxBalanceTime=" + this.maxBlancingTime));
                    break;
                }
            }
            if (this.cpHost != null) {
                try {
                    this.cpHost.postBalance(rpCount < plans.size() ? plans.subList(0, rpCount) : plans);
                }
                catch (IOException ioe) {
                    LOG.error((Object)"Error invoking master coprocessor postBalance()", (Throwable)ioe);
                }
            }
        }
        return true;
    }

    @Override
    @VisibleForTesting
    public RegionNormalizer getRegionNormalizer() {
        return this.normalizer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean normalizeRegions() throws IOException {
        if (!this.isInitialized()) {
            LOG.debug((Object)"Master has not been initialized, don't run region normalizer.");
            return false;
        }
        if (this.isInMaintenanceMode()) {
            LOG.info((Object)"Master is in maintenance mode, don't run region normalizer.");
            return false;
        }
        if (!this.regionNormalizerTracker.isNormalizerOn()) {
            LOG.debug((Object)"Region normalization is disabled, don't run region normalizer.");
            return false;
        }
        RegionNormalizer regionNormalizer = this.normalizer;
        synchronized (regionNormalizer) {
            ArrayList<TableName> allEnabledTables = new ArrayList<TableName>(this.tableStateManager.getTablesInStates(TableState.State.ENABLED));
            Collections.shuffle(allEnabledTables);
            for (TableName table : allEnabledTables) {
                if (this.isInMaintenanceMode()) {
                    LOG.debug((Object)"Master is in maintenance mode, stop running region normalizer.");
                    return false;
                }
                TableDescriptor tblDesc = this.getTableDescriptors().get(table);
                if (table.isSystemTable() || tblDesc != null && !tblDesc.isNormalizationEnabled()) {
                    LOG.debug((Object)("Skipping normalization for table: " + table + ", as it's either system table or doesn't have auto normalization turned on"));
                    continue;
                }
                List<NormalizationPlan> plans = this.normalizer.computePlanForTable(table);
                if (plans == null) continue;
                for (NormalizationPlan plan : plans) {
                    plan.execute(this.clusterConnection.getAdmin());
                    if (plan.getType() == NormalizationPlan.PlanType.SPLIT) {
                        ++this.splitPlanCount;
                        continue;
                    }
                    if (plan.getType() != NormalizationPlan.PlanType.MERGE) continue;
                    ++this.mergePlanCount;
                }
            }
        }
        return true;
    }

    @Override
    public String getClientIdAuditPrefix() {
        return "Client=" + RpcServer.getRequestUserName() + "/" + RpcServer.getRemoteAddress();
    }

    public void setCatalogJanitorEnabled(boolean b) {
        this.catalogJanitorChore.setEnabled(b);
    }

    @Override
    public long mergeRegions(final HRegionInfo[] regionsToMerge, final boolean forcible, long nonceGroup, long nonce) throws IOException {
        this.checkInitialized();
        assert (regionsToMerge.length == 2);
        TableName tableName = regionsToMerge[0].getTable();
        if (tableName == null || regionsToMerge[1].getTable() == null) {
            throw new UnknownRegionException("Can't merge regions without table associated");
        }
        if (!tableName.equals(regionsToMerge[1].getTable())) {
            throw new IOException("Cannot merge regions from two different tables " + regionsToMerge[0].getTable() + " and " + regionsToMerge[1].getTable());
        }
        if (regionsToMerge[0].compareTo(regionsToMerge[1]) == 0) {
            throw new MergeRegionException("Cannot merge a region to itself " + regionsToMerge[0] + ", " + regionsToMerge[1]);
        }
        return MasterProcedureUtil.submitProcedure(new MasterProcedureUtil.NonceProcedureRunnable(this, nonceGroup, nonce){

            @Override
            protected void run() throws IOException {
                this.getMaster().getMasterCoprocessorHost().preMergeRegions(regionsToMerge);
                LOG.info((Object)(HMaster.this.getClientIdAuditPrefix() + " Merge regions " + regionsToMerge[0].getEncodedName() + " and " + regionsToMerge[1].getEncodedName()));
                this.submitProcedure(new MergeTableRegionsProcedure((MasterProcedureEnv)HMaster.this.procedureExecutor.getEnvironment(), regionsToMerge, forcible));
                this.getMaster().getMasterCoprocessorHost().postMergeRegions(regionsToMerge);
            }

            @Override
            protected String getDescription() {
                return "MergeTableProcedure";
            }
        });
    }

    @Override
    public long splitRegion(final HRegionInfo regionInfo, final byte[] splitRow, long nonceGroup, long nonce) throws IOException {
        this.checkInitialized();
        return MasterProcedureUtil.submitProcedure(new MasterProcedureUtil.NonceProcedureRunnable(this, nonceGroup, nonce){

            @Override
            protected void run() throws IOException {
                this.getMaster().getMasterCoprocessorHost().preSplitRegion(regionInfo.getTable(), splitRow);
                LOG.info((Object)(HMaster.this.getClientIdAuditPrefix() + " split " + regionInfo.getRegionNameAsString()));
                this.submitProcedure(HMaster.this.getAssignmentManager().createSplitProcedure(regionInfo, splitRow));
            }

            @Override
            protected String getDescription() {
                return "SplitTableProcedure";
            }
        });
    }

    @VisibleForTesting
    public void move(byte[] encodedRegionName, byte[] destServerName) throws HBaseIOException {
        ServerName dest;
        List<Object> exclude;
        RegionState regionState = this.assignmentManager.getRegionStates().getRegionState(Bytes.toString(encodedRegionName));
        if (regionState == null) {
            throw new UnknownRegionException(Bytes.toStringBinary(encodedRegionName));
        }
        HRegionInfo hri = regionState.getRegion();
        List<Object> list = exclude = hri.isSystemTable() ? this.assignmentManager.getExcludedServersForSystemTable() : new ArrayList(1);
        if (destServerName != null && exclude.contains(ServerName.valueOf(Bytes.toString(destServerName)))) {
            LOG.info((Object)(Bytes.toString(encodedRegionName) + " can not move to " + Bytes.toString(destServerName) + " because the server is in exclude list"));
            destServerName = null;
        }
        if (destServerName == null || destServerName.length == 0) {
            LOG.info((Object)"Passed destination servername is null/empty so choosing a server at random");
            exclude.add(regionState.getServerName());
            List<ServerName> destServers = this.serverManager.createDestinationServersList(exclude);
            dest = this.balancer.randomAssignment(hri, destServers);
            if (dest == null) {
                LOG.debug((Object)("Unable to determine a plan to assign " + hri));
                return;
            }
        } else {
            ServerName candidate = ServerName.valueOf(Bytes.toString(destServerName));
            dest = this.balancer.randomAssignment(hri, Lists.newArrayList(candidate));
            if (dest == null) {
                LOG.debug((Object)("Unable to determine a plan to assign " + hri));
                return;
            }
            if (dest.equals(this.serverName) && this.balancer instanceof BaseLoadBalancer && !((BaseLoadBalancer)this.balancer).shouldBeOnMaster(hri)) {
                LOG.debug((Object)("Skipping move of region " + hri.getRegionNameAsString() + " to avoid unnecessary region moving later by load balancer, because it should not be on master"));
                return;
            }
        }
        if (dest.equals(regionState.getServerName())) {
            LOG.debug((Object)("Skipping move of region " + hri.getRegionNameAsString() + " because region already assigned to the same server " + dest + "."));
            return;
        }
        RegionPlan rp = new RegionPlan(hri, regionState.getServerName(), dest);
        assert (rp.getDestination() != null) : rp.toString() + " " + dest;
        assert (rp.getSource() != null) : rp.toString();
        try {
            this.checkInitialized();
            if (this.cpHost != null && this.cpHost.preMove(hri, rp.getSource(), rp.getDestination())) {
                return;
            }
            this.serverManager.sendRegionWarmup(rp.getDestination(), hri);
            LOG.info((Object)(this.getClientIdAuditPrefix() + " move " + rp + ", running balancer"));
            Future<byte[]> future = this.assignmentManager.moveAsync(rp);
            try {
                future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new HBaseIOException(e);
            }
            if (this.cpHost != null) {
                this.cpHost.postMove(hri, rp.getSource(), rp.getDestination());
            }
        }
        catch (IOException ioe) {
            if (ioe instanceof HBaseIOException) {
                throw (HBaseIOException)ioe;
            }
            throw new HBaseIOException(ioe);
        }
    }

    @Override
    public long createTable(final TableDescriptor tableDescriptor, byte[][] splitKeys, long nonceGroup, long nonce) throws IOException {
        this.checkInitialized();
        String namespace = tableDescriptor.getTableName().getNamespaceAsString();
        this.clusterSchemaService.getNamespace(namespace);
        final HRegionInfo[] newRegions = ModifyRegionUtils.createHRegionInfos(tableDescriptor, splitKeys);
        this.sanityCheckTableDescriptor(tableDescriptor);
        return MasterProcedureUtil.submitProcedure(new MasterProcedureUtil.NonceProcedureRunnable(this, nonceGroup, nonce){

            @Override
            protected void run() throws IOException {
                this.getMaster().getMasterCoprocessorHost().preCreateTable(tableDescriptor, newRegions);
                LOG.info((Object)(HMaster.this.getClientIdAuditPrefix() + " create " + tableDescriptor));
                ProcedurePrepareLatch latch = ProcedurePrepareLatch.createLatch();
                this.submitProcedure(new CreateTableProcedure((MasterProcedureEnv)HMaster.this.procedureExecutor.getEnvironment(), tableDescriptor, newRegions, latch));
                latch.await();
                this.getMaster().getMasterCoprocessorHost().postCreateTable(tableDescriptor, newRegions);
            }

            @Override
            protected String getDescription() {
                return "CreateTableProcedure";
            }
        });
    }

    @Override
    public long createSystemTable(TableDescriptor tableDescriptor) throws IOException {
        if (this.isStopped()) {
            throw new MasterNotRunningException();
        }
        TableName tableName = tableDescriptor.getTableName();
        if (!tableName.isSystemTable()) {
            throw new IllegalArgumentException("Only system table creation can use this createSystemTable API");
        }
        HRegionInfo[] newRegions = ModifyRegionUtils.createHRegionInfos(tableDescriptor, null);
        LOG.info((Object)(this.getClientIdAuditPrefix() + " create " + tableDescriptor));
        long procId = this.procedureExecutor.submitProcedure(new CreateTableProcedure(this.procedureExecutor.getEnvironment(), tableDescriptor, newRegions));
        return procId;
    }

    private void sanityCheckTableDescriptor(TableDescriptor htd) throws IOException {
        String message;
        String tableVal;
        String CONF_KEY = "hbase.table.sanity.checks";
        boolean logWarn = false;
        if (!this.conf.getBoolean("hbase.table.sanity.checks", true)) {
            logWarn = true;
        }
        if ((tableVal = htd.getValue("hbase.table.sanity.checks")) != null && !Boolean.valueOf(tableVal).booleanValue()) {
            logWarn = true;
        }
        long maxFileSizeLowerLimit = 0x200000L;
        long maxFileSize = htd.getMaxFileSize();
        if (maxFileSize < 0L) {
            maxFileSize = this.conf.getLong("hbase.hregion.max.filesize", maxFileSizeLowerLimit);
        }
        if (maxFileSize < this.conf.getLong("hbase.hregion.max.filesize.limit", maxFileSizeLowerLimit)) {
            String message2 = "MAX_FILESIZE for table descriptor or \"hbase.hregion.max.filesize\" (" + maxFileSize + ") is too small, which might cause over splitting into unmanageable number of regions.";
            HMaster.warnOrThrowExceptionForFailure(logWarn, "hbase.table.sanity.checks", message2, null);
        }
        long flushSizeLowerLimit = 0x100000L;
        long flushSize = htd.getMemStoreFlushSize();
        if (flushSize < 0L) {
            flushSize = this.conf.getLong("hbase.hregion.memstore.flush.size", flushSizeLowerLimit);
        }
        if (flushSize < this.conf.getLong("hbase.hregion.memstore.flush.size.limit", flushSizeLowerLimit)) {
            message = "MEMSTORE_FLUSHSIZE for table descriptor or \"hbase.hregion.memstore.flush.size\" (" + flushSize + ") is too small, which might cause very frequent flushing.";
            HMaster.warnOrThrowExceptionForFailure(logWarn, "hbase.table.sanity.checks", message, null);
        }
        try {
            this.checkClassLoading(this.conf, htd);
        }
        catch (Exception ex) {
            HMaster.warnOrThrowExceptionForFailure(logWarn, "hbase.table.sanity.checks", ex.getMessage(), null);
        }
        try {
            this.checkCompression(htd);
        }
        catch (IOException e) {
            HMaster.warnOrThrowExceptionForFailure(logWarn, "hbase.table.sanity.checks", e.getMessage(), e);
        }
        try {
            this.checkEncryption(this.conf, htd);
        }
        catch (IOException e) {
            HMaster.warnOrThrowExceptionForFailure(logWarn, "hbase.table.sanity.checks", e.getMessage(), e);
        }
        try {
            this.checkCompactionPolicy(this.conf, htd);
        }
        catch (IOException e) {
            HMaster.warnOrThrowExceptionForFailure(false, "hbase.table.sanity.checks", e.getMessage(), e);
        }
        if (htd.getColumnFamilyCount() == 0) {
            message = "Table should have at least one column family.";
            HMaster.warnOrThrowExceptionForFailure(logWarn, "hbase.table.sanity.checks", message, null);
        }
        for (ColumnFamilyDescriptor hcd : htd.getColumnFamilies()) {
            String message3;
            if (hcd.getTimeToLive() <= 0) {
                message3 = "TTL for column family " + hcd.getNameAsString() + " must be positive.";
                HMaster.warnOrThrowExceptionForFailure(logWarn, "hbase.table.sanity.checks", message3, null);
            }
            if (hcd.getBlocksize() < 1024 || hcd.getBlocksize() > 0x1000000) {
                message3 = "Block size for column family " + hcd.getNameAsString() + "  must be between 1K and 16MB.";
                HMaster.warnOrThrowExceptionForFailure(logWarn, "hbase.table.sanity.checks", message3, null);
            }
            if (hcd.getMinVersions() < 0) {
                message3 = "Min versions for column family " + hcd.getNameAsString() + "  must be positive.";
                HMaster.warnOrThrowExceptionForFailure(logWarn, "hbase.table.sanity.checks", message3, null);
            }
            if (hcd.getMinVersions() > hcd.getMaxVersions()) {
                message3 = "Min versions for column family " + hcd.getNameAsString() + " must be less than the Max versions.";
                HMaster.warnOrThrowExceptionForFailure(logWarn, "hbase.table.sanity.checks", message3, null);
            }
            this.checkReplicationScope(hcd);
            if (hcd.getDFSReplication() >= 0) continue;
            message3 = "HFile Replication for column family " + hcd.getNameAsString() + "  must be greater than zero.";
            HMaster.warnOrThrowExceptionForFailure(logWarn, "hbase.table.sanity.checks", message3, null);
        }
    }

    private void checkReplicationScope(ColumnFamilyDescriptor hcd) throws IOException {
        WALProtos.ScopeType scop = WALProtos.ScopeType.valueOf(hcd.getScope());
        if (scop == null) {
            String message = "Replication scope for column family " + hcd.getNameAsString() + " is " + hcd.getScope() + " which is invalid.";
            LOG.error((Object)message);
            throw new DoNotRetryIOException(message);
        }
    }

    private void checkCompactionPolicy(Configuration conf, TableDescriptor htd) throws IOException {
        String className = htd.getValue("hbase.hstore.defaultengine.compactionpolicy.class");
        if (className == null) {
            className = conf.get("hbase.hstore.defaultengine.compactionpolicy.class", ExploringCompactionPolicy.class.getName());
        }
        int blockingFileCount = 10;
        String sv = htd.getValue("hbase.hstore.blockingStoreFiles");
        blockingFileCount = sv != null ? Integer.parseInt(sv) : conf.getInt("hbase.hstore.blockingStoreFiles", blockingFileCount);
        for (ColumnFamilyDescriptor hcd : htd.getColumnFamilies()) {
            String compactionPolicy = hcd.getConfigurationValue("hbase.hstore.defaultengine.compactionpolicy.class");
            if (compactionPolicy == null) {
                compactionPolicy = className;
            }
            if (!compactionPolicy.equals(FIFOCompactionPolicy.class.getName())) continue;
            String message = null;
            if (hcd.getTimeToLive() == Integer.MAX_VALUE) {
                message = "Default TTL is not supported for FIFO compaction";
                throw new IOException(message);
            }
            if (hcd.getMinVersions() > 0) {
                message = "MIN_VERSION > 0 is not supported for FIFO compaction";
                throw new IOException(message);
            }
            sv = hcd.getConfigurationValue("hbase.hstore.blockingStoreFiles");
            if (sv != null) {
                blockingFileCount = Integer.parseInt(sv);
            }
            if (blockingFileCount >= 1000) continue;
            message = "Blocking file count 'hbase.hstore.blockingStoreFiles' " + blockingFileCount + " is below recommended minimum of 1000 for column family " + hcd.getNameAsString();
            throw new IOException(message);
        }
    }

    private static void warnOrThrowExceptionForFailure(boolean logWarn, String confKey, String message, Exception cause) throws IOException {
        if (!logWarn) {
            throw new DoNotRetryIOException(message + " Set " + confKey + " to false at conf or table descriptor if you want to bypass sanity checks", cause);
        }
        LOG.warn((Object)message);
    }

    private void startActiveMasterManager(int infoPort) throws KeeperException {
        String backupZNode = ZKUtil.joinZNode(this.zooKeeper.znodePaths.backupMasterAddressesZNode, this.serverName.toString());
        LOG.info((Object)("Adding backup master ZNode " + backupZNode));
        if (!MasterAddressTracker.setMasterAddress(this.zooKeeper, backupZNode, this.serverName, infoPort)) {
            LOG.warn((Object)("Failed create of " + backupZNode + " by " + this.serverName));
        }
        this.activeMasterManager.setInfoPort(infoPort);
        Threads.setDaemonThreadRunning(new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                int timeout = HMaster.this.conf.getInt("zookeeper.session.timeout", 90000);
                if (HMaster.this.conf.getBoolean("hbase.master.backup", false)) {
                    LOG.debug((Object)"HMaster started in backup mode. Stalling until master znode is written.");
                    while (!HMaster.this.activeMasterManager.hasActiveMaster()) {
                        LOG.debug((Object)"Waiting for master address ZNode to be written (Also watching cluster state node)");
                        Threads.sleep(timeout);
                    }
                }
                MonitoredTask status = TaskMonitor.get().createStatus("Master startup");
                status.setDescription("Master startup");
                try {
                    if (HMaster.this.activeMasterManager.blockUntilBecomingActiveMaster(timeout, status)) {
                        HMaster.this.finishActiveMasterInitialization(status);
                    }
                }
                catch (Throwable t) {
                    status.setStatus("Failed to become active: " + t.getMessage());
                    LOG.fatal((Object)"Failed to become active master", t);
                    if (t instanceof NoClassDefFoundError && t.getMessage().contains("org/apache/hadoop/hdfs/protocol/HdfsConstants$SafeModeAction")) {
                        HMaster.this.abort("HBase is having a problem with its Hadoop jars.  You may need to recompile HBase against Hadoop version " + VersionInfo.getVersion() + " or change your hadoop jars to start properly", t);
                    } else {
                        HMaster.this.abort("Unhandled exception. Starting shutdown.", t);
                    }
                }
                finally {
                    status.cleanup();
                }
            }
        }, this.getServerName().toShortString() + ".masterManager"));
    }

    private void checkCompression(TableDescriptor htd) throws IOException {
        if (!this.masterCheckCompression) {
            return;
        }
        for (ColumnFamilyDescriptor hcd : htd.getColumnFamilies()) {
            this.checkCompression(hcd);
        }
    }

    private void checkCompression(ColumnFamilyDescriptor hcd) throws IOException {
        if (!this.masterCheckCompression) {
            return;
        }
        CompressionTest.testCompression(hcd.getCompressionType());
        CompressionTest.testCompression(hcd.getCompactionCompressionType());
    }

    private void checkEncryption(Configuration conf, TableDescriptor htd) throws IOException {
        if (!this.masterCheckEncryption) {
            return;
        }
        for (ColumnFamilyDescriptor hcd : htd.getColumnFamilies()) {
            this.checkEncryption(conf, hcd);
        }
    }

    private void checkEncryption(Configuration conf, ColumnFamilyDescriptor hcd) throws IOException {
        if (!this.masterCheckEncryption) {
            return;
        }
        EncryptionTest.testEncryption(conf, hcd.getEncryptionType(), hcd.getEncryptionKey());
    }

    private void checkClassLoading(Configuration conf, TableDescriptor htd) throws IOException {
        RegionSplitPolicy.getSplitPolicyClass(htd, conf);
        RegionCoprocessorHost.testTableCoprocessorAttrs(conf, htd);
    }

    private static boolean isCatalogTable(TableName tableName) {
        return tableName.equals(TableName.META_TABLE_NAME);
    }

    @Override
    public long deleteTable(final TableName tableName, long nonceGroup, long nonce) throws IOException {
        this.checkInitialized();
        return MasterProcedureUtil.submitProcedure(new MasterProcedureUtil.NonceProcedureRunnable(this, nonceGroup, nonce){

            @Override
            protected void run() throws IOException {
                this.getMaster().getMasterCoprocessorHost().preDeleteTable(tableName);
                LOG.info((Object)(HMaster.this.getClientIdAuditPrefix() + " delete " + tableName));
                ProcedurePrepareLatch latch = ProcedurePrepareLatch.createLatch();
                this.submitProcedure(new DeleteTableProcedure((MasterProcedureEnv)HMaster.this.procedureExecutor.getEnvironment(), tableName, latch));
                latch.await();
                this.getMaster().getMasterCoprocessorHost().postDeleteTable(tableName);
            }

            @Override
            protected String getDescription() {
                return "DeleteTableProcedure";
            }
        });
    }

    @Override
    public long truncateTable(final TableName tableName, final boolean preserveSplits, long nonceGroup, long nonce) throws IOException {
        this.checkInitialized();
        return MasterProcedureUtil.submitProcedure(new MasterProcedureUtil.NonceProcedureRunnable(this, nonceGroup, nonce){

            @Override
            protected void run() throws IOException {
                this.getMaster().getMasterCoprocessorHost().preTruncateTable(tableName);
                LOG.info((Object)(HMaster.this.getClientIdAuditPrefix() + " truncate " + tableName));
                ProcedurePrepareLatch latch = ProcedurePrepareLatch.createLatch(2, 0);
                this.submitProcedure(new TruncateTableProcedure((MasterProcedureEnv)HMaster.this.procedureExecutor.getEnvironment(), tableName, preserveSplits, latch));
                latch.await();
                this.getMaster().getMasterCoprocessorHost().postTruncateTable(tableName);
            }

            @Override
            protected String getDescription() {
                return "TruncateTableProcedure";
            }
        });
    }

    @Override
    public long addColumn(final TableName tableName, final ColumnFamilyDescriptor columnDescriptor, long nonceGroup, long nonce) throws IOException {
        this.checkInitialized();
        this.checkCompression(columnDescriptor);
        this.checkEncryption(this.conf, columnDescriptor);
        this.checkReplicationScope(columnDescriptor);
        return MasterProcedureUtil.submitProcedure(new MasterProcedureUtil.NonceProcedureRunnable(this, nonceGroup, nonce){

            @Override
            protected void run() throws IOException {
                if (this.getMaster().getMasterCoprocessorHost().preAddColumn(tableName, columnDescriptor)) {
                    return;
                }
                ProcedurePrepareLatch latch = ProcedurePrepareLatch.createLatch(2, 0);
                this.submitProcedure(new AddColumnFamilyProcedure((MasterProcedureEnv)HMaster.this.procedureExecutor.getEnvironment(), tableName, columnDescriptor, latch));
                latch.await();
                this.getMaster().getMasterCoprocessorHost().postAddColumn(tableName, columnDescriptor);
            }

            @Override
            protected String getDescription() {
                return "AddColumnFamilyProcedure";
            }
        });
    }

    @Override
    public long modifyColumn(final TableName tableName, final ColumnFamilyDescriptor descriptor, long nonceGroup, long nonce) throws IOException {
        this.checkInitialized();
        this.checkCompression(descriptor);
        this.checkEncryption(this.conf, descriptor);
        this.checkReplicationScope(descriptor);
        return MasterProcedureUtil.submitProcedure(new MasterProcedureUtil.NonceProcedureRunnable(this, nonceGroup, nonce){

            @Override
            protected void run() throws IOException {
                if (this.getMaster().getMasterCoprocessorHost().preModifyColumn(tableName, descriptor)) {
                    return;
                }
                LOG.info((Object)(HMaster.this.getClientIdAuditPrefix() + " modify " + descriptor));
                ProcedurePrepareLatch latch = ProcedurePrepareLatch.createLatch(2, 0);
                this.submitProcedure(new ModifyColumnFamilyProcedure((MasterProcedureEnv)HMaster.this.procedureExecutor.getEnvironment(), tableName, descriptor, latch));
                latch.await();
                this.getMaster().getMasterCoprocessorHost().postModifyColumn(tableName, descriptor);
            }

            @Override
            protected String getDescription() {
                return "ModifyColumnFamilyProcedure";
            }
        });
    }

    @Override
    public long deleteColumn(final TableName tableName, final byte[] columnName, long nonceGroup, long nonce) throws IOException {
        this.checkInitialized();
        return MasterProcedureUtil.submitProcedure(new MasterProcedureUtil.NonceProcedureRunnable(this, nonceGroup, nonce){

            @Override
            protected void run() throws IOException {
                if (this.getMaster().getMasterCoprocessorHost().preDeleteColumn(tableName, columnName)) {
                    return;
                }
                LOG.info((Object)(HMaster.this.getClientIdAuditPrefix() + " delete " + Bytes.toString(columnName)));
                ProcedurePrepareLatch latch = ProcedurePrepareLatch.createLatch(2, 0);
                this.submitProcedure(new DeleteColumnFamilyProcedure((MasterProcedureEnv)HMaster.this.procedureExecutor.getEnvironment(), tableName, columnName, latch));
                latch.await();
                this.getMaster().getMasterCoprocessorHost().postDeleteColumn(tableName, columnName);
            }

            @Override
            protected String getDescription() {
                return "DeleteColumnFamilyProcedure";
            }
        });
    }

    @Override
    public long enableTable(final TableName tableName, long nonceGroup, long nonce) throws IOException {
        this.checkInitialized();
        return MasterProcedureUtil.submitProcedure(new MasterProcedureUtil.NonceProcedureRunnable(this, nonceGroup, nonce){

            @Override
            protected void run() throws IOException {
                this.getMaster().getMasterCoprocessorHost().preEnableTable(tableName);
                MasterQuotaManager quotaManager = HMaster.this.getMasterQuotaManager();
                if (quotaManager != null) {
                    if (quotaManager.isQuotaInitialized()) {
                        QuotaProtos.SpaceViolationPolicy policy;
                        QuotaProtos.Quotas quotaForTable = QuotaUtil.getTableQuota(HMaster.this.getConnection(), tableName);
                        if (quotaForTable != null && quotaForTable.hasSpace() && QuotaProtos.SpaceViolationPolicy.DISABLE == (policy = quotaForTable.getSpace().getViolationPolicy())) {
                            throw new AccessDeniedException("Enabling the table '" + tableName + "' is disallowed due to a violated space quota.");
                        }
                    } else if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)"Unable to check for space quotas as the MasterQuotaManager is not enabled");
                    }
                }
                LOG.info((Object)(HMaster.this.getClientIdAuditPrefix() + " enable " + tableName));
                ProcedurePrepareLatch prepareLatch = ProcedurePrepareLatch.createLatch();
                this.submitProcedure(new EnableTableProcedure((MasterProcedureEnv)HMaster.this.procedureExecutor.getEnvironment(), tableName, false, prepareLatch));
                prepareLatch.await();
                this.getMaster().getMasterCoprocessorHost().postEnableTable(tableName);
            }

            @Override
            protected String getDescription() {
                return "EnableTableProcedure";
            }
        });
    }

    @Override
    public long disableTable(final TableName tableName, long nonceGroup, long nonce) throws IOException {
        this.checkInitialized();
        return MasterProcedureUtil.submitProcedure(new MasterProcedureUtil.NonceProcedureRunnable(this, nonceGroup, nonce){

            @Override
            protected void run() throws IOException {
                this.getMaster().getMasterCoprocessorHost().preDisableTable(tableName);
                LOG.info((Object)(HMaster.this.getClientIdAuditPrefix() + " disable " + tableName));
                ProcedurePrepareLatch prepareLatch = ProcedurePrepareLatch.createLatch();
                this.submitProcedure(new DisableTableProcedure((MasterProcedureEnv)HMaster.this.procedureExecutor.getEnvironment(), tableName, false, prepareLatch));
                prepareLatch.await();
                this.getMaster().getMasterCoprocessorHost().postDisableTable(tableName);
            }

            @Override
            protected String getDescription() {
                return "DisableTableProcedure";
            }
        });
    }

    @VisibleForTesting
    Pair<HRegionInfo, ServerName> getTableRegionForRow(final TableName tableName, byte[] rowKey) throws IOException {
        final AtomicReference<Object> result = new AtomicReference<Object>(null);
        MetaTableAccessor.Visitor visitor = new MetaTableAccessor.Visitor(){

            @Override
            public boolean visit(Result data) throws IOException {
                if (data == null || data.size() <= 0) {
                    return true;
                }
                Pair<HRegionInfo, ServerName> pair = new Pair<HRegionInfo, ServerName>(MetaTableAccessor.getHRegionInfo(data), MetaTableAccessor.getServerName(data, 0));
                if (pair == null) {
                    return false;
                }
                if (!pair.getFirst().getTable().equals(tableName)) {
                    return false;
                }
                result.set(pair);
                return true;
            }
        };
        MetaTableAccessor.scanMeta((Connection)this.clusterConnection, visitor, tableName, rowKey, 1);
        return result.get();
    }

    @Override
    public long modifyTable(final TableName tableName, final TableDescriptor descriptor, long nonceGroup, long nonce) throws IOException {
        this.checkInitialized();
        this.sanityCheckTableDescriptor(descriptor);
        return MasterProcedureUtil.submitProcedure(new MasterProcedureUtil.NonceProcedureRunnable(this, nonceGroup, nonce){

            @Override
            protected void run() throws IOException {
                this.getMaster().getMasterCoprocessorHost().preModifyTable(tableName, descriptor);
                LOG.info((Object)(HMaster.this.getClientIdAuditPrefix() + " modify " + tableName));
                ProcedurePrepareLatch latch = ProcedurePrepareLatch.createLatch(2, 0);
                this.submitProcedure(new ModifyTableProcedure((MasterProcedureEnv)HMaster.this.procedureExecutor.getEnvironment(), descriptor, latch));
                latch.await();
                this.getMaster().getMasterCoprocessorHost().postModifyTable(tableName, descriptor);
            }

            @Override
            protected String getDescription() {
                return "ModifyTableProcedure";
            }
        });
    }

    public long restoreSnapshot(final SnapshotProtos.SnapshotDescription snapshotDesc, long nonceGroup, long nonce, final boolean restoreAcl) throws IOException {
        this.checkInitialized();
        this.getSnapshotManager().checkSnapshotSupport();
        TableName dstTable = TableName.valueOf(snapshotDesc.getTable());
        this.getClusterSchema().getNamespace(dstTable.getNamespaceAsString());
        return MasterProcedureUtil.submitProcedure(new MasterProcedureUtil.NonceProcedureRunnable(this, nonceGroup, nonce){

            @Override
            protected void run() throws IOException {
                this.setProcId(HMaster.this.getSnapshotManager().restoreOrCloneSnapshot(snapshotDesc, this.getNonceKey(), restoreAcl));
            }

            @Override
            protected String getDescription() {
                return "RestoreSnapshotProcedure";
            }
        });
    }

    @Override
    public void checkTableModifiable(TableName tableName) throws IOException, TableNotFoundException, TableNotDisabledException {
        if (HMaster.isCatalogTable(tableName)) {
            throw new IOException("Can't modify catalog tables");
        }
        if (!MetaTableAccessor.tableExists(this.getConnection(), tableName)) {
            throw new TableNotFoundException(tableName);
        }
        if (!this.getTableStateManager().isTableState(tableName, TableState.State.DISABLED)) {
            throw new TableNotDisabledException(tableName);
        }
    }

    public ClusterStatus getClusterStatus() throws InterruptedIOException {
        return this.getClusterStatus(EnumSet.allOf(ClusterStatus.Option.class));
    }

    public ClusterStatus getClusterStatus(EnumSet<ClusterStatus.Option> options) throws InterruptedIOException {
        ClusterStatus.Builder builder = ClusterStatus.newBuilder();
        for (ClusterStatus.Option opt : options) {
            switch (opt) {
                case HBASE_VERSION: {
                    builder.setHBaseVersion(org.apache.hadoop.hbase.util.VersionInfo.getVersion());
                    break;
                }
                case CLUSTER_ID: {
                    builder.setClusterId(this.getClusterId());
                    break;
                }
                case MASTER: {
                    builder.setMaster(this.getServerName());
                    break;
                }
                case BACKUP_MASTERS: {
                    builder.setBackupMasters(this.getBackupMasters());
                    break;
                }
                case LIVE_SERVERS: {
                    if (this.serverManager == null) break;
                    builder.setLiveServers(this.serverManager.getOnlineServers());
                    break;
                }
                case DEAD_SERVERS: {
                    if (this.serverManager == null) break;
                    builder.setDeadServers(this.serverManager.getDeadServers().copyServerNames());
                    break;
                }
                case MASTER_COPROCESSORS: {
                    if (this.cpHost == null) break;
                    builder.setMasterCoprocessors(this.getMasterCoprocessors());
                    break;
                }
                case REGIONS_IN_TRANSITION: {
                    if (this.assignmentManager == null) break;
                    builder.setRegionState(this.assignmentManager.getRegionStates().getRegionsStateInTransition());
                    break;
                }
                case BALANCER_ON: {
                    if (this.loadBalancerTracker == null) break;
                    builder.setBalancerOn(this.loadBalancerTracker.isBalancerOn());
                }
            }
        }
        return builder.build();
    }

    private List<ServerName> getBackupMasters() throws InterruptedIOException {
        List<String> backupMasterStrings;
        try {
            backupMasterStrings = ZKUtil.listChildrenNoWatch(this.zooKeeper, this.zooKeeper.znodePaths.backupMasterAddressesZNode);
        }
        catch (KeeperException e) {
            LOG.warn((Object)this.zooKeeper.prefix("Unable to list backup servers"), (Throwable)e);
            backupMasterStrings = null;
        }
        ArrayList<ServerName> backupMasters = null;
        if (backupMasterStrings != null && !backupMasterStrings.isEmpty()) {
            backupMasters = new ArrayList<ServerName>(backupMasterStrings.size());
            for (String s : backupMasterStrings) {
                try {
                    ServerName sn;
                    byte[] bytes;
                    try {
                        bytes = ZKUtil.getData(this.zooKeeper, ZKUtil.joinZNode(this.zooKeeper.znodePaths.backupMasterAddressesZNode, s));
                    }
                    catch (InterruptedException e) {
                        throw new InterruptedIOException();
                    }
                    if (bytes == null) continue;
                    try {
                        sn = ProtobufUtil.parseServerNameFrom(bytes);
                    }
                    catch (DeserializationException e) {
                        LOG.warn((Object)"Failed parse, skipping registering backup server", (Throwable)e);
                        continue;
                    }
                    backupMasters.add(sn);
                }
                catch (KeeperException e) {
                    LOG.warn((Object)this.zooKeeper.prefix("Unable to get information about backup servers"), (Throwable)e);
                }
            }
            Collections.sort(backupMasters, new Comparator<ServerName>(){

                @Override
                public int compare(ServerName s1, ServerName s2) {
                    return s1.getServerName().compareTo(s2.getServerName());
                }
            });
        }
        return backupMasters;
    }

    public static String getLoadedCoprocessors() {
        return CoprocessorHost.getLoadedCoprocessors().toString();
    }

    public long getMasterStartTime() {
        return this.startcode;
    }

    public long getMasterActiveTime() {
        return this.masterActiveTime;
    }

    public long getMasterFinishedInitializationTime() {
        return this.masterFinishedInitializationTime;
    }

    public int getNumWALFiles() {
        return this.procedureStore != null ? this.procedureStore.getActiveLogs().size() : 0;
    }

    public WALProcedureStore getWalProcedureStore() {
        return this.procedureStore;
    }

    public int getRegionServerInfoPort(ServerName sn) {
        HBaseProtos.RegionServerInfo info = this.regionServerTracker.getRegionServerInfo(sn);
        if (info == null || info.getInfoPort() == 0) {
            return this.conf.getInt("hbase.regionserver.info.port", 16030);
        }
        return info.getInfoPort();
    }

    @Override
    public String getRegionServerVersion(ServerName sn) {
        HBaseProtos.RegionServerInfo info = this.regionServerTracker.getRegionServerInfo(sn);
        if (info != null && info.hasVersionInfo()) {
            return info.getVersionInfo().getVersion();
        }
        return "0.0.0";
    }

    @Override
    public void checkIfShouldMoveSystemRegionAsync() {
        this.assignmentManager.checkIfShouldMoveSystemRegionAsync();
    }

    public String[] getMasterCoprocessors() {
        Set<String> masterCoprocessors = this.getMasterCoprocessorHost().getCoprocessors();
        return masterCoprocessors.toArray(new String[masterCoprocessors.size()]);
    }

    @Override
    public void abort(String msg, Throwable t) {
        if (this.isAborted() || this.isStopped()) {
            return;
        }
        if (this.cpHost != null) {
            LOG.fatal((Object)("Master server abort: loaded coprocessors are: " + HMaster.getLoadedCoprocessors()));
        }
        if (t != null) {
            LOG.fatal((Object)msg, t);
        }
        try {
            this.stopMaster();
        }
        catch (IOException e) {
            LOG.error((Object)"Exception occurred while stopping master", (Throwable)e);
        }
    }

    @Override
    public ZooKeeperWatcher getZooKeeper() {
        return this.zooKeeper;
    }

    @Override
    public MasterCoprocessorHost getMasterCoprocessorHost() {
        return this.cpHost;
    }

    @Override
    public MasterQuotaManager getMasterQuotaManager() {
        return this.quotaManager;
    }

    @Override
    public ProcedureExecutor<MasterProcedureEnv> getMasterProcedureExecutor() {
        return this.procedureExecutor;
    }

    @Override
    public ServerName getServerName() {
        return this.serverName;
    }

    @Override
    public AssignmentManager getAssignmentManager() {
        return this.assignmentManager;
    }

    @Override
    public CatalogJanitor getCatalogJanitor() {
        return this.catalogJanitorChore;
    }

    public MemoryBoundedLogMessageBuffer getRegionServerFatalLogBuffer() {
        return this.rsFatals;
    }

    public void shutdown() throws IOException {
        if (this.cpHost != null) {
            this.cpHost.preShutdown();
        }
        if (this.serverManager != null) {
            this.serverManager.shutdownCluster();
        }
        if (this.clusterStatusTracker != null) {
            try {
                this.clusterStatusTracker.setClusterDown();
            }
            catch (KeeperException e) {
                LOG.error((Object)"ZooKeeper exception trying to set cluster as down in ZK", (Throwable)e);
            }
        }
    }

    public void stopMaster() throws IOException {
        if (this.cpHost != null) {
            this.cpHost.preStopMaster();
        }
        this.stop("Stopped by " + Thread.currentThread().getName());
    }

    void checkServiceStarted() throws ServerNotRunningYetException {
        if (!this.serviceStarted) {
            throw new ServerNotRunningYetException("Server is not running yet");
        }
    }

    void checkInitialized() throws PleaseHoldException, ServerNotRunningYetException, MasterNotRunningException {
        this.checkServiceStarted();
        if (!this.isInitialized()) {
            throw new PleaseHoldException("Master is initializing");
        }
        if (this.isStopped()) {
            throw new MasterNotRunningException();
        }
    }

    @Override
    public boolean isActiveMaster() {
        return this.activeMaster;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized.isReady();
    }

    @Override
    public boolean isInMaintenanceMode() {
        return this.maintenanceModeTracker.isInMaintenanceMode();
    }

    @VisibleForTesting
    public void setInitialized(boolean isInitialized) {
        this.procedureExecutor.getEnvironment().setEventReady(this.initialized, isInitialized);
    }

    @Override
    public ProcedureEvent getInitializedEvent() {
        return this.initialized;
    }

    @Override
    public boolean isServerCrashProcessingEnabled() {
        return this.serverCrashProcessingEnabled.isReady();
    }

    @VisibleForTesting
    public void setServerCrashProcessingEnabled(boolean b) {
        this.procedureExecutor.getEnvironment().setEventReady(this.serverCrashProcessingEnabled, b);
    }

    public ProcedureEvent getServerCrashProcessingEnabledEvent() {
        return this.serverCrashProcessingEnabled;
    }

    public double getAverageLoad() {
        if (this.assignmentManager == null) {
            return 0.0;
        }
        RegionStates regionStates = this.assignmentManager.getRegionStates();
        if (regionStates == null) {
            return 0.0;
        }
        return regionStates.getAverageLoad();
    }

    public long getSplitPlanCount() {
        return this.splitPlanCount;
    }

    public long getMergePlanCount() {
        return this.mergePlanCount;
    }

    @Override
    public boolean registerService(Service instance) {
        Descriptors.ServiceDescriptor serviceDesc = instance.getDescriptorForType();
        String serviceName = CoprocessorRpcUtils.getServiceName(serviceDesc);
        if (this.coprocessorServiceHandlers.containsKey(serviceName)) {
            LOG.error((Object)("Coprocessor service " + serviceName + " already registered, rejecting request from " + instance));
            return false;
        }
        this.coprocessorServiceHandlers.put(serviceName, instance);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Registered master coprocessor service: service=" + serviceName));
        }
        return true;
    }

    public static HMaster constructMaster(Class<? extends HMaster> masterClass, Configuration conf, CoordinatedStateManager cp) {
        try {
            Constructor<? extends HMaster> c = masterClass.getConstructor(Configuration.class, CoordinatedStateManager.class);
            return c.newInstance(conf, cp);
        }
        catch (Exception e) {
            Throwable error = e;
            if (e instanceof InvocationTargetException && ((InvocationTargetException)e).getTargetException() != null) {
                error = ((InvocationTargetException)e).getTargetException();
            }
            throw new RuntimeException("Failed construction of Master: " + masterClass.toString() + ". ", error);
        }
    }

    public static void main(String[] args) {
        LOG.info((Object)("STARTING service " + HMaster.class.getSimpleName()));
        org.apache.hadoop.hbase.util.VersionInfo.logVersion();
        new HMasterCommandLine(HMaster.class).doMain(args);
    }

    public HFileCleaner getHFileCleaner() {
        return this.hfileCleaner;
    }

    public LogCleaner getLogCleaner() {
        return this.logCleaner;
    }

    @Override
    public SnapshotManager getSnapshotManager() {
        return this.snapshotManager;
    }

    @Override
    public MasterProcedureManagerHost getMasterProcedureManagerHost() {
        return this.mpmHost;
    }

    @Override
    public ClusterSchema getClusterSchema() {
        return this.clusterSchemaService;
    }

    long createNamespace(final NamespaceDescriptor namespaceDescriptor, long nonceGroup, long nonce) throws IOException {
        this.checkInitialized();
        TableName.isLegalNamespaceName(Bytes.toBytes(namespaceDescriptor.getName()));
        return MasterProcedureUtil.submitProcedure(new MasterProcedureUtil.NonceProcedureRunnable(this, nonceGroup, nonce){

            @Override
            protected void run() throws IOException {
                if (this.getMaster().getMasterCoprocessorHost().preCreateNamespace(namespaceDescriptor)) {
                    throw new BypassCoprocessorException();
                }
                LOG.info((Object)(HMaster.this.getClientIdAuditPrefix() + " creating " + namespaceDescriptor));
                this.setProcId(HMaster.this.getClusterSchema().createNamespace(namespaceDescriptor, this.getNonceKey()));
                this.getMaster().getMasterCoprocessorHost().postCreateNamespace(namespaceDescriptor);
            }

            @Override
            protected String getDescription() {
                return "CreateNamespaceProcedure";
            }
        });
    }

    long modifyNamespace(final NamespaceDescriptor namespaceDescriptor, long nonceGroup, long nonce) throws IOException {
        this.checkInitialized();
        TableName.isLegalNamespaceName(Bytes.toBytes(namespaceDescriptor.getName()));
        return MasterProcedureUtil.submitProcedure(new MasterProcedureUtil.NonceProcedureRunnable(this, nonceGroup, nonce){

            @Override
            protected void run() throws IOException {
                if (this.getMaster().getMasterCoprocessorHost().preModifyNamespace(namespaceDescriptor)) {
                    throw new BypassCoprocessorException();
                }
                LOG.info((Object)(HMaster.this.getClientIdAuditPrefix() + " modify " + namespaceDescriptor));
                this.setProcId(HMaster.this.getClusterSchema().modifyNamespace(namespaceDescriptor, this.getNonceKey()));
                this.getMaster().getMasterCoprocessorHost().postModifyNamespace(namespaceDescriptor);
            }

            @Override
            protected String getDescription() {
                return "ModifyNamespaceProcedure";
            }
        });
    }

    long deleteNamespace(final String name, long nonceGroup, long nonce) throws IOException {
        this.checkInitialized();
        return MasterProcedureUtil.submitProcedure(new MasterProcedureUtil.NonceProcedureRunnable(this, nonceGroup, nonce){

            @Override
            protected void run() throws IOException {
                if (this.getMaster().getMasterCoprocessorHost().preDeleteNamespace(name)) {
                    throw new BypassCoprocessorException();
                }
                LOG.info((Object)(HMaster.this.getClientIdAuditPrefix() + " delete " + name));
                this.setProcId(HMaster.this.getClusterSchema().deleteNamespace(name, this.getNonceKey()));
                this.getMaster().getMasterCoprocessorHost().postDeleteNamespace(name);
            }

            @Override
            protected String getDescription() {
                return "DeleteNamespaceProcedure";
            }
        });
    }

    NamespaceDescriptor getNamespace(String name) throws IOException {
        this.checkInitialized();
        if (this.cpHost != null) {
            this.cpHost.preGetNamespaceDescriptor(name);
        }
        NamespaceDescriptor nsd = this.clusterSchemaService.getNamespace(name);
        if (this.cpHost != null) {
            this.cpHost.postGetNamespaceDescriptor(nsd);
        }
        return nsd;
    }

    List<NamespaceDescriptor> getNamespaces() throws IOException {
        this.checkInitialized();
        ArrayList<NamespaceDescriptor> nsds = new ArrayList<NamespaceDescriptor>();
        boolean bypass = false;
        if (this.cpHost != null) {
            bypass = this.cpHost.preListNamespaceDescriptors(nsds);
        }
        if (!bypass) {
            nsds.addAll(this.clusterSchemaService.getNamespaces());
            if (this.cpHost != null) {
                this.cpHost.postListNamespaceDescriptors(nsds);
            }
        }
        return nsds;
    }

    @Override
    public List<TableName> listTableNamesByNamespace(String name) throws IOException {
        this.checkInitialized();
        return this.listTableNames(name, null, true);
    }

    @Override
    public List<TableDescriptor> listTableDescriptorsByNamespace(String name) throws IOException {
        this.checkInitialized();
        return this.listTableDescriptors(name, null, null, true);
    }

    @Override
    public boolean abortProcedure(long procId, boolean mayInterruptIfRunning) throws IOException {
        if (this.cpHost != null) {
            this.cpHost.preAbortProcedure(this.procedureExecutor, procId);
        }
        boolean result = this.procedureExecutor.abort(procId, mayInterruptIfRunning);
        if (this.cpHost != null) {
            this.cpHost.postAbortProcedure();
        }
        return result;
    }

    @Override
    public List<Procedure<?>> getProcedures() throws IOException {
        if (this.cpHost != null) {
            this.cpHost.preGetProcedures();
        }
        List<Procedure<?>> procList = this.procedureExecutor.getProcedures();
        if (this.cpHost != null) {
            this.cpHost.postGetProcedures(procList);
        }
        return procList;
    }

    @Override
    public List<LockedResource> getLocks() throws IOException {
        if (this.cpHost != null) {
            this.cpHost.preGetLocks();
        }
        MasterProcedureScheduler procedureScheduler = this.procedureExecutor.getEnvironment().getProcedureScheduler();
        List<LockedResource> lockedResources = procedureScheduler.getLocks();
        if (this.cpHost != null) {
            this.cpHost.postGetLocks(lockedResources);
        }
        return lockedResources;
    }

    public List<TableDescriptor> listTableDescriptors(String namespace, String regex, List<TableName> tableNameList, boolean includeSysTables) throws IOException {
        boolean bypass;
        List<TableDescriptor> htds = new ArrayList<TableDescriptor>();
        boolean bl = bypass = this.cpHost != null ? this.cpHost.preGetTableDescriptors(tableNameList, htds, regex) : false;
        if (!bypass) {
            htds = this.getTableDescriptors(htds, namespace, regex, tableNameList, includeSysTables);
            if (this.cpHost != null) {
                this.cpHost.postGetTableDescriptors(tableNameList, htds, regex);
            }
        }
        return htds;
    }

    public List<TableName> listTableNames(String namespace, String regex, boolean includeSysTables) throws IOException {
        boolean bypass;
        List<TableDescriptor> htds = new ArrayList<TableDescriptor>();
        boolean bl = bypass = this.cpHost != null ? this.cpHost.preGetTableNames(htds, regex) : false;
        if (!bypass) {
            htds = this.getTableDescriptors(htds, namespace, regex, null, includeSysTables);
            if (this.cpHost != null) {
                this.cpHost.postGetTableNames(htds, regex);
            }
        }
        ArrayList<TableName> result = new ArrayList<TableName>(htds.size());
        for (TableDescriptor htd : htds) {
            result.add(htd.getTableName());
        }
        return result;
    }

    private List<TableDescriptor> getTableDescriptors(List<TableDescriptor> htds, String namespace, String regex, List<TableName> tableNameList, boolean includeSysTables) throws IOException {
        if (tableNameList == null || tableNameList.isEmpty()) {
            Collection<TableDescriptor> allHtds;
            if (namespace != null && namespace.length() > 0) {
                this.clusterSchemaService.getNamespace(namespace);
                allHtds = this.tableDescriptors.getByNamespace(namespace).values();
            } else {
                allHtds = this.tableDescriptors.getAll().values();
            }
            for (TableDescriptor desc : allHtds) {
                if (!this.tableStateManager.isTablePresent(desc.getTableName()) || !includeSysTables && desc.getTableName().isSystemTable()) continue;
                htds.add(desc);
            }
        } else {
            for (TableName s : tableNameList) {
                TableDescriptor desc;
                if (!this.tableStateManager.isTablePresent(s) || (desc = this.tableDescriptors.get(s)) == null) continue;
                htds.add(desc);
            }
        }
        if (regex != null) {
            HMaster.filterTablesByRegex(htds, Pattern.compile(regex));
        }
        return htds;
    }

    private static void filterTablesByRegex(Collection<TableDescriptor> descriptors, Pattern pattern) {
        String defaultNS = NamespaceDescriptor.DEFAULT_NAMESPACE_NAME_STR;
        Iterator<TableDescriptor> itr = descriptors.iterator();
        while (itr.hasNext()) {
            TableDescriptor htd = itr.next();
            String tableName = htd.getTableName().getNameAsString();
            boolean matched = pattern.matcher(tableName).matches();
            if (!matched && htd.getTableName().getNamespaceAsString().equals(defaultNS)) {
                matched = pattern.matcher(defaultNS + ':' + tableName).matches();
            }
            if (matched) continue;
            itr.remove();
        }
    }

    @Override
    public long getLastMajorCompactionTimestamp(TableName table) throws IOException {
        return this.getClusterStatus().getLastMajorCompactionTsForTable(table);
    }

    @Override
    public long getLastMajorCompactionTimestampForRegion(byte[] regionName) throws IOException {
        return this.getClusterStatus().getLastMajorCompactionTsForRegion(regionName);
    }

    public AdminProtos.GetRegionInfoResponse.CompactionState getMobCompactionState(TableName tableName) {
        AtomicInteger compactionsCount = this.mobCompactionStates.get(tableName);
        if (compactionsCount != null && compactionsCount.get() != 0) {
            return AdminProtos.GetRegionInfoResponse.CompactionState.MAJOR_AND_MINOR;
        }
        return AdminProtos.GetRegionInfoResponse.CompactionState.NONE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportMobCompactionStart(TableName tableName) throws IOException {
        IdLock.Entry lockEntry = null;
        try {
            lockEntry = this.mobCompactionLock.getLockEntry(tableName.hashCode());
            AtomicInteger compactionsCount = this.mobCompactionStates.get(tableName);
            if (compactionsCount == null) {
                compactionsCount = new AtomicInteger(0);
                this.mobCompactionStates.put(tableName, compactionsCount);
            }
            compactionsCount.incrementAndGet();
        }
        finally {
            if (lockEntry != null) {
                this.mobCompactionLock.releaseLockEntry(lockEntry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportMobCompactionEnd(TableName tableName) throws IOException {
        IdLock.Entry lockEntry = null;
        try {
            int count;
            lockEntry = this.mobCompactionLock.getLockEntry(tableName.hashCode());
            AtomicInteger compactionsCount = this.mobCompactionStates.get(tableName);
            if (compactionsCount != null && (count = compactionsCount.decrementAndGet()) == 0) {
                this.mobCompactionStates.remove(tableName);
            }
        }
        finally {
            if (lockEntry != null) {
                this.mobCompactionLock.releaseLockEntry(lockEntry);
            }
        }
    }

    public void requestMobCompaction(TableName tableName, List<ColumnFamilyDescriptor> columns, boolean allFiles) throws IOException {
        this.mobCompactThread.requestMobCompaction(this.conf, this.fs, tableName, columns, allFiles);
    }

    public boolean isBalancerOn() {
        if (null == this.loadBalancerTracker || this.isInMaintenanceMode()) {
            return false;
        }
        return this.loadBalancerTracker.isBalancerOn();
    }

    public boolean isNormalizerOn() {
        return null == this.regionNormalizerTracker || this.isInMaintenanceMode() ? false : this.regionNormalizerTracker.isNormalizerOn();
    }

    @Override
    public boolean isSplitOrMergeEnabled(MasterSwitchType switchType) {
        if (null == this.splitOrMergeTracker || this.isInMaintenanceMode()) {
            return false;
        }
        return this.splitOrMergeTracker.isSplitOrMergeEnabled(switchType);
    }

    public String getLoadBalancerClassName() {
        return this.conf.get("hbase.master.loadbalancer.class", LoadBalancerFactory.getDefaultLoadBalancerClass().getName());
    }

    public RegionNormalizerTracker getRegionNormalizerTracker() {
        return this.regionNormalizerTracker;
    }

    public SplitOrMergeTracker getSplitOrMergeTracker() {
        return this.splitOrMergeTracker;
    }

    @Override
    public LoadBalancer getLoadBalancer() {
        return this.balancer;
    }

    @Override
    public FavoredNodesManager getFavoredNodesManager() {
        return this.favoredNodesManager;
    }

    @Override
    public void addReplicationPeer(String peerId, ReplicationPeerConfig peerConfig) throws ReplicationException, IOException {
        if (this.cpHost != null) {
            this.cpHost.preAddReplicationPeer(peerId, peerConfig);
        }
        LOG.info((Object)(this.getClientIdAuditPrefix() + " creating replication peer, id=" + peerId + ", config=" + peerConfig));
        this.replicationManager.addReplicationPeer(peerId, peerConfig);
        if (this.cpHost != null) {
            this.cpHost.postAddReplicationPeer(peerId, peerConfig);
        }
    }

    @Override
    public void removeReplicationPeer(String peerId) throws ReplicationException, IOException {
        if (this.cpHost != null) {
            this.cpHost.preRemoveReplicationPeer(peerId);
        }
        LOG.info((Object)(this.getClientIdAuditPrefix() + " removing replication peer, id=" + peerId));
        this.replicationManager.removeReplicationPeer(peerId);
        if (this.cpHost != null) {
            this.cpHost.postRemoveReplicationPeer(peerId);
        }
    }

    @Override
    public void enableReplicationPeer(String peerId) throws ReplicationException, IOException {
        if (this.cpHost != null) {
            this.cpHost.preEnableReplicationPeer(peerId);
        }
        LOG.info((Object)(this.getClientIdAuditPrefix() + " enable replication peer, id=" + peerId));
        this.replicationManager.enableReplicationPeer(peerId);
        if (this.cpHost != null) {
            this.cpHost.postEnableReplicationPeer(peerId);
        }
    }

    @Override
    public void disableReplicationPeer(String peerId) throws ReplicationException, IOException {
        if (this.cpHost != null) {
            this.cpHost.preDisableReplicationPeer(peerId);
        }
        LOG.info((Object)(this.getClientIdAuditPrefix() + " disable replication peer, id=" + peerId));
        this.replicationManager.disableReplicationPeer(peerId);
        if (this.cpHost != null) {
            this.cpHost.postDisableReplicationPeer(peerId);
        }
    }

    @Override
    public ReplicationPeerConfig getReplicationPeerConfig(String peerId) throws ReplicationException, IOException {
        if (this.cpHost != null) {
            this.cpHost.preGetReplicationPeerConfig(peerId);
        }
        ReplicationPeerConfig peerConfig = this.replicationManager.getPeerConfig(peerId);
        LOG.info((Object)(this.getClientIdAuditPrefix() + " get replication peer config, id=" + peerId + ", config=" + peerConfig));
        if (this.cpHost != null) {
            this.cpHost.postGetReplicationPeerConfig(peerId);
        }
        return peerConfig;
    }

    @Override
    public void updateReplicationPeerConfig(String peerId, ReplicationPeerConfig peerConfig) throws ReplicationException, IOException {
        if (this.cpHost != null) {
            this.cpHost.preUpdateReplicationPeerConfig(peerId, peerConfig);
        }
        LOG.info((Object)(this.getClientIdAuditPrefix() + " update replication peer config, id=" + peerId + ", config=" + peerConfig));
        this.replicationManager.updatePeerConfig(peerId, peerConfig);
        if (this.cpHost != null) {
            this.cpHost.postUpdateReplicationPeerConfig(peerId, peerConfig);
        }
    }

    @Override
    public List<ReplicationPeerDescription> listReplicationPeers(String regex) throws ReplicationException, IOException {
        if (this.cpHost != null) {
            this.cpHost.preListReplicationPeers(regex);
        }
        LOG.info((Object)(this.getClientIdAuditPrefix() + " list replication peers, regex=" + regex));
        Pattern pattern = regex == null ? null : Pattern.compile(regex);
        List<ReplicationPeerDescription> peers = this.replicationManager.listReplicationPeers(pattern);
        if (this.cpHost != null) {
            this.cpHost.postListReplicationPeers(regex);
        }
        return peers;
    }

    @Override
    public void drainRegionServer(ServerName server) {
        String parentZnode = this.getZooKeeper().znodePaths.drainingZNode;
        try {
            String node = ZKUtil.joinZNode(parentZnode, server.getServerName());
            ZKUtil.createAndFailSilent(this.getZooKeeper(), node);
        }
        catch (KeeperException ke) {
            LOG.warn((Object)this.zooKeeper.prefix("Unable to add drain for '" + server.getServerName() + "'."), (Throwable)ke);
        }
    }

    @Override
    public List<ServerName> listDrainingRegionServers() {
        String parentZnode = this.getZooKeeper().znodePaths.drainingZNode;
        ArrayList<ServerName> serverNames = new ArrayList<ServerName>();
        List<String> serverStrs = null;
        try {
            serverStrs = ZKUtil.listChildrenNoWatch(this.getZooKeeper(), parentZnode);
        }
        catch (KeeperException ke) {
            LOG.warn((Object)this.zooKeeper.prefix("Unable to list draining servers."), (Throwable)ke);
        }
        if (serverStrs == null) {
            return serverNames;
        }
        for (String serverStr : serverStrs) {
            try {
                serverNames.add(ServerName.parseServerName(serverStr));
            }
            catch (IllegalArgumentException iae) {
                LOG.warn((Object)("Unable to cast '" + serverStr + "' to ServerName."), (Throwable)iae);
            }
        }
        return serverNames;
    }

    @Override
    public void removeDrainFromRegionServer(ServerName server) {
        String parentZnode = this.getZooKeeper().znodePaths.drainingZNode;
        String node = ZKUtil.joinZNode(parentZnode, server.getServerName());
        try {
            ZKUtil.deleteNodeFailSilent(this.getZooKeeper(), node);
        }
        catch (KeeperException ke) {
            LOG.warn((Object)this.zooKeeper.prefix("Unable to remove drain for '" + server.getServerName() + "'."), (Throwable)ke);
        }
    }

    @Override
    public LockManager getLockManager() {
        return this.lockManager;
    }

    @Override
    public boolean recoverMeta() throws IOException {
        ProcedurePrepareLatch latch = ProcedurePrepareLatch.createLatch(2, 0);
        long procId = this.procedureExecutor.submitProcedure(new RecoverMetaProcedure(null, true, latch));
        LOG.info((Object)("Waiting on RecoverMetaProcedure submitted with procId=" + procId));
        latch.await();
        LOG.info((Object)("Default replica of hbase:meta, location=" + this.getMetaTableLocator().getMetaRegionLocation(this.getZooKeeper())));
        return this.assignmentManager.isMetaInitialized();
    }

    public QuotaObserverChore getQuotaObserverChore() {
        return this.quotaObserverChore;
    }

    public SpaceQuotaSnapshotNotifier getSpaceQuotaSnapshotNotifier() {
        return this.spaceQuotaSnapshotNotifier;
    }

    public static class RedirectServlet
    extends HttpServlet {
        private static final long serialVersionUID = 2894774810058302473L;
        private final int regionServerInfoPort;
        private final String regionServerHostname;

        public RedirectServlet(InfoServer infoServer, String hostname) {
            this.regionServerInfoPort = infoServer.getPort();
            this.regionServerHostname = hostname;
        }

        public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            String redirectHost = this.regionServerHostname;
            if (redirectHost == null && !Addressing.isLocalAddress(InetAddress.getByName(redirectHost = request.getServerName()))) {
                LOG.warn((Object)("Couldn't resolve '" + redirectHost + "' as an address local to this node and '" + "hbase.master.hostname" + "' is not set; client will get a HTTP 400 response. If your HBase deployment relies on client accessible names that the region server process can't resolve locally, then you should set the previously mentioned configuration variable to an appropriate hostname."));
                response.sendError(400, "Request was to a host that I can't resolve for any of the network interfaces on this node. If this is due to an intermediary such as an HTTP load balancer or other proxy, your HBase administrator can set 'hbase.master.hostname' to point to the correct hostname.");
                return;
            }
            String redirectUrl = request.getScheme() + "://" + redirectHost + ":" + this.regionServerInfoPort + request.getRequestURI();
            response.sendRedirect(redirectUrl);
        }
    }

    private static class InitializationMonitor
    extends HasThread {
        public static final String TIMEOUT_KEY = "hbase.master.initializationmonitor.timeout";
        public static final long TIMEOUT_DEFAULT = TimeUnit.MILLISECONDS.convert(15L, TimeUnit.MINUTES);
        public static final String HALT_KEY = "hbase.master.initializationmonitor.haltontimeout";
        public static final boolean HALT_DEFAULT = false;
        private final HMaster master;
        private final long timeout;
        private final boolean haltOnTimeout;

        InitializationMonitor(HMaster master) {
            super("MasterInitializationMonitor");
            this.master = master;
            this.timeout = master.getConfiguration().getLong(TIMEOUT_KEY, TIMEOUT_DEFAULT);
            this.haltOnTimeout = master.getConfiguration().getBoolean(HALT_KEY, false);
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                while (!this.master.isStopped() && this.master.isActiveMaster()) {
                    Thread.sleep(this.timeout);
                    if (this.master.isInitialized()) {
                        LOG.debug((Object)"Initialization completed within allotted tolerance. Monitor exiting.");
                        continue;
                    }
                    LOG.error((Object)("Master failed to complete initialization after " + this.timeout + "ms. Please consider submitting a bug report including a thread dump of this process."));
                    if (!this.haltOnTimeout) continue;
                    LOG.error((Object)"Zombie Master exiting. Thread dump to stdout");
                    Threads.printThreadInfo(System.out, "Zombie HMaster");
                    System.exit(-1);
                }
            }
            catch (InterruptedException ie) {
                LOG.trace((Object)"InitMonitor thread interrupted. Existing.");
            }
        }
    }
}

