/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Coprocessor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.MetaMutationAnnotation;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.MasterSwitchType;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.coprocessor.CoprocessorHost;
import org.apache.hadoop.hbase.coprocessor.CoprocessorService;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.MasterObserver;
import org.apache.hadoop.hbase.coprocessor.MetricsCoprocessor;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.RegionPlan;
import org.apache.hadoop.hbase.master.locking.LockProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.metrics.MetricRegistry;
import org.apache.hadoop.hbase.net.Address;
import org.apache.hadoop.hbase.procedure2.LockType;
import org.apache.hadoop.hbase.procedure2.LockedResource;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.shaded.org.apache.commons.lang3.ClassUtils;
import org.apache.hadoop.hbase.shaded.protobuf.generated.QuotaProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.SnapshotProtos;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class MasterCoprocessorHost
extends CoprocessorHost<MasterEnvironment> {
    private static final Log LOG = LogFactory.getLog(MasterCoprocessorHost.class);
    private MasterServices masterServices;

    public MasterCoprocessorHost(MasterServices services, Configuration conf) {
        super(services);
        this.conf = conf;
        this.masterServices = services;
        boolean coprocessorsEnabled = conf.getBoolean("hbase.coprocessor.enabled", true);
        LOG.info((Object)("System coprocessor loading is " + (coprocessorsEnabled ? "enabled" : "disabled")));
        this.loadSystemCoprocessors(conf, "hbase.coprocessor.master.classes");
    }

    @Override
    public MasterEnvironment createEnvironment(Class<?> implClass, Coprocessor instance, int priority, int seq, Configuration conf) {
        for (Class<?> itf : ClassUtils.getAllInterfaces(implClass)) {
            Class<?> c = itf;
            if (!CoprocessorService.class.isAssignableFrom(c)) continue;
            this.masterServices.registerService(((CoprocessorService)((Object)instance)).getService());
        }
        return new MasterEnvironment(implClass, instance, priority, seq, conf, this.masterServices);
    }

    public boolean preCreateNamespace(final NamespaceDescriptor ns) throws IOException {
        return this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.preCreateNamespace(ctx, ns);
            }
        });
    }

    public void postCreateNamespace(final NamespaceDescriptor ns) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.postCreateNamespace(ctx, ns);
            }
        });
    }

    public boolean preDeleteNamespace(final String namespaceName) throws IOException {
        return this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.preDeleteNamespace(ctx, namespaceName);
            }
        });
    }

    public void postDeleteNamespace(final String namespaceName) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.postDeleteNamespace(ctx, namespaceName);
            }
        });
    }

    public boolean preModifyNamespace(final NamespaceDescriptor ns) throws IOException {
        return this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.preModifyNamespace(ctx, ns);
            }
        });
    }

    public void postModifyNamespace(final NamespaceDescriptor ns) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.postModifyNamespace(ctx, ns);
            }
        });
    }

    public void preGetNamespaceDescriptor(final String namespaceName) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.preGetNamespaceDescriptor(ctx, namespaceName);
            }
        });
    }

    public void postGetNamespaceDescriptor(final NamespaceDescriptor ns) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.postGetNamespaceDescriptor(ctx, ns);
            }
        });
    }

    public boolean preListNamespaceDescriptors(final List<NamespaceDescriptor> descriptors) throws IOException {
        return this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.preListNamespaceDescriptors(ctx, descriptors);
            }
        });
    }

    public void postListNamespaceDescriptors(final List<NamespaceDescriptor> descriptors) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.postListNamespaceDescriptors(ctx, descriptors);
            }
        });
    }

    public void preCreateTable(final TableDescriptor htd, final HRegionInfo[] regions) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.preCreateTable(ctx, htd, regions);
            }
        });
    }

    public void postCreateTable(final TableDescriptor htd, final HRegionInfo[] regions) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.postCreateTable(ctx, htd, regions);
            }
        });
    }

    public void preCreateTableAction(final TableDescriptor htd, final HRegionInfo[] regions, User user) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(user){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.preCreateTableAction(ctx, htd, regions);
            }
        });
    }

    public void postCompletedCreateTableAction(final TableDescriptor htd, final HRegionInfo[] regions, User user) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(user){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.postCompletedCreateTableAction(ctx, htd, regions);
            }
        });
    }

    public void preDeleteTable(final TableName tableName) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.preDeleteTable(ctx, tableName);
            }
        });
    }

    public void postDeleteTable(final TableName tableName) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.postDeleteTable(ctx, tableName);
            }
        });
    }

    public void preDeleteTableAction(final TableName tableName, User user) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(user){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.preDeleteTableAction(ctx, tableName);
            }
        });
    }

    public void postCompletedDeleteTableAction(final TableName tableName, User user) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(user){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.postCompletedDeleteTableAction(ctx, tableName);
            }
        });
    }

    public void preTruncateTable(final TableName tableName) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.preTruncateTable(ctx, tableName);
            }
        });
    }

    public void postTruncateTable(final TableName tableName) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.postTruncateTable(ctx, tableName);
            }
        });
    }

    public void preTruncateTableAction(final TableName tableName, User user) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(user){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.preTruncateTableAction(ctx, tableName);
            }
        });
    }

    public void postCompletedTruncateTableAction(final TableName tableName, User user) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(user){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.postCompletedTruncateTableAction(ctx, tableName);
            }
        });
    }

    public void preModifyTable(final TableName tableName, final TableDescriptor htd) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.preModifyTable(ctx, tableName, htd);
            }
        });
    }

    public void postModifyTable(final TableName tableName, final TableDescriptor htd) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.postModifyTable(ctx, tableName, htd);
            }
        });
    }

    public void preModifyTableAction(final TableName tableName, final TableDescriptor htd, User user) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(user){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.preModifyTableAction(ctx, tableName, htd);
            }
        });
    }

    public void postCompletedModifyTableAction(final TableName tableName, final TableDescriptor htd, User user) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(user){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.postCompletedModifyTableAction(ctx, tableName, htd);
            }
        });
    }

    public boolean preAddColumn(final TableName tableName, final ColumnFamilyDescriptor columnFamily) throws IOException {
        return this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.preAddColumnFamily(ctx, tableName, columnFamily);
            }
        });
    }

    public void postAddColumn(final TableName tableName, final ColumnFamilyDescriptor columnFamily) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.postAddColumnFamily(ctx, tableName, columnFamily);
            }
        });
    }

    public boolean preAddColumnFamilyAction(final TableName tableName, final ColumnFamilyDescriptor columnFamily, User user) throws IOException {
        return this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(user){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.preAddColumnFamilyAction(ctx, tableName, columnFamily);
            }
        });
    }

    public void postCompletedAddColumnFamilyAction(final TableName tableName, final ColumnFamilyDescriptor columnFamily, User user) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(user){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.postCompletedAddColumnFamilyAction(ctx, tableName, columnFamily);
            }
        });
    }

    public boolean preModifyColumn(final TableName tableName, final ColumnFamilyDescriptor columnFamily) throws IOException {
        return this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.preModifyColumnFamily(ctx, tableName, columnFamily);
            }
        });
    }

    public void postModifyColumn(final TableName tableName, final ColumnFamilyDescriptor columnFamily) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.postModifyColumnFamily(ctx, tableName, columnFamily);
            }
        });
    }

    public boolean preModifyColumnFamilyAction(final TableName tableName, final ColumnFamilyDescriptor columnFamily, User user) throws IOException {
        return this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(user){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.preModifyColumnFamilyAction(ctx, tableName, columnFamily);
            }
        });
    }

    public void postCompletedModifyColumnFamilyAction(final TableName tableName, final ColumnFamilyDescriptor columnFamily, User user) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(user){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.postCompletedModifyColumnFamilyAction(ctx, tableName, columnFamily);
            }
        });
    }

    public boolean preDeleteColumn(final TableName tableName, final byte[] columnFamily) throws IOException {
        return this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.preDeleteColumnFamily(ctx, tableName, columnFamily);
            }
        });
    }

    public void postDeleteColumn(final TableName tableName, final byte[] columnFamily) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.postDeleteColumnFamily(ctx, tableName, columnFamily);
            }
        });
    }

    public boolean preDeleteColumnFamilyAction(final TableName tableName, final byte[] columnFamily, User user) throws IOException {
        return this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(user){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.preDeleteColumnFamilyAction(ctx, tableName, columnFamily);
            }
        });
    }

    public void postCompletedDeleteColumnFamilyAction(final TableName tableName, final byte[] columnFamily, User user) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(user){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.postCompletedDeleteColumnFamilyAction(ctx, tableName, columnFamily);
            }
        });
    }

    public void preEnableTable(final TableName tableName) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.preEnableTable(ctx, tableName);
            }
        });
    }

    public void postEnableTable(final TableName tableName) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.postEnableTable(ctx, tableName);
            }
        });
    }

    public void preEnableTableAction(final TableName tableName, User user) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(user){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.preEnableTableAction(ctx, tableName);
            }
        });
    }

    public void postCompletedEnableTableAction(final TableName tableName, User user) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(user){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.postCompletedEnableTableAction(ctx, tableName);
            }
        });
    }

    public void preDisableTable(final TableName tableName) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.preDisableTable(ctx, tableName);
            }
        });
    }

    public void postDisableTable(final TableName tableName) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.postDisableTable(ctx, tableName);
            }
        });
    }

    public void preDisableTableAction(final TableName tableName, User user) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(user){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.preDisableTableAction(ctx, tableName);
            }
        });
    }

    public void postCompletedDisableTableAction(final TableName tableName, User user) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(user){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.postCompletedDisableTableAction(ctx, tableName);
            }
        });
    }

    public boolean preAbortProcedure(final ProcedureExecutor<MasterProcedureEnv> procEnv, final long procId) throws IOException {
        return this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.preAbortProcedure(ctx, procEnv, procId);
            }
        });
    }

    public void postAbortProcedure() throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.postAbortProcedure(ctx);
            }
        });
    }

    public boolean preGetProcedures() throws IOException {
        return this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.preGetProcedures(ctx);
            }
        });
    }

    public void postGetProcedures(final List<Procedure<?>> procInfoList) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.postGetProcedures(ctx, procInfoList);
            }
        });
    }

    public boolean preGetLocks() throws IOException {
        return this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.preGetLocks(ctx);
            }
        });
    }

    public void postGetLocks(final List<LockedResource> lockedResources) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.postGetLocks(ctx, lockedResources);
            }
        });
    }

    public boolean preMove(final HRegionInfo region, final ServerName srcServer, final ServerName destServer) throws IOException {
        return this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.preMove(ctx, region, srcServer, destServer);
            }
        });
    }

    public void postMove(final HRegionInfo region, final ServerName srcServer, final ServerName destServer) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.postMove(ctx, region, srcServer, destServer);
            }
        });
    }

    public boolean preAssign(final HRegionInfo regionInfo) throws IOException {
        return this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.preAssign(ctx, regionInfo);
            }
        });
    }

    public void postAssign(final HRegionInfo regionInfo) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.postAssign(ctx, regionInfo);
            }
        });
    }

    public boolean preUnassign(final HRegionInfo regionInfo, final boolean force) throws IOException {
        return this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.preUnassign(ctx, regionInfo, force);
            }
        });
    }

    public void postUnassign(final HRegionInfo regionInfo, final boolean force) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.postUnassign(ctx, regionInfo, force);
            }
        });
    }

    public void preRegionOffline(final HRegionInfo regionInfo) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.preRegionOffline(ctx, regionInfo);
            }
        });
    }

    public void postRegionOffline(final HRegionInfo regionInfo) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.postRegionOffline(ctx, regionInfo);
            }
        });
    }

    public void preMergeRegions(final HRegionInfo[] regionsToMerge) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.preMergeRegions(ctx, regionsToMerge);
            }
        });
    }

    public void postMergeRegions(final HRegionInfo[] regionsToMerge) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.postMergeRegions(ctx, regionsToMerge);
            }
        });
    }

    public boolean preBalance() throws IOException {
        return this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.preBalance(ctx);
            }
        });
    }

    public void postBalance(final List<RegionPlan> plans) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.postBalance(ctx, plans);
            }
        });
    }

    public boolean preSetSplitOrMergeEnabled(final boolean newValue, final MasterSwitchType switchType) throws IOException {
        return this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.preSetSplitOrMergeEnabled(ctx, newValue, switchType);
            }
        });
    }

    public void postSetSplitOrMergeEnabled(final boolean newValue, final MasterSwitchType switchType) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.postSetSplitOrMergeEnabled(ctx, newValue, switchType);
            }
        });
    }

    public void preSplitRegion(final TableName tableName, final byte[] splitRow) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.preSplitRegion(ctx, tableName, splitRow);
            }
        });
    }

    public void preSplitRegionAction(final TableName tableName, final byte[] splitRow, User user) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(user){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.preSplitRegionAction(ctx, tableName, splitRow);
            }
        });
    }

    public void postCompletedSplitRegionAction(final HRegionInfo regionInfoA, final HRegionInfo regionInfoB, User user) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(user){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.postCompletedSplitRegionAction(ctx, regionInfoA, regionInfoB);
            }
        });
    }

    public boolean preSplitBeforePONRAction(final byte[] splitKey, final List<Mutation> metaEntries, User user) throws IOException {
        return this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(user){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.preSplitRegionBeforePONRAction(ctx, splitKey, metaEntries);
            }
        });
    }

    public void preSplitAfterPONRAction(User user) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(user){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.preSplitRegionAfterPONRAction(ctx);
            }
        });
    }

    public void postRollBackSplitRegionAction(User user) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(user){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.postRollBackSplitRegionAction(ctx);
            }
        });
    }

    public boolean preMergeRegionsAction(final HRegionInfo[] regionsToMerge, User user) throws IOException {
        return this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(user){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.preMergeRegionsAction(ctx, regionsToMerge);
            }
        });
    }

    public void postCompletedMergeRegionsAction(final HRegionInfo[] regionsToMerge, final HRegionInfo mergedRegion, User user) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(user){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.postCompletedMergeRegionsAction(ctx, regionsToMerge, mergedRegion);
            }
        });
    }

    public boolean preMergeRegionsCommit(final HRegionInfo[] regionsToMerge, final @MetaMutationAnnotation List<Mutation> metaEntries, User user) throws IOException {
        return this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(user){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.preMergeRegionsCommitAction(ctx, regionsToMerge, metaEntries);
            }
        });
    }

    public void postMergeRegionsCommit(final HRegionInfo[] regionsToMerge, final HRegionInfo mergedRegion, User user) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(user){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.postMergeRegionsCommitAction(ctx, regionsToMerge, mergedRegion);
            }
        });
    }

    public void postRollBackMergeRegionsAction(final HRegionInfo[] regionsToMerge, User user) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(user){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.postRollBackMergeRegionsAction(ctx, regionsToMerge);
            }
        });
    }

    public boolean preBalanceSwitch(boolean b) throws IOException {
        return this.execOperationWithResult(b, this.coprocessors.isEmpty() ? null : new CoprocessorOperationWithResult<Boolean>(){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                this.setResult(oserver.preBalanceSwitch(ctx, (Boolean)this.getResult()));
            }
        });
    }

    public void postBalanceSwitch(final boolean oldValue, final boolean newValue) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.postBalanceSwitch(ctx, oldValue, newValue);
            }
        });
    }

    public void preShutdown() throws IOException {
        this.execShutdown(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.preShutdown(ctx);
            }

            @Override
            public void postEnvCall(MasterEnvironment env) {
                MasterCoprocessorHost.this.shutdown(env);
            }
        });
    }

    public void preStopMaster() throws IOException {
        this.execShutdown(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.preStopMaster(ctx);
            }

            @Override
            public void postEnvCall(MasterEnvironment env) {
                MasterCoprocessorHost.this.shutdown(env);
            }
        });
    }

    public void preMasterInitialization() throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.preMasterInitialization(ctx);
            }
        });
    }

    public void postStartMaster() throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.postStartMaster(ctx);
            }
        });
    }

    public void preSnapshot(final SnapshotProtos.SnapshotDescription snapshot, final TableDescriptor hTableDescriptor) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.preSnapshot(ctx, snapshot, hTableDescriptor);
            }
        });
    }

    public void postSnapshot(final SnapshotProtos.SnapshotDescription snapshot, final TableDescriptor hTableDescriptor) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.postSnapshot(ctx, snapshot, hTableDescriptor);
            }
        });
    }

    public void preListSnapshot(final SnapshotProtos.SnapshotDescription snapshot) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver observer, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                observer.preListSnapshot(ctx, snapshot);
            }
        });
    }

    public void postListSnapshot(final SnapshotProtos.SnapshotDescription snapshot) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver observer, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                observer.postListSnapshot(ctx, snapshot);
            }
        });
    }

    public void preCloneSnapshot(final SnapshotProtos.SnapshotDescription snapshot, final TableDescriptor hTableDescriptor) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.preCloneSnapshot(ctx, snapshot, hTableDescriptor);
            }
        });
    }

    public void postCloneSnapshot(final SnapshotProtos.SnapshotDescription snapshot, final TableDescriptor hTableDescriptor) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.postCloneSnapshot(ctx, snapshot, hTableDescriptor);
            }
        });
    }

    public void preRestoreSnapshot(final SnapshotProtos.SnapshotDescription snapshot, final TableDescriptor hTableDescriptor) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.preRestoreSnapshot(ctx, snapshot, hTableDescriptor);
            }
        });
    }

    public void postRestoreSnapshot(final SnapshotProtos.SnapshotDescription snapshot, final TableDescriptor hTableDescriptor) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.postRestoreSnapshot(ctx, snapshot, hTableDescriptor);
            }
        });
    }

    public void preDeleteSnapshot(final SnapshotProtos.SnapshotDescription snapshot) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.preDeleteSnapshot(ctx, snapshot);
            }
        });
    }

    public void postDeleteSnapshot(final SnapshotProtos.SnapshotDescription snapshot) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.postDeleteSnapshot(ctx, snapshot);
            }
        });
    }

    public boolean preGetTableDescriptors(final List<TableName> tableNamesList, final List<TableDescriptor> descriptors, final String regex) throws IOException {
        return this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.preGetTableDescriptors(ctx, tableNamesList, descriptors, regex);
            }
        });
    }

    public void postGetTableDescriptors(final List<TableName> tableNamesList, final List<TableDescriptor> descriptors, final String regex) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.postGetTableDescriptors(ctx, tableNamesList, descriptors, regex);
            }
        });
    }

    public boolean preGetTableNames(final List<TableDescriptor> descriptors, final String regex) throws IOException {
        return this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.preGetTableNames(ctx, descriptors, regex);
            }
        });
    }

    public void postGetTableNames(final List<TableDescriptor> descriptors, final String regex) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.postGetTableNames(ctx, descriptors, regex);
            }
        });
    }

    public void preTableFlush(final TableName tableName) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.preTableFlush(ctx, tableName);
            }
        });
    }

    public void postTableFlush(final TableName tableName) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.postTableFlush(ctx, tableName);
            }
        });
    }

    public void preSetUserQuota(final String user, final QuotaProtos.Quotas quotas) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.preSetUserQuota(ctx, user, quotas);
            }
        });
    }

    public void postSetUserQuota(final String user, final QuotaProtos.Quotas quotas) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.postSetUserQuota(ctx, user, quotas);
            }
        });
    }

    public void preSetUserQuota(final String user, final TableName table, final QuotaProtos.Quotas quotas) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.preSetUserQuota(ctx, user, table, quotas);
            }
        });
    }

    public void postSetUserQuota(final String user, final TableName table, final QuotaProtos.Quotas quotas) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.postSetUserQuota(ctx, user, table, quotas);
            }
        });
    }

    public void preSetUserQuota(final String user, final String namespace, final QuotaProtos.Quotas quotas) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.preSetUserQuota(ctx, user, namespace, quotas);
            }
        });
    }

    public void postSetUserQuota(final String user, final String namespace, final QuotaProtos.Quotas quotas) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.postSetUserQuota(ctx, user, namespace, quotas);
            }
        });
    }

    public void preSetTableQuota(final TableName table, final QuotaProtos.Quotas quotas) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.preSetTableQuota(ctx, table, quotas);
            }
        });
    }

    public void postSetTableQuota(final TableName table, final QuotaProtos.Quotas quotas) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.postSetTableQuota(ctx, table, quotas);
            }
        });
    }

    public void preSetNamespaceQuota(final String namespace, final QuotaProtos.Quotas quotas) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.preSetNamespaceQuota(ctx, namespace, quotas);
            }
        });
    }

    public void postSetNamespaceQuota(final String namespace, final QuotaProtos.Quotas quotas) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.postSetNamespaceQuota(ctx, namespace, quotas);
            }
        });
    }

    private <T> T execOperationWithResult(T defaultValue, CoprocessorOperationWithResult<T> ctx) throws IOException {
        if (ctx == null) {
            return defaultValue;
        }
        ctx.setResult(defaultValue);
        this.execOperation(ctx);
        return ctx.getResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean execOperation(CoprocessorOperation ctx) throws IOException {
        if (ctx == null) {
            return false;
        }
        boolean bypass = false;
        List envs = this.coprocessors.get();
        for (int i = 0; i < envs.size(); ++i) {
            MasterEnvironment env = (MasterEnvironment)envs.get(i);
            if (env.getInstance() instanceof MasterObserver) {
                ctx.prepare(env);
                Thread currentThread = Thread.currentThread();
                ClassLoader cl = currentThread.getContextClassLoader();
                try {
                    currentThread.setContextClassLoader(env.getClassLoader());
                    ctx.call((MasterObserver)env.getInstance(), ctx);
                }
                catch (Throwable e) {
                    this.handleCoprocessorThrowable(env, e);
                }
                finally {
                    currentThread.setContextClassLoader(cl);
                }
                bypass |= ctx.shouldBypass();
                if (ctx.shouldComplete()) break;
            }
            ctx.postEnvCall(env);
        }
        return bypass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean execShutdown(CoprocessorOperation ctx) throws IOException {
        MasterEnvironment env;
        int i;
        if (ctx == null) {
            return false;
        }
        boolean bypass = false;
        List envs = this.coprocessors.get();
        int envsSize = envs.size();
        for (i = 0; i < envsSize; ++i) {
            env = (MasterEnvironment)envs.get(i);
            if (!(env.getInstance() instanceof MasterObserver)) continue;
            ctx.prepare(env);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                ctx.call((MasterObserver)env.getInstance(), ctx);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            bypass |= ctx.shouldBypass();
            if (ctx.shouldComplete()) break;
        }
        for (i = 0; i < envsSize; ++i) {
            env = (MasterEnvironment)envs.get(i);
            ctx.postEnvCall(env);
        }
        return bypass;
    }

    public void preMoveServersAndTables(final Set<Address> servers, final Set<TableName> tables, final String targetGroup) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                if (((MasterEnvironment)ctx.getEnvironment()).supportGroupCPs) {
                    oserver.preMoveServersAndTables(ctx, servers, tables, targetGroup);
                }
            }
        });
    }

    public void postMoveServersAndTables(final Set<Address> servers, final Set<TableName> tables, final String targetGroup) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                if (((MasterEnvironment)ctx.getEnvironment()).supportGroupCPs) {
                    oserver.postMoveServersAndTables(ctx, servers, tables, targetGroup);
                }
            }
        });
    }

    public void preMoveServers(final Set<Address> servers, final String targetGroup) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                if (((MasterEnvironment)ctx.getEnvironment()).supportGroupCPs) {
                    oserver.preMoveServers(ctx, servers, targetGroup);
                }
            }
        });
    }

    public void postMoveServers(final Set<Address> servers, final String targetGroup) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                if (((MasterEnvironment)ctx.getEnvironment()).supportGroupCPs) {
                    oserver.postMoveServers(ctx, servers, targetGroup);
                }
            }
        });
    }

    public void preMoveTables(final Set<TableName> tables, final String targetGroup) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                if (((MasterEnvironment)ctx.getEnvironment()).supportGroupCPs) {
                    oserver.preMoveTables(ctx, tables, targetGroup);
                }
            }
        });
    }

    public void postMoveTables(final Set<TableName> tables, final String targetGroup) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                if (((MasterEnvironment)ctx.getEnvironment()).supportGroupCPs) {
                    oserver.postMoveTables(ctx, tables, targetGroup);
                }
            }
        });
    }

    public void preAddRSGroup(final String name) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                if (((MasterEnvironment)ctx.getEnvironment()).supportGroupCPs) {
                    oserver.preAddRSGroup(ctx, name);
                }
            }
        });
    }

    public void postAddRSGroup(final String name) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                if (((MasterEnvironment)ctx.getEnvironment()).supportGroupCPs) {
                    oserver.postAddRSGroup(ctx, name);
                }
            }
        });
    }

    public void preRemoveRSGroup(final String name) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                if (((MasterEnvironment)ctx.getEnvironment()).supportGroupCPs) {
                    oserver.preRemoveRSGroup(ctx, name);
                }
            }
        });
    }

    public void postRemoveRSGroup(final String name) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                if (((MasterEnvironment)ctx.getEnvironment()).supportGroupCPs) {
                    oserver.postRemoveRSGroup(ctx, name);
                }
            }
        });
    }

    public void preBalanceRSGroup(final String name) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                if (((MasterEnvironment)ctx.getEnvironment()).supportGroupCPs) {
                    oserver.preBalanceRSGroup(ctx, name);
                }
            }
        });
    }

    public void postBalanceRSGroup(final String name, final boolean balanceRan) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                if (((MasterEnvironment)ctx.getEnvironment()).supportGroupCPs) {
                    oserver.postBalanceRSGroup(ctx, name, balanceRan);
                }
            }
        });
    }

    public void preAddReplicationPeer(final String peerId, final ReplicationPeerConfig peerConfig) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver observer, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                observer.preAddReplicationPeer(ctx, peerId, peerConfig);
            }
        });
    }

    public void postAddReplicationPeer(final String peerId, final ReplicationPeerConfig peerConfig) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver observer, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                observer.postAddReplicationPeer(ctx, peerId, peerConfig);
            }
        });
    }

    public void preRemoveReplicationPeer(final String peerId) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver observer, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                observer.preRemoveReplicationPeer(ctx, peerId);
            }
        });
    }

    public void postRemoveReplicationPeer(final String peerId) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver observer, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                observer.postRemoveReplicationPeer(ctx, peerId);
            }
        });
    }

    public void preEnableReplicationPeer(final String peerId) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver observer, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                observer.preEnableReplicationPeer(ctx, peerId);
            }
        });
    }

    public void postEnableReplicationPeer(final String peerId) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver observer, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                observer.postEnableReplicationPeer(ctx, peerId);
            }
        });
    }

    public void preDisableReplicationPeer(final String peerId) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver observer, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                observer.preDisableReplicationPeer(ctx, peerId);
            }
        });
    }

    public void postDisableReplicationPeer(final String peerId) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver observer, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                observer.postDisableReplicationPeer(ctx, peerId);
            }
        });
    }

    public void preGetReplicationPeerConfig(final String peerId) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver observer, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                observer.preGetReplicationPeerConfig(ctx, peerId);
            }
        });
    }

    public void postGetReplicationPeerConfig(final String peerId) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver observer, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                observer.postGetReplicationPeerConfig(ctx, peerId);
            }
        });
    }

    public void preUpdateReplicationPeerConfig(final String peerId, final ReplicationPeerConfig peerConfig) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver observer, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                observer.preUpdateReplicationPeerConfig(ctx, peerId, peerConfig);
            }
        });
    }

    public void postUpdateReplicationPeerConfig(final String peerId, final ReplicationPeerConfig peerConfig) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver observer, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                observer.postUpdateReplicationPeerConfig(ctx, peerId, peerConfig);
            }
        });
    }

    public void preListReplicationPeers(final String regex) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver observer, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                observer.preListReplicationPeers(ctx, regex);
            }
        });
    }

    public void postListReplicationPeers(final String regex) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver observer, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                observer.postListReplicationPeers(ctx, regex);
            }
        });
    }

    public void preRequestLock(final String namespace, final TableName tableName, final HRegionInfo[] regionInfos, final LockType type, final String description) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.preRequestLock(ctx, namespace, tableName, regionInfos, type, description);
            }
        });
    }

    public void postRequestLock(final String namespace, final TableName tableName, final HRegionInfo[] regionInfos, final LockType type, final String description) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.postRequestLock(ctx, namespace, tableName, regionInfos, type, description);
            }
        });
    }

    public void preLockHeartbeat(final LockProcedure proc, final boolean keepAlive) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.preLockHeartbeat(ctx, proc, keepAlive);
            }
        });
    }

    public void postLockHeartbeat(final LockProcedure proc, final boolean keepAlive) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.postLockHeartbeat(ctx, proc, keepAlive);
            }
        });
    }

    public void preListDeadServers() throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.preListDeadServers(ctx);
            }
        });
    }

    public void postListDeadServers() throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.postListDeadServers(ctx);
            }
        });
    }

    public void preClearDeadServers() throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.preClearDeadServers(ctx);
            }
        });
    }

    public void postClearDeadServers() throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(MasterObserver oserver, ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
                oserver.postClearDeadServers(ctx);
            }
        });
    }

    private static abstract class CoprocessorOperationWithResult<T>
    extends CoprocessorOperation {
        private T result = null;

        private CoprocessorOperationWithResult() {
        }

        public void setResult(T result) {
            this.result = result;
        }

        public T getResult() {
            return this.result;
        }
    }

    private static abstract class CoprocessorOperation
    extends ObserverContext<MasterCoprocessorEnvironment> {
        public CoprocessorOperation() {
            this(RpcServer.getRequestUser());
        }

        public CoprocessorOperation(User user) {
            super(user);
        }

        public abstract void call(MasterObserver var1, ObserverContext<MasterCoprocessorEnvironment> var2) throws IOException;

        public void postEnvCall(MasterEnvironment env) {
        }
    }

    static class MasterEnvironment
    extends CoprocessorHost.Environment
    implements MasterCoprocessorEnvironment {
        private final MasterServices masterServices;
        private final boolean supportGroupCPs;
        private final MetricRegistry metricRegistry;

        public MasterEnvironment(Class<?> implClass, Coprocessor impl, int priority, int seq, Configuration conf, MasterServices services) {
            super(impl, priority, seq, conf);
            this.masterServices = services;
            this.supportGroupCPs = !MasterCoprocessorHost.useLegacyMethod(impl.getClass(), "preBalanceRSGroup", new Class[]{ObserverContext.class, String.class});
            this.metricRegistry = MetricsCoprocessor.createRegistryForMasterCoprocessor(implClass.getName());
        }

        @Override
        public MasterServices getMasterServices() {
            return this.masterServices;
        }

        @Override
        public MetricRegistry getMetricRegistryForMaster() {
            return this.metricRegistry;
        }

        @Override
        protected void shutdown() {
            super.shutdown();
            MetricsCoprocessor.removeRegistry(this.metricRegistry);
        }
    }
}

