/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hbase.ClusterId;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.backup.HFileArchiver;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.fs.HFileSystem;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSTableDescriptors;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class MasterFileSystem {
    private static final Log LOG = LogFactory.getLog(MasterFileSystem.class);
    public static final String HBASE_DIR_PERMS = "hbase.rootdir.perms";
    public static final String HBASE_WAL_DIR_PERMS = "hbase.wal.dir.perms";
    private final Configuration conf;
    private ClusterId clusterId;
    private final FileSystem fs;
    private final FileSystem walFs;
    private final Path rootdir;
    private final Path tempdir;
    private final Path walRootDir;
    private final FsPermission secureRootSubDirPerms;
    private final FsPermission secureRootFilePerms = new FsPermission("600");
    private final FsPermission HiddenDirPerms = FsPermission.valueOf("-rwx--x--x");
    private boolean isSecurityEnabled;
    private final MasterServices services;

    public MasterFileSystem(MasterServices services) throws IOException {
        this.conf = services.getConfiguration();
        this.services = services;
        this.rootdir = FSUtils.getRootDir(this.conf);
        this.tempdir = new Path(this.rootdir, ".tmp");
        this.fs = this.rootdir.getFileSystem(this.conf);
        this.walRootDir = FSUtils.getWALRootDir(this.conf);
        this.walFs = FSUtils.getWALFileSystem(this.conf);
        FSUtils.setFsDefault(this.conf, new Path(this.walFs.getUri()));
        this.walFs.setConf(this.conf);
        FSUtils.setFsDefault(this.conf, new Path(this.fs.getUri()));
        this.fs.setConf(this.conf);
        this.secureRootSubDirPerms = new FsPermission(this.conf.get(HBASE_DIR_PERMS, "700"));
        this.isSecurityEnabled = "kerberos".equalsIgnoreCase(this.conf.get("hbase.security.authentication"));
        this.createInitialFileSystemLayout();
        HFileSystem.addLocationsOrderInterceptor(this.conf);
    }

    private void createInitialFileSystemLayout() throws IOException {
        FsPermission currentRootPerms;
        String[] protectedSubDirs = new String[]{"data", "archive", ".hbck", "mobdir"};
        String[] protectedSubLogDirs = new String[]{"WALs", "oldWALs", "corrupt", "MasterProcWALs"};
        this.checkRootDir(this.rootdir, this.conf, this.fs);
        this.checkTempDir(this.tempdir, this.conf, this.fs);
        for (String subDir : protectedSubDirs) {
            this.checkSubDir(new Path(this.rootdir, subDir), HBASE_DIR_PERMS);
        }
        String perms = !this.walRootDir.equals(this.rootdir) ? HBASE_WAL_DIR_PERMS : HBASE_DIR_PERMS;
        for (String subDir : protectedSubLogDirs) {
            this.checkSubDir(new Path(this.walRootDir, subDir), perms);
        }
        this.checkStagingDir();
        if (this.isSecurityEnabled) {
            this.fs.setPermission(new Path(this.rootdir, "hbase.version"), this.secureRootFilePerms);
            this.fs.setPermission(new Path(this.rootdir, "hbase.id"), this.secureRootFilePerms);
        }
        if (!((currentRootPerms = this.fs.getFileStatus(this.rootdir).getPermission()).getUserAction().implies(FsAction.EXECUTE) && currentRootPerms.getGroupAction().implies(FsAction.EXECUTE) && currentRootPerms.getOtherAction().implies(FsAction.EXECUTE))) {
            LOG.warn((Object)"rootdir permissions do not contain 'excute' for user, group or other. Automatically adding 'excute' permission for all");
            this.fs.setPermission(this.rootdir, new FsPermission(currentRootPerms.getUserAction().or(FsAction.EXECUTE), currentRootPerms.getGroupAction().or(FsAction.EXECUTE), currentRootPerms.getOtherAction().or(FsAction.EXECUTE)));
        }
    }

    public FileSystem getFileSystem() {
        return this.fs;
    }

    protected FileSystem getWALFileSystem() {
        return this.walFs;
    }

    public Configuration getConfiguration() {
        return this.conf;
    }

    public Path getRootDir() {
        return this.rootdir;
    }

    public Path getWALRootDir() {
        return this.walRootDir;
    }

    public Path getTempDir() {
        return this.tempdir;
    }

    public ClusterId getClusterId() {
        return this.clusterId;
    }

    private Path checkRootDir(Path rd, Configuration c, FileSystem fs) throws IOException {
        FSUtils.waitOnSafeMode(c, c.getInt("hbase.server.thread.wakefrequency", 10000));
        try {
            if (!fs.exists(rd)) {
                fs.mkdirs(rd);
                FSUtils.setVersion(fs, rd, c.getInt("hbase.server.thread.wakefrequency", 10000), c.getInt("hbase.server.versionfile.writeattempts", 3));
            } else {
                if (!fs.isDirectory(rd)) {
                    throw new IllegalArgumentException(rd.toString() + " is not a directory");
                }
                FSUtils.checkVersion(fs, rd, true, c.getInt("hbase.server.thread.wakefrequency", 10000), c.getInt("hbase.server.versionfile.writeattempts", 3));
            }
        }
        catch (DeserializationException de) {
            LOG.fatal((Object)"Please fix invalid configuration for hbase.rootdir", (Throwable)de);
            IOException ioe = new IOException();
            ioe.initCause(de);
            throw ioe;
        }
        catch (IllegalArgumentException iae) {
            LOG.fatal((Object)("Please fix invalid configuration for hbase.rootdir " + rd.toString()), (Throwable)iae);
            throw iae;
        }
        if (!FSUtils.checkClusterIdExists(fs, rd, c.getInt("hbase.server.thread.wakefrequency", 10000))) {
            FSUtils.setClusterId(fs, rd, new ClusterId(), c.getInt("hbase.server.thread.wakefrequency", 10000));
        }
        this.clusterId = FSUtils.getClusterId(fs, rd);
        if (!FSUtils.metaRegionExists(fs, rd)) {
            MasterFileSystem.bootstrap(rd, c);
        }
        FSTableDescriptors fsd = new FSTableDescriptors(c, fs, rd);
        fsd.createTableDescriptor(fsd.get(TableName.META_TABLE_NAME));
        return rd;
    }

    private void checkTempDir(Path tmpdir, Configuration c, FileSystem fs) throws IOException {
        if (fs.exists(tmpdir)) {
            for (Path tabledir : FSUtils.getTableDirs(fs, tmpdir)) {
                for (Path regiondir : FSUtils.getRegionDirs(fs, tabledir)) {
                    HFileArchiver.archiveRegion(fs, this.rootdir, tabledir, regiondir);
                }
            }
            if (!fs.delete(tmpdir, true)) {
                throw new IOException("Unable to clean the temp directory: " + tmpdir);
            }
        }
        if (this.isSecurityEnabled ? !fs.mkdirs(tmpdir, this.secureRootSubDirPerms) : !fs.mkdirs(tmpdir)) {
            throw new IOException("HBase temp directory '" + tmpdir + "' creation failure.");
        }
    }

    private void checkSubDir(Path p, String dirPermsConfName) throws IOException {
        FileSystem fs = p.getFileSystem(this.conf);
        FsPermission dirPerms = new FsPermission(this.conf.get(dirPermsConfName, "700"));
        if (!fs.exists(p)) {
            if (this.isSecurityEnabled ? !fs.mkdirs(p, this.secureRootSubDirPerms) : !fs.mkdirs(p)) {
                throw new IOException("HBase directory '" + p + "' creation failure.");
            }
        } else if (this.isSecurityEnabled && !dirPerms.equals(fs.getFileStatus(p).getPermission())) {
            LOG.warn((Object)("Found HBase directory permissions NOT matching expected permissions for " + p.toString() + " permissions=" + fs.getFileStatus(p).getPermission() + ", expecting " + dirPerms + ". Automatically setting the permissions. You can change the permissions by setting \"" + dirPermsConfName + "\" in hbase-site.xml and restarting the master"));
            fs.setPermission(p, dirPerms);
        }
    }

    private void checkStagingDir() throws IOException {
        Path p = new Path(this.rootdir, "staging");
        try {
            if (!this.fs.exists(p)) {
                if (!this.fs.mkdirs(p, this.HiddenDirPerms)) {
                    throw new IOException("Failed to create staging directory " + p.toString());
                }
            } else {
                this.fs.setPermission(p, this.HiddenDirPerms);
            }
        }
        catch (IOException e) {
            LOG.error((Object)("Failed to create or set permission on staging directory " + p.toString()));
            throw new IOException("Failed to create or set permission on staging directory " + p.toString(), e);
        }
    }

    private static void bootstrap(Path rd, Configuration c) throws IOException {
        LOG.info((Object)"BOOTSTRAP: creating hbase:meta region");
        try {
            HRegionInfo metaHRI = new HRegionInfo(HRegionInfo.FIRST_META_REGIONINFO);
            TableDescriptor metaDescriptor = new FSTableDescriptors(c).get(TableName.META_TABLE_NAME);
            HRegion meta = HRegion.createHRegion(metaHRI, rd, c, MasterFileSystem.setInfoFamilyCachingForMeta(metaDescriptor, false), null);
            meta.close();
        }
        catch (IOException e) {
            e = e instanceof RemoteException ? ((RemoteException)e).unwrapRemoteException() : e;
            LOG.error((Object)"bootstrap", (Throwable)e);
            throw e;
        }
    }

    public static TableDescriptor setInfoFamilyCachingForMeta(TableDescriptor metaDescriptor, boolean b) {
        TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder(metaDescriptor);
        for (ColumnFamilyDescriptor hcd : metaDescriptor.getColumnFamilies()) {
            if (!Bytes.equals(hcd.getName(), HConstants.CATALOG_FAMILY)) continue;
            builder.modifyColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder(hcd).setBlockCacheEnabled(b).setInMemory(b).build());
        }
        return builder.build();
    }

    public void deleteFamilyFromFS(HRegionInfo region, byte[] familyName) throws IOException {
        this.deleteFamilyFromFS(this.rootdir, region, familyName);
    }

    public void deleteFamilyFromFS(Path rootDir, HRegionInfo region, byte[] familyName) throws IOException {
        Path tableDir = FSUtils.getTableDir(rootDir, region.getTable());
        HFileArchiver.archiveFamily(this.fs, this.conf, region, tableDir, familyName);
        Path familyDir = new Path(tableDir, new Path(region.getEncodedName(), Bytes.toString(familyName)));
        if (!this.fs.delete(familyDir, true) && this.fs.exists(familyDir)) {
            throw new IOException("Could not delete family " + Bytes.toString(familyName) + " from FileSystem for region " + region.getRegionNameAsString() + "(" + region.getEncodedName() + ")");
        }
    }

    public void stop() {
    }

    public void logFileSystemState(Log log) throws IOException {
        FSUtils.logFileSystemState(this.fs, this.rootdir, log);
    }
}

