/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.client.TableState;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.master.assignment.AssignmentManager;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.KeeperException;
import org.apache.hadoop.hbase.zookeeper.MetaTableLocator;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class MasterMetaBootstrap {
    private static final Log LOG = LogFactory.getLog(MasterMetaBootstrap.class);
    private final MonitoredTask status;
    private final HMaster master;

    public MasterMetaBootstrap(HMaster master, MonitoredTask status) {
        this.master = master;
        this.status = status;
    }

    public void recoverMeta() throws InterruptedException, IOException {
        this.master.recoverMeta();
        this.master.getTableStateManager().start();
        this.enableCrashedServerProcessing(false);
    }

    public void processDeadServers() {
        Set<ServerName> previouslyFailedServers = this.master.getMasterWalManager().getFailedServersFromLogFolders();
        for (ServerName tmpServer : previouslyFailedServers) {
            this.master.getServerManager().processDeadServer(tmpServer, true);
        }
    }

    public void assignMetaReplicas() throws IOException, InterruptedException, KeeperException {
        int numReplicas = this.master.getConfiguration().getInt("hbase.meta.replica.count", 1);
        for (int i = 1; i < numReplicas; ++i) {
            this.assignMeta(i);
        }
        this.unassignExcessMetaReplica(numReplicas);
    }

    private void unassignExcessMetaReplica(int numMetaReplicasConfigured) {
        ZooKeeperWatcher zooKeeper = this.master.getZooKeeper();
        try {
            List<String> metaReplicaZnodes = zooKeeper.getMetaReplicaNodes();
            for (String metaReplicaZnode : metaReplicaZnodes) {
                int replicaId = zooKeeper.znodePaths.getMetaReplicaIdFromZnode(metaReplicaZnode);
                if (replicaId < numMetaReplicasConfigured) continue;
                RegionState r = MetaTableLocator.getMetaRegionState(zooKeeper, replicaId);
                LOG.info((Object)("Closing excess replica of meta region " + r.getRegion()));
                ServerManager.closeRegionSilentlyAndWait(this.master.getClusterConnection(), r.getServerName(), r.getRegion(), 30000L);
                ZKUtil.deleteNode(zooKeeper, zooKeeper.znodePaths.getZNodeForReplica(replicaId));
            }
        }
        catch (Exception ex) {
            LOG.warn((Object)("Ignoring exception " + ex));
        }
    }

    protected void assignMeta(int replicaId) throws InterruptedException, IOException, KeeperException {
        AssignmentManager assignmentManager = this.master.getAssignmentManager();
        if (replicaId == 0) {
            this.status.setStatus("Assigning hbase:meta region");
        } else {
            this.status.setStatus("Assigning hbase:meta region, replicaId " + replicaId);
        }
        RegionState metaState = MetaTableLocator.getMetaRegionState(this.master.getZooKeeper(), replicaId);
        LOG.debug((Object)("meta state from zookeeper: " + metaState));
        HRegionInfo hri = RegionReplicaUtil.getRegionInfoForReplica(HRegionInfo.FIRST_META_REGIONINFO, replicaId);
        assignmentManager.assignMeta(hri, metaState.getServerName());
        if (replicaId == 0) {
            this.master.getTableStateManager().setTableState(TableName.META_TABLE_NAME, TableState.State.ENABLED);
        }
        this.master.getTableStateManager().start();
        if (replicaId == 0) {
            this.enableCrashedServerProcessing(false);
        }
        LOG.info((Object)("hbase:meta with replicaId " + replicaId + ", location=" + this.master.getMetaTableLocator().getMetaRegionLocation(this.master.getZooKeeper(), replicaId)));
        this.status.setStatus("META assigned.");
    }

    private void enableCrashedServerProcessing(boolean waitForMeta) throws InterruptedException {
        if (!this.master.isServerCrashProcessingEnabled()) {
            this.master.setServerCrashProcessingEnabled(true);
            this.master.getServerManager().processQueuedDeadServers();
        }
        if (waitForMeta) {
            this.master.getMetaTableLocator().waitMetaRegionLocation(this.master.getZooKeeper());
        }
    }
}

