/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.MetricsMasterFileSystem;
import org.apache.hadoop.hbase.master.SplitLogManager;
import org.apache.hadoop.hbase.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.wal.AbstractFSWALProvider;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class MasterWalManager {
    private static final Log LOG = LogFactory.getLog(MasterWalManager.class);
    static final PathFilter META_FILTER = new PathFilter(){

        @Override
        public boolean accept(Path p) {
            return AbstractFSWALProvider.isMetaFile(p);
        }
    };
    static final PathFilter NON_META_FILTER = new PathFilter(){

        @Override
        public boolean accept(Path p) {
            return !AbstractFSWALProvider.isMetaFile(p);
        }
    };
    private final MetricsMasterFileSystem metricsMasterFilesystem = new MetricsMasterFileSystem();
    private final MasterServices services;
    private final Configuration conf;
    private final FileSystem fs;
    private final Path oldLogDir;
    private final Path rootDir;
    private final Lock splitLogLock = new ReentrantLock();
    private final SplitLogManager splitLogManager;
    private final boolean distributedLogReplay;
    private volatile boolean fsOk = true;

    public MasterWalManager(MasterServices services) throws IOException {
        this(services.getConfiguration(), services.getMasterFileSystem().getWALFileSystem(), services.getMasterFileSystem().getWALRootDir(), services);
    }

    public MasterWalManager(Configuration conf, FileSystem fs, Path rootDir, MasterServices services) throws IOException {
        this.fs = fs;
        this.conf = conf;
        this.rootDir = rootDir;
        this.services = services;
        this.splitLogManager = new SplitLogManager(services, conf);
        this.distributedLogReplay = this.splitLogManager.isLogReplaying();
        this.oldLogDir = new Path(rootDir, "oldWALs");
    }

    public void stop() {
        if (this.splitLogManager != null) {
            this.splitLogManager.stop();
        }
    }

    @VisibleForTesting
    SplitLogManager getSplitLogManager() {
        return this.splitLogManager;
    }

    Path getOldLogDir() {
        return this.oldLogDir;
    }

    public FileSystem getFileSystem() {
        return this.fs;
    }

    private boolean checkFileSystem() {
        if (this.fsOk) {
            try {
                FSUtils.checkFileSystemAvailable(this.fs);
                FSUtils.checkDfsSafeMode(this.conf);
            }
            catch (IOException e) {
                this.services.abort("Shutting down HBase cluster: file system not available", e);
                this.fsOk = false;
            }
        }
        return this.fsOk;
    }

    public Set<ServerName> getFailedServersFromLogFolders() {
        boolean retrySplitting = !this.conf.getBoolean("hbase.hlog.split.skip.errors", false);
        HashSet<ServerName> serverNames = new HashSet<ServerName>();
        Path logsDirPath = new Path(this.rootDir, "WALs");
        do {
            if (this.services.isStopped()) {
                LOG.warn((Object)"Master stopped while trying to get failed servers.");
                break;
            }
            try {
                if (!this.fs.exists(logsDirPath)) {
                    return serverNames;
                }
                FileStatus[] logFolders = FSUtils.listStatus(this.fs, logsDirPath, null);
                Set<ServerName> onlineServers = this.services.getServerManager().getOnlineServers().keySet();
                if (logFolders == null || logFolders.length == 0) {
                    LOG.debug((Object)"No log files to split, proceeding...");
                    return serverNames;
                }
                for (FileStatus status : logFolders) {
                    FileStatus[] curLogFiles = FSUtils.listStatus(this.fs, status.getPath(), null);
                    if (curLogFiles == null || curLogFiles.length == 0) continue;
                    ServerName serverName = AbstractFSWALProvider.getServerNameFromWALDirectoryName(status.getPath());
                    if (null == serverName) {
                        LOG.warn((Object)("Log folder " + status.getPath() + " doesn't look like its name includes a region server name; leaving in place. If you see later errors about missing write ahead logs they may be saved in this location."));
                        continue;
                    }
                    if (!onlineServers.contains(serverName)) {
                        LOG.info((Object)("Log folder " + status.getPath() + " doesn't belong to a known region server, splitting"));
                        serverNames.add(serverName);
                        continue;
                    }
                    LOG.info((Object)("Log folder " + status.getPath() + " belongs to an existing region server"));
                }
                retrySplitting = false;
            }
            catch (IOException ioe) {
                LOG.warn((Object)"Failed getting failed servers to be recovered.", (Throwable)ioe);
                if (!this.checkFileSystem()) {
                    LOG.warn((Object)"Bad Filesystem, exiting");
                    Runtime.getRuntime().halt(1);
                }
                try {
                    if (!retrySplitting) continue;
                    Thread.sleep(this.conf.getInt("hbase.hlog.split.failure.retry.interval", 30000));
                }
                catch (InterruptedException e) {
                    LOG.warn((Object)"Interrupted, aborting since cannot return w/o splitting");
                    Thread.currentThread().interrupt();
                    retrySplitting = false;
                    Runtime.getRuntime().halt(1);
                }
            }
        } while (retrySplitting);
        return serverNames;
    }

    public void splitLog(ServerName serverName) throws IOException {
        this.splitLog(Collections.singleton(serverName));
    }

    public void splitMetaLog(ServerName serverName) throws IOException {
        this.splitMetaLog(Collections.singleton(serverName));
    }

    public void splitMetaLog(Set<ServerName> serverNames) throws IOException {
        this.splitLog(serverNames, META_FILTER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressWarnings(value={"UL_UNRELEASED_LOCK"}, justification="We only release this lock when we set it. Updates to code that uses it should verify use of the guard boolean.")
    private List<Path> getLogDirs(Set<ServerName> serverNames) throws IOException {
        ArrayList<Path> logDirs = new ArrayList<Path>();
        boolean needReleaseLock = false;
        if (!this.services.isInitialized()) {
            this.splitLogLock.lock();
            needReleaseLock = true;
        }
        try {
            for (ServerName serverName : serverNames) {
                Path logDir = new Path(this.rootDir, AbstractFSWALProvider.getWALDirectoryName(serverName.toString()));
                Path splitDir = logDir.suffix("-splitting");
                if (this.fs.exists(logDir)) {
                    if (!this.fs.rename(logDir, splitDir)) {
                        throw new IOException("Failed fs.rename for log split: " + logDir);
                    }
                    logDir = splitDir;
                    LOG.debug((Object)("Renamed region directory: " + splitDir));
                } else if (!this.fs.exists(splitDir)) {
                    LOG.info((Object)("Log dir for server " + serverName + " does not exist"));
                    continue;
                }
                logDirs.add(splitDir);
            }
        }
        catch (IOException ioe) {
            if (!this.checkFileSystem()) {
                this.services.abort("Aborting due to filesystem unavailable", ioe);
                throw ioe;
            }
        }
        finally {
            if (needReleaseLock) {
                this.splitLogLock.unlock();
            }
        }
        return logDirs;
    }

    public void prepareLogReplay(ServerName serverName, Set<HRegionInfo> regions) throws IOException {
        if (!this.distributedLogReplay) {
            return;
        }
        if (regions == null || regions.isEmpty()) {
            return;
        }
        this.splitLogManager.markRegionsRecovering(serverName, regions);
    }

    public void splitLog(Set<ServerName> serverNames) throws IOException {
        this.splitLog(serverNames, NON_META_FILTER);
    }

    void removeStaleRecoveringRegionsFromZK(Set<ServerName> failedServers) throws IOException, InterruptedIOException {
        this.splitLogManager.removeStaleRecoveringRegions(failedServers);
    }

    public void splitLog(Set<ServerName> serverNames, PathFilter filter) throws IOException {
        long splitTime = 0L;
        long splitLogSize = 0L;
        List<Path> logDirs = this.getLogDirs(serverNames);
        this.splitLogManager.handleDeadWorkers(serverNames);
        splitTime = EnvironmentEdgeManager.currentTime();
        splitLogSize = this.splitLogManager.splitLogDistributed(serverNames, logDirs, filter);
        splitTime = EnvironmentEdgeManager.currentTime() - splitTime;
        if (this.metricsMasterFilesystem != null) {
            if (filter == META_FILTER) {
                this.metricsMasterFilesystem.addMetaWALSplit(splitTime, splitLogSize);
            } else {
                this.metricsMasterFilesystem.addSplit(splitTime, splitLogSize);
            }
        }
    }
}

