/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.ScheduledChore;
import org.apache.hadoop.hbase.TableDescriptors;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableState;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.locking.LockManager;
import org.apache.hadoop.hbase.mob.MobUtils;
import org.apache.hadoop.hbase.procedure2.LockType;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class MobCompactionChore
extends ScheduledChore {
    private static final Log LOG = LogFactory.getLog(MobCompactionChore.class);
    private HMaster master;
    private ExecutorService pool;

    public MobCompactionChore(HMaster master, int period) {
        super(master.getServerName() + "-MobCompactionChore", master, period, period, TimeUnit.SECONDS);
        this.master = master;
        this.pool = MobUtils.createMobCompactorThreadPool(master.getConfiguration());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void chore() {
        try {
            TableDescriptors htds = this.master.getTableDescriptors();
            Map<String, TableDescriptor> map = htds.getAll();
            for (TableDescriptor htd : map.values()) {
                if (!this.master.getTableStateManager().isTableState(htd.getTableName(), TableState.State.ENABLED)) continue;
                boolean reported = false;
                try {
                    LockManager.MasterLock lock = this.master.getLockManager().createMasterLock(MobUtils.getTableLockName(htd.getTableName()), LockType.EXCLUSIVE, this.getClass().getName() + ": mob compaction");
                    for (ColumnFamilyDescriptor hcd : htd.getColumnFamilies()) {
                        if (!hcd.isMobEnabled()) continue;
                        if (!reported) {
                            this.master.reportMobCompactionStart(htd.getTableName());
                            reported = true;
                        }
                        MobUtils.doMobCompaction(this.master.getConfiguration(), this.master.getFileSystem(), htd.getTableName(), hcd, this.pool, false, lock);
                    }
                }
                finally {
                    if (!reported) continue;
                    this.master.reportMobCompactionEnd(htd.getTableName());
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to compact mob files", (Throwable)e);
        }
    }

    @Override
    protected void cleanup() {
        super.cleanup();
        this.pool.shutdown();
    }
}

