/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.favored.FavoredNodeAssignmentHelper;
import org.apache.hadoop.hbase.favored.FavoredNodesPlan;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class SnapshotOfRegionAssignmentFromMeta {
    private static final Log LOG = LogFactory.getLog((String)SnapshotOfRegionAssignmentFromMeta.class.getName());
    private final Connection connection;
    private final Map<TableName, List<HRegionInfo>> tableToRegionMap;
    private Map<HRegionInfo, ServerName> regionToRegionServerMap;
    private final Map<String, HRegionInfo> regionNameToRegionInfoMap;
    private final Map<ServerName, List<HRegionInfo>> currentRSToRegionMap;
    private final Map<ServerName, List<HRegionInfo>> secondaryRSToRegionMap;
    private final Map<ServerName, List<HRegionInfo>> teritiaryRSToRegionMap;
    private final Map<ServerName, List<HRegionInfo>> primaryRSToRegionMap;
    private final FavoredNodesPlan existingAssignmentPlan;
    private final Set<TableName> disabledTables;
    private final boolean excludeOfflinedSplitParents;

    public SnapshotOfRegionAssignmentFromMeta(Connection connection) {
        this(connection, new HashSet<TableName>(), false);
    }

    public SnapshotOfRegionAssignmentFromMeta(Connection connection, Set<TableName> disabledTables, boolean excludeOfflinedSplitParents) {
        this.connection = connection;
        this.tableToRegionMap = new HashMap<TableName, List<HRegionInfo>>();
        this.regionToRegionServerMap = new HashMap<HRegionInfo, ServerName>();
        this.currentRSToRegionMap = new HashMap<ServerName, List<HRegionInfo>>();
        this.primaryRSToRegionMap = new HashMap<ServerName, List<HRegionInfo>>();
        this.secondaryRSToRegionMap = new HashMap<ServerName, List<HRegionInfo>>();
        this.teritiaryRSToRegionMap = new HashMap<ServerName, List<HRegionInfo>>();
        this.regionNameToRegionInfoMap = new TreeMap<String, HRegionInfo>();
        this.existingAssignmentPlan = new FavoredNodesPlan();
        this.disabledTables = disabledTables;
        this.excludeOfflinedSplitParents = excludeOfflinedSplitParents;
    }

    public void initialize() throws IOException {
        LOG.info((Object)"Start to scan the hbase:meta for the current region assignment snappshot");
        MetaTableAccessor.Visitor v = new MetaTableAccessor.Visitor(){

            @Override
            public boolean visit(Result result) throws IOException {
                try {
                    if (result == null || result.isEmpty()) {
                        return true;
                    }
                    RegionLocations rl = MetaTableAccessor.getRegionLocations(result);
                    if (rl == null) {
                        return true;
                    }
                    HRegionInfo hri = rl.getRegionLocation(0).getRegionInfo();
                    if (hri == null) {
                        return true;
                    }
                    if (hri.getTable() == null) {
                        return true;
                    }
                    if (SnapshotOfRegionAssignmentFromMeta.this.disabledTables.contains(hri.getTable())) {
                        return true;
                    }
                    if (SnapshotOfRegionAssignmentFromMeta.this.excludeOfflinedSplitParents && hri.isSplit()) {
                        return true;
                    }
                    HRegionLocation[] hrls = rl.getRegionLocations();
                    for (int i = 0; i < hrls.length; ++i) {
                        if (hrls[i] == null || (hri = hrls[i].getRegionInfo()) == null) continue;
                        SnapshotOfRegionAssignmentFromMeta.this.addAssignment(hri, hrls[i].getServerName());
                        SnapshotOfRegionAssignmentFromMeta.this.addRegion(hri);
                    }
                    hri = rl.getRegionLocation(0).getRegionInfo();
                    byte[] favoredNodes = result.getValue(HConstants.CATALOG_FAMILY, FavoredNodeAssignmentHelper.FAVOREDNODES_QUALIFIER);
                    if (favoredNodes == null) {
                        return true;
                    }
                    Object[] favoredServerList = FavoredNodeAssignmentHelper.getFavoredNodesList(favoredNodes);
                    SnapshotOfRegionAssignmentFromMeta.this.existingAssignmentPlan.updateFavoredNodesMap(hri, Arrays.asList(favoredServerList));
                    if (favoredServerList.length != 3) {
                        LOG.warn((Object)("Insufficient favored nodes for region " + hri + " fn: " + Arrays.toString(favoredServerList)));
                    }
                    for (int i = 0; i < favoredServerList.length; ++i) {
                        if (i == FavoredNodesPlan.Position.PRIMARY.ordinal()) {
                            SnapshotOfRegionAssignmentFromMeta.this.addPrimaryAssignment(hri, (ServerName)favoredServerList[i]);
                        }
                        if (i == FavoredNodesPlan.Position.SECONDARY.ordinal()) {
                            SnapshotOfRegionAssignmentFromMeta.this.addSecondaryAssignment(hri, (ServerName)favoredServerList[i]);
                        }
                        if (i != FavoredNodesPlan.Position.TERTIARY.ordinal()) continue;
                        SnapshotOfRegionAssignmentFromMeta.this.addTeritiaryAssignment(hri, (ServerName)favoredServerList[i]);
                    }
                    return true;
                }
                catch (RuntimeException e) {
                    LOG.error((Object)("Catche remote exception " + e.getMessage() + " when processing" + result));
                    throw e;
                }
            }
        };
        MetaTableAccessor.fullScanRegions(this.connection, v);
        LOG.info((Object)"Finished to scan the hbase:meta for the current region assignmentsnapshot");
    }

    private void addRegion(HRegionInfo regionInfo) {
        this.regionNameToRegionInfoMap.put(regionInfo.getRegionNameAsString(), regionInfo);
        TableName tableName = regionInfo.getTable();
        List<HRegionInfo> regionList = this.tableToRegionMap.get(tableName);
        if (regionList == null) {
            regionList = new ArrayList<HRegionInfo>();
        }
        regionList.add(regionInfo);
        this.tableToRegionMap.put(tableName, regionList);
    }

    private void addAssignment(HRegionInfo regionInfo, ServerName server) {
        this.regionToRegionServerMap.put(regionInfo, server);
        if (server == null) {
            return;
        }
        List<HRegionInfo> regionList = this.currentRSToRegionMap.get(server);
        if (regionList == null) {
            regionList = new ArrayList<HRegionInfo>();
        }
        regionList.add(regionInfo);
        this.currentRSToRegionMap.put(server, regionList);
    }

    private void addPrimaryAssignment(HRegionInfo regionInfo, ServerName server) {
        List<HRegionInfo> regionList = this.primaryRSToRegionMap.get(server);
        if (regionList == null) {
            regionList = new ArrayList<HRegionInfo>();
        }
        regionList.add(regionInfo);
        this.primaryRSToRegionMap.put(server, regionList);
    }

    private void addSecondaryAssignment(HRegionInfo regionInfo, ServerName server) {
        List<HRegionInfo> regionList = this.secondaryRSToRegionMap.get(server);
        if (regionList == null) {
            regionList = new ArrayList<HRegionInfo>();
        }
        regionList.add(regionInfo);
        this.secondaryRSToRegionMap.put(server, regionList);
    }

    private void addTeritiaryAssignment(HRegionInfo regionInfo, ServerName server) {
        List<HRegionInfo> regionList = this.teritiaryRSToRegionMap.get(server);
        if (regionList == null) {
            regionList = new ArrayList<HRegionInfo>();
        }
        regionList.add(regionInfo);
        this.teritiaryRSToRegionMap.put(server, regionList);
    }

    public Map<String, HRegionInfo> getRegionNameToRegionInfoMap() {
        return this.regionNameToRegionInfoMap;
    }

    public Map<TableName, List<HRegionInfo>> getTableToRegionMap() {
        return this.tableToRegionMap;
    }

    public Map<HRegionInfo, ServerName> getRegionToRegionServerMap() {
        return this.regionToRegionServerMap;
    }

    public Map<ServerName, List<HRegionInfo>> getRegionServerToRegionMap() {
        return this.currentRSToRegionMap;
    }

    public FavoredNodesPlan getExistingAssignmentPlan() {
        return this.existingAssignmentPlan;
    }

    public Set<TableName> getTableSet() {
        return this.tableToRegionMap.keySet();
    }

    public Map<ServerName, List<HRegionInfo>> getSecondaryToRegionInfoMap() {
        return this.secondaryRSToRegionMap;
    }

    public Map<ServerName, List<HRegionInfo>> getTertiaryToRegionInfoMap() {
        return this.teritiaryRSToRegionMap;
    }

    public Map<ServerName, List<HRegionInfo>> getPrimaryToRegionInfoMap() {
        return this.primaryRSToRegionMap;
    }
}

