/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.assignment;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.master.assignment.GCRegionProcedure;
import org.apache.hadoop.hbase.master.procedure.AbstractStateMachineTableProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.TableProcedureInterface;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.procedure2.ProcedureSuspendedException;
import org.apache.hadoop.hbase.procedure2.ProcedureYieldException;
import org.apache.hadoop.hbase.procedure2.StateMachineProcedure;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class GCMergedRegionsProcedure
extends AbstractStateMachineTableProcedure<MasterProcedureProtos.GCMergedRegionsState> {
    private static final Log LOG = LogFactory.getLog(GCMergedRegionsProcedure.class);
    private HRegionInfo father;
    private HRegionInfo mother;
    private HRegionInfo mergedChild;

    public GCMergedRegionsProcedure(MasterProcedureEnv env, HRegionInfo mergedChild, HRegionInfo father, HRegionInfo mother) {
        super(env);
        this.father = father;
        this.mother = mother;
        this.mergedChild = mergedChild;
    }

    public GCMergedRegionsProcedure() {
    }

    @Override
    public TableProcedureInterface.TableOperationType getTableOperationType() {
        return TableProcedureInterface.TableOperationType.MERGED_REGIONS_GC;
    }

    @Override
    protected StateMachineProcedure.Flow executeFromState(MasterProcedureEnv env, MasterProcedureProtos.GCMergedRegionsState state) throws ProcedureSuspendedException, ProcedureYieldException, InterruptedException {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)(this + " execute state=" + state));
        }
        try {
            switch (state) {
                case GC_MERGED_REGIONS_PREPARE: {
                    this.setNextState(MasterProcedureProtos.GCMergedRegionsState.GC_MERGED_REGIONS_PURGE);
                    break;
                }
                case GC_MERGED_REGIONS_PURGE: {
                    this.addChildProcedure(this.createGCRegionProcedures(env));
                    this.setNextState(MasterProcedureProtos.GCMergedRegionsState.GC_REGION_EDIT_METADATA);
                    break;
                }
                case GC_REGION_EDIT_METADATA: {
                    MetaTableAccessor.deleteMergeQualifiers(env.getMasterServices().getConnection(), this.mergedChild);
                    return StateMachineProcedure.Flow.NO_MORE_STATE;
                }
                default: {
                    throw new UnsupportedOperationException(this + " unhandled state=" + state);
                }
            }
        }
        catch (IOException ioe) {
            LOG.warn((Object)("Error trying to GC merged regions " + this.father.getShortNameToLog() + " & " + this.mother.getShortNameToLog() + "; retrying..."), (Throwable)ioe);
        }
        return StateMachineProcedure.Flow.HAS_MORE_STATE;
    }

    private GCRegionProcedure[] createGCRegionProcedures(MasterProcedureEnv env) {
        GCRegionProcedure[] procs = new GCRegionProcedure[2];
        int index = 0;
        for (HRegionInfo hri : new HRegionInfo[]{this.father, this.mother}) {
            GCRegionProcedure proc = new GCRegionProcedure(env, hri);
            proc.setOwner(env.getRequestUser().getShortName());
            procs[index++] = proc;
        }
        return procs;
    }

    @Override
    protected void rollbackState(MasterProcedureEnv env, MasterProcedureProtos.GCMergedRegionsState state) throws IOException, InterruptedException {
    }

    @Override
    protected MasterProcedureProtos.GCMergedRegionsState getState(int stateId) {
        return MasterProcedureProtos.GCMergedRegionsState.forNumber(stateId);
    }

    @Override
    protected int getStateId(MasterProcedureProtos.GCMergedRegionsState state) {
        return state.getNumber();
    }

    @Override
    protected MasterProcedureProtos.GCMergedRegionsState getInitialState() {
        return MasterProcedureProtos.GCMergedRegionsState.GC_MERGED_REGIONS_PREPARE;
    }

    @Override
    protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.serializeStateData(serializer);
        MasterProcedureProtos.GCMergedRegionsStateData.Builder msg = MasterProcedureProtos.GCMergedRegionsStateData.newBuilder().setParentA(HRegionInfo.convert(this.father)).setParentB(HRegionInfo.convert(this.mother)).setMergedChild(HRegionInfo.convert(this.mergedChild));
        serializer.serialize(msg.build());
    }

    @Override
    protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.deserializeStateData(serializer);
        MasterProcedureProtos.GCMergedRegionsStateData msg = serializer.deserialize(MasterProcedureProtos.GCMergedRegionsStateData.class);
        this.father = HRegionInfo.convert(msg.getParentA());
        this.mother = HRegionInfo.convert(msg.getParentB());
        this.mergedChild = HRegionInfo.convert(msg.getMergedChild());
    }

    @Override
    public void toStringClassDetails(StringBuilder sb) {
        sb.append(this.getClass().getSimpleName());
        sb.append(" child=");
        sb.append(this.mergedChild.getShortNameToLog());
        sb.append(", father=");
        sb.append(this.father.getShortNameToLog());
        sb.append(", mother=");
        sb.append(this.mother.getShortNameToLog());
    }

    @Override
    public TableName getTableName() {
        return this.mergedChild.getTable();
    }
}

