/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.assignment;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.UnknownRegionException;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.MasterSwitchType;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.exceptions.MergeRegionException;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.master.CatalogJanitor;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.assignment.AssignProcedure;
import org.apache.hadoop.hbase.master.assignment.RegionStates;
import org.apache.hadoop.hbase.master.assignment.UnassignProcedure;
import org.apache.hadoop.hbase.master.assignment.Util;
import org.apache.hadoop.hbase.master.normalizer.NormalizationPlan;
import org.apache.hadoop.hbase.master.procedure.AbstractStateMachineTableProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureUtil;
import org.apache.hadoop.hbase.master.procedure.TableProcedureInterface;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureMetrics;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.procedure2.ProcedureSuspendedException;
import org.apache.hadoop.hbase.procedure2.ProcedureYieldException;
import org.apache.hadoop.hbase.procedure2.StateMachineProcedure;
import org.apache.hadoop.hbase.quotas.QuotaExceededException;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFileInfo;
import org.apache.hadoop.hbase.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class MergeTableRegionsProcedure
extends AbstractStateMachineTableProcedure<MasterProcedureProtos.MergeTableRegionsState> {
    private static final Log LOG = LogFactory.getLog(MergeTableRegionsProcedure.class);
    private Boolean traceEnabled;
    private volatile boolean lock = false;
    private ServerName regionLocation;
    private HRegionInfo[] regionsToMerge;
    private HRegionInfo mergedRegion;
    private boolean forcible;

    public MergeTableRegionsProcedure() {
    }

    public MergeTableRegionsProcedure(MasterProcedureEnv env, HRegionInfo regionToMergeA, HRegionInfo regionToMergeB) throws IOException {
        this(env, regionToMergeA, regionToMergeB, false);
    }

    public MergeTableRegionsProcedure(MasterProcedureEnv env, HRegionInfo regionToMergeA, HRegionInfo regionToMergeB, boolean forcible) throws MergeRegionException {
        this(env, new HRegionInfo[]{regionToMergeA, regionToMergeB}, forcible);
    }

    public MergeTableRegionsProcedure(MasterProcedureEnv env, HRegionInfo[] regionsToMerge, boolean forcible) throws MergeRegionException {
        super(env);
        MergeTableRegionsProcedure.checkRegionsToMerge(regionsToMerge, forcible);
        this.regionsToMerge = regionsToMerge;
        this.mergedRegion = MergeTableRegionsProcedure.createMergedRegionInfo(regionsToMerge);
        this.forcible = forcible;
    }

    private static void checkRegionsToMerge(HRegionInfo[] regionsToMerge, boolean forcible) throws MergeRegionException {
        if (regionsToMerge == null || regionsToMerge.length != 2) {
            throw new MergeRegionException("Expected to merge 2 regions, got: " + Arrays.toString(regionsToMerge));
        }
        MergeTableRegionsProcedure.checkRegionsToMerge(regionsToMerge[0], regionsToMerge[1], forcible);
    }

    private static void checkRegionsToMerge(HRegionInfo regionToMergeA, HRegionInfo regionToMergeB, boolean forcible) throws MergeRegionException {
        if (!regionToMergeA.getTable().equals(regionToMergeB.getTable())) {
            throw new MergeRegionException("Can't merge regions from two different tables: " + regionToMergeA + ", " + regionToMergeB);
        }
        if (regionToMergeA.getReplicaId() != 0 || regionToMergeB.getReplicaId() != 0) {
            throw new MergeRegionException("Can't merge non-default replicas");
        }
        if (!HRegionInfo.areAdjacent(regionToMergeA, regionToMergeB)) {
            String msg = "Unable to merge not adjacent regions " + regionToMergeA.getShortNameToLog() + ", " + regionToMergeB.getShortNameToLog() + " where forcible = " + forcible;
            LOG.warn((Object)msg);
            if (!forcible) {
                throw new MergeRegionException(msg);
            }
        }
    }

    private static HRegionInfo createMergedRegionInfo(HRegionInfo[] regionsToMerge) {
        return MergeTableRegionsProcedure.createMergedRegionInfo(regionsToMerge[0], regionsToMerge[1]);
    }

    private static HRegionInfo createMergedRegionInfo(HRegionInfo regionToMergeA, HRegionInfo regionToMergeB) {
        byte[] startKey = regionToMergeA.compareTo(regionToMergeB) <= 0 ? regionToMergeA.getStartKey() : regionToMergeB.getStartKey();
        byte[] endKey = Bytes.equals(regionToMergeA.getEndKey(), HConstants.EMPTY_BYTE_ARRAY) || !Bytes.equals(regionToMergeB.getEndKey(), HConstants.EMPTY_BYTE_ARRAY) && Bytes.compareTo(regionToMergeA.getEndKey(), regionToMergeB.getEndKey()) > 0 ? regionToMergeA.getEndKey() : regionToMergeB.getEndKey();
        long rid = MergeTableRegionsProcedure.getMergedRegionIdTimestamp(regionToMergeA, regionToMergeB);
        return new HRegionInfo(regionToMergeA.getTable(), startKey, endKey, false, rid);
    }

    private static long getMergedRegionIdTimestamp(HRegionInfo regionToMergeA, HRegionInfo regionToMergeB) {
        long rid = EnvironmentEdgeManager.currentTime();
        if (rid < regionToMergeA.getRegionId() || rid < regionToMergeB.getRegionId()) {
            LOG.warn((Object)("Clock skew; merging regions id are " + regionToMergeA.getRegionId() + " and " + regionToMergeB.getRegionId() + ", but current time here is " + rid));
            rid = Math.max(regionToMergeA.getRegionId(), regionToMergeB.getRegionId()) + 1L;
        }
        return rid;
    }

    @Override
    protected StateMachineProcedure.Flow executeFromState(MasterProcedureEnv env, MasterProcedureProtos.MergeTableRegionsState state) throws ProcedureSuspendedException, ProcedureYieldException, InterruptedException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(this + " execute state=" + state));
        }
        try {
            switch (state) {
                case MERGE_TABLE_REGIONS_PREPARE: {
                    if (!this.prepareMergeRegion(env)) {
                        assert (this.isFailed()) : "Merge region should have an exception here";
                        return StateMachineProcedure.Flow.NO_MORE_STATE;
                    }
                    this.setNextState(MasterProcedureProtos.MergeTableRegionsState.MERGE_TABLE_REGIONS_PRE_MERGE_OPERATION);
                    break;
                }
                case MERGE_TABLE_REGIONS_PRE_MERGE_OPERATION: {
                    this.preMergeRegions(env);
                    this.setNextState(MasterProcedureProtos.MergeTableRegionsState.MERGE_TABLE_REGIONS_SET_MERGING_TABLE_STATE);
                    break;
                }
                case MERGE_TABLE_REGIONS_SET_MERGING_TABLE_STATE: {
                    this.setRegionStateToMerging(env);
                    this.setNextState(MasterProcedureProtos.MergeTableRegionsState.MERGE_TABLE_REGIONS_CLOSE_REGIONS);
                    break;
                }
                case MERGE_TABLE_REGIONS_CLOSE_REGIONS: {
                    this.addChildProcedure(this.createUnassignProcedures(env, this.getRegionReplication(env)));
                    this.setNextState(MasterProcedureProtos.MergeTableRegionsState.MERGE_TABLE_REGIONS_CREATE_MERGED_REGION);
                    break;
                }
                case MERGE_TABLE_REGIONS_CREATE_MERGED_REGION: {
                    this.createMergedRegion(env);
                    this.setNextState(MasterProcedureProtos.MergeTableRegionsState.MERGE_TABLE_REGIONS_PRE_MERGE_COMMIT_OPERATION);
                    break;
                }
                case MERGE_TABLE_REGIONS_PRE_MERGE_COMMIT_OPERATION: {
                    this.preMergeRegionsCommit(env);
                    this.setNextState(MasterProcedureProtos.MergeTableRegionsState.MERGE_TABLE_REGIONS_UPDATE_META);
                    break;
                }
                case MERGE_TABLE_REGIONS_UPDATE_META: {
                    this.updateMetaForMergedRegions(env);
                    this.setNextState(MasterProcedureProtos.MergeTableRegionsState.MERGE_TABLE_REGIONS_POST_MERGE_COMMIT_OPERATION);
                    break;
                }
                case MERGE_TABLE_REGIONS_POST_MERGE_COMMIT_OPERATION: {
                    this.postMergeRegionsCommit(env);
                    this.setNextState(MasterProcedureProtos.MergeTableRegionsState.MERGE_TABLE_REGIONS_OPEN_MERGED_REGION);
                    break;
                }
                case MERGE_TABLE_REGIONS_OPEN_MERGED_REGION: {
                    this.addChildProcedure(this.createAssignProcedures(env, this.getRegionReplication(env)));
                    this.setNextState(MasterProcedureProtos.MergeTableRegionsState.MERGE_TABLE_REGIONS_POST_OPERATION);
                    break;
                }
                case MERGE_TABLE_REGIONS_POST_OPERATION: {
                    this.postCompletedMergeRegions(env);
                    return StateMachineProcedure.Flow.NO_MORE_STATE;
                }
                default: {
                    throw new UnsupportedOperationException(this + " unhandled state=" + state);
                }
            }
        }
        catch (IOException e) {
            LOG.warn((Object)("Error trying to merge regions " + HRegionInfo.getShortNameToLog(this.regionsToMerge) + " in the table " + this.getTableName() + " (in state=" + state + ")"), (Throwable)e);
            this.setFailure("master-merge-regions", e);
        }
        return StateMachineProcedure.Flow.HAS_MORE_STATE;
    }

    @Override
    protected void rollbackState(MasterProcedureEnv env, MasterProcedureProtos.MergeTableRegionsState state) throws IOException, InterruptedException {
        if (this.isTraceEnabled().booleanValue()) {
            LOG.trace((Object)(this + " rollback state=" + state));
        }
        try {
            switch (state) {
                case MERGE_TABLE_REGIONS_UPDATE_META: 
                case MERGE_TABLE_REGIONS_POST_MERGE_COMMIT_OPERATION: 
                case MERGE_TABLE_REGIONS_OPEN_MERGED_REGION: 
                case MERGE_TABLE_REGIONS_POST_OPERATION: {
                    String msg = this + " We are in the " + state + " state. It is complicated to rollback the merge operation that region server is working on. Rollback is not supported and we should let the merge operation to complete";
                    LOG.warn((Object)msg);
                    throw new UnsupportedOperationException(this + " unhandled state=" + state);
                }
                case MERGE_TABLE_REGIONS_PRE_MERGE_COMMIT_OPERATION: {
                    break;
                }
                case MERGE_TABLE_REGIONS_CREATE_MERGED_REGION: {
                    this.cleanupMergedRegion(env);
                    break;
                }
                case MERGE_TABLE_REGIONS_CLOSE_REGIONS: {
                    this.rollbackCloseRegionsForMerge(env);
                    break;
                }
                case MERGE_TABLE_REGIONS_SET_MERGING_TABLE_STATE: {
                    this.setRegionStateToRevertMerging(env);
                    break;
                }
                case MERGE_TABLE_REGIONS_PRE_MERGE_OPERATION: {
                    this.postRollBackMergeRegions(env);
                    break;
                }
                case MERGE_TABLE_REGIONS_MOVE_REGION_TO_SAME_RS: {
                    break;
                }
                case MERGE_TABLE_REGIONS_PREPARE: {
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(this + " unhandled state=" + state);
                }
            }
        }
        catch (Exception e) {
            LOG.warn((Object)("Failed rollback attempt step " + state + " for merging the regions " + HRegionInfo.getShortNameToLog(this.regionsToMerge) + " in table " + this.getTableName()), (Throwable)e);
            throw e;
        }
    }

    @Override
    protected boolean isRollbackSupported(MasterProcedureProtos.MergeTableRegionsState state) {
        switch (state) {
            case MERGE_TABLE_REGIONS_UPDATE_META: 
            case MERGE_TABLE_REGIONS_POST_MERGE_COMMIT_OPERATION: 
            case MERGE_TABLE_REGIONS_OPEN_MERGED_REGION: 
            case MERGE_TABLE_REGIONS_POST_OPERATION: {
                return false;
            }
        }
        return true;
    }

    @Override
    protected MasterProcedureProtos.MergeTableRegionsState getState(int stateId) {
        return MasterProcedureProtos.MergeTableRegionsState.forNumber(stateId);
    }

    @Override
    protected int getStateId(MasterProcedureProtos.MergeTableRegionsState state) {
        return state.getNumber();
    }

    @Override
    protected MasterProcedureProtos.MergeTableRegionsState getInitialState() {
        return MasterProcedureProtos.MergeTableRegionsState.MERGE_TABLE_REGIONS_PREPARE;
    }

    @Override
    protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.serializeStateData(serializer);
        MasterProcedureProtos.MergeTableRegionsStateData.Builder mergeTableRegionsMsg = MasterProcedureProtos.MergeTableRegionsStateData.newBuilder().setUserInfo(MasterProcedureUtil.toProtoUserInfo(this.getUser())).setMergedRegionInfo(HRegionInfo.convert(this.mergedRegion)).setForcible(this.forcible);
        for (int i = 0; i < this.regionsToMerge.length; ++i) {
            mergeTableRegionsMsg.addRegionInfo(HRegionInfo.convert(this.regionsToMerge[i]));
        }
        serializer.serialize(mergeTableRegionsMsg.build());
    }

    @Override
    protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.deserializeStateData(serializer);
        MasterProcedureProtos.MergeTableRegionsStateData mergeTableRegionsMsg = serializer.deserialize(MasterProcedureProtos.MergeTableRegionsStateData.class);
        this.setUser(MasterProcedureUtil.toUserInfo(mergeTableRegionsMsg.getUserInfo()));
        assert (mergeTableRegionsMsg.getRegionInfoCount() == 2);
        this.regionsToMerge = new HRegionInfo[mergeTableRegionsMsg.getRegionInfoCount()];
        for (int i = 0; i < this.regionsToMerge.length; ++i) {
            this.regionsToMerge[i] = HRegionInfo.convert(mergeTableRegionsMsg.getRegionInfo(i));
        }
        this.mergedRegion = HRegionInfo.convert(mergeTableRegionsMsg.getMergedRegionInfo());
    }

    @Override
    public void toStringClassDetails(StringBuilder sb) {
        sb.append(this.getClass().getSimpleName());
        sb.append(" table=");
        sb.append(this.getTableName());
        sb.append(", regions=");
        sb.append(HRegionInfo.getShortNameToLog(this.regionsToMerge));
        sb.append(", forcibly=");
        sb.append(this.forcible);
    }

    @Override
    protected Procedure.LockState acquireLock(MasterProcedureEnv env) {
        if (env.waitInitialized(this)) {
            return Procedure.LockState.LOCK_EVENT_WAIT;
        }
        if (env.getProcedureScheduler().waitRegions(this, this.getTableName(), this.mergedRegion, this.regionsToMerge[0], this.regionsToMerge[1])) {
            try {
                LOG.debug((Object)((Object)((Object)Procedure.LockState.LOCK_EVENT_WAIT) + " " + env.getProcedureScheduler().dumpLocks()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return Procedure.LockState.LOCK_EVENT_WAIT;
        }
        this.lock = true;
        return Procedure.LockState.LOCK_ACQUIRED;
    }

    @Override
    protected void releaseLock(MasterProcedureEnv env) {
        this.lock = false;
        env.getProcedureScheduler().wakeRegions(this, this.getTableName(), this.mergedRegion, this.regionsToMerge[0], this.regionsToMerge[1]);
    }

    @Override
    protected boolean holdLock(MasterProcedureEnv env) {
        return true;
    }

    @Override
    protected boolean hasLock(MasterProcedureEnv env) {
        return this.lock;
    }

    @Override
    public TableName getTableName() {
        return this.mergedRegion.getTable();
    }

    @Override
    public TableProcedureInterface.TableOperationType getTableOperationType() {
        return TableProcedureInterface.TableOperationType.REGION_MERGE;
    }

    @Override
    protected ProcedureMetrics getProcedureMetrics(MasterProcedureEnv env) {
        return env.getAssignmentManager().getAssignmentManagerMetrics().getMergeProcMetrics();
    }

    private boolean prepareMergeRegion(MasterProcedureEnv env) throws IOException {
        boolean regionAHasMergeQualifier;
        CatalogJanitor catalogJanitor = env.getMasterServices().getCatalogJanitor();
        boolean bl = regionAHasMergeQualifier = !catalogJanitor.cleanMergeQualifier(this.regionsToMerge[0]);
        if (regionAHasMergeQualifier || !catalogJanitor.cleanMergeQualifier(this.regionsToMerge[1])) {
            String msg = "Skip merging regions " + HRegionInfo.getShortNameToLog(this.regionsToMerge) + ", because region " + (regionAHasMergeQualifier ? this.regionsToMerge[0].getEncodedName() : this.regionsToMerge[1].getEncodedName()) + " has merge qualifier";
            LOG.warn((Object)msg);
            throw new MergeRegionException(msg);
        }
        RegionStates regionStates = env.getAssignmentManager().getRegionStates();
        RegionState regionStateA = regionStates.getRegionState(this.regionsToMerge[0].getEncodedName());
        RegionState regionStateB = regionStates.getRegionState(this.regionsToMerge[1].getEncodedName());
        if (regionStateA == null || regionStateB == null) {
            throw new UnknownRegionException(regionStateA == null ? this.regionsToMerge[0].getEncodedName() : this.regionsToMerge[1].getEncodedName());
        }
        if (!regionStateA.isOpened() || !regionStateB.isOpened()) {
            throw new MergeRegionException("Unable to merge regions not online " + regionStateA + ", " + regionStateB);
        }
        if (!env.getMasterServices().isSplitOrMergeEnabled(MasterSwitchType.MERGE)) {
            String regionsStr = Arrays.deepToString(this.regionsToMerge);
            LOG.warn((Object)("merge switch is off! skip merge of " + regionsStr));
            super.setFailure(this.getClass().getSimpleName(), new IOException("Merge of " + regionsStr + " failed because merge switch is off"));
            return false;
        }
        IOException mergeableCheckIOE = null;
        boolean mergeable = false;
        RegionState current = regionStateA;
        try {
            mergeable = this.isMergeable(env, current);
        }
        catch (IOException e) {
            mergeableCheckIOE = e;
        }
        if (mergeable && mergeableCheckIOE == null) {
            current = regionStateB;
            try {
                mergeable = this.isMergeable(env, current);
            }
            catch (IOException e) {
                mergeableCheckIOE = e;
            }
        }
        if (!mergeable) {
            e = new IOException(current.getRegion().getShortNameToLog() + " NOT mergeable");
            if (mergeableCheckIOE != null) {
                e.initCause(mergeableCheckIOE);
            }
            super.setFailure(this.getClass().getSimpleName(), e);
            return false;
        }
        return true;
    }

    private boolean isMergeable(MasterProcedureEnv env, RegionState rs) throws IOException {
        AdminProtos.GetRegionInfoResponse response = Util.getRegionInfoResponse(env, rs.getServerName(), rs.getRegion());
        return response.hasMergeable() && response.getMergeable();
    }

    private void preMergeRegions(MasterProcedureEnv env) throws IOException {
        boolean ret;
        MasterCoprocessorHost cpHost = env.getMasterCoprocessorHost();
        if (cpHost != null && (ret = cpHost.preMergeRegionsAction(this.regionsToMerge, this.getUser()))) {
            throw new IOException("Coprocessor bypassing regions " + HRegionInfo.getShortNameToLog(this.regionsToMerge) + " merge.");
        }
        try {
            env.getMasterServices().getMasterQuotaManager().onRegionMerged(this.mergedRegion);
        }
        catch (QuotaExceededException e) {
            env.getAssignmentManager().getRegionNormalizer().planSkipped(this.mergedRegion, NormalizationPlan.PlanType.MERGE);
            throw e;
        }
    }

    private void postRollBackMergeRegions(MasterProcedureEnv env) throws IOException {
        MasterCoprocessorHost cpHost = env.getMasterCoprocessorHost();
        if (cpHost != null) {
            cpHost.postRollBackMergeRegionsAction(this.regionsToMerge, this.getUser());
        }
    }

    public void setRegionStateToMerging(MasterProcedureEnv env) throws IOException {
    }

    private void setRegionStateToRevertMerging(MasterProcedureEnv env) throws IOException {
    }

    private void createMergedRegion(MasterProcedureEnv env) throws IOException {
        MasterFileSystem mfs = env.getMasterServices().getMasterFileSystem();
        Path tabledir = FSUtils.getTableDir(mfs.getRootDir(), this.regionsToMerge[0].getTable());
        FileSystem fs = mfs.getFileSystem();
        HRegionFileSystem regionFs = HRegionFileSystem.openRegionFromFileSystem(env.getMasterConfiguration(), fs, tabledir, this.regionsToMerge[0], false);
        regionFs.createMergesDir();
        this.mergeStoreFiles(env, regionFs, regionFs.getMergesDir());
        HRegionFileSystem regionFs2 = HRegionFileSystem.openRegionFromFileSystem(env.getMasterConfiguration(), fs, tabledir, this.regionsToMerge[1], false);
        this.mergeStoreFiles(env, regionFs2, regionFs.getMergesDir());
        regionFs.commitMergedRegion(this.mergedRegion);
    }

    private void mergeStoreFiles(MasterProcedureEnv env, HRegionFileSystem regionFs, Path mergedDir) throws IOException {
        MasterFileSystem mfs = env.getMasterServices().getMasterFileSystem();
        Configuration conf = env.getMasterConfiguration();
        TableDescriptor htd = env.getMasterServices().getTableDescriptors().get(this.getTableName());
        for (String family : regionFs.getFamilies()) {
            ColumnFamilyDescriptor hcd = htd.getColumnFamily(family.getBytes());
            Collection<StoreFileInfo> storeFiles = regionFs.getStoreFiles(family);
            if (storeFiles == null || storeFiles.size() <= 0) continue;
            CacheConfig cacheConf = new CacheConfig(conf, hcd);
            for (StoreFileInfo storeFileInfo : storeFiles) {
                regionFs.mergeStoreFile(this.mergedRegion, family, new HStoreFile(mfs.getFileSystem(), storeFileInfo, conf, cacheConf, hcd.getBloomFilterType(), true), mergedDir);
            }
        }
    }

    private void cleanupMergedRegion(MasterProcedureEnv env) throws IOException {
        MasterFileSystem mfs = env.getMasterServices().getMasterFileSystem();
        Path tabledir = FSUtils.getTableDir(mfs.getRootDir(), this.regionsToMerge[0].getTable());
        FileSystem fs = mfs.getFileSystem();
        HRegionFileSystem regionFs = HRegionFileSystem.openRegionFromFileSystem(env.getMasterConfiguration(), fs, tabledir, this.regionsToMerge[0], false);
        regionFs.cleanupMergedRegion(this.mergedRegion);
    }

    private void rollbackCloseRegionsForMerge(MasterProcedureEnv env) throws IOException {
        int regionReplication = this.getRegionReplication(env);
        ServerName serverName = this.getServerName(env);
        Procedure[] procs = new AssignProcedure[this.regionsToMerge.length * regionReplication];
        int procsIdx = 0;
        for (int i = 0; i < this.regionsToMerge.length; ++i) {
            for (int j = 0; j < regionReplication; ++j) {
                HRegionInfo hri = RegionReplicaUtil.getRegionInfoForReplica(this.regionsToMerge[i], j);
                procs[procsIdx++] = env.getAssignmentManager().createAssignProcedure(hri, serverName);
            }
        }
        env.getMasterServices().getMasterProcedureExecutor().submitProcedures(procs);
    }

    private UnassignProcedure[] createUnassignProcedures(MasterProcedureEnv env, int regionReplication) {
        UnassignProcedure[] procs = new UnassignProcedure[this.regionsToMerge.length * regionReplication];
        int procsIdx = 0;
        for (int i = 0; i < this.regionsToMerge.length; ++i) {
            for (int j = 0; j < regionReplication; ++j) {
                HRegionInfo hri = RegionReplicaUtil.getRegionInfoForReplica(this.regionsToMerge[i], j);
                procs[procsIdx++] = env.getAssignmentManager().createUnassignProcedure(hri, null, true);
            }
        }
        return procs;
    }

    private AssignProcedure[] createAssignProcedures(MasterProcedureEnv env, int regionReplication) {
        ServerName targetServer = this.getServerName(env);
        AssignProcedure[] procs = new AssignProcedure[regionReplication];
        for (int i = 0; i < procs.length; ++i) {
            HRegionInfo hri = RegionReplicaUtil.getRegionInfoForReplica(this.mergedRegion, i);
            procs[i] = env.getAssignmentManager().createAssignProcedure(hri, targetServer);
        }
        return procs;
    }

    private int getRegionReplication(MasterProcedureEnv env) throws IOException {
        TableDescriptor htd = env.getMasterServices().getTableDescriptors().get(this.getTableName());
        return htd.getRegionReplication();
    }

    private void preMergeRegionsCommit(MasterProcedureEnv env) throws IOException {
        MasterCoprocessorHost cpHost = env.getMasterCoprocessorHost();
        if (cpHost != null) {
            ArrayList<Mutation> metaEntries = new ArrayList<Mutation>();
            boolean ret = cpHost.preMergeRegionsCommit(this.regionsToMerge, metaEntries, this.getUser());
            if (ret) {
                throw new IOException("Coprocessor bypassing regions " + HRegionInfo.getShortNameToLog(this.regionsToMerge) + " merge.");
            }
            try {
                for (Mutation p : metaEntries) {
                    HRegionInfo.parseRegionName(p.getRow());
                }
            }
            catch (IOException e) {
                LOG.error((Object)"Row key of mutation from coprocessor is not parsable as region name.Mutations from coprocessor should only be for hbase:meta table.", (Throwable)e);
                throw e;
            }
        }
    }

    private void updateMetaForMergedRegions(MasterProcedureEnv env) throws IOException, ProcedureYieldException {
        ServerName serverName = this.getServerName(env);
        env.getAssignmentManager().markRegionAsMerged(this.mergedRegion, serverName, this.regionsToMerge[0], this.regionsToMerge[1]);
    }

    private void postMergeRegionsCommit(MasterProcedureEnv env) throws IOException {
        MasterCoprocessorHost cpHost = env.getMasterCoprocessorHost();
        if (cpHost != null) {
            cpHost.postMergeRegionsCommit(this.regionsToMerge, this.mergedRegion, this.getUser());
        }
    }

    private void postCompletedMergeRegions(MasterProcedureEnv env) throws IOException {
        MasterCoprocessorHost cpHost = env.getMasterCoprocessorHost();
        if (cpHost != null) {
            cpHost.postCompletedMergeRegionsAction(this.regionsToMerge, this.mergedRegion, this.getUser());
        }
    }

    private ServerName getServerName(MasterProcedureEnv env) {
        if (this.regionLocation == null) {
            this.regionLocation = env.getAssignmentManager().getRegionStates().getRegionServerOfRegion(this.regionsToMerge[0]);
        }
        return this.regionLocation;
    }

    private Boolean isTraceEnabled() {
        if (this.traceEnabled == null) {
            this.traceEnabled = LOG.isTraceEnabled();
        }
        return this.traceEnabled;
    }

    @VisibleForTesting
    public HRegionInfo getMergedRegion() {
        return this.mergedRegion;
    }
}

