/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.assignment;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.MasterSwitchType;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.assignment.AssignProcedure;
import org.apache.hadoop.hbase.master.assignment.RegionStates;
import org.apache.hadoop.hbase.master.assignment.UnassignProcedure;
import org.apache.hadoop.hbase.master.assignment.Util;
import org.apache.hadoop.hbase.master.normalizer.NormalizationPlan;
import org.apache.hadoop.hbase.master.procedure.AbstractStateMachineRegionProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureUtil;
import org.apache.hadoop.hbase.master.procedure.TableProcedureInterface;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureMetrics;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.procedure2.StateMachineProcedure;
import org.apache.hadoop.hbase.quotas.QuotaExceededException;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFileInfo;
import org.apache.hadoop.hbase.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class SplitTableRegionProcedure
extends AbstractStateMachineRegionProcedure<MasterProcedureProtos.SplitTableRegionState> {
    private static final Log LOG = LogFactory.getLog(SplitTableRegionProcedure.class);
    private Boolean traceEnabled = null;
    private HRegionInfo daughter_1_HRI;
    private HRegionInfo daughter_2_HRI;
    private byte[] bestSplitRow;
    private static RegionState.State[] EXPECTED_SPLIT_STATES = new RegionState.State[]{RegionState.State.OPEN, RegionState.State.CLOSED};

    public SplitTableRegionProcedure() {
    }

    public SplitTableRegionProcedure(MasterProcedureEnv env, HRegionInfo regionToSplit, byte[] splitRow) throws IOException {
        super(env, regionToSplit);
        this.bestSplitRow = splitRow;
        this.checkSplittable(env, regionToSplit, this.bestSplitRow);
        TableName table = regionToSplit.getTable();
        long rid = SplitTableRegionProcedure.getDaughterRegionIdTimestamp(regionToSplit);
        this.daughter_1_HRI = new HRegionInfo(table, regionToSplit.getStartKey(), this.bestSplitRow, false, rid);
        this.daughter_2_HRI = new HRegionInfo(table, this.bestSplitRow, regionToSplit.getEndKey(), false, rid);
    }

    private void checkSplittable(MasterProcedureEnv env, HRegionInfo regionToSplit, byte[] splitRow) throws IOException {
        if (regionToSplit.getReplicaId() != 0) {
            throw new IllegalArgumentException("Can't invoke split on non-default regions directly");
        }
        RegionStates.RegionStateNode node = env.getAssignmentManager().getRegionStates().getRegionNode(this.getParentRegion());
        IOException splittableCheckIOE = null;
        boolean splittable = false;
        if (node != null) {
            try {
                if (this.bestSplitRow == null || this.bestSplitRow.length == 0) {
                    LOG.info((Object)"splitKey isn't explicitly specified,  will try to find a best split key from RS");
                }
                AdminProtos.GetRegionInfoResponse response = Util.getRegionInfoResponse(env, node.getRegionLocation(), node.getRegionInfo(), true);
                if (this.bestSplitRow == null || this.bestSplitRow.length == 0) {
                    this.bestSplitRow = response.hasBestSplitRow() ? response.getBestSplitRow().toByteArray() : null;
                }
                boolean bl = splittable = response.hasSplittable() && response.getSplittable();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Splittable=" + splittable + " " + node.toShortString()));
                }
            }
            catch (IOException e) {
                splittableCheckIOE = e;
            }
        }
        if (!splittable) {
            IOException e = new IOException(regionToSplit.getShortNameToLog() + " NOT splittable");
            if (splittableCheckIOE != null) {
                e.initCause(splittableCheckIOE);
            }
            throw e;
        }
        if (this.bestSplitRow == null || this.bestSplitRow.length == 0) {
            throw new DoNotRetryIOException("Region not splittable because bestSplitPoint = null");
        }
        if (Bytes.equals(regionToSplit.getStartKey(), this.bestSplitRow)) {
            throw new DoNotRetryIOException("Split row is equal to startkey: " + Bytes.toStringBinary(splitRow));
        }
        if (!regionToSplit.containsRow(this.bestSplitRow)) {
            throw new DoNotRetryIOException("Split row is not inside region key range splitKey:" + Bytes.toStringBinary(splitRow) + " region: " + regionToSplit);
        }
    }

    private static long getDaughterRegionIdTimestamp(HRegionInfo hri) {
        long rid = EnvironmentEdgeManager.currentTime();
        if (rid < hri.getRegionId()) {
            LOG.warn((Object)("Clock skew; parent regions id is " + hri.getRegionId() + " but current time here is " + rid));
            rid = hri.getRegionId() + 1L;
        }
        return rid;
    }

    @Override
    protected StateMachineProcedure.Flow executeFromState(MasterProcedureEnv env, MasterProcedureProtos.SplitTableRegionState state) throws InterruptedException {
        if (this.isTraceEnabled()) {
            LOG.trace((Object)(this + " execute state=" + state));
        }
        try {
            switch (state) {
                case SPLIT_TABLE_REGION_PREPARE: {
                    if (this.prepareSplitRegion(env)) {
                        this.setNextState(MasterProcedureProtos.SplitTableRegionState.SPLIT_TABLE_REGION_PRE_OPERATION);
                        break;
                    }
                    assert (this.isFailed()) : "split region should have an exception here";
                    return StateMachineProcedure.Flow.NO_MORE_STATE;
                }
                case SPLIT_TABLE_REGION_PRE_OPERATION: {
                    this.preSplitRegion(env);
                    this.setNextState(MasterProcedureProtos.SplitTableRegionState.SPLIT_TABLE_REGION_CLOSE_PARENT_REGION);
                    break;
                }
                case SPLIT_TABLE_REGION_CLOSE_PARENT_REGION: {
                    this.addChildProcedure(this.createUnassignProcedures(env, this.getRegionReplication(env)));
                    this.setNextState(MasterProcedureProtos.SplitTableRegionState.SPLIT_TABLE_REGION_CREATE_DAUGHTER_REGIONS);
                    break;
                }
                case SPLIT_TABLE_REGION_CREATE_DAUGHTER_REGIONS: {
                    this.createDaughterRegions(env);
                    this.setNextState(MasterProcedureProtos.SplitTableRegionState.SPLIT_TABLE_REGION_PRE_OPERATION_BEFORE_PONR);
                    break;
                }
                case SPLIT_TABLE_REGION_PRE_OPERATION_BEFORE_PONR: {
                    this.preSplitRegionBeforePONR(env);
                    this.setNextState(MasterProcedureProtos.SplitTableRegionState.SPLIT_TABLE_REGION_UPDATE_META);
                    break;
                }
                case SPLIT_TABLE_REGION_UPDATE_META: {
                    this.updateMetaForDaughterRegions(env);
                    this.setNextState(MasterProcedureProtos.SplitTableRegionState.SPLIT_TABLE_REGION_PRE_OPERATION_AFTER_PONR);
                    break;
                }
                case SPLIT_TABLE_REGION_PRE_OPERATION_AFTER_PONR: {
                    this.preSplitRegionAfterPONR(env);
                    this.setNextState(MasterProcedureProtos.SplitTableRegionState.SPLIT_TABLE_REGION_OPEN_CHILD_REGIONS);
                    break;
                }
                case SPLIT_TABLE_REGION_OPEN_CHILD_REGIONS: {
                    this.addChildProcedure(this.createAssignProcedures(env, this.getRegionReplication(env)));
                    this.setNextState(MasterProcedureProtos.SplitTableRegionState.SPLIT_TABLE_REGION_POST_OPERATION);
                    break;
                }
                case SPLIT_TABLE_REGION_POST_OPERATION: {
                    this.postSplitRegion(env);
                    return StateMachineProcedure.Flow.NO_MORE_STATE;
                }
                default: {
                    throw new UnsupportedOperationException(this + " unhandled state=" + state);
                }
            }
        }
        catch (IOException e) {
            String msg = "Error trying to split region " + this.getParentRegion().getEncodedName() + " in the table " + this.getTableName() + " (in state=" + state + ")";
            if (!this.isRollbackSupported(state)) {
                LOG.warn((Object)msg, (Throwable)e);
            }
            LOG.error((Object)msg, (Throwable)e);
            this.setFailure(e);
        }
        return StateMachineProcedure.Flow.HAS_MORE_STATE;
    }

    @Override
    protected void rollbackState(MasterProcedureEnv env, MasterProcedureProtos.SplitTableRegionState state) throws IOException, InterruptedException {
        if (this.isTraceEnabled()) {
            LOG.trace((Object)(this + " rollback state=" + state));
        }
        try {
            switch (state) {
                case SPLIT_TABLE_REGION_UPDATE_META: 
                case SPLIT_TABLE_REGION_PRE_OPERATION_AFTER_PONR: 
                case SPLIT_TABLE_REGION_OPEN_CHILD_REGIONS: 
                case SPLIT_TABLE_REGION_POST_OPERATION: {
                    throw new UnsupportedOperationException(this + " unhandled state=" + state);
                }
                case SPLIT_TABLE_REGION_PRE_OPERATION_BEFORE_PONR: {
                    break;
                }
                case SPLIT_TABLE_REGION_CREATE_DAUGHTER_REGIONS: {
                    break;
                }
                case SPLIT_TABLE_REGION_CLOSE_PARENT_REGION: {
                    this.openParentRegion(env);
                    break;
                }
                case SPLIT_TABLE_REGION_PRE_OPERATION: {
                    this.postRollBackSplitRegion(env);
                    break;
                }
                case SPLIT_TABLE_REGION_PREPARE: {
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(this + " unhandled state=" + state);
                }
            }
        }
        catch (IOException e) {
            LOG.warn((Object)("pid=" + this.getProcId() + " failed rollback attempt step " + state + " for splitting the region " + this.getParentRegion().getEncodedName() + " in table " + this.getTableName()), (Throwable)e);
            throw e;
        }
    }

    @Override
    protected boolean isRollbackSupported(MasterProcedureProtos.SplitTableRegionState state) {
        switch (state) {
            case SPLIT_TABLE_REGION_UPDATE_META: 
            case SPLIT_TABLE_REGION_PRE_OPERATION_AFTER_PONR: 
            case SPLIT_TABLE_REGION_OPEN_CHILD_REGIONS: 
            case SPLIT_TABLE_REGION_POST_OPERATION: {
                return false;
            }
        }
        return true;
    }

    @Override
    protected MasterProcedureProtos.SplitTableRegionState getState(int stateId) {
        return MasterProcedureProtos.SplitTableRegionState.forNumber(stateId);
    }

    @Override
    protected int getStateId(MasterProcedureProtos.SplitTableRegionState state) {
        return state.getNumber();
    }

    @Override
    protected MasterProcedureProtos.SplitTableRegionState getInitialState() {
        return MasterProcedureProtos.SplitTableRegionState.SPLIT_TABLE_REGION_PREPARE;
    }

    @Override
    protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.serializeStateData(serializer);
        MasterProcedureProtos.SplitTableRegionStateData.Builder splitTableRegionMsg = MasterProcedureProtos.SplitTableRegionStateData.newBuilder().setUserInfo(MasterProcedureUtil.toProtoUserInfo(this.getUser())).setParentRegionInfo(HRegionInfo.convert(this.getRegion())).addChildRegionInfo(HRegionInfo.convert(this.daughter_1_HRI)).addChildRegionInfo(HRegionInfo.convert(this.daughter_2_HRI));
        serializer.serialize(splitTableRegionMsg.build());
    }

    @Override
    protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.deserializeStateData(serializer);
        MasterProcedureProtos.SplitTableRegionStateData splitTableRegionsMsg = serializer.deserialize(MasterProcedureProtos.SplitTableRegionStateData.class);
        this.setUser(MasterProcedureUtil.toUserInfo(splitTableRegionsMsg.getUserInfo()));
        this.setRegion(HRegionInfo.convert(splitTableRegionsMsg.getParentRegionInfo()));
        assert (splitTableRegionsMsg.getChildRegionInfoCount() == 2);
        this.daughter_1_HRI = HRegionInfo.convert(splitTableRegionsMsg.getChildRegionInfo(0));
        this.daughter_2_HRI = HRegionInfo.convert(splitTableRegionsMsg.getChildRegionInfo(1));
    }

    @Override
    public void toStringClassDetails(StringBuilder sb) {
        sb.append(this.getClass().getSimpleName());
        sb.append(" table=");
        sb.append(this.getTableName());
        sb.append(", parent=");
        sb.append(this.getParentRegion().getShortNameToLog());
        sb.append(", daughterA=");
        sb.append(this.daughter_1_HRI.getShortNameToLog());
        sb.append(", daughterB=");
        sb.append(this.daughter_2_HRI.getShortNameToLog());
    }

    private HRegionInfo getParentRegion() {
        return this.getRegion();
    }

    @Override
    public TableProcedureInterface.TableOperationType getTableOperationType() {
        return TableProcedureInterface.TableOperationType.REGION_SPLIT;
    }

    @Override
    protected ProcedureMetrics getProcedureMetrics(MasterProcedureEnv env) {
        return env.getAssignmentManager().getAssignmentManagerMetrics().getSplitProcMetrics();
    }

    private byte[] getSplitRow() {
        return this.daughter_2_HRI.getStartKey();
    }

    @VisibleForTesting
    public boolean prepareSplitRegion(MasterProcedureEnv env) throws IOException {
        RegionStates.RegionStateNode node = env.getAssignmentManager().getRegionStates().getRegionNode(this.getParentRegion());
        HRegionInfo parentHRI = null;
        if (node != null) {
            parentHRI = node.getRegionInfo();
            if (node.isInState(RegionState.State.SPLIT)) {
                LOG.info((Object)("Split of " + parentHRI + " skipped; state is already SPLIT"));
                return false;
            }
            if (parentHRI.isSplit() || parentHRI.isOffline()) {
                LOG.info((Object)("Split of " + parentHRI + " skipped because offline/split."));
                return false;
            }
            if (!node.isInState(EXPECTED_SPLIT_STATES)) {
                this.setFailure(new IOException("Split " + parentHRI.getRegionNameAsString() + " FAILED because state=" + (Object)((Object)node.getState()) + "; expected " + Arrays.toString((Object[])EXPECTED_SPLIT_STATES)));
                return false;
            }
        }
        if (!env.getMasterServices().isSplitOrMergeEnabled(MasterSwitchType.SPLIT)) {
            LOG.warn((Object)("pid=" + this.getProcId() + " split switch is off! skip split of " + parentHRI));
            this.setFailure(new IOException("Split region " + (parentHRI == null ? "null" : parentHRI.getRegionNameAsString()) + " failed due to split switch off"));
            return false;
        }
        return true;
    }

    private void preSplitRegion(MasterProcedureEnv env) throws IOException, InterruptedException {
        MasterCoprocessorHost cpHost = env.getMasterCoprocessorHost();
        if (cpHost != null) {
            cpHost.preSplitRegionAction(this.getTableName(), this.getSplitRow(), this.getUser());
        }
        try {
            env.getMasterServices().getMasterQuotaManager().onRegionSplit(this.getParentRegion());
        }
        catch (QuotaExceededException e) {
            env.getAssignmentManager().getRegionNormalizer().planSkipped(this.getParentRegion(), NormalizationPlan.PlanType.SPLIT);
            throw e;
        }
    }

    private void postRollBackSplitRegion(MasterProcedureEnv env) throws IOException {
        MasterCoprocessorHost cpHost = env.getMasterCoprocessorHost();
        if (cpHost != null) {
            cpHost.postRollBackSplitRegionAction(this.getUser());
        }
    }

    private void openParentRegion(MasterProcedureEnv env) throws IOException {
        int regionReplication = this.getRegionReplication(env);
        ServerName serverName = this.getParentRegionServerName(env);
        Procedure[] procs = new AssignProcedure[regionReplication];
        for (int i = 0; i < regionReplication; ++i) {
            HRegionInfo hri = RegionReplicaUtil.getRegionInfoForReplica(this.getParentRegion(), i);
            procs[i] = env.getAssignmentManager().createAssignProcedure(hri, serverName);
        }
        env.getMasterServices().getMasterProcedureExecutor().submitProcedures(procs);
    }

    @VisibleForTesting
    public void createDaughterRegions(MasterProcedureEnv env) throws IOException {
        MasterFileSystem mfs = env.getMasterServices().getMasterFileSystem();
        Path tabledir = FSUtils.getTableDir(mfs.getRootDir(), this.getTableName());
        FileSystem fs = mfs.getFileSystem();
        HRegionFileSystem regionFs = HRegionFileSystem.openRegionFromFileSystem(env.getMasterConfiguration(), fs, tabledir, this.getParentRegion(), false);
        regionFs.createSplitsDir();
        Pair<Integer, Integer> expectedReferences = this.splitStoreFiles(env, regionFs);
        this.assertReferenceFileCount(fs, expectedReferences.getFirst(), regionFs.getSplitsDir(this.daughter_1_HRI));
        regionFs.commitDaughterRegion(this.daughter_1_HRI);
        this.assertReferenceFileCount(fs, expectedReferences.getFirst(), new Path(tabledir, this.daughter_1_HRI.getEncodedName()));
        this.assertReferenceFileCount(fs, expectedReferences.getSecond(), regionFs.getSplitsDir(this.daughter_2_HRI));
        regionFs.commitDaughterRegion(this.daughter_2_HRI);
        this.assertReferenceFileCount(fs, expectedReferences.getSecond(), new Path(tabledir, this.daughter_2_HRI.getEncodedName()));
    }

    private Pair<Integer, Integer> splitStoreFiles(MasterProcedureEnv env, HRegionFileSystem regionFs) throws IOException {
        MasterFileSystem mfs = env.getMasterServices().getMasterFileSystem();
        Configuration conf = env.getMasterConfiguration();
        int nbFiles = 0;
        HashMap files = new HashMap(regionFs.getFamilies().size());
        for (String family : regionFs.getFamilies()) {
            Collection<StoreFileInfo> sfis = regionFs.getStoreFiles(family);
            if (sfis == null) continue;
            ArrayList<StoreFileInfo> filteredSfis = null;
            for (StoreFileInfo storeFileInfo : sfis) {
                if (storeFileInfo.isReference()) {
                    LOG.info((Object)("Skipping split of " + storeFileInfo + "; presuming ready for archiving."));
                    continue;
                }
                if (filteredSfis == null) {
                    filteredSfis = new ArrayList<StoreFileInfo>(sfis.size());
                    files.put(family, filteredSfis);
                }
                filteredSfis.add(storeFileInfo);
                ++nbFiles;
            }
        }
        if (nbFiles == 0) {
            return new Pair<Integer, Integer>(0, 0);
        }
        int maxThreads = Math.min(conf.getInt("hbase.regionserver.region.split.threads.max", conf.getInt("hbase.hstore.blockingStoreFiles", 10)), nbFiles);
        LOG.info((Object)("pid=" + this.getProcId() + " splitting " + nbFiles + " storefiles, region=" + this.getParentRegion().getShortNameToLog() + ", threads=" + maxThreads));
        ExecutorService threadPool = Executors.newFixedThreadPool(maxThreads, Threads.getNamedThreadFactory("StoreFileSplitter-%1$d"));
        ArrayList<Future<Pair<Path, Path>>> futures = new ArrayList<Future<Pair<Path, Path>>>(nbFiles);
        TableDescriptor htd = env.getMasterServices().getTableDescriptors().get(this.getTableName());
        for (Map.Entry entry : files.entrySet()) {
            byte[] familyName = Bytes.toBytes((String)entry.getKey());
            ColumnFamilyDescriptor hcd = htd.getColumnFamily(familyName);
            Collection storeFiles = (Collection)entry.getValue();
            if (storeFiles == null || storeFiles.size() <= 0) continue;
            CacheConfig cacheConfig = new CacheConfig(conf, hcd);
            for (StoreFileInfo storeFileInfo : storeFiles) {
                StoreFileSplitter sfs = new StoreFileSplitter(regionFs, familyName, new HStoreFile(mfs.getFileSystem(), storeFileInfo, conf, cacheConfig, hcd.getBloomFilterType(), true));
                futures.add(threadPool.submit(sfs));
            }
        }
        threadPool.shutdown();
        long fileSplitTimeout = conf.getLong("hbase.master.fileSplitTimeout", 30000L);
        try {
            boolean stillRunning;
            boolean bl = stillRunning = !threadPool.awaitTermination(fileSplitTimeout, TimeUnit.MILLISECONDS);
            if (stillRunning) {
                threadPool.shutdownNow();
                while (!threadPool.isTerminated()) {
                    Thread.sleep(50L);
                }
                throw new IOException("Took too long to split the files and create the references, aborting split");
            }
        }
        catch (InterruptedException e) {
            throw (InterruptedIOException)new InterruptedIOException().initCause(e);
        }
        int daughterA = 0;
        int daughterB = 0;
        for (Future future : futures) {
            try {
                Pair p = (Pair)future.get();
                daughterA += p.getFirst() != null ? 1 : 0;
                daughterB += p.getSecond() != null ? 1 : 0;
            }
            catch (InterruptedException e) {
                throw (InterruptedIOException)new InterruptedIOException().initCause(e);
            }
            catch (ExecutionException e) {
                throw new IOException(e);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("pid=" + this.getProcId() + " split storefiles for region " + this.getParentRegion().getShortNameToLog() + " Daughter A: " + daughterA + " storefiles, Daughter B: " + daughterB + " storefiles."));
        }
        return new Pair<Integer, Integer>(daughterA, daughterB);
    }

    private void assertReferenceFileCount(FileSystem fs, int expectedReferenceFileCount, Path dir) throws IOException {
        if (expectedReferenceFileCount != 0 && expectedReferenceFileCount != FSUtils.getRegionReferenceFileCount(fs, dir)) {
            throw new IOException("Failing split. Expected reference file count isn't equal.");
        }
    }

    private Pair<Path, Path> splitStoreFile(HRegionFileSystem regionFs, byte[] family, StoreFile sf) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("pid=" + this.getProcId() + " splitting started for store file: " + sf.getPath() + " for region: " + this.getParentRegion().getShortNameToLog()));
        }
        byte[] splitRow = this.getSplitRow();
        String familyName = Bytes.toString(family);
        Path path_first = regionFs.splitStoreFile(this.daughter_1_HRI, familyName, sf, splitRow, false, null);
        Path path_second = regionFs.splitStoreFile(this.daughter_2_HRI, familyName, sf, splitRow, true, null);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("pid=" + this.getProcId() + " splitting complete for store file: " + sf.getPath() + " for region: " + this.getParentRegion().getShortNameToLog()));
        }
        return new Pair<Path, Path>(path_first, path_second);
    }

    private void preSplitRegionBeforePONR(MasterProcedureEnv env) throws IOException, InterruptedException {
        ArrayList<Mutation> metaEntries = new ArrayList<Mutation>();
        MasterCoprocessorHost cpHost = env.getMasterCoprocessorHost();
        if (cpHost != null) {
            if (cpHost.preSplitBeforePONRAction(this.getSplitRow(), metaEntries, this.getUser())) {
                throw new IOException("Coprocessor bypassing region " + this.getParentRegion().getRegionNameAsString() + " split.");
            }
            try {
                for (Mutation p : metaEntries) {
                    HRegionInfo.parseRegionName(p.getRow());
                }
            }
            catch (IOException e) {
                LOG.error((Object)("pid=" + this.getProcId() + " row key of mutation from coprocessor not parsable as region name.Mutations from coprocessor should only for hbase:meta table."));
                throw e;
            }
        }
    }

    private void updateMetaForDaughterRegions(MasterProcedureEnv env) throws IOException {
        env.getAssignmentManager().markRegionAsSplit(this.getParentRegion(), this.getParentRegionServerName(env), this.daughter_1_HRI, this.daughter_2_HRI);
    }

    private void preSplitRegionAfterPONR(MasterProcedureEnv env) throws IOException, InterruptedException {
        MasterCoprocessorHost cpHost = env.getMasterCoprocessorHost();
        if (cpHost != null) {
            cpHost.preSplitAfterPONRAction(this.getUser());
        }
    }

    private void postSplitRegion(MasterProcedureEnv env) throws IOException {
        MasterCoprocessorHost cpHost = env.getMasterCoprocessorHost();
        if (cpHost != null) {
            cpHost.postCompletedSplitRegionAction(this.daughter_1_HRI, this.daughter_2_HRI, this.getUser());
        }
    }

    private ServerName getParentRegionServerName(MasterProcedureEnv env) {
        return env.getMasterServices().getAssignmentManager().getRegionStates().getRegionServerOfRegion(this.getParentRegion());
    }

    private UnassignProcedure[] createUnassignProcedures(MasterProcedureEnv env, int regionReplication) {
        UnassignProcedure[] procs = new UnassignProcedure[regionReplication];
        for (int i = 0; i < procs.length; ++i) {
            HRegionInfo hri = RegionReplicaUtil.getRegionInfoForReplica(this.getParentRegion(), i);
            procs[i] = env.getAssignmentManager().createUnassignProcedure(hri, null, true);
        }
        return procs;
    }

    private AssignProcedure[] createAssignProcedures(MasterProcedureEnv env, int regionReplication) {
        HRegionInfo hri;
        int i;
        ServerName targetServer = this.getParentRegionServerName(env);
        AssignProcedure[] procs = new AssignProcedure[regionReplication * 2];
        int procsIdx = 0;
        for (i = 0; i < regionReplication; ++i) {
            hri = RegionReplicaUtil.getRegionInfoForReplica(this.daughter_1_HRI, i);
            procs[procsIdx++] = env.getAssignmentManager().createAssignProcedure(hri, targetServer);
        }
        for (i = 0; i < regionReplication; ++i) {
            hri = RegionReplicaUtil.getRegionInfoForReplica(this.daughter_2_HRI, i);
            procs[procsIdx++] = env.getAssignmentManager().createAssignProcedure(hri, targetServer);
        }
        return procs;
    }

    private int getRegionReplication(MasterProcedureEnv env) throws IOException {
        TableDescriptor htd = env.getMasterServices().getTableDescriptors().get(this.getTableName());
        return htd.getRegionReplication();
    }

    private boolean isTraceEnabled() {
        if (this.traceEnabled == null) {
            this.traceEnabled = LOG.isTraceEnabled();
        }
        return this.traceEnabled;
    }

    private class StoreFileSplitter
    implements Callable<Pair<Path, Path>> {
        private final HRegionFileSystem regionFs;
        private final byte[] family;
        private final StoreFile sf;

        public StoreFileSplitter(HRegionFileSystem regionFs, byte[] family, StoreFile sf) {
            this.regionFs = regionFs;
            this.sf = sf;
            this.family = family;
        }

        @Override
        public Pair<Path, Path> call() throws IOException {
            return SplitTableRegionProcedure.this.splitStoreFile(this.regionFs, this.family, this.sf);
        }
    }
}

