/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.assignment;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.exceptions.UnexpectedStateException;
import org.apache.hadoop.hbase.ipc.ServerNotRunningYetException;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.assignment.RegionStates;
import org.apache.hadoop.hbase.master.assignment.RegionTransitionProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.RSProcedureDispatcher;
import org.apache.hadoop.hbase.master.procedure.ServerCrashException;
import org.apache.hadoop.hbase.master.procedure.TableProcedureInterface;
import org.apache.hadoop.hbase.procedure2.ProcedureMetrics;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.procedure2.RemoteProcedureDispatcher;
import org.apache.hadoop.hbase.regionserver.RegionServerAbortedException;
import org.apache.hadoop.hbase.regionserver.RegionServerStoppedException;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RegionServerStatusProtos;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class UnassignProcedure
extends RegionTransitionProcedure {
    private static final Log LOG = LogFactory.getLog(UnassignProcedure.class);
    protected volatile ServerName hostingServer;
    protected volatile ServerName destinationServer;
    private boolean force;

    public UnassignProcedure() {
    }

    public UnassignProcedure(HRegionInfo regionInfo, ServerName hostingServer, boolean force) {
        this(regionInfo, hostingServer, null, force);
    }

    public UnassignProcedure(HRegionInfo regionInfo, ServerName hostingServer, ServerName destinationServer, boolean force) {
        super(regionInfo);
        this.hostingServer = hostingServer;
        this.destinationServer = destinationServer;
        this.force = force;
        this.setTransitionState(MasterProcedureProtos.RegionTransitionState.REGION_TRANSITION_DISPATCH);
    }

    @Override
    public TableProcedureInterface.TableOperationType getTableOperationType() {
        return TableProcedureInterface.TableOperationType.REGION_UNASSIGN;
    }

    @Override
    protected boolean isRollbackSupported(MasterProcedureProtos.RegionTransitionState state) {
        switch (state) {
            case REGION_TRANSITION_QUEUE: 
            case REGION_TRANSITION_DISPATCH: {
                return true;
            }
        }
        return false;
    }

    @Override
    protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        MasterProcedureProtos.UnassignRegionStateData.Builder state = MasterProcedureProtos.UnassignRegionStateData.newBuilder().setTransitionState(this.getTransitionState()).setHostingServer(ProtobufUtil.toServerName(this.hostingServer)).setRegionInfo(HRegionInfo.convert(this.getRegionInfo()));
        if (this.destinationServer != null) {
            state.setDestinationServer(ProtobufUtil.toServerName(this.destinationServer));
        }
        if (this.force) {
            state.setForce(true);
        }
        serializer.serialize(state.build());
    }

    @Override
    protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        MasterProcedureProtos.UnassignRegionStateData state = serializer.deserialize(MasterProcedureProtos.UnassignRegionStateData.class);
        this.setTransitionState(state.getTransitionState());
        this.setRegionInfo(HRegionInfo.convert(state.getRegionInfo()));
        this.hostingServer = ProtobufUtil.toServerName(state.getHostingServer());
        this.force = state.getForce();
        if (state.hasDestinationServer()) {
            this.destinationServer = ProtobufUtil.toServerName(state.getDestinationServer());
        }
    }

    @Override
    protected boolean startTransition(MasterProcedureEnv env, RegionStates.RegionStateNode regionNode) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected boolean updateTransition(MasterProcedureEnv env, RegionStates.RegionStateNode regionNode) throws IOException {
        if (regionNode.isInState(RegionState.State.CLOSED, RegionState.State.OFFLINE)) {
            LOG.info((Object)("Not unassigned " + this + "; " + regionNode.toShortString()));
            return false;
        }
        if (this.aborted.get() && regionNode.isInState(RegionState.State.OPEN)) {
            this.setAbortFailure(this.getClass().getSimpleName(), "abort requested");
            return false;
        }
        env.getAssignmentManager().markRegionAsClosing(regionNode);
        if (!this.addToRemoteDispatcher(env, regionNode.getRegionLocation())) {
            // empty if block
        }
        return true;
    }

    @Override
    protected void finishTransition(MasterProcedureEnv env, RegionStates.RegionStateNode regionNode) throws IOException {
        env.getAssignmentManager().markRegionAsClosed(regionNode);
    }

    @Override
    public RemoteProcedureDispatcher.RemoteOperation remoteCallBuild(MasterProcedureEnv env, ServerName serverName) {
        assert (serverName.equals(this.getRegionState(env).getRegionLocation()));
        return new RSProcedureDispatcher.RegionCloseOperation(this, this.getRegionInfo(), this.destinationServer);
    }

    @Override
    protected void reportTransition(MasterProcedureEnv env, RegionStates.RegionStateNode regionNode, RegionServerStatusProtos.RegionStateTransition.TransitionCode code, long seqId) throws UnexpectedStateException {
        switch (code) {
            case CLOSED: {
                this.setTransitionState(MasterProcedureProtos.RegionTransitionState.REGION_TRANSITION_FINISH);
                break;
            }
            default: {
                throw new UnexpectedStateException(String.format("Received report unexpected transition state=%s for region=%s server=%s, expected CLOSED.", code, regionNode.getRegionInfo(), regionNode.getRegionLocation()));
            }
        }
    }

    @Override
    protected boolean remoteCallFailed(MasterProcedureEnv env, RegionStates.RegionStateNode regionNode, IOException exception) {
        if (exception instanceof ServerCrashException) {
            try {
                this.reportTransition(env, regionNode, RegionServerStatusProtos.RegionStateTransition.TransitionCode.CLOSED, -1L);
            }
            catch (UnexpectedStateException e) {
                throw new RuntimeException(e);
            }
        } else if (exception instanceof RegionServerAbortedException || exception instanceof RegionServerStoppedException || exception instanceof ServerNotRunningYetException) {
            LOG.info((Object)"Ignoring; waiting on ServerCrashProcedure", (Throwable)exception);
        } else if (exception instanceof NotServingRegionException) {
            LOG.info((Object)("IS THIS OK? ANY LOGS TO REPLAY; ACTING AS THOUGH ALL GOOD " + regionNode), (Throwable)exception);
            this.setTransitionState(MasterProcedureProtos.RegionTransitionState.REGION_TRANSITION_FINISH);
        } else {
            LOG.warn((Object)("Expiring server " + this + "; " + regionNode.toShortString() + ", exception=" + exception));
            env.getMasterServices().getServerManager().expireServer(regionNode.getRegionLocation());
            return false;
        }
        return true;
    }

    @Override
    public void toStringClassDetails(StringBuilder sb) {
        super.toStringClassDetails(sb);
        sb.append(", server=").append(this.hostingServer);
    }

    @Override
    public ServerName getServer(MasterProcedureEnv env) {
        return this.hostingServer;
    }

    @Override
    protected ProcedureMetrics getProcedureMetrics(MasterProcedureEnv env) {
        return env.getAssignmentManager().getAssignmentManagerMetrics().getUnassignProcMetrics();
    }
}

