/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.assignment;

import java.io.IOException;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.ipc.HBaseRpcController;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.ServiceException;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.RequestConverter;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class Util {
    private Util() {
    }

    static AdminProtos.GetRegionInfoResponse getRegionInfoResponse(MasterProcedureEnv env, ServerName regionLocation, HRegionInfo hri) throws IOException {
        return Util.getRegionInfoResponse(env, regionLocation, hri, false);
    }

    static AdminProtos.GetRegionInfoResponse getRegionInfoResponse(MasterProcedureEnv env, ServerName regionLocation, HRegionInfo hri, boolean includeBestSplitRow) throws IOException {
        HBaseRpcController controller = env.getMasterServices().getClusterConnection().getRpcControllerFactory().newController();
        AdminProtos.AdminService.BlockingInterface admin = env.getMasterServices().getClusterConnection().getAdmin(regionLocation);
        AdminProtos.GetRegionInfoRequest request = null;
        request = includeBestSplitRow ? RequestConverter.buildGetRegionInfoRequest(hri.getRegionName(), false, true) : RequestConverter.buildGetRegionInfoRequest(hri.getRegionName());
        try {
            return admin.getRegionInfo(controller, request);
        }
        catch (ServiceException e) {
            throw ProtobufUtil.handleRemoteException(e);
        }
    }
}

