/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.ServerLoad;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.favored.FavoredNodeAssignmentHelper;
import org.apache.hadoop.hbase.favored.FavoredNodesManager;
import org.apache.hadoop.hbase.favored.FavoredNodesPlan;
import org.apache.hadoop.hbase.favored.FavoredNodesPromoter;
import org.apache.hadoop.hbase.master.LoadBalancer;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.RegionPlan;
import org.apache.hadoop.hbase.master.balancer.BaseLoadBalancer;
import org.apache.hadoop.hbase.master.balancer.StochasticLoadBalancer;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.Lists;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.Maps;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.Sets;
import org.apache.hadoop.hbase.util.Pair;

public class FavoredStochasticBalancer
extends StochasticLoadBalancer
implements FavoredNodesPromoter {
    private static final Log LOG = LogFactory.getLog(FavoredStochasticBalancer.class);
    private FavoredNodesManager fnm;

    @Override
    public void initialize() throws HBaseIOException {
        this.configureGenerators();
        super.initialize();
    }

    protected void configureGenerators() {
        ArrayList<StochasticLoadBalancer.CandidateGenerator> fnPickers = new ArrayList<StochasticLoadBalancer.CandidateGenerator>(2);
        fnPickers.add(new FavoredNodeLoadPicker());
        fnPickers.add(new FavoredNodeLocalityPicker());
        this.setCandidateGenerators(fnPickers);
    }

    @Override
    public void setMasterServices(MasterServices masterServices) {
        super.setMasterServices(masterServices);
        this.fnm = masterServices.getFavoredNodesManager();
    }

    @Override
    public Map<ServerName, List<HRegionInfo>> roundRobinAssignment(List<HRegionInfo> regions, List<ServerName> servers) throws HBaseIOException {
        this.metricsBalancer.incrMiscInvocations();
        HashSet<HRegionInfo> regionSet = Sets.newHashSet(regions);
        Map<ServerName, List<HRegionInfo>> assignmentMap = this.assignMasterSystemRegions(regions, servers);
        if (assignmentMap != null && !assignmentMap.isEmpty()) {
            servers = new ArrayList<ServerName>(servers);
            servers.remove(this.masterServerName);
            List<HRegionInfo> masterRegions = assignmentMap.get(this.masterServerName);
            if (!masterRegions.isEmpty()) {
                for (HRegionInfo region : masterRegions) {
                    regionSet.remove(region);
                }
            }
        }
        if (regionSet.isEmpty()) {
            return assignmentMap;
        }
        try {
            FavoredNodeAssignmentHelper helper = new FavoredNodeAssignmentHelper(servers, this.fnm.getRackManager());
            helper.initialize();
            Set<HRegionInfo> systemRegions = FavoredNodesManager.filterNonFNApplicableRegions(regionSet);
            regionSet.removeAll(systemRegions);
            Map<ServerName, List<HRegionInfo>> systemAssignments = super.roundRobinAssignment(Lists.newArrayList(systemRegions), servers);
            Pair<Map<ServerName, List<HRegionInfo>>, List<HRegionInfo>> segregatedRegions = this.segregateRegionsAndAssignRegionsWithFavoredNodes(regionSet, servers);
            Map<ServerName, List<HRegionInfo>> regionsWithFavoredNodesMap = segregatedRegions.getFirst();
            Map<ServerName, List<HRegionInfo>> regionsWithoutFN = this.generateFNForRegionsWithoutFN(helper, segregatedRegions.getSecond());
            this.mergeAssignmentMaps(assignmentMap, systemAssignments);
            this.mergeAssignmentMaps(assignmentMap, regionsWithFavoredNodesMap);
            this.mergeAssignmentMaps(assignmentMap, regionsWithoutFN);
        }
        catch (Exception ex) {
            throw new HBaseIOException("Encountered exception while doing favored-nodes assignment " + ex + " Falling back to regular assignment", ex);
        }
        return assignmentMap;
    }

    private void mergeAssignmentMaps(Map<ServerName, List<HRegionInfo>> assignmentMap, Map<ServerName, List<HRegionInfo>> otherAssignments) {
        if (otherAssignments == null || otherAssignments.isEmpty()) {
            return;
        }
        for (Map.Entry<ServerName, List<HRegionInfo>> entry : otherAssignments.entrySet()) {
            ServerName sn = entry.getKey();
            List<HRegionInfo> regionsList = entry.getValue();
            if (assignmentMap.get(sn) == null) {
                assignmentMap.put(sn, Lists.newArrayList(regionsList));
                continue;
            }
            assignmentMap.get(sn).addAll(regionsList);
        }
    }

    private Map<ServerName, List<HRegionInfo>> generateFNForRegionsWithoutFN(FavoredNodeAssignmentHelper helper, List<HRegionInfo> regions) throws IOException {
        HashMap<ServerName, List<HRegionInfo>> assignmentMap = Maps.newHashMap();
        if (regions.size() > 0) {
            Map<HRegionInfo, List<ServerName>> regionsNoFNMap = helper.generateFavoredNodesRoundRobin(assignmentMap, regions);
            this.fnm.updateFavoredNodes(regionsNoFNMap);
        }
        return assignmentMap;
    }

    private Pair<Map<ServerName, List<HRegionInfo>>, List<HRegionInfo>> segregateRegionsAndAssignRegionsWithFavoredNodes(Collection<HRegionInfo> regions, List<ServerName> onlineServers) throws HBaseIOException {
        HashMap<ServerName, List<HRegionInfo>> assignmentMapForFavoredNodes = new HashMap<ServerName, List<HRegionInfo>>(onlineServers.size());
        ArrayList<HRegionInfo> regionsWithNoFavoredNodes = new ArrayList<HRegionInfo>();
        for (HRegionInfo region : regions) {
            List<ServerName> favoredNodes = this.fnm.getFavoredNodes(region);
            ServerName primaryHost = null;
            ServerName secondaryHost = null;
            ServerName tertiaryHost = null;
            if (favoredNodes != null && !favoredNodes.isEmpty()) {
                for (ServerName s : favoredNodes) {
                    ServerName serverWithLegitStartCode = this.getServerFromFavoredNode(onlineServers, s);
                    if (serverWithLegitStartCode == null) continue;
                    FavoredNodesPlan.Position position = FavoredNodesPlan.getFavoredServerPosition(favoredNodes, s);
                    if (FavoredNodesPlan.Position.PRIMARY.equals((Object)position)) {
                        primaryHost = serverWithLegitStartCode;
                        continue;
                    }
                    if (FavoredNodesPlan.Position.SECONDARY.equals((Object)position)) {
                        secondaryHost = serverWithLegitStartCode;
                        continue;
                    }
                    if (!FavoredNodesPlan.Position.TERTIARY.equals((Object)position)) continue;
                    tertiaryHost = serverWithLegitStartCode;
                }
                this.assignRegionToAvailableFavoredNode(assignmentMapForFavoredNodes, region, primaryHost, secondaryHost, tertiaryHost);
                continue;
            }
            regionsWithNoFavoredNodes.add(region);
        }
        return new Pair<Map<ServerName, List<HRegionInfo>>, List<HRegionInfo>>(assignmentMapForFavoredNodes, regionsWithNoFavoredNodes);
    }

    private void addRegionToMap(Map<ServerName, List<HRegionInfo>> assignmentMapForFavoredNodes, HRegionInfo region, ServerName host) {
        List<HRegionInfo> regionsOnServer = assignmentMapForFavoredNodes.get(host);
        if (regionsOnServer == null) {
            regionsOnServer = Lists.newArrayList();
            assignmentMapForFavoredNodes.put(host, regionsOnServer);
        }
        regionsOnServer.add(region);
    }

    private ServerName getServerFromFavoredNode(List<ServerName> servers, ServerName fn) {
        for (ServerName server : servers) {
            if (!ServerName.isSameAddress(fn, server)) continue;
            return server;
        }
        return null;
    }

    private void assignRegionToAvailableFavoredNode(Map<ServerName, List<HRegionInfo>> assignmentMapForFavoredNodes, HRegionInfo region, ServerName primaryHost, ServerName secondaryHost, ServerName tertiaryHost) {
        if (primaryHost != null) {
            this.addRegionToMap(assignmentMapForFavoredNodes, region, primaryHost);
        } else if (secondaryHost != null && tertiaryHost != null) {
            ServerLoad tertiaryLoad = this.services.getServerManager().getLoad(tertiaryHost);
            ServerLoad secondaryLoad = this.services.getServerManager().getLoad(secondaryHost);
            ServerName s = secondaryLoad != null && tertiaryLoad != null ? (secondaryLoad.getLoad() < tertiaryLoad.getLoad() ? secondaryHost : tertiaryHost) : (RANDOM.nextBoolean() ? secondaryHost : tertiaryHost);
            this.addRegionToMap(assignmentMapForFavoredNodes, region, s);
        } else if (secondaryHost != null) {
            this.addRegionToMap(assignmentMapForFavoredNodes, region, secondaryHost);
        } else if (tertiaryHost != null) {
            this.addRegionToMap(assignmentMapForFavoredNodes, region, tertiaryHost);
        } else {
            this.addRegionToMap(assignmentMapForFavoredNodes, region, BOGUS_SERVER_NAME);
        }
    }

    @Override
    public ServerName randomAssignment(HRegionInfo regionInfo, List<ServerName> servers) throws HBaseIOException {
        List<ServerName> onlineServers;
        if (servers != null && servers.contains(this.masterServerName)) {
            if (this.shouldBeOnMaster(regionInfo)) {
                this.metricsBalancer.incrMiscInvocations();
                return this.masterServerName;
            }
            if (!LoadBalancer.isTablesOnMaster(this.getConf())) {
                servers = new ArrayList<ServerName>(servers);
                servers.remove(this.masterServerName);
            }
        }
        ServerName destination = null;
        if (!FavoredNodesManager.isFavoredNodeApplicable(regionInfo)) {
            return super.randomAssignment(regionInfo, servers);
        }
        this.metricsBalancer.incrMiscInvocations();
        List<ServerName> favoredNodes = this.fnm.getFavoredNodes(regionInfo);
        if (favoredNodes == null || favoredNodes.isEmpty()) {
            FavoredNodeAssignmentHelper helper = new FavoredNodeAssignmentHelper(servers, this.getConf());
            helper.initialize();
            try {
                favoredNodes = helper.generateFavoredNodes(regionInfo);
                this.updateFavoredNodesForRegion(regionInfo, favoredNodes);
            }
            catch (IOException e) {
                LOG.warn((Object)("Encountered exception while doing favored-nodes (random)assignment " + e));
                throw new HBaseIOException(e);
            }
        }
        if ((onlineServers = this.getOnlineFavoredNodes(servers, favoredNodes)).size() > 0) {
            destination = onlineServers.get(RANDOM.nextInt(onlineServers.size()));
        }
        boolean alwaysAssign = this.getConf().getBoolean("hbase.favored.assignment.always.assign", true);
        if (destination == null && alwaysAssign) {
            LOG.warn((Object)("Can't generate FN for region: " + regionInfo + " falling back"));
            destination = super.randomAssignment(regionInfo, servers);
        }
        return destination;
    }

    private void updateFavoredNodesForRegion(HRegionInfo regionInfo, List<ServerName> newFavoredNodes) throws IOException {
        HashMap<HRegionInfo, List<ServerName>> regionFNMap = Maps.newHashMap();
        regionFNMap.put(regionInfo, newFavoredNodes);
        this.fnm.updateFavoredNodes(regionFNMap);
    }

    @Override
    public Map<ServerName, List<HRegionInfo>> retainAssignment(Map<HRegionInfo, ServerName> regions, List<ServerName> servers) throws HBaseIOException {
        HashMap<ServerName, List<HRegionInfo>> assignmentMap = Maps.newHashMap();
        Map<ServerName, List<HRegionInfo>> result = super.retainAssignment(regions, servers);
        if (result == null || result.isEmpty()) {
            LOG.warn((Object)"Nothing to assign to, probably no servers or no regions");
            return null;
        }
        if (servers != null && servers.contains(this.masterServerName)) {
            servers = new ArrayList<ServerName>(servers);
            servers.remove(this.masterServerName);
        }
        FavoredNodeAssignmentHelper helper = new FavoredNodeAssignmentHelper(servers, this.getConf());
        helper.initialize();
        LOG.debug((Object)"Generating favored nodes for regions missing them.");
        HashMap<HRegionInfo, List<ServerName>> regionFNMap = Maps.newHashMap();
        try {
            for (Map.Entry<ServerName, List<HRegionInfo>> entry : result.entrySet()) {
                ServerName sn = entry.getKey();
                ServerName primary = ServerName.valueOf(sn.getHostname(), sn.getPort(), -1L);
                for (HRegionInfo hri : entry.getValue()) {
                    if (FavoredNodesManager.isFavoredNodeApplicable(hri)) {
                        List<ServerName> favoredNodes = this.fnm.getFavoredNodes(hri);
                        if (favoredNodes == null || favoredNodes.size() < 3) {
                            LOG.debug((Object)("Generating favored nodes for: " + hri + " with primary: " + primary));
                            ServerName[] secondaryAndTertiaryNodes = helper.getSecondaryAndTertiary(hri, primary);
                            if (secondaryAndTertiaryNodes != null && secondaryAndTertiaryNodes.length == 2) {
                                ArrayList<ServerName> newFavoredNodes = Lists.newArrayList();
                                newFavoredNodes.add(primary);
                                newFavoredNodes.add(ServerName.valueOf(secondaryAndTertiaryNodes[0].getHostname(), secondaryAndTertiaryNodes[0].getPort(), -1L));
                                newFavoredNodes.add(ServerName.valueOf(secondaryAndTertiaryNodes[1].getHostname(), secondaryAndTertiaryNodes[1].getPort(), -1L));
                                regionFNMap.put(hri, newFavoredNodes);
                                this.addRegionToMap(assignmentMap, hri, sn);
                                continue;
                            }
                            throw new HBaseIOException("Cannot generate secondary/tertiary FN for " + hri + " generated " + (secondaryAndTertiaryNodes != null ? secondaryAndTertiaryNodes : " nothing"));
                        }
                        List<ServerName> onlineFN = this.getOnlineFavoredNodes(servers, favoredNodes);
                        if (onlineFN.isEmpty()) {
                            this.addRegionToMap(assignmentMap, hri, BOGUS_SERVER_NAME);
                            continue;
                        }
                        if (FavoredNodesPlan.getFavoredServerPosition(favoredNodes, sn) != null) {
                            this.addRegionToMap(assignmentMap, hri, sn);
                            continue;
                        }
                        ServerName destination = onlineFN.get(RANDOM.nextInt(onlineFN.size()));
                        LOG.warn((Object)("Region: " + hri + " not hosted on favored nodes: " + favoredNodes + " current: " + sn + " moving to: " + destination));
                        this.addRegionToMap(assignmentMap, hri, destination);
                        continue;
                    }
                    this.addRegionToMap(assignmentMap, hri, sn);
                }
            }
            if (!regionFNMap.isEmpty()) {
                LOG.debug((Object)("Updating FN in meta for missing regions, count: " + regionFNMap.size()));
                this.fnm.updateFavoredNodes(regionFNMap);
            }
        }
        catch (IOException e) {
            throw new HBaseIOException("Cannot generate/update FN for regions: " + regionFNMap.keySet());
        }
        return assignmentMap;
    }

    private List<ServerName> getOnlineFavoredNodes(List<ServerName> onlineServers, List<ServerName> serversWithoutStartCodes) {
        if (serversWithoutStartCodes == null) {
            return null;
        }
        ArrayList<ServerName> result = Lists.newArrayList();
        for (ServerName sn : serversWithoutStartCodes) {
            for (ServerName online : onlineServers) {
                if (!ServerName.isSameAddress(sn, online)) continue;
                result.add(online);
            }
        }
        return result;
    }

    public synchronized List<ServerName> getFavoredNodes(HRegionInfo regionInfo) {
        return this.fnm.getFavoredNodes(regionInfo);
    }

    @Override
    public void generateFavoredNodesForDaughter(List<ServerName> servers, HRegionInfo parent, HRegionInfo regionA, HRegionInfo regionB) throws IOException {
        HashMap<HRegionInfo, List<ServerName>> result = new HashMap<HRegionInfo, List<ServerName>>();
        FavoredNodeAssignmentHelper helper = new FavoredNodeAssignmentHelper(servers, this.rackManager);
        helper.initialize();
        List<ServerName> parentFavoredNodes = this.fnm.getFavoredNodes(parent);
        if (parentFavoredNodes == null) {
            LOG.debug((Object)("Unable to find favored nodes for parent, " + parent + " generating new favored nodes for daughter"));
            result.put(regionA, helper.generateFavoredNodes(regionA));
            result.put(regionB, helper.generateFavoredNodes(regionB));
        } else {
            Set<ServerName> regionAFN = this.getInheritedFNForDaughter(helper, parentFavoredNodes, FavoredNodesPlan.Position.PRIMARY, FavoredNodesPlan.Position.SECONDARY);
            result.put(regionA, Lists.newArrayList(regionAFN));
            Set<ServerName> regionBFN = this.getInheritedFNForDaughter(helper, parentFavoredNodes, FavoredNodesPlan.Position.PRIMARY, FavoredNodesPlan.Position.TERTIARY);
            result.put(regionB, Lists.newArrayList(regionBFN));
        }
        this.fnm.updateFavoredNodes(result);
    }

    private Set<ServerName> getInheritedFNForDaughter(FavoredNodeAssignmentHelper helper, List<ServerName> parentFavoredNodes, FavoredNodesPlan.Position primary, FavoredNodesPlan.Position secondary) throws IOException {
        LinkedHashSet<ServerName> daughterFN = Sets.newLinkedHashSet();
        if (parentFavoredNodes.size() >= primary.ordinal()) {
            daughterFN.add(parentFavoredNodes.get(primary.ordinal()));
        }
        if (parentFavoredNodes.size() >= secondary.ordinal()) {
            daughterFN.add(parentFavoredNodes.get(secondary.ordinal()));
        }
        while (daughterFN.size() < 3) {
            ServerName newNode = helper.generateMissingFavoredNode(Lists.newArrayList(daughterFN));
            daughterFN.add(newNode);
        }
        return daughterFN;
    }

    @Override
    public void generateFavoredNodesForMergedRegion(HRegionInfo merged, HRegionInfo regionA, HRegionInfo regionB) throws IOException {
        this.updateFavoredNodesForRegion(merged, this.fnm.getFavoredNodes(regionA));
    }

    @Override
    public List<RegionPlan> balanceCluster(Map<ServerName, List<HRegionInfo>> clusterState) {
        if (this.services != null) {
            ArrayList<RegionPlan> regionPlans = Lists.newArrayList();
            HashMap<ServerName, List<HRegionInfo>> correctAssignments = new HashMap<ServerName, List<HRegionInfo>>();
            int misplacedRegions = 0;
            for (Map.Entry<ServerName, List<HRegionInfo>> entry : clusterState.entrySet()) {
                ServerName current = entry.getKey();
                ArrayList<HRegionInfo> regions = Lists.newArrayList();
                correctAssignments.put(current, regions);
                for (HRegionInfo hri : entry.getValue()) {
                    List<ServerName> favoredNodes = this.fnm.getFavoredNodes(hri);
                    if (FavoredNodesPlan.getFavoredServerPosition(favoredNodes, current) != null || !FavoredNodesManager.isFavoredNodeApplicable(hri)) {
                        regions.add(hri);
                        continue;
                    }
                    LOG.warn((Object)("Region not on favored nodes, unassign. Region: " + hri + " current: " + current + " favored nodes: " + favoredNodes));
                    try {
                        this.services.getAssignmentManager().unassign(hri);
                    }
                    catch (IOException e) {
                        LOG.warn((Object)"Failed unassign", (Throwable)e);
                        continue;
                    }
                    RegionPlan rp = new RegionPlan(hri, null, null);
                    regionPlans.add(rp);
                    ++misplacedRegions;
                }
            }
            LOG.debug((Object)("Found misplaced regions: " + misplacedRegions + ", not on favored nodes."));
            List<RegionPlan> regionPlansFromBalance = super.balanceCluster(correctAssignments);
            if (regionPlansFromBalance != null) {
                regionPlans.addAll(regionPlansFromBalance);
            }
            return regionPlans;
        }
        return super.balanceCluster(clusterState);
    }

    class FavoredNodeLoadPicker
    extends StochasticLoadBalancer.CandidateGenerator {
        FavoredNodeLoadPicker() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        BaseLoadBalancer.Cluster.Action generate(BaseLoadBalancer.Cluster cluster) {
            int otherServer;
            cluster.sortServersByRegionCount();
            int thisServer = this.pickMostLoadedServer(cluster);
            int thisRegion = this.pickRandomRegion(cluster, thisServer, 0.0);
            HRegionInfo hri = cluster.regions[thisRegion];
            List<ServerName> favoredNodes = FavoredStochasticBalancer.this.fnm.getFavoredNodes(hri);
            if (favoredNodes == null) {
                if (FavoredNodesManager.isFavoredNodeApplicable(hri)) return BaseLoadBalancer.Cluster.NullAction;
                otherServer = this.pickLeastLoadedServer(cluster, thisServer);
                return this.getAction(thisServer, thisRegion, otherServer, -1);
            } else {
                otherServer = this.pickLeastLoadedFNServer(cluster, favoredNodes, thisServer);
            }
            return this.getAction(thisServer, thisRegion, otherServer, -1);
        }

        private int pickLeastLoadedServer(BaseLoadBalancer.Cluster cluster, int thisServer) {
            int index;
            Integer[] servers = cluster.serverIndicesSortedByRegionCount;
            for (index = 0; index < servers.length && (servers[index] == null || servers[index] == thisServer); ++index) {
            }
            return servers[index];
        }

        private int pickLeastLoadedFNServer(BaseLoadBalancer.Cluster cluster, List<ServerName> favoredNodes, int currentServerIndex) {
            ArrayList<Integer> fnIndex = new ArrayList<Integer>();
            for (ServerName sn : favoredNodes) {
                if (!cluster.serversToIndex.containsKey(sn.getHostAndPort())) continue;
                fnIndex.add(cluster.serversToIndex.get(sn.getHostAndPort()));
            }
            int leastLoadedFN = -1;
            int load = Integer.MAX_VALUE;
            for (Integer index : fnIndex) {
                int temp;
                if (index == currentServerIndex || (temp = cluster.getNumRegions(index)) >= load) continue;
                load = temp;
                leastLoadedFN = index;
            }
            return leastLoadedFN;
        }

        private int pickMostLoadedServer(BaseLoadBalancer.Cluster cluster) {
            int index;
            Integer[] servers = cluster.serverIndicesSortedByRegionCount;
            for (index = servers.length - 1; index > 0 && servers[index] == null; --index) {
            }
            return servers[index];
        }
    }

    private class FavoredNodeLocalityPicker
    extends StochasticLoadBalancer.CandidateGenerator {
        private FavoredNodeLocalityPicker() {
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        protected BaseLoadBalancer.Cluster.Action generate(BaseLoadBalancer.Cluster cluster) {
            int otherServer;
            int thisServer = this.pickRandomServer(cluster);
            if (thisServer == -1) {
                LOG.trace((Object)"Could not pick lowest local region server");
                return BaseLoadBalancer.Cluster.NullAction;
            }
            int thisRegion = this.pickLowestLocalRegionOnServer(cluster, thisServer);
            if (thisRegion == -1) {
                if (cluster.regionsPerServer[thisServer].length <= 0) return BaseLoadBalancer.Cluster.NullAction;
                LOG.trace((Object)("Could not pick lowest local region even when region server held " + cluster.regionsPerServer[thisServer].length + " regions"));
                return BaseLoadBalancer.Cluster.NullAction;
            }
            HRegionInfo hri = cluster.regions[thisRegion];
            List<ServerName> favoredNodes = FavoredStochasticBalancer.this.fnm.getFavoredNodes(hri);
            if (favoredNodes != null) {
                otherServer = this.getDifferentFavoredNode(cluster, favoredNodes, thisServer);
                return this.getAction(thisServer, thisRegion, otherServer, -1);
            }
            if (!FavoredNodesManager.isFavoredNodeApplicable(hri)) {
                otherServer = this.pickOtherRandomServer(cluster, thisServer);
                return this.getAction(thisServer, thisRegion, otherServer, -1);
            }
            LOG.trace((Object)("Ignoring, no favored nodes for region: " + hri));
            return BaseLoadBalancer.Cluster.NullAction;
        }

        private int getDifferentFavoredNode(BaseLoadBalancer.Cluster cluster, List<ServerName> favoredNodes, int currentServer) {
            ArrayList<Integer> fnIndex = new ArrayList<Integer>();
            for (ServerName sn : favoredNodes) {
                if (!cluster.serversToIndex.containsKey(sn.getHostAndPort())) continue;
                fnIndex.add(cluster.serversToIndex.get(sn.getHostAndPort()));
            }
            float locality = 0.0f;
            int highestLocalRSIndex = -1;
            for (Integer index : fnIndex) {
                float temp;
                if (index == currentServer || !((temp = cluster.localityPerServer[index]) >= locality)) continue;
                locality = temp;
                highestLocalRSIndex = index;
            }
            return highestLocalRSIndex;
        }

        private int pickLowestLocalRegionOnServer(BaseLoadBalancer.Cluster cluster, int server) {
            return cluster.getLowestLocalityRegionOnServer(server);
        }
    }
}

