/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.cleaner;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.ScheduledChore;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.master.cleaner.FileCleanerDelegate;
import org.apache.hadoop.hbase.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.ImmutableSet;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.Iterables;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.Lists;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.ipc.RemoteException;

public abstract class CleanerChore<T extends FileCleanerDelegate>
extends ScheduledChore {
    private static final Log LOG = LogFactory.getLog((String)CleanerChore.class.getName());
    protected final FileSystem fs;
    private final Path oldFileDir;
    private final Configuration conf;
    protected List<T> cleanersChain;
    protected Map<String, Object> params;
    private AtomicBoolean enabled = new AtomicBoolean(true);

    public CleanerChore(String name, int sleepPeriod, Stoppable s, Configuration conf, FileSystem fs, Path oldFileDir, String confKey) {
        this(name, sleepPeriod, s, conf, fs, oldFileDir, confKey, null);
    }

    public CleanerChore(String name, int sleepPeriod, Stoppable s, Configuration conf, FileSystem fs, Path oldFileDir, String confKey, Map<String, Object> params) {
        super(name, s, sleepPeriod);
        this.fs = fs;
        this.oldFileDir = oldFileDir;
        this.conf = conf;
        this.params = params;
        this.initCleanerChain(confKey);
    }

    protected abstract boolean validate(Path var1);

    private void initCleanerChain(String confKey) {
        this.cleanersChain = new LinkedList<T>();
        String[] logCleaners = this.conf.getStrings(confKey);
        if (logCleaners != null) {
            for (String className : logCleaners) {
                T logCleaner = this.newFileCleaner(className, this.conf);
                if (logCleaner == null) continue;
                LOG.debug((Object)("initialize cleaner=" + className));
                this.cleanersChain.add(logCleaner);
            }
        }
    }

    private T newFileCleaner(String className, Configuration conf) {
        try {
            Class<FileCleanerDelegate> c = Class.forName(className).asSubclass(FileCleanerDelegate.class);
            FileCleanerDelegate cleaner = c.newInstance();
            cleaner.setConf(conf);
            cleaner.init(this.params);
            return (T)cleaner;
        }
        catch (Exception e) {
            LOG.warn((Object)("Can NOT create CleanerDelegate: " + className), (Throwable)e);
            return null;
        }
    }

    @Override
    protected void chore() {
        if (this.getEnabled()) {
            this.runCleaner();
        } else {
            LOG.debug((Object)"Cleaner chore disabled! Not cleaning.");
        }
    }

    public Boolean runCleaner() {
        try {
            FileStatus[] files = FSUtils.listStatus(this.fs, this.oldFileDir);
            this.checkAndDeleteEntries(files);
        }
        catch (IOException e) {
            e = e instanceof RemoteException ? ((RemoteException)e).unwrapRemoteException() : e;
            LOG.warn((Object)"Error while cleaning the logs", (Throwable)e);
            return false;
        }
        return true;
    }

    private void sortByConsumedSpace(List<FileStatus> dirs) {
        if (dirs == null || dirs.size() < 2) {
            return;
        }
        Collections.sort(dirs, new Comparator<FileStatus>(){
            HashMap<FileStatus, Long> directorySpaces = new HashMap();

            @Override
            public int compare(FileStatus f1, FileStatus f2) {
                long f2ConsumedSpace;
                long f1ConsumedSpace = this.getSpace(f1);
                return f1ConsumedSpace > (f2ConsumedSpace = this.getSpace(f2)) ? -1 : (f1ConsumedSpace < f2ConsumedSpace ? 1 : 0);
            }

            private long getSpace(FileStatus f) {
                Long cached = this.directorySpaces.get(f);
                if (cached != null) {
                    return cached;
                }
                try {
                    long space = f.isDirectory() ? CleanerChore.this.fs.getContentSummary(f.getPath()).getSpaceConsumed() : f.getLen();
                    this.directorySpaces.put(f, space);
                    return space;
                }
                catch (IOException e) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("failed to get space consumed by path " + f.getPath()), (Throwable)e);
                    }
                    return -1L;
                }
            }
        });
    }

    private boolean checkAndDeleteEntries(FileStatus[] entries) {
        if (entries == null) {
            return true;
        }
        boolean allEntriesDeleted = true;
        ArrayList<FileStatus> files = Lists.newArrayListWithCapacity(entries.length);
        ArrayList<FileStatus> dirs = new ArrayList<FileStatus>();
        for (FileStatus child : entries) {
            if (child.isDirectory()) {
                dirs.add(child);
                continue;
            }
            files.add(child);
        }
        if (dirs.size() > 0) {
            this.sortByConsumedSpace(dirs);
            LOG.debug((Object)("Prepared to delete files in directories: " + dirs));
            for (FileStatus child : dirs) {
                Path path = child.getPath();
                if (this.checkAndDeleteDirectory(path)) continue;
                allEntriesDeleted = false;
            }
        }
        if (!this.checkAndDeleteFiles(files)) {
            allEntriesDeleted = false;
        }
        return allEntriesDeleted;
    }

    @VisibleForTesting
    boolean checkAndDeleteDirectory(Path dir) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Checking directory: " + dir));
        }
        try {
            FileStatus[] children = FSUtils.listStatus(this.fs, dir);
            boolean allChildrenDeleted = this.checkAndDeleteEntries(children);
            if (!allChildrenDeleted) {
                return false;
            }
        }
        catch (IOException e) {
            e = e instanceof RemoteException ? ((RemoteException)e).unwrapRemoteException() : e;
            LOG.warn((Object)("Error while listing directory: " + dir), (Throwable)e);
            return false;
        }
        try {
            return this.fs.delete(dir, false);
        }
        catch (IOException e) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Couldn't delete directory: " + dir), (Throwable)e);
            }
            return false;
        }
    }

    private boolean checkAndDeleteFiles(List<FileStatus> files) {
        ArrayList<FileStatus> validFiles = Lists.newArrayListWithCapacity(files.size());
        ArrayList<FileStatus> invalidFiles = Lists.newArrayList();
        for (FileStatus fileStatus : files) {
            if (this.validate(fileStatus.getPath())) {
                validFiles.add(fileStatus);
                continue;
            }
            LOG.warn((Object)("Found a wrongly formatted file: " + fileStatus.getPath() + " - will delete it."));
            invalidFiles.add(fileStatus);
        }
        Iterable<FileStatus> deletableValidFiles = validFiles;
        for (FileCleanerDelegate cleaner : this.cleanersChain) {
            if (cleaner.isStopped() || this.getStopper().isStopped()) {
                LOG.warn((Object)("A file cleaner" + this.getName() + " is stopped, won't delete any more files in:" + this.oldFileDir));
                return false;
            }
            Iterable<FileStatus> filteredFiles = cleaner.getDeletableFiles(deletableValidFiles);
            if (LOG.isTraceEnabled()) {
                ImmutableSet<FileStatus> filteredFileSet = ImmutableSet.copyOf(filteredFiles);
                for (FileStatus file : deletableValidFiles) {
                    if (filteredFileSet.contains(file)) continue;
                    LOG.trace((Object)(file.getPath() + " is not deletable according to:" + cleaner));
                }
            }
            deletableValidFiles = filteredFiles;
        }
        Iterable<FileStatus> iterable = Iterables.concat(invalidFiles, deletableValidFiles);
        return this.deleteFiles(iterable) == files.size();
    }

    protected int deleteFiles(Iterable<FileStatus> filesToDelete) {
        int deletedFileCount = 0;
        for (FileStatus file : filesToDelete) {
            Path filePath = file.getPath();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Removing: " + filePath + " from archive"));
            }
            try {
                boolean success = this.fs.delete(filePath, false);
                if (success) {
                    ++deletedFileCount;
                    continue;
                }
                LOG.warn((Object)("Attempted to delete:" + filePath + ", but couldn't. Run cleaner chain and attempt to delete on next pass."));
            }
            catch (IOException e) {
                e = e instanceof RemoteException ? ((RemoteException)e).unwrapRemoteException() : e;
                LOG.warn((Object)("Error while deleting: " + filePath), (Throwable)e);
            }
        }
        return deletedFileCount;
    }

    @Override
    public void cleanup() {
        for (FileCleanerDelegate lc : this.cleanersChain) {
            try {
                lc.stop("Exiting");
            }
            catch (Throwable t) {
                LOG.warn((Object)"Stopping", t);
            }
        }
    }

    public boolean setEnabled(boolean enabled) {
        return this.enabled.getAndSet(enabled);
    }

    public boolean getEnabled() {
        return this.enabled.get();
    }
}

