/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.cleaner;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.ScheduledChore;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.replication.ReplicationPeerDescription;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ReplicationMetaCleaner
extends ScheduledChore {
    private static final Log LOG = LogFactory.getLog(ReplicationMetaCleaner.class);
    private final Admin admin;
    private final MasterServices master;

    public ReplicationMetaCleaner(MasterServices master, Stoppable stoppable, int period) throws IOException {
        super("ReplicationMetaCleaner", stoppable, period);
        this.master = master;
        this.admin = master.getConnection().getAdmin();
    }

    @Override
    protected void chore() {
        try {
            Map<String, TableDescriptor> tables = this.master.getTableDescriptors().getAllDescriptors();
            HashMap serialTables = new HashMap();
            for (Map.Entry<String, TableDescriptor> entry : tables.entrySet()) {
                boolean hasSerialScope = false;
                for (ColumnFamilyDescriptor column : entry.getValue().getColumnFamilies()) {
                    if (column.getScope() != 2) continue;
                    hasSerialScope = true;
                    break;
                }
                if (!hasSerialScope) continue;
                serialTables.put(entry.getValue().getTableName().getNameAsString(), new HashSet());
            }
            if (serialTables.isEmpty()) {
                return;
            }
            List<ReplicationPeerDescription> peers = this.admin.listReplicationPeers();
            block22: for (ReplicationPeerDescription peerDesc : peers) {
                for (Map.Entry entry : peerDesc.getPeerConfig().getTableCFsMap().entrySet()) {
                    if (!serialTables.containsKey(((TableName)entry.getKey()).getNameAsString())) continue;
                    ((Set)serialTables.get(((TableName)entry.getKey()).getNameAsString())).add(peerDesc.getPeerId());
                    continue block22;
                }
            }
            Map<String, List<Long>> map = MetaTableAccessor.getAllBarriers(this.master.getConnection());
            for (Map.Entry<String, List<Long>> entry : map.entrySet()) {
                Object daughterRegions;
                String string = entry.getKey();
                byte[] encodedBytes = Bytes.toBytes(string);
                boolean canClearRegion = false;
                Map<String, Long> posMap = MetaTableAccessor.getReplicationPositionForAllPeer(this.master.getConnection(), encodedBytes);
                if (posMap.isEmpty()) continue;
                String tableName = MetaTableAccessor.getSerialReplicationTableName(this.master.getConnection(), encodedBytes);
                Set confPeers = (Set)serialTables.get(tableName);
                if (confPeers == null) {
                    canClearRegion = true;
                } else {
                    if (!this.allPeersHavePosition(confPeers, posMap)) continue;
                    String daughterValue = MetaTableAccessor.getSerialReplicationDaughterRegion(this.master.getConnection(), encodedBytes);
                    if (daughterValue != null) {
                        boolean allDaughterStart = true;
                        daughterRegions = daughterValue.split(",");
                        for (String daughter : daughterRegions) {
                            byte[] region = Bytes.toBytes(daughter);
                            if (MetaTableAccessor.getReplicationBarriers(this.master.getConnection(), region).isEmpty() || this.allPeersHavePosition(confPeers, MetaTableAccessor.getReplicationPositionForAllPeer(this.master.getConnection(), region))) continue;
                            allDaughterStart = false;
                            break;
                        }
                        if (allDaughterStart) {
                            canClearRegion = true;
                        }
                    }
                }
                if (canClearRegion) {
                    Delete delete = new Delete(encodedBytes);
                    delete.addFamily(HConstants.REPLICATION_POSITION_FAMILY);
                    delete.addFamily(HConstants.REPLICATION_BARRIER_FAMILY);
                    delete.addFamily(HConstants.REPLICATION_META_FAMILY);
                    Table metaTable = this.master.getConnection().getTable(TableName.META_TABLE_NAME);
                    daughterRegions = null;
                    try {
                        metaTable.delete(delete);
                        continue;
                    }
                    catch (Throwable throwable) {
                        daughterRegions = throwable;
                        throw throwable;
                    }
                    finally {
                        if (metaTable == null) continue;
                        if (daughterRegions != null) {
                            try {
                                metaTable.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)daughterRegions).addSuppressed(throwable);
                            }
                            continue;
                        }
                        metaTable.close();
                        continue;
                    }
                }
                long minPos = Long.MAX_VALUE;
                for (Map.Entry<String, Long> pos : posMap.entrySet()) {
                    minPos = Math.min(minPos, pos.getValue());
                }
                List<Long> barriers = entry.getValue();
                int index = Collections.binarySearch(barriers, minPos);
                if (index < 0) {
                    index = -index - 1;
                }
                Delete delete = new Delete(encodedBytes);
                for (int i = 0; i < index - 1; ++i) {
                    delete.addColumn(HConstants.REPLICATION_BARRIER_FAMILY, Bytes.toBytes(barriers.get(i)));
                }
                Table metaTable = this.master.getConnection().getTable(TableName.META_TABLE_NAME);
                Throwable throwable = null;
                try {
                    metaTable.delete(delete);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (metaTable == null) continue;
                    if (throwable != null) {
                        try {
                            metaTable.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    metaTable.close();
                }
            }
        }
        catch (IOException e) {
            LOG.error((Object)"Exception during cleaning up.", (Throwable)e);
        }
    }

    private boolean allPeersHavePosition(Set<String> peers, Map<String, Long> posMap) throws IOException {
        for (String peer : peers) {
            if (posMap.containsKey(peer)) continue;
            return false;
        }
        return true;
    }
}

