/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.cleaner;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.replication.ReplicationFactory;
import org.apache.hadoop.hbase.replication.ReplicationPeers;
import org.apache.hadoop.hbase.replication.ReplicationQueueInfo;
import org.apache.hadoop.hbase.replication.ReplicationQueuesClient;
import org.apache.hadoop.hbase.replication.ReplicationQueuesClientArguments;
import org.apache.hadoop.hbase.replication.ReplicationStateZKBase;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.KeeperException;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ReplicationZKNodeCleaner {
    private static final Log LOG = LogFactory.getLog(ReplicationZKNodeCleaner.class);
    private final ZooKeeperWatcher zkw;
    private final ReplicationQueuesClient queuesClient;
    private final ReplicationPeers replicationPeers;
    private final ReplicationQueueDeletor queueDeletor;

    public ReplicationZKNodeCleaner(Configuration conf, ZooKeeperWatcher zkw, Abortable abortable) throws IOException {
        try {
            this.zkw = zkw;
            this.queuesClient = ReplicationFactory.getReplicationQueuesClient(new ReplicationQueuesClientArguments(conf, abortable, zkw));
            this.queuesClient.init();
            this.replicationPeers = ReplicationFactory.getReplicationPeers(zkw, conf, this.queuesClient, abortable);
            this.replicationPeers.init();
            this.queueDeletor = new ReplicationQueueDeletor(zkw, conf, abortable);
        }
        catch (Exception e) {
            throw new IOException("failed to construct ReplicationZKNodeCleaner", e);
        }
    }

    public Map<String, List<String>> getUnDeletedQueues() throws IOException {
        HashMap<String, List<String>> undeletedQueues = new HashMap<String, List<String>>();
        HashSet<String> peerIds = new HashSet<String>(this.replicationPeers.getAllPeerIds());
        try {
            List<String> replicators = this.queuesClient.getListOfReplicators();
            if (replicators == null || replicators.isEmpty()) {
                return undeletedQueues;
            }
            for (String replicator : replicators) {
                List<String> queueIds = this.queuesClient.getAllQueues(replicator);
                for (String queueId : queueIds) {
                    ReplicationQueueInfo queueInfo = new ReplicationQueueInfo(queueId);
                    if (peerIds.contains(queueInfo.getPeerId())) continue;
                    undeletedQueues.computeIfAbsent(replicator, key -> new ArrayList()).add(queueId);
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)("Undeleted replication queue for removed peer found: " + String.format("[removedPeerId=%s, replicator=%s, queueId=%s]", queueInfo.getPeerId(), replicator, queueId)));
                }
            }
        }
        catch (KeeperException ke) {
            throw new IOException("Failed to get the replication queues of all replicators", ke);
        }
        return undeletedQueues;
    }

    public Set<String> getUnDeletedHFileRefsQueues() throws IOException {
        HashSet<String> undeletedHFileRefsQueue = new HashSet<String>();
        HashSet<String> peerIds = new HashSet<String>(this.replicationPeers.getAllPeerIds());
        String hfileRefsZNode = this.queueDeletor.getHfileRefsZNode();
        try {
            if (-1 == ZKUtil.checkExists(this.zkw, hfileRefsZNode)) {
                return null;
            }
            List<String> listOfPeers = this.queuesClient.getAllPeersFromHFileRefsQueue();
            HashSet<String> peers = new HashSet<String>(listOfPeers);
            peers.removeAll(peerIds);
            if (!peers.isEmpty()) {
                undeletedHFileRefsQueue.addAll(peers);
            }
        }
        catch (KeeperException e) {
            throw new IOException("Failed to get list of all peers from hfile-refs znode " + hfileRefsZNode, e);
        }
        return undeletedHFileRefsQueue;
    }

    public void removeQueues(Map<String, List<String>> undeletedQueues) throws IOException {
        for (Map.Entry<String, List<String>> replicatorAndQueueIds : undeletedQueues.entrySet()) {
            String replicator = replicatorAndQueueIds.getKey();
            for (String queueId : replicatorAndQueueIds.getValue()) {
                this.queueDeletor.removeQueue(replicator, queueId);
            }
        }
    }

    public void removeHFileRefsQueues(Set<String> undeletedHFileRefsQueues) throws IOException {
        for (String hfileRefsQueueId : undeletedHFileRefsQueues) {
            this.queueDeletor.removeHFileRefsQueue(hfileRefsQueueId);
        }
    }

    private class ReplicationQueueDeletor
    extends ReplicationStateZKBase {
        public ReplicationQueueDeletor(ZooKeeperWatcher zk, Configuration conf, Abortable abortable) {
            super(zk, conf, abortable);
        }

        public void removeQueue(String replicator, String queueId) throws IOException {
            String queueZnodePath = ZKUtil.joinZNode(ZKUtil.joinZNode(this.queuesZNode, replicator), queueId);
            try {
                ReplicationQueueInfo queueInfo = new ReplicationQueueInfo(queueId);
                if (!ReplicationZKNodeCleaner.this.replicationPeers.getAllPeerIds().contains(queueInfo.getPeerId())) {
                    ZKUtil.deleteNodeRecursively(this.zookeeper, queueZnodePath);
                    LOG.info((Object)("Successfully removed replication queue, replicator: " + replicator + ", queueId: " + queueId));
                }
            }
            catch (KeeperException e) {
                throw new IOException("Failed to delete queue, replicator: " + replicator + ", queueId: " + queueId);
            }
        }

        public void removeHFileRefsQueue(String hfileRefsQueueId) throws IOException {
            String node = ZKUtil.joinZNode(this.hfileRefsZNode, hfileRefsQueueId);
            try {
                if (!ReplicationZKNodeCleaner.this.replicationPeers.getAllPeerIds().contains(hfileRefsQueueId)) {
                    ZKUtil.deleteNodeRecursively(this.zookeeper, node);
                    LOG.info((Object)("Successfully removed hfile-refs queue " + hfileRefsQueueId + " from path " + this.hfileRefsZNode));
                }
            }
            catch (KeeperException e) {
                throw new IOException("Failed to delete hfile-refs queue " + hfileRefsQueueId + " from path " + this.hfileRefsZNode);
            }
        }

        String getHfileRefsZNode() {
            return this.hfileRefsZNode;
        }
    }
}

